/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.string;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public final class BufferConvertUtils {
    private static final String CHARSET = "UTF-8";

    private BufferConvertUtils() {
    }

    public static ByteBuffer charBuffer2ByteBuffer(CharBuffer charBuffer) throws CharacterCodingException {
        return BufferConvertUtils.charBuffer2ByteBuffer(charBuffer, CHARSET);
    }

    public static ByteBuffer charBuffer2ByteBuffer(CharBuffer charBuffer, String charset) throws CharacterCodingException {
        Charset cs = Charset.forName(charset);
        CharsetEncoder coder = cs.newEncoder();
        return coder.encode(charBuffer);
    }

    public static CharBuffer byteBuffer2CharBuffer(ByteBuffer byteBuffer) throws CharacterCodingException {
        return BufferConvertUtils.byteBuffer2CharBuffer(byteBuffer, CHARSET);
    }

    public static CharBuffer byteBuffer2CharBuffer(ByteBuffer byteBuffer, String charset) throws CharacterCodingException {
        Charset cs = Charset.forName(charset);
        CharsetDecoder coder = cs.newDecoder();
        return coder.decode(byteBuffer);
    }
}

