/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.string;

import com.huawei.baize.base.common.Conditions;
import com.huawei.baize.base.string.RadixType;
import com.huawei.baize.base.string.StringArrayConvertHelper;
import com.huawei.baize.base.string.StringHexConvertHelper;
import com.huawei.baize.base.string.StringListConvertHelper;
import com.huawei.baize.base.string.StringNumConvertHelper;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public final class StringConvertUtils {
    private StringConvertUtils() {
    }

    public static String hexStrToStr(String hexStr) throws ParseException {
        return StringHexConvertHelper.hexStrToStr(hexStr);
    }

    public static String strToHexStr(String str) {
        return StringHexConvertHelper.strToHexStr(str);
    }

    public static byte[] hexStrToByteArr(String hexStr) {
        return StringHexConvertHelper.hexStrToByteArr(hexStr);
    }

    public static String byteArrToHexStr(byte[] bytes) {
        return StringHexConvertHelper.byteArrToHexStr(bytes);
    }

    public static <T> Integer parseInt(T object, RadixType radix, int defaultValue) {
        return StringNumConvertHelper.parseInt(object, radix, defaultValue);
    }

    public static <T> Integer parseInt(T object, int defaultValue) {
        return StringConvertUtils.parseInt(object, RadixType.DEC, defaultValue);
    }

    public static <T> Long parseLong(T object, RadixType radix, long defaultValue) {
        return StringNumConvertHelper.parseLong(object, radix, defaultValue);
    }

    public static <T> Long parseLong(T object, long defaultValue) {
        return StringConvertUtils.parseLong(object, RadixType.DEC, defaultValue);
    }

    public static <T> Short parseShort(T object, RadixType radix, int defaultValue) {
        return StringNumConvertHelper.parseShort(object, radix, defaultValue);
    }

    public static <T> Short parseShort(T object, int defaultValue) {
        return StringConvertUtils.parseShort(object, RadixType.DEC, defaultValue);
    }

    public static <T> Float parseFloat(T object, float defaultValue) {
        return StringNumConvertHelper.parseFloat(object, defaultValue);
    }

    public static <T> Double parseDouble(T object, double defaultValue) {
        return StringNumConvertHelper.parseDouble(object, defaultValue);
    }

    public static <T> Boolean parseBoolean(T object, boolean defaultValue) {
        return StringNumConvertHelper.parseBoolean(object, defaultValue);
    }

    public static Integer bigDecimalToInteger(BigDecimal object, int defaultValue) {
        return StringNumConvertHelper.bigDecimalToInteger(object, defaultValue);
    }

    public static Long bigDecimalToLong(BigDecimal object, long defaultValue) {
        return StringNumConvertHelper.bigDecimalToLong(object, defaultValue);
    }

    public static <T> String objectToString(T object, String defaultValue, boolean ifTrim) {
        if (object == null || StringUtils.isBlank((CharSequence)object.toString())) {
            return defaultValue;
        }
        return ifTrim ? object.toString().trim() : object.toString();
    }

    public static String listToString(List<?> list, String separator) {
        return StringListConvertHelper.listToString(list, separator);
    }

    public static String listToString(List<?> list, String separator, Predicate<? super Object> filter) {
        return StringListConvertHelper.listToString(list, separator, filter);
    }

    public static String listToString(List<?> list, String separator, Predicate<? super Object> filter, Function<? super Object, String> mapper) {
        return StringListConvertHelper.listToString(list, separator, filter, mapper);
    }

    public static String listToStringWithMapper(List<?> list, String separator, Function<? super Object, String> mapper) {
        return StringListConvertHelper.listToStringWithMapper(list, separator, mapper);
    }

    public static List<String> stringToList(String sourceStr, String separator) {
        return StringListConvertHelper.stringToList(sourceStr, separator);
    }

    public static <T> List<T> stringToList(String sourceStr, String separator, Function<String, ? extends T> mapper) {
        return StringListConvertHelper.stringToList(sourceStr, separator, mapper);
    }

    public static <T> List<T> stringToList(String sourceStr, String separator, Predicate<? super String> filter, Function<String, ? extends T> mapper) {
        return StringListConvertHelper.stringToList(sourceStr, separator, filter, mapper);
    }

    public static String arrayToString(int[] intArr, String separator) {
        return StringArrayConvertHelper.arrayToString(intArr, separator);
    }

    public static String arrayToString(long[] longArr, String separator) {
        return StringArrayConvertHelper.arrayToString(longArr, separator);
    }

    public static String arrayToString(float[] floatArr, String separator) {
        return StringArrayConvertHelper.arrayToString(floatArr, separator);
    }

    public static String arrayToString(double[] doubleArr, String separator) {
        return StringArrayConvertHelper.arrayToString(doubleArr, separator);
    }

    public static <T> String arrayToString(T[] arr, String separator) {
        return StringArrayConvertHelper.arrayToString(arr, separator);
    }

    public static String leftAppend(String str, char specifier, int totalLength) {
        Objects.requireNonNull(str);
        Conditions.requireArgument(totalLength > 0, "The total length of format string must be positive.");
        if (totalLength > str.length()) {
            String chars = StringUtils.repeat((char)specifier, (int)(totalLength - str.length()));
            return chars + str;
        }
        return str;
    }

    public static String rightAppend(String str, char specifier, int totalLength) {
        Objects.requireNonNull(str);
        Conditions.requireArgument(totalLength > 0, "The total length of format string must be positive.");
        if (totalLength > str.length()) {
            String chars = StringUtils.repeat((char)specifier, (int)(totalLength - str.length()));
            return str + chars;
        }
        return str;
    }
}

