/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

final class StringListConvertHelper {
    private StringListConvertHelper() {
    }

    static String listToString(List<?> list, String separator) {
        Objects.requireNonNull(separator);
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        return list.stream().map(Object::toString).collect(Collectors.joining(separator));
    }

    static String listToString(List<?> list, String separator, Predicate<? super Object> filter) {
        Objects.requireNonNull(separator);
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        return list.stream().filter(filter).map(Object::toString).collect(Collectors.joining(separator));
    }

    static String listToString(List<?> list, String separator, Predicate<? super Object> filter, Function<? super Object, String> mapper) {
        Objects.requireNonNull(separator);
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        return list.stream().filter(filter).map(mapper).collect(Collectors.joining(separator));
    }

    static String listToStringWithMapper(List<?> list, String separator, Function<? super Object, String> mapper) {
        Objects.requireNonNull(separator);
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        return list.stream().map(mapper).collect(Collectors.joining(separator));
    }

    static List<String> stringToList(String sourceStr, String separator) {
        if (StringUtils.isEmpty((CharSequence)sourceStr)) {
            return new ArrayList<String>();
        }
        return Arrays.asList(StringUtils.split((String)sourceStr, (String)separator));
    }

    static <T> List<T> stringToList(String sourceStr, String separator, Function<String, ? extends T> mapper) {
        if (StringUtils.isEmpty((CharSequence)sourceStr)) {
            return new ArrayList();
        }
        return Stream.of(StringUtils.split((String)sourceStr, (String)separator)).map(mapper).collect(Collectors.toList());
    }

    static <T> List<T> stringToList(String sourceStr, String separator, Predicate<? super String> filter, Function<String, ? extends T> mapper) {
        if (StringUtils.isEmpty((CharSequence)sourceStr)) {
            return new ArrayList();
        }
        return Stream.of(StringUtils.split((String)sourceStr, (String)separator)).filter(filter).map(mapper).collect(Collectors.toList());
    }
}

