/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.string;

import com.huawei.baize.base.string.RadixType;
import java.math.BigDecimal;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

final class StringNumConvertHelper {
    private StringNumConvertHelper() {
    }

    static <T> Integer parseInt(T object, RadixType radix, int defaultValue) {
        Objects.requireNonNull(radix);
        if (object == null || StringUtils.isBlank((CharSequence)object.toString())) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(object.toString().trim(), radix.getVal());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    static <T> Long parseLong(T object, RadixType radix, long defaultValue) {
        Objects.requireNonNull(radix);
        if (object == null || StringUtils.isBlank((CharSequence)object.toString())) {
            return defaultValue;
        }
        try {
            return Long.parseLong(object.toString().trim(), radix.getVal());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    static <T> Short parseShort(T object, RadixType radix, int defaultValue) {
        Objects.requireNonNull(radix);
        if (object == null || StringUtils.isBlank((CharSequence)object.toString())) {
            return (short)defaultValue;
        }
        try {
            return Short.parseShort(object.toString().trim(), radix.getVal());
        }
        catch (NumberFormatException e) {
            return (short)defaultValue;
        }
    }

    static <T> Float parseFloat(T object, float defaultValue) {
        if (object == null || StringUtils.isBlank((CharSequence)object.toString())) {
            return Float.valueOf(defaultValue);
        }
        try {
            return Float.valueOf(Float.parseFloat(object.toString().trim()));
        }
        catch (NumberFormatException e) {
            return Float.valueOf(defaultValue);
        }
    }

    static <T> Double parseDouble(T object, double defaultValue) {
        if (object == null || StringUtils.isBlank((CharSequence)object.toString())) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(object.toString().trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    static <T> Boolean parseBoolean(T object, boolean defaultValue) {
        if (object == null || StringUtils.isBlank((CharSequence)object.toString())) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(object.toString().trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    static Integer bigDecimalToInteger(BigDecimal object, int defaultValue) {
        if (object == null) {
            return defaultValue;
        }
        try {
            return object.intValueExact();
        }
        catch (ArithmeticException e) {
            return defaultValue;
        }
    }

    static Long bigDecimalToLong(BigDecimal object, long defaultValue) {
        if (object == null) {
            return defaultValue;
        }
        try {
            return object.longValueExact();
        }
        catch (ArithmeticException e) {
            return defaultValue;
        }
    }
}

