/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.string;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class StringSliceUtils {
    private StringSliceUtils() {
    }

    public static String slice(String str, int start, int end) {
        int ed;
        if (str == null) {
            return null;
        }
        if (!StringSliceUtils.validation(str, start, end)) {
            return "";
        }
        int len = str.length();
        int st = StringSliceUtils.calcStart(start, len);
        if (st >= (ed = StringSliceUtils.calcEnd(end, len))) {
            return "";
        }
        return str.substring(st, ed);
    }

    public static String slice(String str, String scale) {
        Objects.requireNonNull(scale);
        if (scale.charAt(0) != '[' || scale.charAt(scale.length() - 1) != ']') {
            return "";
        }
        if (!scale.contains(":")) {
            int idx;
            String index = StringUtils.substringBetween((String)scale, (String)"[", (String)"]");
            int n = idx = StringUtils.isBlank((CharSequence)index) ? 0 : Integer.parseInt(index);
            if (idx == -1) {
                return StringSliceUtils.slice(str, idx, str.length());
            }
            return StringSliceUtils.slice(str, idx, idx + 1);
        }
        String startExpr = StringUtils.substringBetween((String)scale, (String)"[", (String)":");
        String endExpr = StringUtils.substringBetween((String)scale, (String)":", (String)"]");
        int start = StringUtils.isBlank((CharSequence)startExpr) ? 0 : Integer.parseInt(startExpr);
        int end = StringUtils.isBlank((CharSequence)endExpr) ? str.length() : Integer.parseInt(endExpr);
        return StringSliceUtils.slice(str, start, end);
    }

    public static List<String> split(String str, int length) {
        ArrayList<String> res = new ArrayList<String>();
        if (length <= 0) {
            return res;
        }
        int strLength = str.length();
        int index = 0;
        while (index < strLength) {
            if (index + length > strLength) {
                res.add(str.substring(index, strLength));
                index = strLength;
                continue;
            }
            res.add(str.substring(index, index + length));
            index += length;
        }
        return res;
    }

    private static int calcEnd(int end, int len) {
        int ed = end;
        if (end > len) {
            ed = len;
        } else if (end < 0) {
            ed = end + len;
        }
        return ed;
    }

    private static int calcStart(int start, int len) {
        int st = start;
        if (start < 0) {
            st = start <= len * -1 ? 0 : len + start;
        }
        return st;
    }

    private static boolean validation(String str, int start, int end) {
        if ("".equals(str)) {
            return false;
        }
        int len = str.length();
        if (start >= len) {
            return false;
        }
        if (end <= len * -1) {
            return false;
        }
        return end != 0;
    }
}

