/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.time;

import com.huawei.baize.base.regex.RegexMatchUtils;
import java.time.LocalDateTime;

public final class TimeCheckUtils {
    private static final String VALIDATE_REGEX_DATE = "((((19|20)\\d{2})-(0?(1|[3-9])|1[012])-(0?[1-9]|[12]\\d|30))|(((19|20)\\d{2})-(0?[13578]|1[02])-31)|(((19|20)\\d{2})-0?2-(0?[1-9]|1\\d|2[0-8]))|((((19|20)([13579][26]|[2468][048]|0[48]))|(2000))-0?2-29))$";
    private static final String VALIDATE_REGEX_DATE_TIME = "((((19|20)\\d{2})-(0?(1|[3-9])|1[012])-(0?[1-9]|[12]\\d|30))|(((19|20)\\d{2})-(0?[13578]|1[02])-31)|(((19|20)\\d{2})-0?2-(0?[1-9]|1\\d|2[0-8]))|((((19|20)([13579][26]|[2468][048]|0[48]))|(2000))-0?2-29))\\s([0-1]?[0-9]|2[0-3]):([0-5][0-9])(:([0-5][0-9]))?$";
    private static final String NO_SPLIT_MUL_REGEX = "^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})(((0[13578]|1[02])(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)(0[1-9]|[12][0-9]|30))|(02(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))0229))([0-1]?[0-9]|2[0-3])([0-5][0-9])([0-5][0-9])$";
    private static final String NO_SPLIT_REGEX = "^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})(((0[13578]|1[02])(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)(0[1-9]|[12][0-9]|30))|(02(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))0229))$";
    private static final String STAND_REGEX_DATA_TIME = "((((19|20)\\d{2})/(0(1|[3-9])|1[012])/(0[1-9]|[12]\\d|30))|(((19|20)\\d{2})/(0[13578]|1[02])/31)|(((19|20)\\d{2})/02/(0[1-9]|1\\d|2[0-8]))|((((19|20)([13579][26]|[2468][048]|0[48]))|(2000))/02/29))\\s([0-1]?[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$";
    private static final String STAND_REGEX = "(((0?[1-9]|[12]\\d|30)/(0(1|[3-9])|1[012])/((19|20)\\d{2}))|(31/(0[13578]|1[02])/((19|20)\\d{2}))|((0[1-9]|1\\d|2[0-8])/02/((19|20)\\d{2}))|(29/02/(((19|20)([13579][26]|[2468][048]|0[48]))|(2000))))\\s([0-1]?[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$";
    private static final String ZONE_REGEX = "(((-0\\d|-1[0-1]|\\+0\\d|[+]1[0-3]))(:{0,1}[0-5]\\d){0,1}|-12:{0,1}(00){0,1}|\\+14:{0,1}(00){0,1})";

    private TimeCheckUtils() {
    }

    public static boolean validateDate(String date) {
        return RegexMatchUtils.matches(VALIDATE_REGEX_DATE, date);
    }

    public static boolean validateTime(String time) {
        return RegexMatchUtils.matches(VALIDATE_REGEX_DATE, time) || RegexMatchUtils.matches(VALIDATE_REGEX_DATE_TIME, time);
    }

    public static boolean validTimeForyyyyMMddHHmmss(String time) {
        return RegexMatchUtils.matches(NO_SPLIT_MUL_REGEX, time);
    }

    public static boolean validTimeForyyyyMMdd(String time) {
        return RegexMatchUtils.matches(NO_SPLIT_REGEX, time);
    }

    public static boolean validTimeForStandardFormat(String time) {
        return RegexMatchUtils.matches(STAND_REGEX_DATA_TIME, time) || RegexMatchUtils.matches(STAND_REGEX, time);
    }

    public static boolean validTimeForZoneFormat(String zone) {
        return RegexMatchUtils.matches(ZONE_REGEX, zone);
    }

    public static boolean ifBetweenTime(LocalDateTime nowTime, LocalDateTime startTime, LocalDateTime endTime) {
        if (nowTime == null || startTime == null || endTime == null) {
            return false;
        }
        if (nowTime.isEqual(startTime) || nowTime.isEqual(endTime)) {
            return true;
        }
        return nowTime.isAfter(startTime) && nowTime.isBefore(endTime);
    }
}

