/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.baize.base.time;

import com.huawei.baize.base.common.Conditions;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class TimeConvertUtils {
    private static final String PATTEN = "yyyy-MM-dd HH:mm:ss E";
    private static final String NOWEEK_PATTEN = "yyyy-MM-dd HH:mm:ss";

    private TimeConvertUtils() {
    }

    public static String getLocalDateTimeNowNoWeek() {
        return TimeConvertUtils.getLocalDateTimeNow(NOWEEK_PATTEN);
    }

    public static String getLocalDateTimeNow() {
        return TimeConvertUtils.getLocalDateTimeNow(PATTEN);
    }

    public static String getLocalDateTimeNow(String pattern) {
        return TimeConvertUtils.localDateTimeToString(LocalDateTime.now(), pattern);
    }

    public static Date getLocalDateTimeToDate() {
        return TimeConvertUtils.localDateTimeToDate(LocalDateTime.now());
    }

    public static long localDateTimeByCurMonthAndFirstDay(LocalDateTime localDateTime) {
        return TimeConvertUtils.localDateTimeByCurMonthAndFirstDay(localDateTime, ZoneId.systemDefault());
    }

    public static long localDateTimeByCurMonthAndFirstDay(LocalDateTime localDateTime, ZoneId zoneId) {
        Objects.requireNonNull(localDateTime);
        Objects.requireNonNull(zoneId);
        return localDateTime.toLocalDate().withDayOfMonth(1).atStartOfDay(zoneId).toInstant().toEpochMilli();
    }

    @Deprecated
    public static String localDateTimeToSting(LocalDateTime localDateTime, String pattern) {
        return TimeConvertUtils.localDateTimeToString(localDateTime, pattern);
    }

    public static String localDateTimeToString(LocalDateTime localDateTime, String pattern) {
        Objects.requireNonNull(localDateTime);
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)pattern));
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH);
        return localDateTime.format(dtf);
    }

    public static String localDateToString(LocalDate localDate, String pattern) {
        Objects.requireNonNull(localDate);
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)pattern));
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH);
        return localDate.format(dtf);
    }

    public static String localDateTimeToZonedDateTimeString(LocalDateTime localDateTime, String pattern, ZoneId zoneId) {
        Objects.requireNonNull(localDateTime);
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)pattern));
        Objects.requireNonNull(zoneId);
        ZonedDateTime zonedDateTime = localDateTime.atZone(zoneId);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH);
        return zonedDateTime.format(dtf);
    }

    public static String localDateTimeToZonedDateTimeString(LocalDateTime localDateTime, String pattern) {
        return TimeConvertUtils.localDateTimeToZonedDateTimeString(localDateTime, pattern, ZoneId.systemDefault());
    }

    public static long localDateTimeToLongByCutDown(LocalDateTime localDateTime, ChronoUnit chronoUnit) {
        return TimeConvertUtils.localDateTimeToLongByCutDown(localDateTime, chronoUnit, ZoneId.systemDefault());
    }

    public static long localDateTimeToLongByCutDown(LocalDateTime localDateTime, ChronoUnit chronoUnit, ZoneId zoneId) {
        Objects.requireNonNull(localDateTime);
        Objects.requireNonNull(chronoUnit);
        Objects.requireNonNull(zoneId);
        return localDateTime.truncatedTo(chronoUnit).atZone(zoneId).toInstant().toEpochMilli();
    }

    public static Date localDateTimeToDate(LocalDateTime localDateTime, ZoneId zoneId) {
        Objects.requireNonNull(localDateTime);
        Objects.requireNonNull(zoneId);
        return Date.from(localDateTime.atZone(zoneId).toInstant());
    }

    public static Date localDateTimeToDate(LocalDateTime localDateTime) {
        return TimeConvertUtils.localDateTimeToDate(localDateTime, ZoneId.systemDefault());
    }

    public static long zonedDateTimeStringToLong(String zonedDateTimeString, String pattern) {
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)zonedDateTimeString));
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)pattern));
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH);
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(zonedDateTimeString, dtf);
        return zonedDateTime == null ? 0L : zonedDateTime.toInstant().toEpochMilli();
    }

    public static long dateTimeStringToLong(String localDateTime, String pattern) {
        return TimeConvertUtils.dateTimeStringToLong(localDateTime, pattern, ZoneId.systemDefault());
    }

    public static long dateTimeStringToLong(String localDateTime, String pattern, ZoneId zoneId) {
        LocalDateTime ldt = TimeConvertUtils.dateTimeStringToLocalDateTime(localDateTime, pattern, zoneId);
        return ldt == null ? 0L : ldt.atZone(zoneId).toInstant().toEpochMilli();
    }

    public static LocalDateTime dateTimeStringToLocalDateTime(String localDateTime, String pattern, ZoneId zoneId) {
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)localDateTime));
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)pattern));
        Objects.requireNonNull(zoneId);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(pattern);
        return LocalDateTime.parse(localDateTime, dtf);
    }

    public static LocalDateTime dateTimeStringToLocalDateTime(String localDateTime, String pattern) {
        return TimeConvertUtils.dateTimeStringToLocalDateTime(localDateTime, pattern, ZoneId.systemDefault());
    }

    public static LocalDate dateTimeStringToLocalDate(String localDateTime, String pattern) {
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)localDateTime));
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)pattern));
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(pattern);
        return LocalDateTime.parse(localDateTime, dtf).toLocalDate();
    }

    public static String dateTimeStringToLocalDateString(String localDateTime, String pattern, String datePattern) {
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)datePattern));
        LocalDate ld = TimeConvertUtils.dateTimeStringToLocalDate(localDateTime, pattern);
        return TimeConvertUtils.localDateToString(ld, datePattern);
    }

    public static LocalDateTime localDateStringToLocalDateTime(String localDate, String pattern) {
        LocalDate ld = TimeConvertUtils.localDateStringToLocalDate(localDate, pattern);
        return ld.atStartOfDay();
    }

    public static LocalDate localDateStringToLocalDate(String localDate, String pattern) {
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)localDate));
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)pattern));
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(pattern);
        return LocalDate.parse(localDate, dtf);
    }

    public static Date dateTimeStringToDate(String localDateTimeString, String pattern, ZoneId zoneId) {
        Objects.requireNonNull(zoneId);
        LocalDateTime ldt = TimeConvertUtils.dateTimeStringToLocalDateTime(localDateTimeString, pattern, zoneId);
        return ldt == null ? null : Date.from(ldt.atZone(zoneId).toInstant());
    }

    public static Date dateTimeStringToDate(String localDateTimeString, String pattern) {
        return TimeConvertUtils.dateTimeStringToDate(localDateTimeString, pattern, ZoneId.systemDefault());
    }

    public static LocalDateTime longToLocalDateTime(long timestamp, ZoneId zoneId) {
        Objects.requireNonNull(zoneId);
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
    }

    public static LocalDateTime longToLocalDateTime(long timestamp) {
        return TimeConvertUtils.longToLocalDateTime(timestamp, ZoneId.systemDefault());
    }

    public static String longToLocalDateTimeString(long timestamp, String pattern, ZoneId zoneId) {
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)pattern));
        LocalDateTime ldt = TimeConvertUtils.longToLocalDateTime(timestamp, zoneId);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH);
        return ldt.format(dtf);
    }

    public static String longToLocalDateTimeString(long timestamp, String pattern) {
        return TimeConvertUtils.longToLocalDateTimeString(timestamp, pattern, ZoneId.systemDefault());
    }

    public static ZonedDateTime longToZonedDateTime(long timestamp, ZoneId zoneId) {
        Objects.requireNonNull(zoneId);
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
    }

    public static ZonedDateTime longToZonedDateTime(long timestamp) {
        return TimeConvertUtils.longToZonedDateTime(timestamp, ZoneId.systemDefault());
    }

    public static String longToZonedDateTimeString(long timestamp, String pattern) {
        return TimeConvertUtils.longToZonedDateTimeString(timestamp, pattern, ZoneId.systemDefault());
    }

    public static String longToZonedDateTimeString(long timestamp, String pattern, ZoneId zoneId) {
        Conditions.requireArgument(StringUtils.isNotBlank((CharSequence)pattern));
        Objects.requireNonNull(zoneId);
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(timestamp).atZone(zoneId);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(pattern, Locale.ENGLISH);
        return zonedDateTime.format(dtf);
    }

    public static Date longToDate(long timestamp, ZoneId zoneId) {
        String dateTime = TimeConvertUtils.longToZonedDateTimeString(timestamp, NOWEEK_PATTEN, zoneId);
        return TimeConvertUtils.dateTimeStringToDate(dateTime, NOWEEK_PATTEN);
    }

    public static Date longToDate(long timestamp) {
        return TimeConvertUtils.longToDate(timestamp, ZoneId.systemDefault());
    }

    public static LocalDateTime dateToLocalDateTime(Date date) {
        return TimeConvertUtils.dateToLocalDateTime(date, ZoneId.systemDefault());
    }

    public static LocalDateTime dateToLocalDateTime(Date date, ZoneId zoneId) {
        Objects.requireNonNull(date);
        Objects.requireNonNull(zoneId);
        return LocalDateTime.ofInstant(date.toInstant(), zoneId);
    }

    public static String dateToLocalDateTimeString(Date date, String pattern, ZoneId zoneId) {
        Objects.requireNonNull(date);
        return TimeConvertUtils.longToLocalDateTimeString(date.getTime(), pattern, zoneId);
    }

    public static String dateToLocalDateTimeString(Date date, String pattern) {
        return TimeConvertUtils.dateToLocalDateTimeString(date, pattern, ZoneId.systemDefault());
    }

    public static ZonedDateTime dateToZonedDateTime(Date date, ZoneId zoneId) {
        Objects.requireNonNull(date);
        return TimeConvertUtils.longToZonedDateTime(date.getTime(), zoneId);
    }

    public static ZonedDateTime dateToZonedDateTime(Date date) {
        return TimeConvertUtils.dateToZonedDateTime(date, ZoneId.systemDefault());
    }

    public static String dateToZonedDateTimeString(Date date, String pattern, ZoneId zoneId) {
        Objects.requireNonNull(date);
        return TimeConvertUtils.longToZonedDateTimeString(date.getTime(), pattern, zoneId);
    }

    public static String dateToZonedDateTimeString(Date date, String pattern) {
        Objects.requireNonNull(date);
        return TimeConvertUtils.longToZonedDateTimeString(date.getTime(), pattern, ZoneId.systemDefault());
    }
}

