/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.deploy.context;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.deploy.entity.DevScriptMapping;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.SupportProduct;
import com.huawei.ism.tool.framework.pubservice.utils.SupportProductUtils;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DeployInfoContext
extends AbstractContext {
    private static final Logger log = LoggerFactory.getLogger(DeployInfoContext.class);
    private static final String TOOL_SCENE = "toolScene";
    private static final String DEPLOYMENT_COMPATIBILITY_INFORMATION_COLLECTION = "DeploymentCompatibilityInformationCollection";
    private static final String JSON_SCENE_ARGS_LIST = "jsonSceneArgsList";
    private static final String DEV_TYPE = "devType";
    private static final String SCRIPT_PATH = "scriptPath";
    private static final String CHILD_TAG_NAME = "item";
    private static final DeployInfoContext DEPLOY_INFO_CONTEXT = new DeployInfoContext();
    private List<DevScriptMapping> devScriptMappingList = new LinkedList<DevScriptMapping>();
    private List<SupportProduct> deployInfoCollectSupportProducts = new LinkedList<SupportProduct>();
    private List<DevNode> offHostDevs = new ArrayList<DevNode>();
    private static final String DEPLOY_SCRIPT = "config/deploy/wizard/devScriptMapping.xml";
    private List<String> offImportDates = new ArrayList<String>();
    private List<File> dataFiles = new ArrayList<File>();

    private DeployInfoContext() {
        this.initDevScriptMappingList();
        this.initDeployInfoStorageDevSupportProducts();
    }

    private void initDevScriptMappingList() {
        Document doc = this.getDoc();
        if (doc == null) {
            log.info("doc is null.");
            return;
        }
        Element root = doc.getDocumentElement();
        for (Element moduleElem : XmlUtils.getChildren((Element)root, (String)CHILD_TAG_NAME)) {
            String devType = moduleElem.getAttribute(DEV_TYPE).trim();
            String path = moduleElem.getAttribute(SCRIPT_PATH).trim();
            if (this.checkValue(devType) && this.checkValue(path)) {
                DevScriptMapping scriptMapping = DevScriptMapping.builder().devType(devType).scriptPath(path).build();
                this.devScriptMappingList.add(scriptMapping);
                continue;
            }
            log.error("devType:{} or path:{} error. ", (Object)devType, (Object)path);
        }
    }

    private boolean checkValue(String value) {
        value = value.replaceAll("\\\\", "");
        value = value.replaceAll("/", "");
        return Pattern.matches("[A-Za-z0-9-._]{0,}", value);
    }

    private void initDeployInfoStorageDevSupportProducts() {
        Path path = Paths.get(ApplicationContext.getInstance().getWorkPath(), "script", "storages", "HUAWEI", "deploy", "sysconf.xml");
        if (Files.exists(path, new LinkOption[0])) {
            this.deployInfoCollectSupportProducts.addAll(SupportProductUtils.parseProductsXml((File)path.toFile()));
        } else {
            log.error("product config file not found = ", (Object)path.toString());
        }
    }

    private Document getDoc() {
        ClassLoader classLoader = DeployInfoContext.class.getClassLoader();
        Document doc = null;
        if (!VerifyUtil.isEmpty((Object)classLoader)) {
            try (InputStream in = classLoader.getResourceAsStream(DEPLOY_SCRIPT);){
                doc = XmlUtils.parseDocument((InputStream)in);
            }
            catch (FileNotFoundException e) {
                log.error("file:devScriptMapping not found.");
            }
            catch (IOException e) {
                log.error("io error.");
            }
        }
        return doc;
    }

    public static DeployInfoContext getDeployContext() {
        return DEPLOY_INFO_CONTEXT;
    }

    public List<SupportProduct> getDeployInfoCollectSupportProducts() {
        return this.deployInfoCollectSupportProducts;
    }

    public List<DevScriptMapping> getDevScriptMappingList() {
        return this.devScriptMappingList;
    }

    public File getReportFile() {
        return new File(InfoGrabDirPropertiesUtil.getProperty());
    }

    public boolean isDeployInfoCollect() {
        String toolScene = "";
        try {
            String sceneKey = System.getenv(JSON_SCENE_ARGS_LIST);
            log.info("sceneKey {}", (Object)StringUtils.getCleanMessage((String)sceneKey));
            JSONObject jsonObj = new JSONObject(sceneKey);
            toolScene = (String)jsonObj.get(TOOL_SCENE);
        }
        catch (Exception e) {
            log.info("prase jsonSceneArgsList failed");
        }
        return toolScene.equals(DEPLOYMENT_COMPATIBILITY_INFORMATION_COLLECTION);
    }

    public boolean isDevNodeSupport(com.huawei.ism.tool.framework.pubservice.entity.DevNode dev) {
        if (ItDeviceType.Host.equals((Object)dev.getItDeviceType())) {
            return true;
        }
        String devType = "";
        if (!VerifyUtil.isEmpty((Object)dev.getDeviceType())) {
            devType = dev.getDeviceType().toString();
        }
        String productVersion = dev.getProductVersion();
        List versions = new ArrayList();
        List<SupportProduct> supportProducts = DeployInfoContext.getDeployContext().getDeployInfoCollectSupportProducts();
        for (SupportProduct supportProduct : supportProducts) {
            if (!supportProduct.getProductName().equalsIgnoreCase(devType)) continue;
            versions = supportProduct.getVersions();
            break;
        }
        return versions.stream().anyMatch(configVersion -> productVersion.startsWith((String)configVersion));
    }

    public List<DevNode> getOffHostDevs() {
        return this.offHostDevs;
    }

    public List<String> getOffImportDates() {
        return this.offImportDates;
    }

    public List<File> getDataFiles() {
        return this.dataFiles;
    }

    public void setDevScriptMappingList(List<DevScriptMapping> devScriptMappingList) {
        this.devScriptMappingList = devScriptMappingList;
    }

    public void setDeployInfoCollectSupportProducts(List<SupportProduct> deployInfoCollectSupportProducts) {
        this.deployInfoCollectSupportProducts = deployInfoCollectSupportProducts;
    }

    public void setOffHostDevs(List<DevNode> offHostDevs) {
        this.offHostDevs = offHostDevs;
    }

    public void setOffImportDates(List<String> offImportDates) {
        this.offImportDates = offImportDates;
    }

    public void setDataFiles(List<File> dataFiles) {
        this.dataFiles = dataFiles;
    }
}

