/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.deploy.listener;

import com.huawei.ism.tool.deploy.context.DeployInfoContext;
import com.huawei.ism.tool.deploy.ui.DeployCompatibilityInfoCollectDialog;
import com.huawei.ism.tool.deploy.util.DeployInfoExcelReportUtil;
import com.huawei.ism.tool.devicemanager.service.DefaultNodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.ShowSysConstans;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddDialog;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.framework.pubui.entity.DeviceManageSetting;
import com.huawei.ism.tool.obase.entity.SettingType;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddDeviceForDeployListener
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(AddDeviceForDeployListener.class);
    private Window parent;
    private static Map<ItDeviceType, List<String>> deviceTypeModel = new HashMap<ItDeviceType, List<String>>();
    private static List<String> hostType = new LinkedList<String>();

    public AddDeviceForDeployListener(DeployCompatibilityInfoCollectDialog parent) {
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList supportDevTypes = new ArrayList();
        DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(supportDevTypes, (INodeSupport)new DeployInfoCollectINodeSupport(), ShowSysConstans.getShowSysCmds());
        DeviceAddDialog.InfoTips tips = new DeviceAddDialog.InfoTips("devicemanager.layout.device.add.deviceadddialog.deviceduplicatebyupgrade");
        DeviceManageSetting setting = new DeviceManageSetting(true, true, true);
        DeviceAddDialog dialog = null;
        LinkedList<ItDeviceType> deviceTypeList = new LinkedList<ItDeviceType>();
        HashMap<ItDeviceType, List<String>> deviceTypeView = new HashMap<ItDeviceType, List<String>>();
        this.initDeviceTypeView(deviceTypeList, deviceTypeView, setting, ItDeviceType.Storage, ItDeviceType.Host);
        dialog = new DeviceAddDialog(this.parent, (INodeTypeQuery)nodeTypeQuery, tips, setting, new SettingType[]{SettingType.Socks5Proxy, SettingType.SshForward});
        dialog.setForceRootOnHost(true);
        dialog.setVisible(true);
        List devs = DefaultNodeProviderImpl.getInstance().getNodeList();
        ((DeployCompatibilityInfoCollectDialog)this.parent).refreshTableRows(DeployInfoExcelReportUtil.filterDevByNodeSupport(devs));
    }

    public void initDeviceTypeView(List<ItDeviceType> itDeviceList, Map<ItDeviceType, List<String>> deviceTypeView, DeviceManageSetting setting, ItDeviceType ... deviceTypes) {
        for (ItDeviceType deviceType : deviceTypes) {
            itDeviceList.add(deviceType);
            deviceTypeView.put(deviceType, deviceTypeModel.get(deviceType));
            setting.setItDeviceList(itDeviceList);
            if (ItDeviceType.Storage.equals((Object)deviceType)) continue;
            setting.setDeviceTypel2(deviceTypeView);
        }
    }

    static {
        hostType.add("Linux");
        hostType.add("AIX");
        hostType.add("HP-UX");
        hostType.add("Solaris");
        hostType.add("VMware");
        deviceTypeModel.put(ItDeviceType.Host, hostType);
    }

    private class DeployInfoCollectINodeSupport
    implements INodeSupport {
        private DeployInfoCollectINodeSupport() {
        }

        public boolean isNodeSupport(DevNode dev) {
            return DeployInfoContext.getDeployContext().isDevNodeSupport(dev);
        }
    }
}

