/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.deploy.listener;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.deploy.context.DeployInfoContext;
import com.huawei.ism.tool.deploy.entity.HostEvalNode;
import com.huawei.ism.tool.deploy.task.offline.OffLineImportAsyncExcutor;
import com.huawei.ism.tool.deploy.ui.DeployCompatibilityInfoCollectDialog;
import com.huawei.ism.tool.deploy.ui.ImportInfoDialog;
import com.huawei.ism.tool.deploy.util.FileUtil;
import com.huawei.ism.tool.devicemanager.service.ShowSysConstans;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.entity.enums.NodeAddEnum;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.swing.DefaultNodeTypeQuery;
import com.huawei.ism.tool.infograb.swing.DeviceManageService;
import com.huawei.ism.tool.infograb.swing.IDeviceManageService;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import utils.FilesUtil;

public class OffLineBatchImportAction
implements ActionListener {
    private static final String EVALU_IMPORT_INPUT = "evalu_import_input_zip";
    private static final int MOST_FILES_AMOUNT = 50;
    private static final int IMPORT_FILE_MAX_SIZE_MB = 50;
    private DeployCompatibilityInfoCollectDialog parent;

    public OffLineBatchImportAction(DeployCompatibilityInfoCollectDialog parent) {
        this.parent = parent;
    }

    public boolean checkSelectedFile(List<File> selectedFiles) {
        return this.checkFileContent(selectedFiles);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        List<File> userSelectedDataFiles = this.selectFiles();
        if (!this.checkFilePath(userSelectedDataFiles)) {
            userSelectedDataFiles.clear();
        }
        if (!this.preCheck(userSelectedDataFiles)) {
            return;
        }
        this.checkFileContent(userSelectedDataFiles);
        userSelectedDataFiles.clear();
    }

    public boolean checkFileContent(List<File> selectedFiles) {
        OffLineImportDeviceTask task = new OffLineImportDeviceTask(selectedFiles);
        List<?> result = OffLineImportAsyncExcutor.execute(this.parent, task);
        HashMap<String, String> message = new HashMap<String, String>();
        List taskResults = new ArrayList();
        if (result.get(0) instanceof List) {
            taskResults = (List)result.get(0);
        }
        for (TaskResult taskResult : taskResults) {
            if (!TaskResult.Result.FAILED.equals((Object)taskResult.getResult())) continue;
            message.put(((HostEvalNode)taskResult.getResultObject()).getFileName(), taskResult.getErrorLocaleDescription());
        }
        List<File> dataFiles = DeployInfoContext.getDeployContext().getDataFiles();
        if (!message.isEmpty()) {
            dataFiles.clear();
            new ImportInfoDialog((Window)this.parent, message).setVisible(true);
            return false;
        }
        this.getDataFileTime(dataFiles);
        return true;
    }

    private void getDataFileTime(List<File> dataFiles) {
        for (File dataFile : dataFiles) {
            String name = dataFile.getName();
            try {
                String[] paths = name.split("_");
                String dateStrs = paths[2];
                int len = dateStrs.length();
                if (len >= 13 && dateStrs.endsWith(".data")) {
                    String dateStr = dateStrs.substring(0, 8);
                    DeployInfoContext.getDeployContext().getOffImportDates().add(dateStr);
                    continue;
                }
                DeployInfoContext.getDeployContext().getOffImportDates().add("--");
            }
            catch (Exception e) {
                DeployInfoContext.getDeployContext().getOffImportDates().add("--");
            }
        }
        dataFiles.clear();
    }

    public boolean checkFilePath(List<File> checkFiles) {
        String path = "";
        if (null == checkFiles) {
            return false;
        }
        if (checkFiles.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"filechooser.prompt.file.path.format.error"));
            return false;
        }
        for (File file : checkFiles) {
            try {
                path = file.getCanonicalPath();
                if (FileUtil.checkBlankPath(path) && FileUtil.checkNormalPath(path)) continue;
                DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.select.File.Illegal"));
                return false;
            }
            catch (IOException e) {
                DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"filechooser.prompt.file.path.format.error"));
                return false;
            }
        }
        return true;
    }

    public boolean checkFileSize(List<File> checkFiles) {
        String size = "";
        if (null == checkFiles) {
            return false;
        }
        if (checkFiles.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"filechooser.prompt.file.path.format.error"));
            return false;
        }
        for (File file : checkFiles) {
            try {
                size = ToolFileChooser.getFileSize(file);
                if (Float.valueOf(size).intValue() <= 50) continue;
                DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.select.File.too.big"));
                return false;
            }
            catch (NumberFormatException e) {
                DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"evalu.ui.mainDialog.select.File.failed.get.size"));
                return false;
            }
        }
        return true;
    }

    private List<File> selectFiles() {
        List<File> importFiles = ToolFileChooser.selectFiles((Window)this.parent, ResourceUtil.getString((String)"evalu.ui.card.addDev.device.import.title"), new String[]{"zip"}, EVALU_IMPORT_INPUT, "*.zip", 0);
        return importFiles;
    }

    public boolean preCheck(List<File> selectedFiles) {
        if (null == selectedFiles) {
            return false;
        }
        if (selectedFiles.size() > 50) {
            DialogUtils.showErrorDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"evalu.ui.import.morethan.50"));
            return false;
        }
        return true;
    }

    private class OffLineImportDeviceTask
    implements Callable<List<TaskResult>> {
        private List<File> checkFiles;

        public OffLineImportDeviceTask(List<File> checkFiles) {
            this.checkFiles = checkFiles;
        }

        @Override
        public List<TaskResult> call() throws IOException, InterruptedException {
            ArrayList<TaskResult> allReaults = new ArrayList<TaskResult>();
            List<File> allDataFile = this.checkFiles.stream().filter(file -> file.getName().endsWith(".data")).collect(Collectors.toList());
            this.checkManualGrabFile(allReaults, allDataFile);
            return allReaults;
        }

        public void checkManualGrabFile(List<TaskResult> allReaults, List<File> allDataFile) throws IOException, InterruptedException {
            DefaultNodeTypeQuery nodeTypeQuery = new DefaultNodeTypeQuery(null, ShowSysConstans.getShowSysCmds());
            DeviceManageService service = new DeviceManageService(nodeTypeQuery);
            for (File dataFile : allDataFile) {
                DevNode dev = this.addDevByFiles(dataFile, service);
                if (dev.getErrorDecs() != null) {
                    TaskResult oneTaskResult = new TaskResult();
                    HostEvalNode hostEvalTask = new HostEvalNode();
                    oneTaskResult.setResult(TaskResult.Result.SUCCESS);
                    oneTaskResult.setResultObject((Object)hostEvalTask);
                    hostEvalTask.setFileName(dataFile.getCanonicalPath());
                    hostEvalTask.setImportTime(new Date());
                    oneTaskResult.setResult(TaskResult.Result.FAILED);
                    String errorMsg = ResourceUtil.getString((String)"evalu.ui.import.pkg.exception");
                    if (!"".equals(dev.getErrorDecs())) {
                        errorMsg = dev.getErrorDecs();
                    }
                    oneTaskResult.setErrorLocaleDescription(errorMsg);
                    allReaults.add(oneTaskResult);
                }
                TimeUnit.MILLISECONDS.sleep(50L);
            }
        }

        private DevNode addDevByFiles(File mannualGrabFile, IDeviceManageService service) {
            GrabDevNode1 dev = new GrabDevNode1();
            dev.setDevInfoPkgPath(FilesUtil.getCanonicalPath(mannualGrabFile));
            dev.setNodeAddType(NodeAddEnum.GRAB_FILE);
            dev.setLoginUser(new User("root", null));
            com.huawei.ism.tool.obase.taskexecutor.TaskResult result = service.addDevice(dev);
            if (TaskResult.Result.SUCCESS.equals((Object)result.getResult())) {
                DeployInfoContext.getDeployContext().getOffHostDevs().add(dev);
                dev.setErrorDecs(null);
            } else {
                dev.setErrorDecs(result.getErrorLocaleDescription());
            }
            return dev;
        }
    }
}

