/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.deploy.task;

import com.huawei.ism.tool.deploy.entity.AbstractDeployInfoCollectCallableResult;
import com.huawei.ism.tool.deploy.entity.DeployInfoCollectCallableHostResult;
import com.huawei.ism.tool.deploy.entity.DeployInfoCollectCallableStorageResult;
import com.huawei.ism.tool.deploy.ui.observer.IDeployInfoUiObserver;
import com.huawei.ism.tool.deploy.util.DeployInfoExcelReportUtil;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.connection.FileConnectionGrab;
import com.huawei.ism.tool.infograb.connection.SshConnectionHelper;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployInfoCollectCallable
implements Callable<AbstractDeployInfoCollectCallableResult> {
    private static final Logger log = LoggerFactory.getLogger(DeployInfoCollectCallable.class);
    private static final String PYENV_KEY_LANGE = "lang";
    private static final String PYENV_KEY_LOGGER = "logger";
    private static final String PYENV_KEY_OBSERVER = "uiObserver";
    private static final String PYENV_KEY_DEV = "deployDev";
    private static final String PYENV_KEY_CLI = "cli";
    private static final String PYENV_KEY_RESULT = "result";
    private final DevNode deployInfoCollectDevNode;
    private final IDeployInfoUiObserver uiDeployObserver;

    public DeployInfoCollectCallable(DevNode dev, IDeployInfoUiObserver uiObserver) {
        this.deployInfoCollectDevNode = dev;
        this.uiDeployObserver = uiObserver;
    }

    @Override
    public AbstractDeployInfoCollectCallableResult call() {
        this.uiDeployObserver.updateDeviceProgress(this.deployInfoCollectDevNode, 5);
        return this.callScript();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractDeployInfoCollectCallableResult callScript() {
        JythonExecuter jythonExecuter = new JythonExecuter(Paths.get(com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getWorkPath(), "script").toFile());
        HashMap<String, Object> env = new HashMap<String, Object>();
        AbstractDeployInfoCollectCallableResult result = this.getDeployInfoResultByDeviceType(this.deployInfoCollectDevNode);
        try {
            this.buildJavaPyEnv(env, result);
            result = (AbstractDeployInfoCollectCallableResult)env.get(PYENV_KEY_RESULT);
        }
        catch (ToolException e) {
            log.error("create dev connection error.");
            result.setInfoCollectResult(AbstractDeployInfoCollectCallableResult.buildFailedResult(this.deployInfoCollectDevNode, "execute.py.err.connection.error"));
            return result;
        }
        File pythonScFile = new File(DeployInfoExcelReportUtil.getPythonFileByDevType(this.deployInfoCollectDevNode));
        if (!pythonScFile.exists()) {
            log.error("py file not exist :{}", (Object)pythonScFile.getName());
            return result;
        }
        try {
            log.info("begin execute py file : {}", (Object)pythonScFile.getName());
            jythonExecuter.compileScript(pythonScFile);
            jythonExecuter.simpleInvokeFunction("execute", env);
        }
        catch (SignException e) {
            log.error("py sign not pass. file name = {}", (Object)pythonScFile.getName());
        }
        catch (FileNotFoundException e) {
            log.error("py file not found : {}", (Object)pythonScFile.getName());
        }
        catch (ToolException e) {
            log.error("py excute error, py name:{}, exception:{}", (Object)pythonScFile.getName(), (Object)e.getMessage());
        }
        catch (Exception e) {
            log.error("py fatal excute error\uff1a{} ", (Object)pythonScFile.getName());
        }
        finally {
            Object connection = env.get(PYENV_KEY_CLI);
            if (connection instanceof ICliConnection) {
                ((ICliConnection)connection).close();
            }
        }
        result.setInfoCollectResult(AbstractDeployInfoCollectCallableResult.buildSuccessfulResult());
        this.uiDeployObserver.updateDeviceProgress(this.deployInfoCollectDevNode, 100);
        return result;
    }

    private void buildJavaPyEnv(Map<String, Object> env, AbstractDeployInfoCollectCallableResult result) throws ToolException {
        env.put(PYENV_KEY_LANGE, ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
        env.put(PYENV_KEY_LOGGER, log);
        env.put(PYENV_KEY_OBSERVER, this.uiDeployObserver);
        env.put(PYENV_KEY_DEV, this.deployInfoCollectDevNode);
        env.put(PYENV_KEY_CLI, this.createConnection());
        env.put(PYENV_KEY_RESULT, result);
    }

    private AbstractDeployInfoCollectCallableResult getDeployInfoResultByDeviceType(DevNode deployInfoDevNode) {
        return ItDeviceType.Host.equals((Object)deployInfoDevNode.getItDeviceType()) ? new DeployInfoCollectCallableHostResult() : new DeployInfoCollectCallableStorageResult();
    }

    private ICliConnection createConnection() throws ToolException {
        return this.deployInfoCollectDevNode.isFileNode() ? new FileConnectionGrab(this.deployInfoCollectDevNode) : this.createSshConnection();
    }

    private ICliConnection createSshConnection() throws ToolException {
        com.huawei.ism.tool.obase.entity.DevNode oldDev = EntityUtils.toOldDev(this.deployInfoCollectDevNode);
        if (oldDev.getAdminUser() != null) {
            oldDev.setRootUser(new User(oldDev.getAdminUser().getUserName(), oldDev.getAdminUser().getPassword()));
        }
        return SshConnectionHelper.getSshConnection(oldDev);
    }
}

