/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.deploy.task;

import com.huawei.ism.tool.deploy.entity.AbstractDeployInfoCollectCallableResult;
import com.huawei.ism.tool.deploy.task.DeployInfoCollectCallable;
import com.huawei.ism.tool.deploy.ui.observer.IDeployInfoUiObserver;
import com.huawei.ism.tool.deploy.util.DeployInfoExcelReportUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.infograb.context.CollectStatusEnum;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.GifAssistant;

public class DeployInfoCollectManager {
    private static final Logger log = LoggerFactory.getLogger(DeployInfoCollectManager.class);
    private static final int MAX_EVALU_DEV = 10;
    private List<DevNode> devList;
    private IDeployInfoUiObserver deployInfoUiObserver;
    private ExecutorService deployInfoExecutorService = Executors.newFixedThreadPool(10);

    public DeployInfoCollectManager(List<DevNode> devs, IDeployInfoUiObserver observer) {
        this.devList = devs;
        this.deployInfoUiObserver = observer;
    }

    public void startDeployInfoCollect() {
        this.deployInfoUiObserver.refreshBtnStatusAfterCollectStart();
        GifAssistant.getInstance().start();
        GifAssistant.getInstance().setObserver(this.deployInfoUiObserver);
        LinkedList<Future<AbstractDeployInfoCollectCallableResult>> taskFutureResults = new LinkedList<Future<AbstractDeployInfoCollectCallableResult>>();
        LinkedList<AbstractDeployInfoCollectCallableResult> taskResults = new LinkedList<AbstractDeployInfoCollectCallableResult>();
        this.deployInfoUiObserver.refreshProgress(this.devList, 0);
        this.deployInfoUiObserver.refreshDevStatus(this.devList, CollectStatusEnum.WAIT_TOGO.toString());
        for (DevNode devNode : this.devList) {
            DeployInfoCollectCallable task = new DeployInfoCollectCallable(devNode, this.deployInfoUiObserver);
            taskFutureResults.add(this.deployInfoExecutorService.submit(task));
        }
        for (Future future : taskFutureResults) {
            try {
                taskResults.add((AbstractDeployInfoCollectCallableResult)future.get());
            }
            catch (InterruptedException e) {
                log.error("task in interrupted.");
            }
            catch (Exception e) {
                log.error("execute error.");
            }
        }
        this.deployInfoExecutorService.shutdown();
        log.info("begin create excel report.");
        if (taskResults.size() == this.devList.size()) {
            try {
                DeployInfoExcelReportUtil.createExcelReportByResults(this.filterDeployResultByTaskResult(taskResults, TaskResult.Result.SUCCESS));
                for (DevNode devNode : this.devList) {
                    this.deployInfoUiObserver.updateDeviceProgress(devNode, 100);
                }
                this.deployInfoUiObserver.refreshFailedStatus(this.filterDeployResultByTaskResult(taskResults, TaskResult.Result.FAILED));
            }
            catch (Exception e) {
                log.error("create excel report error", (Throwable)e);
            }
        }
        log.info("excel create success.");
        this.deployInfoUiObserver.refreshBtnStatusAfterCollectFinish();
        GifAssistant.getInstance().stopGifLoading();
    }

    private List<AbstractDeployInfoCollectCallableResult> filterDeployResultByTaskResult(List<AbstractDeployInfoCollectCallableResult> deployInfoCollectCallableResultList, TaskResult.Result taskResult) {
        return deployInfoCollectCallableResultList.stream().filter(result -> result.getInfoCollectResult().getTaskResult().getResult().equals((Object)taskResult)).collect(Collectors.toList());
    }
}

