/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.deploy.ui;

import com.huawei.ism.tool.base.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.base.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.deploy.context.DeployInfoContext;
import com.huawei.ism.tool.deploy.entity.AbstractDeployInfoCollectCallableResult;
import com.huawei.ism.tool.deploy.listener.AddDeviceForDeployListener;
import com.huawei.ism.tool.deploy.listener.OffLineBatchImportAction;
import com.huawei.ism.tool.deploy.listener.ShowSupportProductListener;
import com.huawei.ism.tool.deploy.task.DeployInfoCollectManager;
import com.huawei.ism.tool.deploy.ui.DeployCompatibilityInfoCollectLayout;
import com.huawei.ism.tool.deploy.ui.observer.IDeployInfoUiObserver;
import com.huawei.ism.tool.deploy.util.DeployInfoExcelReportUtil;
import com.huawei.ism.tool.deploy.util.FinishedSceneTaskUtil;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.infograb.context.CollectStatusEnum;
import com.huawei.ism.tool.infograb.service.CollectStatusCache;
import com.huawei.ism.tool.infograb.ui.action.DownLoadAction;
import com.huawei.ism.tool.infograb.ui.action.GetOfflineCollectionFileAction;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.plaf.RootPaneUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.GifAssistant;

public class DeployCompatibilityInfoCollectDialog
extends JDialog
implements IDeployInfoUiObserver,
IHelpActionCallBack {
    private static final Logger log = LoggerFactory.getLogger(DeployCompatibilityInfoCollectDialog.class);
    private static final Dimension SIZE = new Dimension(1127, 667);
    private static final String IMPORT_FILE_PATH_KEY = "eval.offline.import";
    private int progressComplete = 100;
    private transient GifAssistant gifAssistant = GifAssistant.getInstance();
    private ReentrantLock lockUI = new ReentrantLock();
    private int deviceType = 0;
    private int modelColNum = 1;
    private int versionColNum = 2;
    private static int ipColNum = 3;
    private static int snColNum = 4;
    private int progressColNum = 5;
    private static int statusColNum = 6;
    private int resultColNum = 7;
    private DeployCompatibilityInfoCollectLayout layout;
    private transient CollectStatusCache statusCache = CollectStatusCache.getInstance();
    private WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();

    public DeployCompatibilityInfoCollectDialog(Window parent) {
        super(parent);
        this.initUI();
        this.initListener();
        ApplicationContext.getInstance().init();
        UiMethod.setComponentSize(SIZE, this);
        SwingUtil.putScreenCenter((Window)this);
        this.initDatas();
    }

    private void initDatas() {
        this.refreshTableRows(DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(devNode -> DeployInfoContext.getDeployContext().isDevNodeSupport(EntityUtils.toNewDev(devNode))).collect(Collectors.toList()));
    }

    private void initUI() {
        this.layout = new DeployCompatibilityInfoCollectLayout();
        this.layout.setCompName();
        this.setLayout(new BorderLayout());
        this.add(this.layout);
        this.getRootPane().setUI((RootPaneUI)this.rootPaneUI);
        this.rootPaneUI.setHelpActionCallBack((IHelpActionCallBack)this);
        this.setTitle(ResourceUtil.getString((String)"info.collect.deployment.compatibility.info.collection"));
        this.setModal(true);
        this.setResizable(true);
        this.validate();
        this.pack();
        this.setIconImage(ResourceUtil.getImage((String)"deploy.png").getImage());
        this.setDefaultCloseOperation(0);
        SwingUtil.putScreenCenter((Window)this);
    }

    private void initListener() {
        this.bindDevAddListener();
        this.bindEvalListener();
        this.bindOpenResultListener();
        this.bindCloseListener();
        this.bindOfflineImportListener();
        this.bingOffLineCollectListener();
        this.bindSupportProductLabelListener();
        this.bindGetDeployCommondListListener();
    }

    private void bindGetDeployCommondListListener() {
        this.layout.getGetDeployCommondListLabel().addClickListener(new DownLoadAction(this, "deployCommandlist"));
    }

    private void bindSupportProductLabelListener() {
        this.layout.getSupportProductLabel().addMouseListener(new ShowSupportProductListener(this));
    }

    private void bingOffLineCollectListener() {
        this.layout.getOffLineCollectLabel().addClickListener(new GetOfflineCollectionFileAction(this));
    }

    private void bindOfflineImportListener() {
        this.layout.getOfflineImportBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List selectFiles = DeployCompatibilityInfoCollectDialog.this.getSeleceFiles();
                if (!DeployCompatibilityInfoCollectDialog.this.checkImportFiles(selectFiles)) {
                    return;
                }
                DeployCompatibilityInfoCollectDialog.this.refreshTableRows(DeployInfoExcelReportUtil.filterDevByNodeSupport(DeployInfoContext.getDeployContext().getOffHostDevs()));
            }
        });
    }

    private boolean checkImportFiles(List<File> selectFiles) {
        OffLineBatchImportAction action = new OffLineBatchImportAction(this);
        if (!action.checkFilePath(selectFiles)) {
            selectFiles.clear();
            return false;
        }
        if (!action.checkFileSize(selectFiles)) {
            selectFiles.clear();
            return false;
        }
        if (!action.preCheck(selectFiles)) {
            return false;
        }
        return action.checkSelectedFile(selectFiles);
    }

    private void bindCloseListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                DeployCompatibilityInfoCollectDialog.this.exitDeployInfoCollectTool();
            }
        });
    }

    private void exitDeployInfoCollectTool() {
        ToolLoggerFactory.getLogger(this.getClass()).info("Operate: click close button");
        WarningDialog wd = DialogUtils.showYesNoDialog((Window)this, (String)ResourceUtil.getString((String)"evalu.ui.out.line.dialog.exit.tool.tip"));
        if (0 == wd.getValue()) {
            FinishedSceneTaskUtil.callbackScene(this.layout.getTableModel().getAllRows());
            Runtime.getRuntime().exit(0);
        }
    }

    private void bindOpenResultListener() {
        this.layout.getOpenEvaluResult().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File reportFile = DeployInfoContext.getDeployContext().getReportFile();
                OSCmdUtils.explorerFile((File)reportFile);
            }
        });
    }

    private void bindDevAddListener() {
        JButton addBtn = this.layout.getAddEvaluDevBtn();
        addBtn.addActionListener(new AddDeviceForDeployListener(this));
    }

    private void bindEvalListener() {
        ToolLoggerFactory.getLogger(this.getClass()).info("Operate: click execut evalu button");
        this.layout.getStartCollect().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeployCompatibilityInfoCollectDialog.this.startDeployEvaluation();
            }
        });
    }

    private List<File> getSeleceFiles() {
        List<File> selectFiles = ToolFileChooser.selectFiles((Window)this, ResourceUtil.getString((String)"evalu.ui.mainDialog.offlinebtn"), new String[]{"zip", "data"}, IMPORT_FILE_PATH_KEY, "*.data", 0);
        return selectFiles;
    }

    private void startDeployEvaluation() {
        List<DevNode> tabDevs = this.getSelectDevNodes();
        if (VerifyUtil.isEmpty(tabDevs)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString((String)"infograb.remind.deploy.at.least.one.tip"));
            return;
        }
        List notSupportDevs = tabDevs.stream().filter(devNode -> !new File(DeployInfoExcelReportUtil.getPythonFileByDevType(devNode)).exists()).map(DevNode::getIp).collect(Collectors.toList());
        if (!VerifyUtil.isEmpty(notSupportDevs)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getStringWithParams((String)"infograb.remind.deploy.device_not.support", (Object[])new Object[]{String.join((CharSequence)",", notSupportDevs)}));
            return;
        }
        DeployInfoCollectManager mgr = new DeployInfoCollectManager(tabDevs, this);
        new Thread(() -> mgr.startDeployInfoCollect()).start();
    }

    private List<DevNode> getSelectDevNodes() {
        ArrayList<DevNode> nodeList = new ArrayList<DevNode>();
        List rows = this.layout.getTaskTable().getMarkedRows();
        for (TableRow tr : rows) {
            if (!(tr.getUserObject() instanceof DevNode)) continue;
            DevNode evaluDev = (DevNode)tr.getUserObject();
            nodeList.add(evaluDev);
        }
        return nodeList;
    }

    public void refreshTableRows(List<com.huawei.ism.tool.obase.entity.DevNode> devs) {
        for (com.huawei.ism.tool.obase.entity.DevNode oldDevNode : devs) {
            DevNode newDev = EntityUtils.toNewDev(oldDevNode);
            String rowSn = newDev.getIp() + newDev.getDeviceSerialNumber();
            if (this.hasRowInTable(rowSn)) continue;
            DefaultTableRow row = new DefaultTableRow(this.resultColNum + 1, (Object)newDev, (Object)(newDev.getIp() + newDev.getDeviceSerialNumber()));
            this.layout.getTableModel().addRow(new TableRow[]{row});
            row.setValueAt(this.deviceType, (Object)newDev.getItDeviceType().getDescription());
            row.setValueAt(this.modelColNum, (Object)newDev.getDeviceName());
            row.setValueAt(this.versionColNum, (Object)newDev.getDeviceType());
            row.setValueAt(ipColNum, (Object)newDev.getIp());
            row.setValueAt(snColNum, (Object)newDev.getDeviceSerialNumber());
            row.setValueAt(this.progressColNum, (Object)new IsmTableCell.ProgressCell(0));
            row.setValueAt(statusColNum, (Object)this.getStatusCell(CollectStatusEnum.NOT_COLLECT));
        }
    }

    @Override
    public void refreshProgress(List<DevNode> devs, int progress) {
        devs.stream().forEach(dev -> this.updateDeviceProgress((DevNode)dev, progress));
    }

    @Override
    public void refreshDevStatus(List<DevNode> devs, String status) {
        List allRows = this.layout.getTableModel().getAllRows();
        ArrayList shouldRefreshRows = new ArrayList();
        for (DevNode newDev : devs) {
            for (TableRow row2 : allRows) {
                shouldRefreshRows.add(this.findRow(newDev.getIp() + newDev.getDeviceSerialNumber()));
            }
        }
        shouldRefreshRows.stream().forEachOrdered(row -> row.setValueAt(statusColNum, (Object)status));
    }

    public void refreshDevStatus(DevNode dev, String status) {
        this.layout.getTableModel().getAllRows().stream().forEachOrdered(row -> {
            if (row.getIdentifier().equals(dev.getIp() + dev.getDeviceSerialNumber())) {
                row.setValueAt(statusColNum, (Object)status);
            }
        });
    }

    private boolean hasRowInTable(String rowSn) {
        List tableRows = this.layout.getTableModel().getAllRows();
        for (TableRow row : tableRows) {
            if (!row.getIdentifier().equals(rowSn)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshLoadingPic() {
        this.lockUI.lock();
        try {
            List allRows = this.layout.getTableModel().getAllRows();
            List<TableRow> runningRows = this.findLoadingRows(allRows);
            if (runningRows.isEmpty()) {
                return;
            }
            for (TableRow row : runningRows) {
                row.setValueAt(statusColNum, (Object)new IsmTableCell.IconCell((Icon)this.gifAssistant.getProcessingImage(), CollectStatusEnum.COLLECTING.toString()));
            }
        }
        finally {
            this.lockUI.unlock();
        }
        this.layout.getTaskTable().repaint();
    }

    private List<TableRow> findLoadingRows(List<TableRow> allRows) {
        LinkedList<TableRow> runningRows = new LinkedList<TableRow>();
        for (TableRow row : allRows) {
            IsmTableCell.ProgressCell progressCell = null;
            if (row.getValueAt(this.progressColNum) instanceof IsmTableCell.ProgressCell) {
                progressCell = (IsmTableCell.ProgressCell)row.getValueAt(this.progressColNum);
            }
            if (progressCell == null || progressCell.getProgress() <= 0 || progressCell.getProgress() >= this.progressComplete) continue;
            runningRows.add(row);
        }
        return runningRows;
    }

    private IsmTableCell getStatusCell(CollectStatusEnum status) {
        return this.statusCache.getTableCellFromStatus(status);
    }

    @Override
    public void refreshBtnStatusAfterCollectStart() {
        this.refreshBtnStatus(false);
    }

    @Override
    public void refreshBtnStatusAfterCollectFinish() {
        this.refreshBtnStatus(true);
    }

    @Override
    public void refreshFailedStatus(List<AbstractDeployInfoCollectCallableResult> failedResults) {
        if (VerifyUtil.isEmpty(failedResults)) {
            return;
        }
        failedResults.stream().forEachOrdered(result -> this.handleResult((AbstractDeployInfoCollectCallableResult)result));
    }

    private void handleResult(AbstractDeployInfoCollectCallableResult result) {
        if (result.getInfoCollectResult().getResultObj() instanceof DevNode) {
            DevNode devNode = (DevNode)result.getInfoCollectResult().getResultObj();
            this.refreshDevStatus(devNode, result.getInfoCollectResult().getErrMsg());
        }
    }

    @Override
    public void updateDeviceProgress(DevNode devNode, int progress) {
        if (VerifyUtil.isEmpty((Object)devNode)) {
            return;
        }
        this.updateRowRrogress(devNode, progress);
    }

    private void updateRowRrogress(DevNode devNode, int progress) {
        String rowSn = devNode.getIp() + devNode.getDeviceSerialNumber();
        TableRow<?, ?> row = this.findRow(rowSn);
        if (VerifyUtil.isEmpty(row)) {
            log.error("not found row.");
            return;
        }
        IsmTableCell.ProgressCell progressCell = (IsmTableCell.ProgressCell)row.getValueAt(this.progressColNum);
        progressCell.setProgress(progress);
        row.setValueAt(this.progressColNum, (Object)progressCell);
        if (progress < this.progressComplete) {
            row.setValueAt(this.resultColNum, (Object)ResourceUtil.getString((String)"deploy.info.collect.processing"));
            this.refreshLoadingPic();
        } else if (progress == this.progressComplete) {
            row.setValueAt(this.resultColNum, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"deploy.info.collect.success")));
            row.setValueAt(statusColNum, (Object)this.getStatusCell(CollectStatusEnum.COLLECT_SUCC));
        }
        this.layout.getTaskTable().repaint();
    }

    private TableRow<?, ?> findRow(String rowSn) {
        List rows = this.layout.getTableModel().getAllRows();
        for (TableRow row : rows) {
            if (!rowSn.equals(row.getIdentifier())) continue;
            return row;
        }
        return null;
    }

    private void refreshBtnStatus(boolean flag) {
        this.layout.getAddEvaluDevBtn().setEnabled(flag);
        this.layout.getOpenEvaluResult().setEnabled(flag);
        this.layout.getStartCollect().setEnabled(flag);
        this.layout.getOfflineImportBtn().setEnabled(flag);
    }

    private void openHelpFile(Window parent) {
        File helpFile = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().isEnglishEnv() ? Paths.get(com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getWorkPath(), "help", "deploy", "Deploy_en.chm").toFile() : Paths.get(com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getWorkPath(), "help", "deploy", "Deploy_zh.chm").toFile();
        log.info("explorer help file:{}", (Object)helpFile);
        if (!helpFile.exists()) {
            if (com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().isJunit()) {
                return;
            }
            DialogUtils.showErrorDialog((Window)parent, (String)ResourceUtil.getString((String)"deploy.help.warning"));
        } else {
            com.huawei.ism.tool.obase.utils.OSCmdUtils.explorerFile(helpFile);
        }
    }

    public void doHelpActionWork() {
        this.openHelpFile(this);
    }

    public String getListenerName() {
        return "DeployCompatibilityInfoCollectDialog";
    }

    public static int getIpColNum() {
        return ipColNum;
    }

    public static int getSnColNum() {
        return snColNum;
    }

    public static int getStatusColNum() {
        return statusColNum;
    }
}

