/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.deploy.ui;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.deploy.context.DeployInfoContext;
import com.huawei.ism.tool.deploy.listener.HyperlinkCellListener;
import com.huawei.ism.tool.framework.pubservice.entity.SupportProduct;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

public class DeviceSupportDevLayout
extends JPanel {
    private String[] tableColumn = new String[]{ResourceUtil.getString((String)"infocollect.selectdevice.support.devmodel"), ResourceUtil.getString((String)"infocollect.selectdevice.support.devversion"), ResourceUtil.getString((String)"infocollect.selectdevice.support.devdetail")};
    private DefaultTableModel tableModel = new DefaultTableModel(this.tableColumn, new int[0]);
    private IsmTable devListTable = new IsmTable((TableModel)this.tableModel);
    private JButton closeBtn = UiMethod.createButton(ResourceUtil.getString((String)"infocollect.selectdevice.support.closebtn"), 'C');

    public DeviceSupportDevLayout() {
        this.setLayout(new BorderLayout());
        JLabel suggestion = new JLabel(ResourceUtil.getString((String)"infocollect.selectdevice.support.suggestion"));
        JComponent vBox = UCD.buildVerticalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)suggestion), new JScrollPane((Component)this.devListTable), UCD.buildHorizontalBoxRight((Component)this.closeBtn)});
        this.add((Component)UiMethod.buildFrameSpace(vBox, 12), "Center");
        this.initTableData();
    }

    private void initTableData() {
        List<SupportProduct> supportProductList = DeployInfoContext.getDeployContext().getDeployInfoCollectSupportProducts();
        for (SupportProduct product : supportProductList) {
            DefaultTableRow row = new DefaultTableRow(this.tableColumn.length, (Object)product.getProductName());
            row.setValueAt(0, (Object)product.getProductName());
            row.setValueAt(1, (Object)this.getSupportVersions(product));
            row.setValueAt(2, (Object)this.createHyperlinkCell(product.getVersions()));
            this.tableModel.addRow(new TableRow[]{row});
        }
    }

    private String getSupportVersions(SupportProduct product) {
        StringBuilder versions = new StringBuilder();
        product.getVersions().forEach(value -> {
            versions.append((String)value);
            versions.append(",");
        });
        return VerifyUtil.isEmpty((String)versions.toString()) ? "" : versions.substring(0, versions.length() - 1);
    }

    public JButton getCloseBtn() {
        return this.closeBtn;
    }

    private IsmTableCell.HyperlinkCell createHyperlinkCell(List<String> detailedVersions) {
        return new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"infocollect.selectdevice.support.view"), (ActionListener)new HyperlinkCellListener(detailedVersions));
    }
}

