/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.deploy.util;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.deploy.context.DeployInfoContext;
import com.huawei.ism.tool.deploy.entity.AbstractDeployInfoCollectCallableResult;
import com.huawei.ism.tool.deploy.entity.DeployInfoCollectCallableHostResult;
import com.huawei.ism.tool.deploy.entity.DeployInfoCollectCallableStorageResult;
import com.huawei.ism.tool.deploy.entity.DevScriptMapping;
import com.huawei.ism.tool.deploy.entity.HostCombinationInfo;
import com.huawei.ism.tool.deploy.entity.StorageCombination;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployInfoExcelReportUtil {
    private static final Logger log = LoggerFactory.getLogger(DeployInfoExcelReportUtil.class);
    private static final int HOST_NAME_COL_NUM = 0;
    private static final int PROTOCOL_COL_NUM = 1;
    private static final int INTERFACE_CARD_COL_NUM = 2;
    private static final int SERVER_MODEL_COL_NUM = 3;
    private static final int OP_SYSTEM_COL_NUM = 4;
    private static final int KENEL_COL_NUM = 5;
    private static final int BUS_ADAPTER_COL_NUM = 6;
    private static final int HBA_DRIVER_VERSION_COL_NUM = 7;
    private static final int HBA_FIRM_VERSION_COL_NUM = 8;
    private static final int MULTIPATH_SOFT_COL_NUM = 9;
    private static final int STORAGE_SYSTEM_COL_NUM = 10;
    private static final int STORAGE_SYSTEM_VERSION_COL_NUM = 11;
    private static final String REPORT_SHEETNAME = "Compatible_Information";
    private static final String CLI_RET_SHEET_NAME = "data";
    private static final String[] PROTOCOL_OPTION_DATAS = new String[]{"FC", "FC-NVMe", "FC or iSCSI", "iSCSI", "NVMe over RoCE"};
    private static final int CELL_CONTENT_MAX_LEN = 2000;
    private static int rowBeginRowNum;
    private static String EXCEL_NAME_TIME_FORMAT;
    private static String EXCEL_NAME_TIME_SUFFIX;

    public static String getPythonFileByDevType(DevNode deployInfoCollectDevNode) {
        String devType = ItDeviceType.Host.equals((Object)deployInfoCollectDevNode.getItDeviceType()) ? deployInfoCollectDevNode.getDevTypeLevel2().toString() : deployInfoCollectDevNode.getItDeviceType().getName();
        StringBuffer pyFileSb = new StringBuffer(ApplicationContext.getInstance().getWorkPath());
        pyFileSb.append(File.separator).append("script").append(File.separator);
        List<DevScriptMapping> devScriptMappings = DeployInfoContext.getDeployContext().getDevScriptMappingList();
        DevScriptMapping devScript = devScriptMappings.stream().filter(devScriptMap -> devScriptMap.getDevType().toLowerCase(Locale.ENGLISH).equals(devType.toLowerCase(Locale.ENGLISH))).findFirst().orElse(new DevScriptMapping());
        pyFileSb.append(devScript.getScriptPath());
        return pyFileSb.toString();
    }

    public static void createExcelReportByResults(List<AbstractDeployInfoCollectCallableResult> successfulResults) {
        if (VerifyUtil.isEmpty(successfulResults)) {
            return;
        }
        Workbook workbook = DeployInfoExcelReportUtil.getExcelTemplateWorkBook();
        if (!VerifyUtil.isEmpty((Object)workbook)) {
            List<List<String>> excelModuleTitles = DeployInfoExcelReportUtil.readDatasFromSheet(workbook.getSheet(REPORT_SHEETNAME));
            DeployInfoExcelReportUtil.writeDeployExcelReport(excelModuleTitles, successfulResults);
        } else {
            log.error("read excel template error.");
        }
    }

    public static void writeDeployExcelReport(List<List<String>> excelModuleTitles, List<AbstractDeployInfoCollectCallableResult> deployInfoCollectCallableResults) {
        String reportPath = new SimpleDateFormat(EXCEL_NAME_TIME_FORMAT).format(new Date()) + EXCEL_NAME_TIME_SUFFIX;
        File reportFile = new File(DeployInfoContext.getDeployContext().getReportFile(), reportPath);
        XSSFWorkbook reportWorkBook = new XSSFWorkbook();
        Sheet dataSheet = reportWorkBook.createSheet(REPORT_SHEETNAME);
        Sheet cliRetDataSheet = reportWorkBook.createSheet(CLI_RET_SHEET_NAME);
        CellStyle titleColorStyle = DeployInfoExcelReportUtil.buildTitleCellStyle((Workbook)reportWorkBook);
        CellStyle dataCellStyle = DeployInfoExcelReportUtil.buildDataCellStyle((Workbook)reportWorkBook);
        DeployInfoExcelReportUtil.setColSize(dataSheet);
        DeployInfoExcelReportUtil.writeExcelTitles(excelModuleTitles, dataSheet, titleColorStyle);
        DeployInfoExcelReportUtil.writeExcelReportDatas(excelModuleTitles, deployInfoCollectCallableResults, dataSheet, dataCellStyle);
        DeployInfoExcelReportUtil.writeProtocolSelectDatas(dataSheet, DeployInfoExcelReportUtil.createDvConstraint(excelModuleTitles.size(), rowBeginRowNum - 1, 1, 1), DeployInfoExcelReportUtil.createDvConstraint(dataSheet, PROTOCOL_OPTION_DATAS));
        DeployInfoExcelReportUtil.writeCliRetToExcel(deployInfoCollectCallableResults, cliRetDataSheet, dataCellStyle);
        DeployInfoExcelReportUtil.writeReportFile((Workbook)reportWorkBook, reportFile);
    }

    public static List<com.huawei.ism.tool.obase.entity.DevNode> filterDevByNodeSupport(List<com.huawei.ism.tool.obase.entity.DevNode> devs) {
        return devs.stream().filter(devNode -> DeployInfoContext.getDeployContext().isDevNodeSupport(EntityUtils.toNewDev(devNode))).collect(Collectors.toList());
    }

    private static void writeProtocolSelectDatas(Sheet sheet, CellRangeAddressList cellRangeAddressList, XSSFDataValidationConstraint dvConstraint) {
        XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper((XSSFSheet)sheet);
        XSSFDataValidation dataValidation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, cellRangeAddressList);
        sheet.addValidationData((DataValidation)dataValidation);
    }

    private static CellRangeAddressList createDvConstraint(int firstRow, int lastRow, int firstCol, int lastCol) {
        return new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
    }

    private static XSSFDataValidationConstraint createDvConstraint(Sheet sheet, String[] protocolOptionDatas) {
        XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper((XSSFSheet)sheet);
        return (XSSFDataValidationConstraint)dvHelper.createExplicitListConstraint(protocolOptionDatas);
    }

    private static void writeReportFile(Workbook reportWorkBook, File file) {
        try (FileOutputStream outputStream = new FileOutputStream(FilePathUtils.checkFile((File)file));){
            reportWorkBook.write((OutputStream)outputStream);
        }
        catch (FileNotFoundException e) {
            log.error("file: {} not found.", (Object)StringUtils.getCleanMessage((String)file.getName()));
        }
        catch (IOException e) {
            log.error("write file error. {}", (Object)StringUtils.getCleanMessage((String)file.getName()));
        }
    }

    private static CellStyle buildTitleCellStyle(Workbook reportWorkBook) {
        CellStyle cellStyle = reportWorkBook.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(IndexedColors.GREEN.getIndex());
        DataFormat format = reportWorkBook.createDataFormat();
        cellStyle.setDataFormat(format.getFormat("@"));
        return cellStyle;
    }

    private static CellStyle buildDataCellStyle(Workbook reportWorkBook) {
        CellStyle cellStyle = reportWorkBook.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        DataFormat format = reportWorkBook.createDataFormat();
        cellStyle.setDataFormat(format.getFormat("@"));
        return cellStyle;
    }

    private static void writeCliRetToExcel(List<AbstractDeployInfoCollectCallableResult> deployInfoCollectCallableResults, Sheet cliRetDataSheet, CellStyle dataCellStyle) {
        int rowCount = 0;
        for (AbstractDeployInfoCollectCallableResult result : deployInfoCollectCallableResults) {
            Row row = cliRetDataSheet.createRow(rowCount);
            int cmdRetLen = result.getCmdRetList().size();
            for (int i = 0; i < cmdRetLen; ++i) {
                Cell cell = row.createCell(i);
                cell.setCellStyle(dataCellStyle);
                String cliRet = result.getCmdRetList().get(i);
                cell.setCellValue(DeployInfoExcelReportUtil.isCellValueLenCorrect(cliRet) ? cliRet : DeployInfoExcelReportUtil.handleBigCellContent(cliRet));
            }
            ++rowCount;
        }
    }

    private static boolean isCellValueLenCorrect(String value) {
        return value.length() <= 2000;
    }

    private static String handleBigCellContent(String bigCellValue) {
        log.info("this cell content is too big: {}", (Object)bigCellValue);
        return bigCellValue.substring(0, 2000);
    }

    private static void writeExcelReportDatas(List<List<String>> excelModuleTitles, List<AbstractDeployInfoCollectCallableResult> deployInfoCollectCallableResults, Sheet dataSheet, CellStyle dataCellStyle) {
        rowBeginRowNum = excelModuleTitles.size();
        LinkedList<DeployInfoCollectCallableHostResult> hostResults = new LinkedList<DeployInfoCollectCallableHostResult>();
        LinkedList<DeployInfoCollectCallableStorageResult> storateResults = new LinkedList<DeployInfoCollectCallableStorageResult>();
        for (AbstractDeployInfoCollectCallableResult infoCollectCallableResult : deployInfoCollectCallableResults) {
            if (infoCollectCallableResult instanceof DeployInfoCollectCallableHostResult) {
                hostResults.add((DeployInfoCollectCallableHostResult)infoCollectCallableResult);
                continue;
            }
            if (!(infoCollectCallableResult instanceof DeployInfoCollectCallableStorageResult)) continue;
            storateResults.add((DeployInfoCollectCallableStorageResult)infoCollectCallableResult);
        }
        if (DeployInfoExcelReportUtil.hasOnlyHostResult(hostResults, storateResults)) {
            DeployInfoExcelReportUtil.writeHostDatas(dataSheet, hostResults, dataCellStyle);
        }
        if (DeployInfoExcelReportUtil.hasOnlyStorageResult(hostResults, storateResults)) {
            DeployInfoExcelReportUtil.writeStorageResult(dataSheet, storateResults, dataCellStyle);
        }
        if (DeployInfoExcelReportUtil.hasHostAndStorageResult(hostResults, storateResults)) {
            DeployInfoExcelReportUtil.writeHostAndStorageDatas(dataSheet, hostResults, storateResults, dataCellStyle);
        }
    }

    private static void setColSize(Sheet dataSheet) {
        dataSheet.setColumnWidth(0, 4000);
        dataSheet.setColumnWidth(1, 4000);
        dataSheet.setColumnWidth(2, 8000);
        dataSheet.setColumnWidth(3, 4000);
        dataSheet.setColumnWidth(4, 6000);
        dataSheet.setColumnWidth(5, 4000);
        dataSheet.setColumnWidth(6, 6000);
        dataSheet.setColumnWidth(7, 4000);
        dataSheet.setColumnWidth(8, 4000);
        dataSheet.setColumnWidth(9, 4000);
        dataSheet.setColumnWidth(10, 4000);
        dataSheet.setColumnWidth(11, 5000);
    }

    private static boolean hasOnlyHostResult(List<DeployInfoCollectCallableHostResult> hostResults, List<DeployInfoCollectCallableStorageResult> storateResults) {
        return VerifyUtil.isEmpty(storateResults) && !VerifyUtil.isEmpty(hostResults);
    }

    private static void writeHostDatas(Sheet dataSheet, List<DeployInfoCollectCallableHostResult> hostResults, CellStyle dataCellStyle) {
        for (DeployInfoCollectCallableHostResult hostResult : hostResults) {
            List<HostCombinationInfo> hbaHostCombinationList = hostResult.getHbaHostCombinationInfos();
            for (HostCombinationInfo hbaHostCombination : hbaHostCombinationList) {
                Row row = dataSheet.createRow(rowBeginRowNum);
                DeployInfoExcelReportUtil.writeHostCombinationInfos(row, hbaHostCombination, dataCellStyle);
                ++rowBeginRowNum;
            }
        }
    }

    private static boolean hasOnlyStorageResult(List<DeployInfoCollectCallableHostResult> hostResults, List<DeployInfoCollectCallableStorageResult> storateResults) {
        return !VerifyUtil.isEmpty(storateResults) && VerifyUtil.isEmpty(hostResults);
    }

    private static void writeStorageResult(Sheet dataSheet, List<DeployInfoCollectCallableStorageResult> storateResults, CellStyle dataCellStyle) {
        storateResults.stream().forEachOrdered(storageResult -> storageResult.getCardStorageCombinationList().stream().forEachOrdered(storageCombination -> DeployInfoExcelReportUtil.writeStorageCombinationInfos(dataSheet.createRow(rowBeginRowNum++), storageCombination, dataCellStyle)));
    }

    private static boolean hasHostAndStorageResult(List<DeployInfoCollectCallableHostResult> hostResults, List<DeployInfoCollectCallableStorageResult> storateResults) {
        return !VerifyUtil.isEmpty(storateResults) && !VerifyUtil.isEmpty(hostResults);
    }

    private static void writeHostAndStorageDatas(Sheet dataSheet, List<DeployInfoCollectCallableHostResult> hostResults, List<DeployInfoCollectCallableStorageResult> storateResults, CellStyle dataCellStyle) {
        storateResults.stream().forEachOrdered(storageResult -> hostResults.stream().forEachOrdered(hostResult -> DeployInfoExcelReportUtil.writeReportDatas(dataSheet, storageResult, hostResult, dataCellStyle)));
    }

    private static void writeReportDatas(Sheet dataSheet, DeployInfoCollectCallableStorageResult storageResult, DeployInfoCollectCallableHostResult hostResult, CellStyle dataCellStyle) {
        storageResult.getCardStorageCombinationList().stream().forEachOrdered(storageCombinInfo -> hostResult.getHbaHostCombinationInfos().stream().forEachOrdered(hbaHostCombinInfo -> {
            Row row = dataSheet.createRow(rowBeginRowNum++);
            DeployInfoExcelReportUtil.writeHostCombinationInfos(row, hbaHostCombinInfo, dataCellStyle);
            DeployInfoExcelReportUtil.writeStorageCombinationInfos(row, storageCombinInfo, dataCellStyle);
        }));
    }

    private static void writeHostCombinationInfos(Row row, HostCombinationInfo hostCombination, CellStyle dataCellStyle) {
        DeployInfoExcelReportUtil.setCellValue(row.createCell(0), hostCombination.getHostName(), dataCellStyle);
        DeployInfoExcelReportUtil.setCellValue(row.createCell(1), hostCombination.getProtocol(), dataCellStyle);
        DeployInfoExcelReportUtil.setCellValue(row.createCell(3), hostCombination.getServerModel(), dataCellStyle);
        DeployInfoExcelReportUtil.setCellValue(row.createCell(4), hostCombination.getOperatingSystem(), dataCellStyle);
        DeployInfoExcelReportUtil.setCellValue(row.createCell(5), hostCombination.getKernel(), dataCellStyle);
        DeployInfoExcelReportUtil.setCellValue(row.createCell(9), hostCombination.getMultipathingSoftware(), dataCellStyle);
        DeployInfoExcelReportUtil.setCellValue(row.createCell(6), hostCombination.getHbaInfo().getHostBusAdapter(), dataCellStyle);
        DeployInfoExcelReportUtil.setCellValue(row.createCell(7), hostCombination.getHbaInfo().getHbaDriverVersion(), dataCellStyle);
        DeployInfoExcelReportUtil.setCellValue(row.createCell(8), hostCombination.getHbaInfo().getHbaFirmwareVersion(), dataCellStyle);
    }

    private static void writeStorageCombinationInfos(Row row, StorageCombination storageCombinInfo, CellStyle dataCellStyle) {
        DeployInfoExcelReportUtil.setCellValue(row.createCell(2), storageCombinInfo.getCard(), dataCellStyle);
        DeployInfoExcelReportUtil.setCellValue(row.createCell(10), storageCombinInfo.getStorageSystem(), dataCellStyle);
        DeployInfoExcelReportUtil.setCellValue(row.createCell(11), storageCombinInfo.getStorageSystemVersion(), dataCellStyle);
    }

    private static void setCellValue(Cell cell, String value, CellStyle style) {
        cell.setCellValue(value);
        cell.setCellStyle(style);
    }

    private static void writeExcelTitles(List<List<String>> excelModuleTitles, Sheet dataSheet, CellStyle titleColorStyle) {
        int dataSize = excelModuleTitles.size();
        for (int rowNum = 0; rowNum < dataSize; ++rowNum) {
            Row row = dataSheet.createRow(rowNum);
            List<String> rowDatas = excelModuleTitles.get(rowNum);
            for (int cellNum = 0; cellNum < rowDatas.size(); ++cellNum) {
                Cell cell = row.createCell(cellNum);
                cell.setCellStyle(titleColorStyle);
                cell.setCellValue(rowDatas.get(cellNum));
            }
        }
    }

    private static List<List<String>> readDatasFromSheet(Sheet sheet) {
        LinkedList<List<String>> datas = new LinkedList<List<String>>();
        int rowNum = sheet.getPhysicalNumberOfRows();
        for (int row = 0; row < rowNum; ++row) {
            ArrayList<String> rowDatas = new ArrayList<String>();
            Row readRow = sheet.getRow(row);
            if (VerifyUtil.isEmpty((Object)readRow)) continue;
            int colNum = readRow.getLastCellNum();
            for (int cellIdx = 0; cellIdx < colNum; ++cellIdx) {
                rowDatas.add(readRow.getCell(cellIdx).getStringCellValue());
            }
            datas.add(rowDatas);
        }
        return datas;
    }

    private static Workbook getExcelTemplateWorkBook() {
        XSSFWorkbook workbook = null;
        try (InputStream in = DeployInfoExcelReportUtil.class.getResourceAsStream("/config/deploy/excelTemplate/deployInfoCollectModule.xlsx");){
            workbook = new XSSFWorkbook(in);
        }
        catch (IOException e) {
            log.error("read deployInfoCollectModule excel error.");
        }
        return workbook;
    }

    static {
        EXCEL_NAME_TIME_FORMAT = "yyyyMMddHHmmss";
        EXCEL_NAME_TIME_SUFFIX = "_reportx.xlsx";
    }
}

