/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.deploy.util;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.deploy.ui.DeployCompatibilityInfoCollectDialog;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.infograb.context.CollectStatusEnum;
import com.huawei.ism.tool.infograb.utils.SceneEnvironmentImpl;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinishedSceneTaskUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FinishedSceneTaskUtil.class);
    private static final String SCENE_SN = "SN";
    private static final String SCENE_IP = "IP";
    private static final String SCENE_DEV_STATUS = "status";
    private static final String SCENE_TOOL_ID = "toolId";
    private static final String SCENE_END_TIME = "endTime";
    private static final String EMPTY_VALUE = "";
    private static final String TOOL_ID = "infoGrab";
    private static final String SCENE_DEV_STATUS_FAILED = "failed";
    private static final String SCENE_DEV_STATUS_SUCCESS = "success";

    public static void callbackScene(List<TableRow> tableRows) {
        if (!SceneUtils.isScene()) {
            return;
        }
        String endTime = FinishedSceneTaskUtil.getCurFarmatTime();
        ArrayList<Map<String, String>> sceneDevs = new ArrayList<Map<String, String>>();
        tableRows.forEach(tableRow -> FinishedSceneTaskUtil.createInfo(tableRow, endTime, sceneDevs));
        if (sceneDevs.isEmpty()) {
            sceneDevs.add(FinishedSceneTaskUtil.createEmptyInfo());
        }
        FinishedSceneTaskUtil.finishedSceneTask(sceneDevs);
    }

    private static void createInfo(TableRow tableRow, String endTime, List<Map<String, String>> sceneDevs) {
        HashMap<String, String> scenceDevInfo = new HashMap<String, String>();
        scenceDevInfo.put(SCENE_TOOL_ID, TOOL_ID);
        scenceDevInfo.put(SCENE_SN, tableRow.getValueAt(DeployCompatibilityInfoCollectDialog.getIpColNum()).toString());
        scenceDevInfo.put(SCENE_IP, tableRow.getValueAt(DeployCompatibilityInfoCollectDialog.getSnColNum()).toString());
        scenceDevInfo.put(SCENE_END_TIME, endTime);
        String status = CollectStatusEnum.COLLECT_FAILED.toString();
        if (tableRow.getValueAt(DeployCompatibilityInfoCollectDialog.getStatusColNum()) instanceof IsmTableCell.IconCell) {
            IsmTableCell.IconCell cell = (IsmTableCell.IconCell)tableRow.getValueAt(DeployCompatibilityInfoCollectDialog.getStatusColNum());
            status = cell.toString();
        }
        if (CollectStatusEnum.NOT_COLLECT.toString().equals(status)) {
            return;
        }
        if (CollectStatusEnum.COLLECT_SUCC.toString().equals(status)) {
            scenceDevInfo.put(SCENE_DEV_STATUS, SCENE_DEV_STATUS_SUCCESS);
        } else {
            scenceDevInfo.put(SCENE_DEV_STATUS, SCENE_DEV_STATUS_FAILED);
        }
        sceneDevs.add(scenceDevInfo);
    }

    private static Map<String, String> createEmptyInfo() {
        HashMap<String, String> scenceDevInfo = new HashMap<String, String>();
        scenceDevInfo.put(SCENE_TOOL_ID, TOOL_ID);
        scenceDevInfo.put(SCENE_SN, EMPTY_VALUE);
        scenceDevInfo.put(SCENE_IP, EMPTY_VALUE);
        scenceDevInfo.put(SCENE_DEV_STATUS, EMPTY_VALUE);
        scenceDevInfo.put(SCENE_END_TIME, EMPTY_VALUE);
        return scenceDevInfo;
    }

    private static String getCurFarmatTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date());
    }

    private static void finishedSceneTask(List<Map<String, String>> callBackMap) {
        boolean result = false;
        try {
            result = SceneEnvironmentImpl.getInstance().finishedSceneTask(callBackMap);
        }
        catch (ToolException e) {
            LOGGER.error("write roll back data failed");
        }
        if (!result) {
            LOGGER.info("scene call back faild!");
        }
    }
}

