/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.deploy.context.DeployInfoContext;
import com.huawei.ism.tool.deploy.ui.DeployCompatibilityInfoCollectDialog;
import com.huawei.ism.tool.framework.platform.common.ui.IStartAction;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.ui.InfoGrabMainFrame;
import com.huawei.ism.tool.infograb.utils.SceneEnvironmentImpl;
import com.huawei.ism.tool.infograb.utils.migration.SmartIdcUtil;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoGrabAction
implements IStartAction {
    private static final String EVALTOOL_DB_5300_V3 = "/UpgradeEvaluation/db/db_5300_v3.db";
    private static final String DB_DB_5300_V3_CUT_DB = "/db/db_5300_v3_cut.db";
    private static final int ONE_MB = 0x100000;
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoGrabAction.class);
    private static final String PRODUCT_SUPPORT_PAKAGE = "productSuportPkgPath";

    public void actionPerformed(Window parent, ActionEvent e) {
        this.initSceneIfNeeded();
        if (DeployInfoContext.getDeployContext().isDeployInfoCollect()) {
            DeployCompatibilityInfoCollectDialog deployDialog = new DeployCompatibilityInfoCollectDialog(null);
            deployDialog.setVisible(true);
        } else {
            String path = ApplicationContext.getInstance().getWorkPath();
            HibernateContainer.getInstance().put(PRODUCT_SUPPORT_PAKAGE, (Object)(path + File.separator + "packages" + File.separator + "toolkit"));
            InfoGrabMainFrame dialog = new InfoGrabMainFrame();
            dialog.setVisible(true);
            LOGGER.info("InfoGrab tools has been initialized!");
            OperationEnum.START_TOOL.successLog("");
            this.copyDbIfEvalToolNeed();
            SmartIdcUtil.INSTANCE.startSmartIDC();
        }
    }

    private void copyDbIfEvalToolNeed() {
        try {
            boolean isInSvp = LocalHostUtil.isRunInSvp();
            if (!isInSvp) {
                LOGGER.info("not in svp.no need to copy");
                return;
            }
            String workpath = ApplicationContext.getInstance().getWorkPath();
            String evalToolPath = new File(workpath).getParent() + EVALTOOL_DB_5300_V3;
            File dbFile = new File(evalToolPath);
            if (!dbFile.exists() || dbFile.length() < 0x100000L) {
                if (!new File(evalToolPath).getParentFile().exists()) {
                    LOGGER.info("create result :{}", (Object)new File(evalToolPath).getParentFile().mkdirs());
                }
                Files.copy(Paths.get(workpath + DB_DB_5300_V3_CUT_DB, new String[0]), Paths.get(evalToolPath, new String[0]), new CopyOption[0]);
            }
        }
        catch (Exception e) {
            LOGGER.error("exec copy db file error", (Throwable)e);
        }
    }

    private void initSceneIfNeeded() {
        try {
            if (SceneUtils.isScene()) {
                SceneEnvironmentImpl.getInstance().initSceneEnvir();
            }
        }
        catch (ToolException e) {
            LOGGER.error("exec init scene error", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("exec init scene error", (Throwable)e);
        }
    }
}

