/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.connection;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.infograb.connection.SshConnectionHelper;
import com.huawei.ism.tool.infograb.entity.DBCmdResultSet;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.connection.AbstractGrabConn;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.constant.CliCmdModel;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;

public class DbConnection
extends AbstractGrabConn {
    public static final String EXE_FAILED = "TOOLKIT_EXE_CMD_FAILED";
    private static final String SQL_QUERY_MYSQL_DBNAME = "show databases";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DbConnection.class);
    private static final Object LOCK = new Object();
    private static final int CMD_DEFAULT_TIMEOUT = 1200;
    private DevNode devNode;
    private String systemInfo = "";
    private String asmInfo = "";
    private String asmOracleInfo = "";
    private String username;
    private String password;
    private String ip = "";
    private int dbPort = 0;
    private String dbName = "";
    private String dbType;
    private Connection conn = null;
    private List<PreparedStatement> psList;
    private List<ResultSet> rsList;
    private boolean useJdbc;
    private ICliConnection sshCon = null;
    private final Map<String, String> echoValueMap = new HashMap<String, String>();

    protected void setSshCon(ICliConnection sshCon) {
        this.sshCon = sshCon;
    }

    public DbConnection(String ip, User loginUser, int port, String dbType, String dbName, boolean useJdbc) {
        this.ip = ip;
        this.username = loginUser.getUserName();
        this.setPassword(loginUser.getPassword());
        this.dbPort = port;
        this.dbType = dbType;
        this.dbName = dbName;
        this.useJdbc = useJdbc;
        this.psList = new LinkedList<PreparedStatement>();
        this.rsList = new LinkedList<ResultSet>();
    }

    public String getSystemInfo() {
        return this.systemInfo;
    }

    public String getAsmInfo() {
        return this.asmInfo;
    }

    public void setAsmInfo(String asmInfo) {
        this.asmInfo = asmInfo;
    }

    public void setSystemInfo(String systemInfo) {
        this.systemInfo = systemInfo;
    }

    private void openMySqlConn() throws ToolException {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            StringBuilder url = new StringBuilder();
            url.append("jdbc:mysql://");
            url.append(this.ip);
            url.append(':');
            url.append(this.dbPort);
            url.append('/');
            url.append(this.dbName);
            url.append("?user=");
            url.append(this.username);
            url.append("&password=");
            url.append(this.getPassword());
            url.append("&useSSL=true");
            url.append("&serverTimezone=UTC");
            this.conn = DriverManager.getConnection(url.toString());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("read mysql driver error, not found the class.", (Throwable)e);
            throw new ToolException("build.connection.error.no.mysql", e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("get mysql connection error.", (Throwable)e);
            throw new ToolException("build.connection.failed.db", new String[]{this.getIp()}, e.getMessage(), e);
        }
    }

    private void openOracleConn() throws ToolException {
        try {
            Properties props = new Properties();
            Class.forName("oracle.jdbc.driver.OracleDriver");
            StringBuilder url = new StringBuilder();
            url.append("jdbc:oracle:thin:@");
            url.append(this.ip);
            url.append(':');
            url.append(this.dbPort);
            url.append(':');
            url.append(this.dbName);
            props.put("user", this.username);
            props.put("password", this.getPassword());
            props.put("useSSL", "True");
            if ("sys".equalsIgnoreCase(this.username)) {
                props.put("defaultRowPrefetch", "15");
                props.put("internal_logon", "sysdba");
            }
            this.conn = DriverManager.getConnection(url.toString(), props);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("read oracle driver error, not found the class.", (Throwable)e);
            throw new ToolException("build.connection.error.no.oracle", e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("get oracle connection error.", (Throwable)e);
            throw new ToolException("build.connection.failed.db", new String[]{this.getIp()}, e.getMessage(), e);
        }
    }

    private void openDb2Conn() throws ToolException {
        try {
            Class.forName("com.ibm.db2.jcc.DB2Driver");
            String url = "jdbc:db2://" + this.ip + ':' + this.dbPort + '/' + this.dbName;
            Properties pro = new Properties(System.getProperties());
            pro.put("user", this.username);
            pro.put("password", this.getPassword());
            pro.put("useSSL", "True");
            this.conn = DriverManager.getConnection(url, pro);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("read db2 driver error, not found the class.", (Throwable)e);
            throw new ToolException("build.connection.error.no.db2", e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("build db2 database connection failed.", (Throwable)e);
            throw new ToolException("build.connection.failed.db", new String[]{this.getIp()}, e.getMessage(), e);
        }
    }

    private void openSQLServerConn() throws ToolException {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            StringBuilder url = new StringBuilder();
            url.append("jdbc:sqlserver://");
            url.append(this.ip);
            url.append(':');
            url.append(this.dbPort);
            url.append("; DatabaseName=");
            url.append(this.dbName);
            url.append("; useSSL=true");
            this.conn = DriverManager.getConnection(url.toString(), this.username, this.getPassword());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("the sqlserver class cannot be located.", (Throwable)e);
            throw new ToolException("build.connection.error.no.sqlserver", "the class cannot be located.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("build sqlserver database connection failed.", (Throwable)e);
            throw new ToolException("build.connection.failed.db", new String[]{this.getIp()}, e.getMessage(), e);
        }
    }

    public ResultSet executeQuery(String sql, String ... parameters) throws ToolException {
        ResultSet rs = null;
        PreparedStatement ps = null;
        if (!this.isConnected()) {
            throw new ToolException("build.connection.failed.db");
        }
        try {
            ps = this.conn.prepareStatement(sql, 1004, 1007);
            for (int i = 1; i <= parameters.length; ++i) {
                ps.setString(i, parameters[i + 1]);
            }
            rs = ps.executeQuery();
            this.rsList.add(rs);
            this.psList.add(ps);
        }
        catch (SQLException e) {
            this.echoValueMap.put(sql, "unknown");
            this.dealwithSqlException(ps);
        }
        catch (Exception e) {
            this.dealwithSqlException(ps);
        }
        LOGGER.info("excute sql : {} , result = {}{}", new Object[]{sql, System.lineSeparator(), StringUtils.getCleanMessage((String)this.parseResultsetToStr(rs))});
        try {
            if (null != rs) {
                rs.beforeFirst();
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQLException.");
        }
        return rs;
    }

    private String parseResultsetToStr(ResultSet resultSet) {
        StringBuilder sbStr = new StringBuilder();
        if (null == resultSet) {
            LOGGER.info("resultSet is null.");
            return sbStr.toString();
        }
        try {
            resultSet.beforeFirst();
            LinkedList<String> columeName = new LinkedList<String>();
            ResultSetMetaData rsmd = resultSet.getMetaData();
            int count = rsmd.getColumnCount();
            sbStr.append("DataBase Column Name : ");
            for (int i = 1; i <= count; ++i) {
                String columnStr = rsmd.getColumnLabel(i);
                columeName.add(columnStr);
                sbStr.append("[");
                sbStr.append(columnStr);
                sbStr.append("]");
            }
            sbStr.append(System.getProperty("line.separator"));
            while (resultSet.next()) {
                for (String name : columeName) {
                    sbStr.append(resultSet.getString(name)).append("|");
                }
                sbStr.append(System.getProperty("line.separator"));
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error happened in parseResultsetToStr.");
        }
        catch (Exception e) {
            LOGGER.error("Error Exception happened in parseResultsetToStr", (Throwable)e);
        }
        return sbStr.toString();
    }

    private void dealwithSqlException(PreparedStatement ps) {
        try {
            if (null != ps) {
                ps.close();
            }
        }
        catch (SQLException e1) {
            LOGGER.error("DbConnection close stream err");
        }
    }

    private void closeResource() {
        try {
            for (PreparedStatement ps : this.psList) {
                ps.close();
            }
            for (ResultSet rs : this.rsList) {
                rs.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("close resource PreparedStatement or ResultSet error.");
        }
    }

    private void closeConn() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
            if (this.sshCon != null) {
                this.sshCon.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("db connection close error.");
        }
    }

    @Override
    public void close() {
        this.closeResource();
        this.closeConn();
    }

    @Override
    public void connect() throws ToolException {
        if (!this.useJdbc) {
            this.sshCon = SshConnectionHelper.getSshConnection(this.devNode);
            this.sshCon.connect();
            this.changeLanguageToEn();
            String currentName = this.sshCon.execCmd("whoami");
            if (!this.username.equalsIgnoreCase("root") && !SshConnection.isSwitchRoot(currentName)) {
                if (SshConnection.checkWhoAmICommond(currentName)) {
                    throw new ToolException(ResourceUtil.getString((String)"infograb.check.whoami.error"));
                }
                throw new ToolException(ResourceUtil.getString((String)"infograb.switchroot.passwd.error"));
            }
            this.initSysInfo();
            this.connectDbMonitor();
            return;
        }
        if (this.dbType.equalsIgnoreCase("mysql")) {
            this.openMySqlConn();
        } else if (this.dbType.equalsIgnoreCase("oracle")) {
            this.openOracleConn();
        } else if (this.dbType.equalsIgnoreCase("SQLServer")) {
            this.openSQLServerConn();
        } else if (this.dbType.equalsIgnoreCase("DB2")) {
            this.openDb2Conn();
        } else {
            LOGGER.error("Error DB Type!");
            throw new ToolException(ResourceUtil.getString((String)"db.connect.error.dbtype"));
        }
    }

    protected void initSysInfo() {
        if (this.dbType.equalsIgnoreCase("oracle") && StringUtils.isNULLStr((String)this.systemInfo)) {
            try {
                this.systemInfo = this.sshCon.execCmd("uname -a");
                this.asmInfo = this.sshCon.execCmd("ps -ef|grep pmon|cat");
                this.asmOracleInfo = this.sshCon.execCmd("ps -ef|grep ocssd.bin|cat");
            }
            catch (Exception e) {
                LOGGER.error("init system info error!", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isConnected() {
        try {
            if ("DB2".equalsIgnoreCase(this.dbType)) {
                return this.conn != null && !this.conn.isClosed();
            }
            return this.conn != null && !this.conn.isClosed() && this.conn.isValid(1);
        }
        catch (SQLException e) {
            LOGGER.error("check connection status error in method isConnected().");
            return false;
        }
    }

    public void setPassword(String pwd) {
        this.password = AESEncrypt.encrypt((String)pwd);
    }

    public String getPassword() {
        return AESEncrypt.decrypt((String)this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execSql(String sql) throws ToolException {
        Object object = LOCK;
        synchronized (object) {
            if (this.useJdbc) {
                return new DBCmdResultSet(sql, this.executeQuery(sql, new String[0]));
            }
            return new DBCmdResultSet(sql, this.execSqlBySsh(sql));
        }
    }

    private synchronized String execSqlBySsh(String sql) throws ToolException {
        String exeSqlRetString = this.sshCon.execCmdWithTimout(sql + ";", 60);
        if ((exeSqlRetString = exeSqlRetString.substring(exeSqlRetString.lastIndexOf(ToolConstants.ENTER) + 2) + exeSqlRetString.substring(0, exeSqlRetString.lastIndexOf(ToolConstants.ENTER) + 2)).contains("SP2-") || exeSqlRetString.contains("ORA-")) {
            return exeSqlRetString + EXE_FAILED + ToolConstants.ENTER;
        }
        if (exeSqlRetString.contains(EXE_FAILED)) {
            String[] values = exeSqlRetString.split(EXE_FAILED);
            if (2 == values.length) {
                this.echoValueMap.put(sql, values[1]);
            } else {
                this.echoValueMap.put(sql, "unknown");
            }
        }
        return exeSqlRetString;
    }

    @Override
    public String execCmd(String command) throws ToolException {
        return this.sshCon.execCmdWithTimout(command, 1200);
    }

    @Override
    public String execCmdNoLog(String command) throws ToolException {
        Object object = LOCK;
        synchronized (object) {
            throw new ToolException("cli.wrong.function.called");
        }
    }

    @Override
    public String execCmdNoLogTimout(String cmd, int timeOut) throws ToolException {
        Object object = LOCK;
        synchronized (object) {
            throw new ToolException("cli.wrong.function.called");
        }
    }

    @Override
    public void execCmdWithOutReturn(String command) throws ToolException {
        Object object = LOCK;
        synchronized (object) {
            throw new ToolException("cli.wrong.function.called");
        }
    }

    @Override
    public String execCmdWithTimout(String command, int timeout) throws ToolException {
        Object object = LOCK;
        synchronized (object) {
            throw new ToolException("cli.wrong.function.called");
        }
    }

    @Override
    public void setCLIMode(CliCmdModel mode) {
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String queryMysqlDbName() {
        StringBuilder mysqlDbNameBuilder = new StringBuilder();
        try {
            ResultSet rsTableName = this.executeQuery(SQL_QUERY_MYSQL_DBNAME, new String[0]);
            if (null == rsTableName) {
                return mysqlDbNameBuilder.toString();
            }
            List<String> columeName = this.queryByName(rsTableName);
            this.formMysqlDbNameBulider(mysqlDbNameBuilder, rsTableName, columeName);
        }
        catch (SQLException e) {
            LOGGER.error("execute sql error.");
        }
        catch (Exception e) {
            LOGGER.error("execute sql error.", (Throwable)e);
        }
        return mysqlDbNameBuilder.toString();
    }

    private List<String> queryByName(ResultSet rsTableName) throws SQLException {
        LinkedList<String> columeName = new LinkedList<String>();
        ResultSetMetaData rsmd = rsTableName.getMetaData();
        int count = rsmd.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            columeName.add(rsmd.getColumnLabel(i));
        }
        return columeName;
    }

    private void formMysqlDbNameBulider(StringBuilder mysqlDbNameBuilder, ResultSet rsTableName, List<String> columeName) throws SQLException {
        while (rsTableName.next()) {
            for (String name : columeName) {
                mysqlDbNameBuilder.append(rsTableName.getString(name)).append(',');
            }
        }
    }

    protected void connectDbMonitor() throws ToolException {
        String connectDbRet = null;
        if (this.dbType.equalsIgnoreCase("oracle") && !ToolUtils.isHavePreUpgrabdeScene()) {
            String name = this.sshCon.execCmd("whoami");
            if (this.username.equalsIgnoreCase("root") || SshConnection.isSwitchRoot(name)) {
                this.sshCon.execCmdNoLogTimout("su - oracle", 60);
            }
            this.sshCon.execCmdNoLogTimout("sqlplus \"/as sysdba\"", 60);
            LOGGER.info("sqlplus \"/as sysdba\" connectDbRet = {}{}", (Object)System.lineSeparator(), connectDbRet);
            connectDbRet = this.sshCon.execCmdNoLogTimout("set sqlprompt SQL>", 60);
            if (!this.checkDbRetBySsh(connectDbRet)) {
                throw new ToolException("build.connection.failed.db", new String[]{this.getIp()});
            }
        } else if (this.dbType.equalsIgnoreCase("oracle") && ToolUtils.isHavePreUpgrabdeScene()) {
            String asmOracleName = ToolUtils.getASMInstanceName(this.asmInfo);
            String asmOracleSID = ToolUtils.getASMInstanceSID(this.asmInfo);
            String asmOracleHome = ToolUtils.getASMInstanceHome(this.asmOracleInfo);
            if (!(StringUtils.isNULLStr((String)asmOracleName) || StringUtils.isNULLStr((String)asmOracleSID) || StringUtils.isNULLStr((String)asmOracleHome))) {
                this.sshCon.execCmdHasLog("su - " + asmOracleName);
                this.sshCon.execCmdHasLog("export ORACLE_SID=" + asmOracleSID);
                this.sshCon.execCmdHasLog("export ORACLE_HOME=" + asmOracleHome);
                this.sshCon.execCmdHasLog("sqlplus / as sysasm");
                String cliRet = this.sshCon.execCmdHasLog("set sqlprompt SQL>");
                if (!this.checkDbRetBySsh(cliRet)) {
                    throw new ToolException("build.connection.failed.db", new String[]{this.getIp()});
                }
                this.sshCon.execCmdHasLog("set linesize 1000");
                this.sshCon.execCmdHasLog("col path for a40");
                this.sshCon.execCmdHasLog("col name for a30");
                this.sshCon.execCmdHasLog("col value for a30");
                this.sshCon.execCmdHasLog("col describe for a100");
            } else {
                if (!StringUtils.isNULLStr((String)asmOracleSID)) {
                    String msgKey = "infograb.layout.device.add.deviceadddialog.oracle.sshadd.notsupport.tip";
                    String msg = ResourceUtil.getStringWithParams((String)msgKey, (Object[])new Object[]{asmOracleSID});
                    LOGGER.info("asmName msg = {}", (Object)msg);
                    throw new ToolException(msg, false);
                }
                String msg = ResourceUtil.getString((String)"infograb.layout.device.add.deviceadddialog.oracle.noasm.tip");
                LOGGER.info("asmName msg = {}", (Object)msg);
                throw new ToolException(msg, false);
            }
        }
    }

    @Override
    public String execCmdHasLog(String command) throws ToolException {
        return this.sshCon.execCmdHasLog(command);
    }

    private boolean checkDbRetBySsh(String ret) {
        if (null == ret) {
            return false;
        }
        boolean result1 = ret.trim().endsWith("SQL>") || ret.trim().endsWith("mysql>");
        boolean result2 = !ret.contains("idle instance");
        return result1 && result2;
    }

    @Override
    public void execSwitchRootCmd(com.huawei.ism.tool.framework.pubservice.entity.DevNode device) {
    }

    private void changeLanguageToEn() throws ToolException {
        String execCmd = this.sshCon.execCmd("uname -a");
        if (StringUtils.isNULLStr((String)execCmd)) {
            if ((execCmd = execCmd.toLowerCase(Locale.ENGLISH)).contains("linux") || execCmd.contains("fusionsphere") || execCmd.contains("solaris") || execCmd.contains("xenserver")) {
                this.sshCon.execCmd("export LC_ALL=en_US.UTF-8");
            } else if (execCmd.contains("aix")) {
                this.sshCon.execCmd("export LC_ALL=en_US");
            } else if (execCmd.contains("hp-ux")) {
                this.sshCon.execCmd("export LANG=en_US.utf8");
            } else {
                ToolLoggerFactory.getLogger(DbConnection.class).info("the system is windows or vmware, need not to change language to English.");
            }
        }
    }

    @Override
    public ICliConnection.CliRtnEntity asyncExecReturnEntity(String commandLine, int timeout) throws ToolException {
        return null;
    }

    @Override
    public ICliConnection.CliRtnEntity asyncExecReturnEntity(String commandLine) throws ToolException {
        return null;
    }

    @Override
    public String execCmdWithKeepAlive(String commandLine, int keepInterval, List<String> endStrs) throws ToolException {
        return null;
    }

    @Override
    public String execCmdWithKeepAlive(String commandLine, ICliConnection.SSHCmdParamEntity paramEntity) throws ToolException {
        return null;
    }

    @Override
    public String execCmdWithTimout(String commandLine, int timeout, List<String> endStrs) throws ToolException {
        return null;
    }

    @Override
    public String execCmd(String commandLine, List<String> endStrs) throws ToolException {
        return null;
    }

    @Override
    public String execCmdNoLog(String command, List<String> endStrs) throws ToolException {
        LOGGER.warn("execCmdNoLog is not implemented");
        return null;
    }

    @Override
    public String execCmdNoLogTimout(String cmd, int timeOut, List<String> endStrs) throws ToolException {
        LOGGER.warn("execCmdNoLogTimout is not implemented");
        return null;
    }

    @Override
    public Map<String, String> getEchoValue() {
        return this.echoValueMap;
    }

    public void setDevNode(DevNode devNode) {
        this.devNode = devNode;
    }
}

