/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.connection;

import com.huawei.ism.tool.infograb.connection.DbConnection;
import com.huawei.ism.tool.infograb.connection.DbConnectionCreator;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.IGrabCliConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ConnPoolUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbConnectionManager.class);
    private static ConcurrentHashMap<String, DbConnection> connectionPool = new ConcurrentHashMap();
    private static Object lock = new Object();

    private DbConnectionManager() {
        LOGGER.info("DbConnectionManager has been initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IGrabCliConnection getDbConnection(DevNode devNode) throws ToolException {
        String key = ConnPoolUtils.getKey(devNode);
        Object object = lock;
        synchronized (object) {
            DbConnection dbConn = connectionPool.get(key);
            if (dbConn == null || !dbConn.isConnected()) {
                dbConn = new DbConnectionCreator(devNode).create();
                connectionPool.put(key, dbConn);
            }
            return dbConn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConnection(GrabDevNode1 devNode) {
        Object object = lock;
        synchronized (object) {
            String key = ConnPoolUtils.getKey(devNode);
            DbConnection dbConn = connectionPool.get(key);
            if (dbConn != null && dbConn.isConnected()) {
                dbConn.close();
            }
            connectionPool.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConnection(ICliConnection connection) {
        if (connection == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            for (Map.Entry<String, DbConnection> entry : connectionPool.entrySet()) {
                if (entry.getValue() != connection) continue;
                if (connection.isConnected()) {
                    connection.close();
                }
                connectionPool.remove(entry.getKey());
            }
        }
    }
}

