/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.connection;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.connection.DbConnection;
import com.huawei.ism.tool.infograb.entity.DBCmdResultSet;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.obase.connection.FileConnection;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.constant.CliCmdModel;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.simu.EchoMgr;
import com.huawei.ism.tool.obase.utils.CommonEncodeDetectUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class FileConnectionGrab
extends DbConnection {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FileConnection.class);
    private Map<String, String> echoValueMap = new HashMap<String, String>();
    private DevNode devNode;
    private EchoMgr echoMgr = null;

    public DevNode getDevNode() {
        return this.devNode;
    }

    public void setDevNode(DevNode devNode) {
        this.devNode = devNode;
    }

    @Override
    public synchronized String execCmd(String command) throws ToolException {
        return this.execCmdWithTimout(command, 0);
    }

    public String executeCmdTimeoutLcalWmic(String command, int timeout) throws ToolException {
        return this.execCmdWithTimout(command, 0);
    }

    @Override
    public synchronized String execCmdNoLog(String command) throws ToolException {
        return this.execCmdNoLogTimout(command, 10);
    }

    @Override
    public String execCmdNoLog(String command, List<String> endStrs) throws ToolException {
        return this.execCmdNoLogTimout(command, 10);
    }

    @Override
    public String execCmdHasLog(String command) throws ToolException {
        return this.execCmdWithTimout(command, 10);
    }

    @Override
    public String execCmdHasLogTimout(String command, int timeOut) throws ToolException {
        return this.execCmdWithTimout(command, timeOut);
    }

    public String sendCmdAndGetResult(int timeout, boolean isLog, String cmd, ICliConnection.SSHCmdParamEntity params) throws ToolException {
        return this.execCmdWithTimout(cmd, 10);
    }

    public String getHost() {
        return this.devNode.getIp();
    }

    @Override
    public synchronized String execCtrlCmd(String ctrlCmd, int timeOutSecs, List<String> endStrs) throws ToolException {
        return this.execCmdWithTimout(ctrlCmd, 10);
    }

    @Override
    public synchronized String execCmdNoLogTimout(String command, int timeOut) throws ToolException {
        return this.getCommandExecRet(command, false);
    }

    @Override
    public String execCmdNoLogTimout(String cmd, int timeOut, List<String> endStrs) throws ToolException {
        return this.execCmdNoLogTimout(cmd, 10);
    }

    @Override
    public synchronized void execCmdWithOutReturn(String command) throws ToolException {
        LOGGER.info("method execCmdWithOutReturn invked...");
    }

    @Override
    public synchronized String execCmdWithTimout(String command, int timeout) {
        return this.getCommandExecRet(command, true);
    }

    public synchronized String getCommandExecRet(String command, boolean isLog) {
        String ret;
        block3: {
            String cmd = command.trim();
            ret = "";
            try {
                String data = this.echoMgr.getEcho(cmd, null);
                ret = "~>" + cmd + System.lineSeparator() + data;
                if (isLog) {
                    LOGGER.info("cmd={},\n{}", (Object)cmd, (Object)ret);
                }
            }
            catch (ToolException e) {
                ret = cmd + ToolConstants.ENTER + "TOOLKIT_EXE_CMD_FAILED";
                if (!isLog) break block3;
                LOGGER.info("cmd={},\n{}", (Object)cmd, (Object)ret);
            }
        }
        return ret;
    }

    public String getCharset() {
        String charSet;
        try {
            charSet = CommonEncodeDetectUtils.endcodeDetect(this.devNode.getDevInfoPkgPath());
        }
        catch (Exception e1) {
            charSet = "UTF-8";
            LOGGER.error("eochde error..");
        }
        return charSet;
    }

    @Override
    public void setCLIMode(CliCmdModel mode) {
        LOGGER.info("setCLIMode invoked...{}", (Object)this.devNode.getIp());
    }

    @Override
    public void close() {
    }

    @Override
    public void connect() throws ToolException {
        this.setSshCon(this);
        this.initSysInfo();
        this.connectDbMonitor();
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    @Override
    public ICliConnection.CliRtnEntity asyncExecReturnEntity(String commandLine, int timeout) throws ToolException {
        LOGGER.info("asyncExecReturnEntity invked...");
        return null;
    }

    @Override
    public ICliConnection.CliRtnEntity asyncExecReturnEntity(String commandLine) throws ToolException {
        return null;
    }

    @Override
    public String execCmdWithKeepAlive(String commandLine, int keepInterval, List<String> endStrs) throws ToolException {
        return this.execCmdWithTimout(commandLine, 10);
    }

    @Override
    public String execCmdWithKeepAlive(String cmd, ICliConnection.SSHCmdParamEntity paramEntity) throws ToolException {
        return this.execCmdWithTimout(cmd, 10);
    }

    @Override
    public String execCmdWithTimout(String commandLine, int timeout, List<String> endStrs) throws ToolException {
        return this.execCmdWithTimout(commandLine, 10);
    }

    @Override
    public String execCmd(String commandLine, List<String> endStrs) throws ToolException {
        return this.execCmdWithTimout(commandLine, 10);
    }

    @Override
    public String execCmdWithNoCheckResult(String commandLine, int timeOut) throws ToolException {
        return this.execCmdWithTimout(commandLine, 10);
    }

    @Override
    public synchronized String execCmdWithNoCheckResult(String cmd, int timeOut, List<String> endStrs) throws ToolException {
        return this.execCmdWithTimout(cmd, 10);
    }

    @Override
    public String executeCmdTimeout(String commandLine, int timeOut) throws ToolException {
        return this.execCmdWithTimout(commandLine, 10);
    }

    @Override
    public void execSwitchRootCmd(DevNode device) {
    }

    @Override
    public synchronized Object execSql(String sql) throws ToolException {
        String ret = this.execCmdWithTimout(sql, 10);
        if (ret.contains("TOOLKIT_EXE_CMD_FAILED")) {
            ret = this.execCmdWithTimout(sql + ";", 10);
        }
        return new DBCmdResultSet("oracle", ret);
    }

    @Override
    public Map<String, String> getEchoValue() {
        return this.echoValueMap;
    }

    public synchronized String execCmdWithConditions(String commandLine, Map<String, Object> params) throws ToolException {
        return this.execCmdWithTimout(commandLine, 10);
    }

    private void setOsType(GrabDevNode1 dev) throws ToolException {
        dev.setItDeviceType(ItDeviceType.Host);
        dev.setDeviceType(DeviceType.HOST);
        String echo = this.execCmd("self_define_cmd_basicinfo");
        if (!echo.contains("TOOLKIT_EXE_CMD_FAILED")) {
            String ostype = echo.split("\n")[1].trim();
            String ip = echo.split("\n")[2].trim();
            dev.setDevTypeLevel2(DeviceType.valueOf(ostype));
            dev.setIp(ip);
            if ("Oracle".equals(ostype)) {
                dev.setItDeviceType(ItDeviceType.Database);
                User loginUser = new User("root", "");
                dev.setLoginUser(loginUser);
                this.connect();
            }
        } else {
            dev.setDevTypeLevel2(DeviceType.valueOf("Windows"));
        }
    }

    @Override
    public String getIp() {
        return this.getDevNode().getIp();
    }

    public FileConnectionGrab(GrabDevNode1 devNode) throws ToolException {
        super(devNode.getIp(), new User("root", ""), devNode.getPort(), "oracle", devNode.getDbName(), false);
        this.devNode = EntityUtils.toNewDev(devNode);
        this.echoMgr = new EchoMgr(devNode.getDevInfoPkgPath());
        this.integrityCheck();
        this.setOsType(devNode);
    }

    private void integrityCheck() throws ToolException {
        block6: {
            try {
                String workPath = ApplicationContext.getInstance().getWorkPath();
                String ignoreFile = workPath + File.separator + "manual" + File.separator + "ignorecheck.txt";
                if (new File(ignoreFile).exists()) {
                    return;
                }
                String echo = this.execCmd("self_define_cmd_checkinfo");
                ToolException te = new ToolException();
                if (!echo.contains("TOOLKIT_EXE_CMD_FAILED")) {
                    String dataVersion = echo.split("\n")[1].trim();
                    String scriptVersion = this.getScriptVersion();
                    LOGGER.info("dataVersion={},scriptVersion={}", (Object)dataVersion, (Object)scriptVersion);
                    if ("".equals(scriptVersion) || "".equals(dataVersion)) {
                        te.setDes(ResourceUtil.getString((String)"scriptgrab.scriptVersionError"));
                        throw te;
                    }
                    if ((dataVersion = dataVersion.replace("version:", "")).compareToIgnoreCase(scriptVersion) < 0) {
                        te.setDes(ResourceUtil.getString((String)"scriptgrab.scriptVersionError"));
                        throw te;
                    }
                    break block6;
                }
                te.setDes(ResourceUtil.getString((String)"scriptgrab.grabNotFinish"));
                throw te;
            }
            catch (ToolException e) {
                LOGGER.error("set ostype error.", (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getScriptVersion() {
        workPath = ApplicationContext.getInstance().getWorkPath();
        scriptPath = workPath + File.separator + "manual" + File.separator + "other_os_grab" + File.separator + "main.sh";
        br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(scriptPath), "utf-8"));
            line = null;
            lineNo = 0;
            version = "";
lbl9:
            // 2 sources

            while ((line = br.readLine()) != null) {
                if (lineNo <= 5) ** GOTO lbl-1000
                var7_9 = "";
                ** GOTO lbl22
            }
            ** GOTO lbl36
        }
        catch (IOException e) {
            try {
                FileConnectionGrab.LOGGER.error("get script version error.", (Throwable)e);
                var5_7 = "";
            }
            catch (Throwable var10_15) {
                StreamUtils.closeResource(null, br);
                throw var10_15;
            }
lbl22:
            // 1 sources

            StreamUtils.closeResource(null, (Closeable)br);
            return var7_9;
lbl-1000:
            // 1 sources

            {
                if (!line.startsWith("GRAB_VERSION=")) ** GOTO lbl-1000
                p = Pattern.compile(".*([0-9]\\.[0-9]\\.[0-9]).*");
                m = p.matcher(line);
                if (m.matches()) ** GOTO lbl-1000
                var9_13 = "";
            }
            StreamUtils.closeResource(null, (Closeable)br);
            return var9_13;
lbl-1000:
            // 1 sources

            {
                var9_14 = m.group(1);
            }
            StreamUtils.closeResource(null, (Closeable)br);
            return var9_14;
lbl-1000:
            // 1 sources

            {
                ++lineNo;
                ** GOTO lbl9
lbl36:
                // 1 sources

                var7_11 = version;
            }
            StreamUtils.closeResource(null, (Closeable)br);
            return var7_11;
            StreamUtils.closeResource(null, (Closeable)br);
            return var5_7;
        }
    }

    public FileConnectionGrab(DevNode devNode) throws ToolException {
        super(devNode.getIp(), new User("root", ""), devNode.getPort(), "oracle", devNode.getDbName(), false);
        this.devNode = devNode;
        this.echoMgr = new EchoMgr(devNode.getDevInfoPkgPath());
    }
}

