/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.connection;

import com.huawei.ism.tool.infograb.connection.SimpleAbstractGrabConnection;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.utils.RestUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.json.JSONObject;
import java.util.Locale;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestGrabConnection
extends SimpleAbstractGrabConnection {
    private static final Logger log = LoggerFactory.getLogger(RestGrabConnection.class);
    private static final String EMPTY_JSON_STR = "{}";
    private final GrabDevNode1 devNode;

    public String sendRestWithLog(String methodName, String restApi, String params) {
        String response = this.sendRestWithoutLog(methodName, restApi, params);
        log.info("Send {} rest api [{}] with params [{}]. And get response: {}.", new Object[]{this.devNode.getDeviceModel(), restApi, params, response.replaceAll("[\\n\\r]", "")});
        return response;
    }

    public String sendRestWithoutLog(String methodName, String restApi, String params) {
        try {
            return RestUtils.executeRestCmd(this.getRequestInfo(methodName, this.getUrl(restApi)), new JSONObject(StringUtils.isNULLStr(params) ? EMPTY_JSON_STR : params), this.isCheckCertificate());
        }
        catch (ToolException e) {
            log.error("Send {} rest api error.", (Object)this.devNode.getDeviceModel(), (Object)e);
            return EMPTY_JSON_STR;
        }
    }

    protected abstract ClassicHttpRequest getRequestInfo(String var1, String var2) throws ToolException;

    protected boolean isCheckCertificate() {
        if ("Vplex".equalsIgnoreCase(this.devNode.getDeviceModel()) || "Unity".equalsIgnoreCase(this.devNode.getDeviceModel())) {
            return this.devNode.isVerifyCertificate();
        }
        return true;
    }

    protected abstract String getUrlFormat();

    private String getUrl(String restApi) {
        return String.format(Locale.ENGLISH, this.getUrlFormat(), this.devNode.getIp(), this.devNode.getPort(), restApi);
    }

    protected String getBasicAuthInfo() {
        return "Basic " + Base64EncodeUtils.encode(this.getUsername() + ":" + this.getPassword());
    }

    private String getUsername() {
        return this.devNode.getLoginUser().getUserName();
    }

    private String getPassword() {
        return this.devNode.getLoginUser().getPassword();
    }

    public RestGrabConnection(GrabDevNode1 devNode) {
        this.devNode = devNode;
    }
}

