/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.connection;

import com.huawei.ism.tool.base.utils.Base64EncodeUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.connection.GrabDefaultSshJudge;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ExtendHandleException;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnectionHelper {
    private static final Logger log = LoggerFactory.getLogger(SshConnectionHelper.class);

    public static ICliConnection getSshConnection(DevNode devNode) throws ToolException {
        ICliConnection sshConnection = SshConnectionManager.getSshConnection(devNode, new GrabDefaultSshJudge());
        if (sshConnection instanceof SshConnection) {
            ((SshConnection)sshConnection).setDefaultCmdParamEntity(SshConnectionHelper.getSshCmdParamEntity());
            ((SshConnection)sshConnection).setDoExtendHandleForResult((TriFunction<String, String, ICliConnection.SSHCmdParamEntity, String>)((TriFunction)(cmd, result, params) -> SshConnectionHelper.handleSshCmdResult(cmd, result, params, sshConnection, devNode)));
        }
        SshConnectionHelper.checkClientUserAndStartIfNeed(sshConnection, devNode, false);
        return sshConnection;
    }

    public static void checkClientUserAndStartIfNeed(@NotNull ICliConnection sshConnection, @NotNull DevNode deviceNode, boolean isStart) throws ToolException {
        if (Objects.isNull(deviceNode.getClientUser())) {
            return;
        }
        User clientUser = deviceNode.getClientUser();
        String cliStartResult = sshConnection.execCmdNoLogTimout("cli_start -u " + clientUser.getUserName(), 120).toLowerCase(Locale.ENGLISH);
        if (SshConnectionHelper.isCommandNotFound(cliStartResult)) {
            throw new ToolException(ResourceUtil.getString((String)"infograb.login.client.command.notfound"));
        }
        cliStartResult = sshConnection.execCmdNoLog(Base64EncodeUtils.decode((String)clientUser.getPassword()));
        if (cliStartResult.toLowerCase(Locale.ENGLISH).contains("the user name or password is incorrect")) {
            throw new ToolException(ResourceUtil.getString((String)"infograb.login.client.password.error"));
        }
        if (!isStart) {
            sshConnection.execCmd("exit");
        }
    }

    private static boolean isCommandNotFound(String cliStartEcho) {
        return cliStartEcho.contains("not found") || cliStartEcho.contains("not-found") || cliStartEcho.contains("no such file or directory") || cliStartEcho.contains("not exist") || cliStartEcho.contains("\u4e0d\u5b58\u5728") || cliStartEcho.contains("\u6ca1\u6709\u90a3\u4e2a");
    }

    private static ICliConnection.SSHCmdParamEntity getSshCmdParamEntity() {
        ICliConnection.SSHCmdParamEntity sshCmdParamEntity = new ICliConnection.SSHCmdParamEntity();
        sshCmdParamEntity.setParams(Collections.singletonMap("Tool", "InfoGrab"));
        return sshCmdParamEntity;
    }

    private static String handleSshCmdResult(String cmd, String result, ICliConnection.SSHCmdParamEntity params, ICliConnection sshConnection, DevNode devNode) {
        if ("TOOLKIT_SEND_CMD_TIME_OUT".equals(result)) {
            try {
                SshConnectionHelper.doReconnect(params, sshConnection, devNode);
                return cmd + ToolConstants.ENTER + result + ToolConstants.ENTER;
            }
            catch (ToolException e) {
                throw new ExtendHandleException(e);
            }
        }
        if (!SshConnectionHelper.isNeedCheckResult(params) || SshConnectionHelper.isSqlOrLogout(result)) {
            return result;
        }
        if (SshConnectionHelper.isSwitch(devNode) && (!result.contains("TOOLKIT_SEND_CMD_TIME_OUT") || !result.contains("TOOLKIT_EXE_CMD_FAILED")) && StringUtils.isNotEmpty((CharSequence)result)) {
            return result + ToolConstants.ENTER;
        }
        int lastEnterIndex = result.lastIndexOf(ToolConstants.ENTER) + ToolConstants.ENTER.length();
        String cmdResult = result.substring(lastEnterIndex) + result.substring(0, lastEnterIndex);
        return SshConnectionHelper.isVmwareHost(devNode) ? cmdResult.replace("\r\r\n", "") : cmdResult;
    }

    private static void doReconnect(ICliConnection.SSHCmdParamEntity params, ICliConnection sshConnection, DevNode devNode) throws ToolException {
        if (SshConnectionHelper.isDbSsh(params)) {
            return;
        }
        SshConnectionHelper.reconnect(sshConnection);
        SshConnectionHelper.switchToRootForFusionSphere(sshConnection, devNode);
    }

    private static void reconnect(ICliConnection sshConnection) throws ToolException {
        sshConnection.close();
        sshConnection.connect();
    }

    private static void switchToRootForFusionSphere(ICliConnection sshConnection, DevNode devNode) throws ToolException {
        if (devNode == null || !"fusionsphere".equalsIgnoreCase(devNode.getDeviceName())) {
            return;
        }
        sshConnection.execCmd("TMOUT=0");
        log.info("switch to root");
        DevNode newNode = EntityUtils.cloneDevNode(devNode);
        if (devNode.getAdminUser() != null) {
            newNode.setRootUser(new User(devNode.getAdminUser().getUserName(), devNode.getAdminUser().getPassword()));
        }
        SshConnection.switchToRootIfNeeded(newNode, sshConnection);
        log.info("switch to root success!");
        sshConnection.execCmd("TMOUT=0");
    }

    private static boolean isDbSsh(ICliConnection.SSHCmdParamEntity params) {
        return params != null && SshConnectionHelper.isParamTrue(params, "isDbSsh");
    }

    private static boolean isNeedCheckResult(ICliConnection.SSHCmdParamEntity params) {
        return params != null && (params.isCkeckCmdSendResult() || SshConnectionHelper.isParamTrue(params, "needCheckResult"));
    }

    private static boolean isParamTrue(ICliConnection.SSHCmdParamEntity params, String paramKey) {
        return params.getParams() != null && Boolean.parseBoolean(Objects.toString(params.getParams().get(paramKey)));
    }

    private static boolean isSqlOrLogout(String cmdResult) {
        String trimResult = cmdResult.trim();
        return trimResult.endsWith("SQL>") || trimResult.endsWith("mysql>") || trimResult.endsWith("logout");
    }

    private static boolean isVmwareHost(DevNode devNode) {
        return Objects.nonNull(devNode) && "VMware".equals(devNode.getDeviceName());
    }

    private static boolean isSwitch(DevNode devNode) {
        return devNode != null && ItDeviceType.Switch.equals((Object)devNode.getItDeviceType());
    }

    public static void releaseConnection(ICliConnection connection) {
        SshConnectionManager.releaseConnection(connection);
    }

    private SshConnectionHelper() {
    }
}

