/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.connection;

import com.huawei.ism.tool.infograb.connection.SimpleAbstractGrabConnection;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class StorageConnection
extends SimpleAbstractGrabConnection {
    public static final String EXE_FAILED = "TOOLKIT_EXE_CMD_FAILED" + System.lineSeparator() + "unknown";
    private static final String[] ERROR_LISTS = new String[]{"Error occurred because connection refused", "Authentication failed", "Error occurred because of time out", "Error occurred during HTTP request/response"};
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(StorageConnection.class);
    private final String ip;
    private final String naviseccliCmdHead;
    private final Map<String, String> echoValueMap = new HashMap<String, String>();

    public StorageConnection(String ip) {
        this.ip = ip;
        this.naviseccliCmdHead = this.createCmdHead();
    }

    private String createCmdHead() {
        return "naviseccli -h " + this.ip + " ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String execStorageCmd(String command) {
        StringBuilder resultBuffer = new StringBuilder();
        String[] cmds = new String[]{"cmd.exe", "/C", this.naviseccliCmdHead + command};
        Process process = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader reader = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(cmds);
            pb = pb.redirectErrorStream(true);
            process = pb.start();
            inputStreamReader = new InputStreamReader(process.getInputStream(), "GBK");
            reader = new BufferedReader(inputStreamReader);
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ("".equals(line.trim())) continue;
                resultBuffer.append(line + ToolConstants.ENTER);
            }
            this.echoValueMap.remove(command);
            if (resultBuffer.toString().isEmpty()) {
                this.echoValueMap.put(command, "unknown");
                String string = "~>" + command + ToolConstants.ENTER + EXE_FAILED;
                this.doClose(process, inputStreamReader, reader);
                return string;
            }
        }
        catch (IOException e) {
            try {
                LOGGER.error("execStorageCmd error");
                this.echoValueMap.put(command, "unknown");
                String string = command + ToolConstants.ENTER + EXE_FAILED;
                this.doClose(process, inputStreamReader, reader);
                return string;
            }
            catch (Throwable throwable) {
                this.doClose(process, inputStreamReader, reader);
                throw throwable;
            }
        }
        {
            for (String errorInfo : ERROR_LISTS) {
                if (!resultBuffer.toString().contains(errorInfo)) continue;
                this.echoValueMap.put(command, "unknown");
                String string = "~>" + command + ToolConstants.ENTER + resultBuffer + ToolConstants.ENTER + EXE_FAILED;
                this.doClose(process, inputStreamReader, reader);
                return string;
            }
        }
        {
            String string = "~>" + command + ToolConstants.ENTER + resultBuffer;
            this.doClose(process, inputStreamReader, reader);
            return string;
        }
    }

    private void doClose(Process process, InputStreamReader inputStreamReader, BufferedReader reader) {
        StreamUtils.closeResource(null, reader);
        StreamUtils.closeResource(null, inputStreamReader);
        if (null != process) {
            process.destroy();
        }
    }

    @Override
    public String execCmdHasLog(String command) {
        String result = this.execStorageCmd(command);
        LOGGER.info("execute command is : {} result = {}{}", new Object[]{command, System.lineSeparator(), result});
        return result;
    }

    @Override
    public String execCmd(String command) throws ToolException {
        return this.execStorageCmd(command);
    }

    @Override
    public Map<String, String> getEchoValue() {
        return this.echoValueMap;
    }

    @Override
    public String execCmdWithTimout(String command, int timeout) throws ToolException {
        LOGGER.info("execute command <{}> with no timeout<{}> .", (Object)command, (Object)timeout);
        return this.execStorageCmd(command);
    }

    @Override
    public boolean isConnected() {
        return true;
    }
}

