/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.connection;

import com.huawei.ism.tool.infograb.connection.StorageConnection;
import com.huawei.ism.tool.infograb.connection.StorageConnectionCreator;
import com.huawei.ism.tool.infograb.connection.storage.emc.EmcUnityRestGrabConnection;
import com.huawei.ism.tool.infograb.connection.storage.emc.EmcVplexRestGrabConnection;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.obase.connection.IGrabCliConnection;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ConnPoolUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StorageConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageConnectionManager.class);
    private static Map<String, StorageConnection> connectionPool = new HashMap<String, StorageConnection>();
    private static Object lock = new Object();

    private StorageConnectionManager() {
        LOGGER.info("StorageConnectionManager has been initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IGrabCliConnection getStorageConnection(GrabDevNode1 devNode) throws ToolException {
        String key = ConnPoolUtils.getKey(devNode);
        Object object = lock;
        synchronized (object) {
            StorageConnection storageConn = connectionPool.get(key);
            if (storageConn == null) {
                storageConn = new StorageConnectionCreator(devNode).create();
                connectionPool.put(key, storageConn);
            }
            return storageConn;
        }
    }

    public static IGrabCliConnection getStorageRestConnection(GrabDevNode1 devNode) throws ToolException {
        if ("Vplex".equalsIgnoreCase(devNode.getDeviceModel())) {
            return new EmcVplexRestGrabConnection(devNode);
        }
        if ("Unity".equalsIgnoreCase(devNode.getDeviceModel())) {
            return new EmcUnityRestGrabConnection(devNode);
        }
        throw new ToolException(devNode.getDeviceModel() + " do not use rest grab.");
    }
}

