/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.entity;

import com.huawei.ism.tool.base.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.entity.DbGrabData;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.SQLExecInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DB2DevReportData {
    public static final String HTML_ENTER = "<br>";
    public static final String HTML_SPACE = "&nbsp;";
    public static final String HTML_STRING_FORMAT_END = "</p></div></div>";
    public static final String HTML_TABLE_ALIGN_START = "<div class=\"padds\">";
    public static final String HTML_TABLE_ALIGN_END = "</div>";
    public static final String HTML_STRING_FORMAT_START_1 = "<div class=\"padds\"><div class=\"tables\" style=\"border:1px solid black;\">";
    public static final String HTML_STRING_FORMAT_START_2 = "<p class=\"fonts\" style=\"padding-left:5px;white-space:nowrap;\">";
    public static final String HTML_TABLE_SCROLL_START = "<div class=\"tables\">";
    public static final String HTML_TABLE_SCROLL_END = "</div>";
    public static final String HTML_TABLE_SIZE_END = "</table>";
    public static final String HTML_TABLE_SIZE_START = "<table align=left width=100% class='hovertable'>";
    public static final String HTML_TABLE_ROW_START_1 = "<tr>";
    public static final String HTML_TABLE_ROW_START_2 = "<tr onmouseover=\"this.style.backgroundColor='#ffff66';\" ";
    public static final String HTML_TABLE_ROW_START_3 = "onmouseout=\"this.style.backgroundColor='#d4e3e5';\">";
    public static final String HTML_TABLE_ROW_END = "</tr>";
    public static final String HTML_TABLE_HEAD_START = "<th>";
    public static final String HTML_TABLE_HEAD_END = "</th>";
    public static final String HTML_TABLE_DATA_START = "<td>";
    public static final String HTML_TABLE_DATA_END = "</td>";
    private Map<String, Object> reportMap;
    private LeftTree leftTree = new LeftTree();
    private DevInfo devInfo;
    private ReightCmds reightCmds = new ReightCmds();
    private List<ExecuteResult> resultList = new LinkedList<ExecuteResult>();
    private List<DbGrabData> currDbResultList = new LinkedList<DbGrabData>();

    public DB2DevReportData(List<ExecuteResult> resultList, List<DbGrabData> currDbResultList) {
        this.resultList = resultList;
        this.currDbResultList = currDbResultList;
        this.reportMap = new HashMap<String, Object>();
        this.init();
    }

    public void init() {
        GrabDevNode2 devNode = this.resultList.get(0).getDevNode();
        this.devInfo = new DevInfo(devNode.getItDeviceType().toString(), devNode.getDevTypeLevel2().toString(), devNode.getIp(), new SimpleDateFormat("yyyy-MM-dd").format(this.resultList.get(0).getExecuteStartTime()), new SimpleDateFormat("HH:mm:ss").format(this.resultList.get(0).getExecuteStartTime()));
        for (DbGrabData dataObj : this.currDbResultList) {
            ArrayList<CmdNode> cmdList = new ArrayList<CmdNode>();
            KeyOrderedHashMap<SQLExecInfo, String> map = dataObj.getHtmlResultMap();
            KeyOrderedHashMap cmdResultMap = new KeyOrderedHashMap();
            for (Map.Entry entry : map.entrySet()) {
                SQLExecInfo sqlExecInfo = (SQLExecInfo)entry.getKey();
                if (((String)entry.getValue()).contains(ResourceUtil.getString((String)"infoGrab.execute.sql.failed"))) {
                    cmdList.add(new CmdNode((String)dataObj.getSqlDesc().get((Object)sqlExecInfo), sqlExecInfo.getSqlName(), 1));
                } else {
                    cmdList.add(new CmdNode((String)dataObj.getSqlDesc().get((Object)sqlExecInfo), sqlExecInfo.getSqlName(), 0));
                }
                String cmdDisplay = (String)entry.getValue();
                cmdResultMap.put(dataObj.getSqlDesc().get((Object)sqlExecInfo), cmdDisplay);
            }
            this.leftTree.addTreeNode(dataObj.getItem().getId(), dataObj.getItem().toString(), cmdList);
            this.reightCmds.addTreeNode(dataObj.getItem().getId(), dataObj.getItem().toString(), (Map<String, String>)cmdResultMap);
        }
        this.reportMap.put("lefttree", this.leftTree.getTreeNodeList());
        this.reportMap.put("devinfo", this.devInfo);
        this.reportMap.put("reightresult", this.reightCmds.getGrabNodeList());
    }

    public Map<String, Object> getReportMap() {
        return this.reportMap;
    }

    public static class GrabNode {
        private String dbDd;
        private String name;
        private Map<String, String> cmdResultMap;

        public GrabNode(String id, String name, Map<String, String> cmdResultMap) {
            this.dbDd = id;
            this.name = name;
            this.cmdResultMap = cmdResultMap;
        }

        public String getId() {
            return this.dbDd;
        }

        public Map<String, String> getCmdResultMap() {
            return this.cmdResultMap;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class ReightCmds {
        private List<GrabNode> grabNodeList = new ArrayList<GrabNode>();

        public void addTreeNode(String id, String name, Map<String, String> cmdResultMap) {
            this.grabNodeList.add(new GrabNode(id, name, cmdResultMap));
        }

        public List<GrabNode> getGrabNodeList() {
            return this.grabNodeList;
        }
    }

    public static class CmdNode {
        private String cmdDesc;
        private String cmdId;
        private int excuteStatus;

        public CmdNode(String cmdId, String cmdDesc, int excuteStatus) {
            this.cmdId = cmdId;
            this.cmdDesc = cmdDesc;
            this.excuteStatus = excuteStatus;
        }

        public int getExcuteStatus() {
            return this.excuteStatus;
        }

        public String getCmdDesc() {
            return this.cmdDesc;
        }

        public String getCmdId() {
            return this.cmdId;
        }
    }

    public static class TreeNode {
        private String id;
        private String name;
        private List<CmdNode> cmds;

        public TreeNode(String id, String name, List<CmdNode> cmds) {
            this.id = id;
            this.name = name;
            this.cmds = cmds;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public List<CmdNode> getCmds() {
            return this.cmds;
        }
    }

    public static class LeftTree {
        private List<TreeNode> treeNodeDbList = new ArrayList<TreeNode>();

        public void addTreeNode(String id, String name, List<CmdNode> cmds) {
            this.treeNodeDbList.add(new TreeNode(id, name, cmds));
        }

        public List<TreeNode> getTreeNodeList() {
            return this.treeNodeDbList;
        }
    }

    public static class DevInfo {
        private String devType;
        private String ip;
        private String devTypel2;
        private String dateYMD;
        private String dateMM;

        public DevInfo(String devType, String devTypel2, String ip, String dateYMD, String dateMM) {
            this.devType = devType;
            this.devTypel2 = devTypel2;
            this.ip = ip;
            this.dateYMD = dateYMD;
            this.dateMM = dateMM;
        }

        public String getIp() {
            return this.ip;
        }

        public String getDevType() {
            return this.devType;
        }

        public String getDateYMD() {
            return this.dateYMD;
        }

        public String getDevTypel2() {
            return this.devTypel2;
        }

        public String getDateMM() {
            return this.dateMM;
        }
    }
}

