/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.entity;

import com.huawei.ism.tool.base.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.infograb.context.CmdResultEnum;
import com.huawei.ism.tool.infograb.entity.DBCmdResultSet;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.grab.FilterDataLinkedHashMap;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabFileFactory;
import com.huawei.ism.tool.infograb.utils.ExportFileUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevReportData {
    private static final Logger log = LoggerFactory.getLogger(DevReportData.class);
    public static final String HTML_ENTER = "<br>";
    public static final String HTML_UPPER = "&gt;";
    public static final String HTML_LOWER = "&lt;";
    public static final String HTML_SPACE = "&nbsp;";
    public static final String HTML_STRING_FORMAT_START_1 = "<div class=\"padds\"><div class=\"tables\" style=\"border:1px solid black;\">";
    public static final String HTML_STRING_FORMAT_START_2 = "<p class=\"fonts\" style=\"padding-left:5px;white-space:nowrap;\">";
    public static final String HTML_STRING_FORMAT_END = "</p></div></div>";
    public static final String HTML_TABLE_ALIGN_START = "<div class=\"padds\">";
    public static final String HTML_TABLE_ALIGN_END = "</div>";
    public static final String HTML_TABLE_SCROLL_START = "<div class=\"tables\">";
    public static final String HTML_TABLE_SCROLL_END = "</div>";
    public static final String HTML_TABLE_SIZE_START = "<table align=left width=100% class='hovertable'>";
    public static final String HTML_TABLE_SIZE_END = "</table>";
    public static final String HTML_TABLE_ROW_START_1 = "<tr>";
    public static final String HTML_TABLE_ROW_START_2 = "<tr onmouseover=\"this.style.backgroundColor='#ffff66';\" ";
    public static final String HTML_TABLE_ROW_START_3 = "onmouseout=\"this.style.backgroundColor='#d4e3e5';\">";
    public static final String HTML_TABLE_ROW_END = "</tr>";
    public static final String HTML_TABLE_HEAD_START = "<th>";
    public static final String HTML_TABLE_HEAD_END = "</th>";
    public static final String HTML_TABLE_DATA_START = "<td>";
    public static final String HTML_TABLE_DATA_END = "</td>";
    private Map<String, Object> reportMap;
    private LeftTree leftTree = new LeftTree();
    private DevInfo devInfo;
    private ReightCmds reightCmds = new ReightCmds();
    private List<ExecuteResult> resultList = new LinkedList<ExecuteResult>();

    public DevReportData(List<ExecuteResult> resultList) {
        this.resultList = resultList;
        this.reportMap = new HashMap<String, Object>();
        this.init();
    }

    public void init() {
        GrabDevNode2 devNode = this.resultList.get(0).getDevNode();
        this.devInfo = new DevInfo(devNode.getItDeviceType().toString(), devNode.getDevTypeLevel2().toString(), devNode.getIp(), new SimpleDateFormat("yyyy-MM-dd").format(this.resultList.get(0).getExecuteStartTime()), new SimpleDateFormat("HH:mm:ss").format(this.resultList.get(0).getExecuteStartTime()));
        for (ExecuteResult result : this.resultList) {
            ArrayList<CmdNode> cmdList = new ArrayList<CmdNode>();
            KeyOrderedHashMap cmdResultMap = new KeyOrderedHashMap();
            Object errMsgObj = result.getResultMap().get("err_msg");
            String errMsg = "";
            if (null != errMsgObj) {
                errMsg = errMsgObj.toString();
            }
            for (Map.Entry<String, Object> entry : result.getResultMap().entrySet()) {
                if (!ExportFileUtil.isShowCliKeyInReport(entry.getKey())) continue;
                if (entry.getValue() instanceof String) {
                    String cmdDisplay = null;
                    cmdDisplay = entry.getValue().equals(FilterDataLinkedHashMap.getReadFromTemp()) ? (String)((FilterDataLinkedHashMap)result.getResultMap()).get(entry.getKey()) : (String)entry.getValue();
                    this.deelStringRet(cmdDisplay, cmdList, entry, (Map<String, String>)cmdResultMap);
                    continue;
                }
                if (!(entry.getValue() instanceof DBCmdResultSet)) continue;
                this.devReportDataInitDbData(cmdList, (Map<String, String>)cmdResultMap, entry, errMsg);
            }
            this.leftTree.addTreeNode(result.getItem().getId(), result.getItem().toString(), cmdList);
            this.reightCmds.addTreeNode(result.getItem().getId(), result.getItem().toString(), (Map<String, String>)cmdResultMap);
        }
        this.reportMap.put("lefttree", this.leftTree.getTreeNodeList());
        this.reportMap.put("devinfo", this.devInfo);
        this.reportMap.put("reightresult", this.reightCmds.getGrabNodeList());
    }

    private void devReportDataInitDbData(List<CmdNode> cmdList, Map<String, String> cmdResultMap, Map.Entry<String, Object> entry, String errMsg) {
        DBCmdResultSet tableResult = (DBCmdResultSet)entry.getValue();
        if (tableResult.getSqlResult() == null || tableResult.getSqlResult() instanceof ResultSet) {
            if (tableResult.getSqlResult() == null) {
                this.add2ListWihleNoSqlResult(cmdList, entry, errMsg, tableResult);
            } else {
                cmdList.add(new CmdNode(entry.getKey(), tableResult.getSqlName(), CmdResultEnum.FINISHED.getValue()));
            }
            String cmdDisplay = this.parseResultsetToTableStr(tableResult.getSqlName(), (ResultSet)tableResult.getSqlResult(), errMsg);
            cmdResultMap.put(entry.getKey(), cmdDisplay);
        } else if (tableResult.getSqlResult() instanceof String) {
            String cmdDisplay = (String)tableResult.getSqlResult();
            this.deelStringRet(cmdDisplay, cmdList, entry, cmdResultMap);
        }
    }

    private void add2ListWihleNoSqlResult(List<CmdNode> cmdList, Map.Entry<String, Object> entry, String errMsg, DBCmdResultSet tableResult) {
        String[] errMsgs;
        CmdNode sqlNode = new CmdNode(entry.getKey(), tableResult.getSqlName(), CmdResultEnum.FAILD.getValue());
        String sqlName = tableResult.getSqlName();
        for (String msg : errMsgs = errMsg.split("\r\n")) {
            if (!msg.contains(sqlName) || !msg.contains(ResourceUtil.getString((String)"infograb.dev.status.noecollect"))) continue;
            sqlNode = new CmdNode(entry.getKey(), tableResult.getSqlName(), CmdResultEnum.NOTCOLLECTED.getValue());
            break;
        }
        cmdList.add(sqlNode);
    }

    private void deelStringRet(String cmdDisplay, List<CmdNode> cmdList, Map.Entry<String, Object> entry, Map<String, String> cmdResultMap) {
        if (StringUtils.isNULLStr(cmdDisplay)) {
            log.info("cmdDisplay is empty.");
            return;
        }
        cmdDisplay = this.compStrTabToSpaceAndCut(cmdDisplay.toCharArray());
        String cmdDesc = this.parseCmdDesc(cmdDisplay.split("\n")[0].trim());
        cmdDisplay = org.apache.commons.lang3.StringUtils.replace((String)cmdDisplay, (String)">", (String)HTML_UPPER);
        cmdDisplay = org.apache.commons.lang3.StringUtils.replace((String)cmdDisplay, (String)"<", (String)HTML_LOWER);
        cmdDisplay = org.apache.commons.lang3.StringUtils.replace((String)cmdDisplay, (String)GrabFileFactory.ENTER, (String)HTML_ENTER);
        cmdDisplay = org.apache.commons.lang3.StringUtils.replace((String)cmdDisplay, (String)"\n", (String)HTML_ENTER);
        cmdDisplay = org.apache.commons.lang3.StringUtils.replace((String)cmdDisplay, (String)" ", (String)HTML_SPACE);
        cmdDisplay = "<div class=\"padds\"><div class=\"tables\" style=\"border:1px solid black;\"><p class=\"fonts\" style=\"padding-left:5px;white-space:nowrap;\">" + cmdDisplay + HTML_STRING_FORMAT_END;
        if (cmdDisplay.contains("TOOLKIT_SEND_CMD_TIME_OUT")) {
            cmdList.add(new CmdNode(entry.getKey(), cmdDesc, CmdResultEnum.FAILD.getValue()));
            cmdDisplay = org.apache.commons.lang3.StringUtils.replace((String)cmdDisplay, (String)"TOOLKIT_SEND_CMD_TIME_OUT", (String)ResourceUtil.getString((String)"infograb.execute.cmd.failed.timeout"));
            cmdResultMap.put(entry.getKey(), cmdDisplay);
        } else {
            cmdList.add(new CmdNode(entry.getKey(), cmdDesc, CmdResultEnum.FINISHED.getValue()));
        }
        cmdResultMap.put(entry.getKey(), cmdDisplay);
    }

    private String compStrTabToSpaceAndCut(char[] str) {
        int numTab = 0;
        int numEnter = 0;
        StringBuilder ret = new StringBuilder();
        for (char c : str) {
            if (c == '\n') {
                ++numEnter;
            }
            if (c != '\t') {
                ret.append(c);
            } else {
                switch (numTab % 4) {
                    case 0: {
                        ret.append("    ");
                        break;
                    }
                    case 1: {
                        ret.append("   ");
                        break;
                    }
                    case 2: {
                        ret.append("  ");
                        break;
                    }
                    default: {
                        ret.append(' ');
                    }
                }
            }
            numTab = c == '\n' || c == '\t' ? 0 : ++numTab;
            if (numEnter < 1000) continue;
            ret.append("... ...(" + ResourceUtil.getString((String)"report.display.too.long") + ")");
            break;
        }
        return ret.toString();
    }

    private String parseCmdDesc(String cmdDisplay) {
        if (cmdDisplay.contains(":~ #")) {
            return this.parseCmdDescByStr(cmdDisplay, ":~ #");
        }
        if (cmdDisplay.contains("#")) {
            return this.parseCmdDescByStr(cmdDisplay, "#");
        }
        if (cmdDisplay.contains(":/>")) {
            return this.parseCmdDescByStr(cmdDisplay, ":/>");
        }
        if (cmdDisplay.contains(":~]")) {
            return this.parseCmdDescByStr(cmdDisplay, ":~]");
        }
        if (cmdDisplay.contains(">")) {
            return this.parseCmdDescByStr(cmdDisplay, ">");
        }
        if (cmdDisplay.contains(":/")) {
            return this.parseCmdDescByStr(cmdDisplay, ":/");
        }
        if (cmdDisplay.contains(":~$")) {
            return this.parseCmdDescByStr(cmdDisplay, ":~\\$");
        }
        if (cmdDisplay.contains("~>")) {
            return this.parseCmdDescByStr(cmdDisplay, "~>");
        }
        if (cmdDisplay.contains("SQL>")) {
            return this.parseCmdDescByStr(cmdDisplay, "SQL>");
        }
        if (cmdDisplay.contains("$") && !cmdDisplay.contains("echo")) {
            return this.parseCmdDescByStr(cmdDisplay, "\\$");
        }
        if (cmdDisplay.contains("oracle")) {
            if (cmdDisplay.contains("$")) {
                return this.parseCmdDescByStr(cmdDisplay, "\\$");
            }
            if (cmdDisplay.contains(">")) {
                return this.parseCmdDescByStr(cmdDisplay, ">");
            }
        }
        return cmdDisplay;
    }

    private String parseCmdDescByStr(String cmdDisplay, String splitStr) {
        String result = cmdDisplay;
        try {
            result = cmdDisplay.split(splitStr)[1].trim();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.error("index out of bounds, return original String.");
        }
        return result;
    }

    public Map<String, Object> getReportMap() {
        return this.reportMap;
    }

    private String parseResultsetToTableStr(String sqlName, ResultSet resultSet, String errMsg) {
        if (resultSet == null) {
            String[] errMsgs;
            String cmdDisplay = sqlName + HTML_ENTER + ResourceUtil.getString((String)"infograb.execute.cmd.failed.timeout") + HTML_ENTER;
            for (String msg : errMsgs = errMsg.split("\r\n")) {
                if (!msg.contains(sqlName) || !msg.contains(ResourceUtil.getString((String)"infograb.dev.status.noecollect"))) continue;
                cmdDisplay = sqlName + HTML_ENTER + ResourceUtil.getString((String)"infograb.execute.cmd.error127&128&others") + HTML_ENTER;
            }
            cmdDisplay = "<div class=\"padds\"><div class=\"tables\" style=\"border:1px solid black;\"><p class=\"fonts\" style=\"padding-left:5px;white-space:nowrap;\">" + cmdDisplay + HTML_STRING_FORMAT_END;
            return cmdDisplay;
        }
        StringBuilder tableStr = new StringBuilder();
        tableStr.append(sqlName).append(HTML_ENTER);
        try {
            resultSet.beforeFirst();
            LinkedList<String> columeName = new LinkedList<String>();
            ResultSetMetaData rsmd = resultSet.getMetaData();
            int count = rsmd.getColumnCount();
            tableStr.append(HTML_TABLE_ALIGN_START);
            tableStr.append(HTML_TABLE_SCROLL_START);
            tableStr.append(HTML_TABLE_SIZE_START);
            tableStr.append(HTML_TABLE_ROW_START_1);
            for (int i = 1; i <= count; ++i) {
                String columnStr = rsmd.getColumnLabel(i);
                columeName.add(columnStr);
                tableStr.append(HTML_TABLE_HEAD_START).append(columnStr).append(HTML_TABLE_HEAD_END);
            }
            tableStr.append(HTML_TABLE_ROW_END);
            while (resultSet.next()) {
                tableStr.append("<tr onmouseover=\"this.style.backgroundColor='#ffff66';\" onmouseout=\"this.style.backgroundColor='#d4e3e5';\">");
                for (String name : columeName) {
                    tableStr.append(HTML_TABLE_DATA_START).append(resultSet.getString(name)).append(HTML_TABLE_DATA_END);
                }
                tableStr.append(HTML_TABLE_ROW_END);
            }
            tableStr.append(HTML_TABLE_SIZE_END);
            tableStr.append("</div>");
            tableStr.append("</div>");
        }
        catch (SQLException e) {
            log.error("Error happened in parseResultsetToStr");
        }
        return tableStr.toString();
    }

    public static class GrabNode {
        private String id;
        private String name;
        private Map<String, String> cmdResultMap;

        public GrabNode(String id, String name, Map<String, String> cmdResultMap) {
            this.id = id;
            this.name = name;
            this.cmdResultMap = cmdResultMap;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getCmdResultMap() {
            return this.cmdResultMap;
        }
    }

    public static class ReightCmds {
        private List<GrabNode> grabNodeList = new ArrayList<GrabNode>();

        public void addTreeNode(String id, String name, Map<String, String> cmdResultMap) {
            this.grabNodeList.add(new GrabNode(id, name, cmdResultMap));
        }

        public List<GrabNode> getGrabNodeList() {
            return this.grabNodeList;
        }
    }

    public static class CmdNode {
        private String cmdId;
        private String cmdDesc;
        private int excuteStatus;

        public CmdNode(String cmdId, String cmdDesc, int excuteStatus) {
            this.cmdId = cmdId;
            this.cmdDesc = cmdDesc;
            this.excuteStatus = excuteStatus;
        }

        public String getCmdId() {
            return this.cmdId;
        }

        public String getCmdDesc() {
            return this.cmdDesc;
        }

        public int getExcuteStatus() {
            return this.excuteStatus;
        }
    }

    public static class TreeNode {
        private String id;
        private String name;
        private List<CmdNode> cmds;

        public TreeNode(String id, String name, List<CmdNode> cmds) {
            this.id = id;
            this.name = name;
            this.cmds = cmds;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<CmdNode> getCmds() {
            return this.cmds;
        }
    }

    public static class LeftTree {
        private List<TreeNode> treeNodeList = new ArrayList<TreeNode>();

        public void addTreeNode(String id, String name, List<CmdNode> cmds) {
            this.treeNodeList.add(new TreeNode(id, name, cmds));
        }

        public List<TreeNode> getTreeNodeList() {
            return this.treeNodeList;
        }
    }

    public static class DevInfo {
        private String devType;
        private String ip;
        private String devTypel2;
        private String dateYMD;
        private String dateMM;

        public DevInfo(String devType, String devTypel2, String ip, String dateYMD, String dateMM) {
            this.devType = devType;
            this.devTypel2 = devTypel2;
            this.ip = ip;
            this.dateYMD = dateYMD;
            this.dateMM = dateMM;
        }

        public String getDevType() {
            return this.devType;
        }

        public String getIp() {
            return this.ip;
        }

        public String getDevTypel2() {
            return this.devTypel2;
        }

        public String getDateYMD() {
            return this.dateYMD;
        }

        public String getDateMM() {
            return this.dateMM;
        }
    }
}

