/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.entity;

import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportItem.class);
    private String taskType;
    private String taskName;
    private String devType;
    private String subType;
    private String ipAddr;
    private String grabDate;
    private String sn;
    private String taskCreateDate;
    private String htmlReportPath;
    private List<String> hostDevType = new LinkedList<String>();
    private List<String> dataBaseDevType = new LinkedList<String>();
    private List<String> switchDevType = new LinkedList<String>();
    private String appScence;
    private String hostName;
    private String filePath;

    public ReportItem() {
        this.initDevType();
        this.setDevType("");
        this.setSubType("");
        this.setIpAddr("");
        this.setGrabDate("");
        this.setSn("");
    }

    public ReportItem(String subtype, String ip, String date) {
        this.initDevType();
        this.setSubType(subtype);
        this.setDevType(this.getDevType(subtype));
        this.setIpAddr(ip);
        this.setGrabDate(date);
        this.setSn(this.generateSN());
    }

    public ReportItem(String subtype, String ip, String date, String taskType, String taskName, String taskCreateDate) {
        this(subtype, ip, date);
        this.setTaskType(taskType);
        this.setTaskName(taskName);
        this.setTaskCreateDate(taskCreateDate);
    }

    private String getDevType(String subtype) {
        if (this.hostDevType.contains(subtype)) {
            return ItDeviceType.Host.getName();
        }
        if (this.dataBaseDevType.contains(subtype)) {
            return ItDeviceType.Database.getName();
        }
        if (this.switchDevType.contains(subtype)) {
            return ItDeviceType.Switch.getName();
        }
        return "";
    }

    private void initDevType() {
        this.hostDevType.add("Linux");
        this.hostDevType.add("Aix");
        this.hostDevType.add("HP-UX");
        this.hostDevType.add("Solaris");
        this.hostDevType.add("VMware");
        this.hostDevType.add("Windows");
        this.hostDevType.add("FusionSphere");
        this.hostDevType.add("XenServer");
        this.dataBaseDevType.add("Oracle");
        this.dataBaseDevType.add("MySQL");
        this.dataBaseDevType.add("SQLServer");
        this.dataBaseDevType.add("DB2");
        this.switchDevType.add("Brocade");
        this.switchDevType.add("Cisco");
    }

    private String generateSN() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.devType.charAt(0)).append(this.devType.charAt(1)).append(this.subType.charAt(0)).append(this.subType.charAt(1)).append(this.ipAddr.replace(".", "")).append(this.grabDate);
        return builder.toString().replaceAll("[^0-9a-zA-Z]", "");
    }

    private String getDate(String dateStr) {
        if (StringUtils.isNULLStr(dateStr)) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = null;
        try {
            date = format.parse(dateStr);
            SimpleDateFormat reformat = new SimpleDateFormat("yyyyMMddHHmmss");
            return reformat.format(date);
        }
        catch (ParseException e) {
            LOGGER.info("date parse date error.");
            return "";
        }
    }

    public String getDevType() {
        return this.devType;
    }

    public void setDevType(String devType) {
        this.devType = devType;
    }

    public void setDevTypeBySubType(String subtype) {
        this.setDevType(this.getDevType(subtype));
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getHtmlReportPath() {
        return this.htmlReportPath;
    }

    public void setHtmlReportPath(String htmlReportPath) {
        this.htmlReportPath = htmlReportPath;
    }

    public String getIpAddr() {
        return this.ipAddr;
    }

    public void setIpAddr(String ipAddr) {
        this.ipAddr = ipAddr;
    }

    public String getGrabDate() {
        return this.grabDate;
    }

    public void setGrabDate(String grabDate) {
        this.grabDate = this.getDate(grabDate);
    }

    public void setHtmlGrabDate(String date) {
        this.grabDate = date;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DevType: ").append(this.getDevType()).append(" SubType: ").append(this.getSubType()).append(" IP: ").append(this.getIpAddr()).append(" Date: ").append(this.getGrabDate());
        return builder.toString();
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public String getSn() {
        return this.sn;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskCreateDate() {
        return this.taskCreateDate;
    }

    public void setTaskCreateDate(String taskCreateDate) {
        this.taskCreateDate = taskCreateDate;
    }

    public String getAppScence() {
        return this.appScence;
    }

    public void setAppScence(String appScence) {
        this.appScence = appScence;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }
}

