/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.entity;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.User;
import com.huawei.ism.tool.infograb.context.CollectStatusEnum;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class UserOpDeviceDetail {
    private static final String NO_PROXY = "0";
    private static final String SSH_FORWARD = "1";
    private static final String SOCKET5 = "2";
    private static final String PWSSWORD = "0";
    private static final String PUBLIC_KEY_PSD = "2";
    private static final String PUBLIC_KEY = "1";
    private static final String NO_AUTHWAY = "-1";
    private static final String IPV4 = "ipv4";
    private static final String IPV6 = "ipv6";
    private static final Pattern PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    private String deviceType;
    private String deviceVersion;
    private String deviceSn;
    private String proxyWay;
    private String authWay;
    private int isJdbc = 0;
    private long deviceTimeConsuming;
    private String ipv;
    private List<String> failCommand = new ArrayList<String>();
    private int deviceResult;
    private List<Map<String, Object>> collectionItem = new ArrayList<Map<String, Object>>();

    public UserOpDeviceDetail(GrabDevNode2 devNode) {
        if (devNode != null) {
            this.setAuthWay(devNode);
            this.setProxyWay(devNode);
            this.setDeviceSn(devNode.getDeviceSerialNumber());
            this.setDeviceVersion(devNode.getProductVersion());
            this.setDeviceType(devNode.getDeviceType().toString());
            this.setIpv(devNode.getIp());
            this.setIsJdbc(devNode.isUseJdbc() ? 1 : 0);
        }
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceVersion() {
        return this.deviceVersion;
    }

    public void setDeviceVersion(String deviceVersion) {
        this.deviceVersion = deviceVersion;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public void setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
    }

    public String getProxyWay() {
        return this.proxyWay;
    }

    public String getAuthWay() {
        return this.authWay;
    }

    public int getIsJdbc() {
        return this.isJdbc;
    }

    public void setIsJdbc(int isJdbc) {
        this.isJdbc = isJdbc;
    }

    public long getDeviceTimeConsuming() {
        return this.deviceTimeConsuming;
    }

    public void setDeviceTimeConsuming(long deviceTimeConsuming) {
        this.deviceTimeConsuming = deviceTimeConsuming;
    }

    public List<String> getFailCommand() {
        return this.failCommand;
    }

    public void setFailCommand(List<String> failCommand) {
        this.failCommand = failCommand;
    }

    public List<Map<String, Object>> getCollectionItem() {
        return this.collectionItem;
    }

    public void setCollectionItem(List<Map<String, Object>> collectionItem) {
        this.collectionItem = collectionItem;
    }

    public String getIpv() {
        return this.ipv;
    }

    public void setIpv(String ipv) {
        this.ipv = PATTERN.matcher(ipv).matches() ? IPV4 : IPV6;
    }

    public void setIpv(DevNode devNode) {
        this.setIpv(devNode.getIp());
    }

    private void setProxyWay(DevNode deNode) {
        this.proxyWay = null != deNode.getSocks5Proxy() ? "2" : (null != deNode.getSshForwardList() && !deNode.getSshForwardList().isEmpty() ? "1" : "0");
    }

    private void setAuthWay(DevNode deNode) {
        User user = deNode.getLoginUser();
        if (null == user) {
            this.authWay = NO_AUTHWAY;
        } else {
            if (deNode.getPriKey() != null && StringUtils.isNULLStr((String)user.getPassword())) {
                this.authWay = "1";
            }
            if (deNode.getPriKey() != null && !StringUtils.isNULLStr((String)user.getPassword())) {
                this.authWay = "2";
            }
            if (deNode.getPriKey() == null && !StringUtils.isNULLStr((String)user.getPassword())) {
                this.authWay = "0";
            }
        }
    }

    public int getDeviceResult() {
        return this.deviceResult;
    }

    public void setDeviceResult(CollectStatusEnum deviceEnum) {
        switch (deviceEnum) {
            case COLLECT_SUCC: {
                this.deviceResult = 1;
                break;
            }
            case COLLECT_FAILED: {
                this.deviceResult = 2;
                break;
            }
            case COLLECT_FINISHED_NOTALL: {
                this.deviceResult = 3;
                break;
            }
            default: {
                this.deviceResult = 0;
            }
        }
    }
}

