/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.grab;

import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.context.SingleDevTask;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabFileFactory;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.FileUtils;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressDataTurboLogThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(CompressDataTurboLogThread.class);
    private List<GrabDevNode2> currSelectedNodes;
    private SingleDevTask devTask;
    private int count = 0;
    private int pollingTimes;

    public CompressDataTurboLogThread(List<GrabDevNode2> currSelectedNodes) {
        super.setName("CompressDataTurboLogThread");
        this.currSelectedNodes = currSelectedNodes;
    }

    @Override
    public void run() {
        Set<String> keys = GrabContext.getInstance().getSingleDevTask().keySet();
        for (String key : keys) {
            if (!key.contains(this.currSelectedNodes.get(0).getIp())) continue;
            this.devTask = GrabContext.getInstance().getSingleDevTask().get(key);
        }
        while (!this.devTask.getDevNodesList().stream().allMatch(GrabDevNode2::isCollectDone)) {
            this.pollingTimes = (this.currSelectedNodes.size() / 10 + 1) * 4 * 60;
            if (this.count > this.pollingTimes) {
                log.error("CompressDataTurboLogThread thread was waiting time out.");
                break;
            }
            ++this.count;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.error("InterruptedException:", (Throwable)e);
                break;
            }
        }
        this.compressDataTurboFile(this.currSelectedNodes);
    }

    private void compressDataTurboFile(List<GrabDevNode2> currSelectedNodes) {
        RealTimeTask collectTask = (RealTimeTask)GrabContext.getInstance().getTaskMap().get(currSelectedNodes.stream().findFirst().get());
        String taskBasePath = GrabFileFactory.getInstance().getTaskBasePath(collectTask).toString();
        String dataTurboDir = taskBasePath + File.separator + "DataTurbo";
        File dataTurboFile = new File(dataTurboDir);
        if (dataTurboFile.exists()) {
            String volumeSize = String.valueOf(collectTask.getDataTurboCollectStrategy().getSplitVolumeSize());
            FileAssistant.compressFile7zToSplitVolumeByPath(FileAssistant.get7zPathByInfoGrab(), volumeSize + "g", dataTurboDir, dataTurboDir);
        }
        FileUtils.deleteAllInFolder(dataTurboDir);
        FileUtils.deleteFile(dataTurboFile);
    }
}

