/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.grab;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class FilterDataLinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 7356055193034181656L;
    private static AtomicInteger tempFileCount = new AtomicInteger(1);
    private static final String PREFIX = "p_";
    private static final String SUFFIX = "s_";
    private static final String LINE_BREAK = "\r\n";
    private static final String READ_FROM_TEMP = "r_f_t";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FilterDataLinkedHashMap.class);
    private static final int THRESH_HOLD_VALUE = 2048;
    private String pathName = ApplicationContext.getInstance().getTmpPath() + File.separator + tempFileCount.getAndIncrement() + "_data.temp";

    public FilterDataLinkedHashMap() {
        File tmpPath = new File(ApplicationContext.getInstance().getTmpPath());
        if (!tmpPath.exists()) {
            LOGGER.info(" mkdir result:{}", (Object)tmpPath.mkdir());
        }
    }

    @Override
    public V put(K name, V value) {
        if (!"err_msg".equals((String)name) && null != value && value instanceof String && ((String)value).getBytes(Charset.defaultCharset()).length > 2048) {
            LOGGER.info("***[key= {} :length > {}]***", name, (Object)2048);
            String prefix = PREFIX + ((String)name).trim();
            String suffix = SUFFIX + ((String)name).trim();
            this.writer(prefix + LINE_BREAK + (String)value + LINE_BREAK + suffix + LINE_BREAK);
            return (V)super.put(name, READ_FROM_TEMP);
        }
        return super.put(name, value);
    }

    @Override
    public V get(Object key) {
        Object value = super.get(key);
        if (null != value && value instanceof String && READ_FROM_TEMP.equals((String)value)) {
            return (V)this.reader((String)key);
        }
        return super.get(key);
    }

    private void writer(String data) {
        File tempFile = FileUtils.getFile((String[])new String[]{this.getPathName()});
        this.writer(tempFile, data);
    }

    private void writer(File file, String data) {
        if (null == file || StringUtils.isBlank((CharSequence)data)) {
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(file, true);
             OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)fos, Charset.defaultCharset());
             BufferedWriter out = new BufferedWriter(outWriter);){
            out.write(data);
            out.flush();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("file not found.");
        }
        catch (Exception e) {
            LOGGER.error("write file fail.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String reader(String key) {
        String itemStr;
        StringBuffer sb;
        boolean isStopSuffix;
        block12: {
            if (StringUtils.isBlank((CharSequence)key)) {
                return null;
            }
            boolean isFrefixOccur = false;
            isStopSuffix = false;
            File file = FileUtils.getFile((String[])new String[]{this.getPathName()});
            BufferedReader in = null;
            sb = new StringBuffer();
            itemStr = null;
            String prefix = PREFIX + key.trim();
            String suffix = SUFFIX + key.trim();
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.defaultCharset()));
                String line = null;
                while (null != (line = in.readLine())) {
                    if (!line.equals(prefix) && !isFrefixOccur) continue;
                    if (line.equals(suffix)) {
                        isStopSuffix = true;
                        break;
                    }
                    if (isFrefixOccur) {
                        sb.append(line).append(LINE_BREAK);
                        continue;
                    }
                    isFrefixOccur = true;
                }
                StreamUtils.closeResource(null, (Closeable)in);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("file not found.");
            }
            catch (IOException e2) {
                LOGGER.error("read file fail.");
                break block12;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                StreamUtils.closeResource(null, in);
            }
        }
        if (sb.length() > 0 && isStopSuffix) {
            itemStr = sb.toString().substring(0, sb.lastIndexOf(LINE_BREAK));
        }
        return itemStr;
    }

    public boolean delteteFile() {
        LOGGER.info("***[entry delteteFile, filePath= {}]***", (Object)this.getPathName());
        boolean flag = false;
        String filePath = this.getPathName();
        if (null == filePath || "".equals(filePath)) {
            return flag;
        }
        File file = new File(filePath);
        if (file.isFile() && file.exists()) {
            LOGGER.info("delete file result:{}", (Object)file.delete());
            flag = true;
        }
        return flag;
    }

    public String getPathName() {
        return this.pathName;
    }

    public void setPathName(String pathName) {
        this.pathName = pathName;
    }

    public static String getReadFromTemp() {
        return READ_FROM_TEMP;
    }
}

