/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.grab;

import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.GrabParamEntity;
import com.huawei.ism.tool.infograb.grab.GrabThread;
import com.huawei.ism.tool.infograb.intf.worktaker.IGrabRefreshUI;
import com.huawei.ism.tool.infograb.periodgrab.PeriodGrabThread;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrabEngine {
    public static final Object BLOCKING_QUEUE_LOCK = new Object();
    private static final GrabEngine INSTANCE = new GrabEngine();
    private static final Logger LOGGER = LoggerFactory.getLogger(GrabEngine.class);
    private static final int CORE_NUM = 10;
    private LinkedBlockingQueue<Runnable> lbkqBlockingQueue = new LinkedBlockingQueue();
    private ExecutorService threadPool = new ThreadPoolExecutor(10, 50, 0L, TimeUnit.MILLISECONDS, this.lbkqBlockingQueue);
    private ConcurrentHashMap<GrabDevNode2, GrabThread> currThreadMap = new ConcurrentHashMap();
    private ConcurrentHashMap<GrabDevNode2, PeriodGrabThread> currMonitorThreadMap = new ConcurrentHashMap();

    private GrabEngine() {
    }

    public static GrabEngine getInstance() {
        return INSTANCE;
    }

    public synchronized void addOneGrabThread(GrabParamEntity entity) {
        GrabDevNode2 devNode = entity.getCurGrabDev();
        GrabThread currThrad = new GrabThread(entity);
        GrabThread preThread = GrabEngine.getInstance().getCurrThreadMap().get((Object)devNode);
        if (preThread != null && (preThread.isGrabIng() == null || preThread.isGrabIng().booleanValue())) {
            LOGGER.info("has exist same thread.thread ip={}", (Object)devNode.getIp());
            preThread.getOtherTaskObservers().add(entity.getUiListener());
            return;
        }
        this.currThreadMap.put(devNode, currThrad);
        currThrad.setGrabIng(true);
        this.threadPool.execute(currThrad);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Add collect device thread to thread pool IP is: " + devNode.getIp());
        }
    }

    public ConcurrentHashMap<GrabDevNode2, PeriodGrabThread> getCurrMonitorThreadMap() {
        return this.currMonitorThreadMap;
    }

    public void addOneMonitorThread(GrabDevNode2 devNode, IGrabRefreshUI uiListener) {
        PeriodGrabThread currMonitorInfoThread = new PeriodGrabThread(devNode, uiListener);
        this.currMonitorThreadMap.put(devNode, currMonitorInfoThread);
        this.threadPool.execute(currMonitorInfoThread);
        LOGGER.info("Add monitor device thread to thread pool.");
    }

    public void clear() {
        LOGGER.info("Closed thread pool");
        this.threadPool.shutdownNow();
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public Map<GrabDevNode2, GrabThread> getCurrThreadMap() {
        return this.currThreadMap;
    }

    public LinkedBlockingQueue<Runnable> getLbkqBlockingQueue() {
        return this.lbkqBlockingQueue;
    }
}

