/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.grab;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.GrabFlow;
import com.huawei.ism.tool.infograb.entity.Item;
import com.huawei.ism.tool.infograb.entity.Module;
import com.huawei.ism.tool.infograb.intf.worktaker.IGrabFlowAdapter;
import com.huawei.ism.tool.infograb.utils.OfflineImportUtils;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class GrabFlowAdapter
implements IGrabFlowAdapter {
    private static GrabFlowAdapter instance = new GrabFlowAdapter();
    private Map<GrabDevNode2, List<Item>> nodeGrabFlowMap = new HashMap<GrabDevNode2, List<Item>>();
    private Map<GrabDevNode2, List<String>> nodeSelectedCategoryMap = new HashMap<GrabDevNode2, List<String>>();

    private GrabFlowAdapter() {
    }

    public static GrabFlowAdapter getInstance() {
        return instance;
    }

    public Map<GrabDevNode2, List<Item>> getNodeGrabFlowMap() {
        return this.nodeGrabFlowMap;
    }

    public Map<GrabDevNode2, List<String>> getNodeSelectedCategoryMap() {
        return this.nodeSelectedCategoryMap;
    }

    @Override
    public List<Item> findProperFlow(GrabDevNode2 currDevNode) {
        if (this.nodeGrabFlowMap.containsKey((Object)currDevNode)) {
            return this.nodeGrabFlowMap.get((Object)currDevNode);
        }
        return this.findAllItemsOfIttype(currDevNode);
    }

    public List<Item> findAllFlow(Map<ItDeviceType, GrabFlow> type2FlowMap, GrabDevNode2 currDevNode) {
        String properNameKey = currDevNode.getDeviceName();
        ItDeviceType itDeviceType = currDevNode.getItDeviceType();
        if (null == type2FlowMap) {
            return null;
        }
        GrabFlow grabFlow = type2FlowMap.get(itDeviceType);
        if (null == grabFlow) {
            return null;
        }
        List<Module> currModuleList = grabFlow.getModuleList();
        for (Module currModule : currModuleList) {
            String moduleName = currModule.getTitle();
            if (null == moduleName) continue;
            if (moduleName.equalsIgnoreCase("oracle_jdbc") && moduleName.contains(currDevNode.getDevTypeLevel2().toString()) && currDevNode.isUseJdbc()) {
                List<Item> currListItems = currModule.getItemList();
                this.nodeGrabFlowMap.put(currDevNode, currListItems);
                return currListItems;
            }
            if (moduleName.equalsIgnoreCase("oracle_ssh") && moduleName.contains(currDevNode.getDevTypeLevel2().toString()) && !currDevNode.isUseJdbc()) {
                List<Item> currListItems = currModule.getItemList();
                this.nodeGrabFlowMap.put(currDevNode, currListItems);
                return currListItems;
            }
            if (!moduleName.equalsIgnoreCase(properNameKey)) continue;
            List<Item> currListItems = currModule.getItemList();
            this.nodeGrabFlowMap.put(currDevNode, currListItems);
            return currListItems;
        }
        return null;
    }

    public List<Item> findAllItemsOfNode(Map<ItDeviceType, GrabFlow> type2FlowMap, DevNode currDevNode) {
        GrabDevNode2 newNode = ToolUtils.toGrabNewNode(currDevNode);
        if (type2FlowMap == null) {
            type2FlowMap = GrabContext.getInstance().getSysType2FlowMap();
        }
        return this.findAllFlow(type2FlowMap, newNode);
    }

    public void cacheItemsOfNodeForUpgrade(GrabDevNode2 currDevNode) {
        ArrayList<String> selectedCategory = new ArrayList<String>();
        selectedCategory.add(ResourceUtil.getString((String)"infograb.item.category.pre_update_exploration"));
        this.cacheItemsOfNodeInCat(currDevNode, selectedCategory);
        GrabFlowAdapter.getInstance().getNodeSelectedCategoryMap().put(currDevNode, selectedCategory);
    }

    public void cacheItemsOfNodeInCat(GrabDevNode2 currDevNode, List<String> selectedCategory) {
        Map<ItDeviceType, GrabFlow> type2FlowMap = GrabContext.getInstance().getSysType2FlowMap();
        List<Item> allItems = this.findAllFlow(type2FlowMap, currDevNode);
        ArrayList<Item> categoryItems = new ArrayList<Item>();
        if (null != allItems) {
            ToolUtils.findCategoryItems(selectedCategory, allItems, categoryItems);
        }
        GrabDevNode2 newNode = ToolUtils.toGrabNewNode(currDevNode);
        GrabFlowAdapter.getInstance().getNodeGrabFlowMap().put(newNode, categoryItems);
    }

    public List<Item> findAllItemsOfIttype(GrabDevNode2 currDevNode) {
        ItDeviceType itDeviceType = currDevNode.getItDeviceType();
        Map<ItDeviceType, GrabFlow> type2FlowMap = OfflineImportUtils.getType2Flow(currDevNode);
        GrabFlow grabFlow = type2FlowMap.get(itDeviceType);
        if (null == grabFlow) {
            return null;
        }
        List<Module> currModuleList = grabFlow.getModuleList();
        for (Module currModule : currModuleList) {
            String moduleName = currModule.getTitle();
            if (null == moduleName) continue;
            if (moduleName.equalsIgnoreCase("oracle_jdbc") && moduleName.contains(currDevNode.getDevTypeLevel2().toString()) && currDevNode.isUseJdbc()) {
                List<Item> currListItems = currModule.getItemList();
                this.nodeGrabFlowMap.put(currDevNode, currListItems);
                return currListItems;
            }
            if (moduleName.equalsIgnoreCase("oracle_ssh") && moduleName.contains(currDevNode.getDevTypeLevel2().toString()) && !currDevNode.isUseJdbc()) {
                List<Item> currListItems = currModule.getItemList();
                this.nodeGrabFlowMap.put(currDevNode, currListItems);
                return currListItems;
            }
            if (!moduleName.equalsIgnoreCase(currDevNode.getDeviceName())) continue;
            List<Item> currListItems = currModule.getItemList();
            this.nodeGrabFlowMap.put(currDevNode, currListItems);
            return currListItems;
        }
        return null;
    }
}

