/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.grab;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.bizpack.wizardparse.factory.SftpConnector;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.runtime.SystemProperties;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.enums.NodeAddEnum;
import com.huawei.ism.tool.infograb.base.BaseTask;
import com.huawei.ism.tool.infograb.base.BaseTaskPanel;
import com.huawei.ism.tool.infograb.connection.DbConnectionManager;
import com.huawei.ism.tool.infograb.connection.FileConnectionGrab;
import com.huawei.ism.tool.infograb.connection.SshConnectionHelper;
import com.huawei.ism.tool.infograb.connection.StorageConnectionManager;
import com.huawei.ism.tool.infograb.context.CollectStatusEnum;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.context.ItemResultEnum;
import com.huawei.ism.tool.infograb.context.SingleDevTask;
import com.huawei.ism.tool.infograb.entity.CollectItem;
import com.huawei.ism.tool.infograb.entity.DBCmdResultSet;
import com.huawei.ism.tool.infograb.entity.DbGrabData;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode1;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.GrabParamEntity;
import com.huawei.ism.tool.infograb.entity.GrabResultEntity;
import com.huawei.ism.tool.infograb.entity.HbaInfo;
import com.huawei.ism.tool.infograb.entity.InfoGrabUserOpData;
import com.huawei.ism.tool.infograb.entity.Item;
import com.huawei.ism.tool.infograb.entity.MigrationType;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.entity.SQLExecInfo;
import com.huawei.ism.tool.infograb.entity.UserOpDeviceDetail;
import com.huawei.ism.tool.infograb.grab.FilterDataLinkedHashMap;
import com.huawei.ism.tool.infograb.grab.GrabFlowAdapter;
import com.huawei.ism.tool.infograb.intf.worktaker.IGrabFlowAdapter;
import com.huawei.ism.tool.infograb.intf.worktaker.IGrabRefreshUI;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.Db2GrabFileFactory;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabFileFactory;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabUtil;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.infograb.log.operation.OperationEnum;
import com.huawei.ism.tool.infograb.parser.MigrationParse;
import com.huawei.ism.tool.infograb.service.HandleStorageXlsData;
import com.huawei.ism.tool.infograb.service.HostDataHandleService;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.tool.infograb.service.XLSService;
import com.huawei.ism.tool.infograb.service.XLSStorageService;
import com.huawei.ism.tool.infograb.service.XlsClusterItem;
import com.huawei.ism.tool.infograb.service.XlsItem;
import com.huawei.ism.tool.infograb.service.XlsReader;
import com.huawei.ism.tool.infograb.service.XlsWriter;
import com.huawei.ism.tool.infograb.service.migration.NasParseService;
import com.huawei.ism.tool.infograb.ui.InfoGrabIsmTable;
import com.huawei.ism.tool.infograb.ui.RealTimeTaskDetailContainer;
import com.huawei.ism.tool.infograb.utils.DeviceModelChecker;
import com.huawei.ism.tool.infograb.utils.ExportFileUtil;
import com.huawei.ism.tool.infograb.utils.GrabCommonUtils;
import com.huawei.ism.tool.infograb.utils.GrabItemUtils;
import com.huawei.ism.tool.infograb.utils.InfoGrabDeviceTypeUtil;
import com.huawei.ism.tool.infograb.utils.InfograbConstants;
import com.huawei.ism.tool.infograb.utils.OfflineImportUtils;
import com.huawei.ism.tool.infograb.utils.SceneEnvironmentImpl;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.infograb.utils.migration.AnonymizeUtils;
import com.huawei.ism.tool.infograb.utils.migration.MigrationUtils;
import com.huawei.ism.tool.infograb.utils.migration.SmartIdcUtil;
import com.huawei.ism.tool.obase.connection.FileConnection;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.IGrabCliConnection;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.connection.win.WmicConnection;
import com.huawei.ism.tool.obase.connection.win.WmicConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import com.huawei.migration.common.util.json.JsonUtil;
import java.awt.Frame;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import utils.FilesUtil;

public class GrabThread
extends Thread {
    private static final int VALID_PARAM = -1;
    private static final int PREG10 = 10;
    private static final int PREG30 = 30;
    private static final int PREG40 = 40;
    private static final int PREG50 = 50;
    private static final int PREG80 = 80;
    private static final int PREG95 = 95;
    private static final int NO_PROGRESS = -1;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(GrabThread.class);
    private static final String SSH = "SSH";
    private static final String DBCON = "DBConn";
    private static final String DEV_TYPE = "dev_type";
    private static final String LANGUAGE = "lang";
    private static final String RET_MAP = "ret_map";
    private static final String CHECK_CMD_VMSTAT = "vmstat 1 6";
    private static final String EXTENDED_COMMANDS = "extendedCommands";
    private static final int CHECK_TIMES = 3;
    private static final int ERROR_INDEX = -1;
    private static final String TAB = ":\t";
    private static final String ENTER = "\r\n";
    private static final String CMDFILENAME = "getInfo.cmd";
    private static final String REMOTEDIR = "tempCollectWindowsInfo";
    private static final String IPPLACE = "${IP}";
    private static final String FULLPRO = "100%";
    private static final String ROOT_DIR = "user.dir";
    private static final String IDLE_CPU = "app.check.item.idle.cpu";
    private static final String IO_WAIT = "app.check.item.iowait";
    private static final Date START_TASK_DATE = new Date();
    private String wwpnTitle = ResourceUtil.getString((String)"infograb.report.host.title.wwpn");
    private String isFCTitle = ResourceUtil.getString((String)"infograb.report.host.title.fc");
    private String hbaModelTitle = ResourceUtil.getString((String)"infograb.report.host.title.hab.model");
    private String hbaDriverTitle = ResourceUtil.getString((String)"infograb.report.host.title.hab.driver");
    private String hbaFWTitle = ResourceUtil.getString((String)"infograb.report.host.title.hab.fw");
    private String notUpdateWwpnTitle = ResourceUtil.getString((String)"infograb.report.host.title.wwpn.not.update");
    private int taskNum;
    private GrabDevNode2 devNode;
    private IGrabRefreshUI uiListener;
    private InfoGrabService grabService;
    private IGrabFlowAdapter grabFlowAdapter;
    private ICliConnection devCon;
    private Item finalItem;
    private String threadPool = "Grab ThreadPool-";
    private List<Map<String, String>> vmstatResultMapList;
    private volatile boolean isCollectStop = false;
    private volatile Boolean isGrabIng = null;
    private volatile Boolean isRuningProgress = true;
    private SingleDevTask singleTask = null;
    private String taskKey = "";
    private String preUpgrade = ResourceUtil.getString((String)"infograb.item.category.pre_update_exploration");
    private String networkDiscovery = ResourceUtil.getString((String)"infograb.item.category.network.discovery");
    private String dataMigration = ResourceUtil.getString((String)"infograb.item.category.data_migration");
    private String defaultRepath = InfoGrabDirPropertiesUtil.getProperty();
    private HbaInfo hbaObj = new HbaInfo();
    private GrabParamEntity grabParamEntity;
    private List<GrabDevNode2> allTaskNodes;
    private String totalResultPath;
    private String dataFilePath = "";
    private List<IGrabRefreshUI> otherTaskObservers = new ArrayList<IGrabRefreshUI>();

    public GrabThread(GrabParamEntity grabParamEntity) {
        this.grabParamEntity = grabParamEntity;
        this.taskNum = grabParamEntity.getTaskNum();
        this.devNode = grabParamEntity.getCurGrabDev();
        this.uiListener = grabParamEntity.getUiListener();
        this.grabFlowAdapter = GrabFlowAdapter.getInstance();
        this.grabService = InfoGrabService.getInstance();
        this.setName(this.createThreadName());
        this.allTaskNodes = grabParamEntity.getGrabDevNodeList();
        String curIp = this.devNode.getIp();
        Set<String> keys = GrabContext.getInstance().getSingleDevTask().keySet();
        for (String key : keys) {
            if (!key.contains(curIp)) continue;
            SingleDevTask devTask = GrabContext.getInstance().getSingleDevTask().get(key);
            this.taskKey = key;
            if (this.taskNum != devTask.getTaskNum()) continue;
            this.singleTask = devTask;
            break;
        }
    }

    public Boolean isGrabIng() {
        return this.isGrabIng;
    }

    public void setGrabIng(boolean isGrab) {
        this.isGrabIng = isGrab;
    }

    public List<IGrabRefreshUI> getOtherTaskObservers() {
        return this.otherTaskObservers;
    }

    public GrabDevNode2 getDevNode() {
        return this.devNode;
    }

    public void setDevNode(GrabDevNode2 devNode) {
        this.devNode = devNode;
    }

    @Override
    public void run() {
        Thread.currentThread().setName(this.devNode.getIp());
        if (MigrationType.NAS.getName().equals(this.devNode.getMigrType()) && "NetApp".equals(this.devNode.getDeviceName())) {
            OperationEnum.DO_COLLECT.successLogWithResources(this.devNode.getIp(), this.devNode.getDeviceName());
            this.getInfoBySmartIdc();
        } else {
            try {
                OperationEnum.DO_COLLECT.successLogWithResources(this.devNode.getIp(), this.devNode.getDeviceName());
                this.getInfoRun();
            }
            catch (Exception e) {
                OperationEnum.DO_COLLECT.failLogWithResources(this.devNode.getIp(), this.devNode.getDeviceName());
                LOGGER.error("Execute task error.", (Throwable)e);
            }
        }
    }

    public void refreshOuterPreg(int preg) {
        IGrabRefreshUI observer = this.grabParamEntity.getUiListener();
        if (observer != null) {
            GrabResultEntity entity = new GrabResultEntity();
            entity.setCurProgress(preg);
            entity.setEvalNode(this.devNode);
            observer.refreshPregress(entity);
            for (IGrabRefreshUI obs : this.otherTaskObservers) {
                obs.refreshPregress(entity);
            }
        }
    }

    private List<File> fillLatestFile2List() {
        ArrayList<File> xlsFiles = new ArrayList<File>();
        List<GrabDevNode2> allDevices = this.allTaskNodes;
        for (GrabDevNode2 device : allDevices) {
            boolean isLosingFile = true;
            List<String> xlsPaths = GrabContext.getInstance().getCollectedResult().get(device.getDeviceSerialNumber());
            if (null == xlsPaths) continue;
            for (String path : xlsPaths) {
                File xlsFile = new File(path);
                if (!xlsFile.exists()) continue;
                xlsFiles.add(xlsFile);
                isLosingFile = false;
                break;
            }
            if (!isLosingFile) continue;
            GrabContext.getInstance().getCollectedResult().remove(device.getDeviceSerialNumber());
            LOGGER.info("the device [{}] has lost its necessary result file, it would be collected in next mission.", (Object)device.getIp());
        }
        return xlsFiles;
    }

    private void updateDeviceMetaDateKey(List<File> xlsFiles) {
        for (File xlsFile : xlsFiles) {
            int updateIdx;
            List<String> header;
            String xlsPath = null;
            try {
                xlsPath = xlsFile.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.warn("get xls path error.");
                continue;
            }
            if (GrabContext.getInstance().getHasUpdatedEvalResultFile().contains(xlsPath)) {
                LOGGER.info("the file [{}] has bean updated already.", (Object)xlsPath);
                continue;
            }
            try {
                header = XlsReader.getInstance().getXlsRow(xlsPath, 0);
            }
            catch (com.huawei.ism.tool.framework.platform.exception.ToolException e) {
                LOGGER.warn("get xls header error.");
                continue;
            }
            int idexOfMtDateEN = header.indexOf(XLSService.META_DATE_KEY_EN);
            int idexOfMtDateCN = header.indexOf(XLSService.META_DATE_KEY_CN);
            int n = updateIdx = idexOfMtDateEN > 0 ? idexOfMtDateEN : idexOfMtDateCN;
            if (updateIdx < 0) continue;
            String evalFileName = xlsFile.getName().replace(".xls", "_foreEval.txt");
            XLSService.getInstance().updateOneCellValue(xlsFile, updateIdx, "EvalMetaData" + File.separator + evalFileName);
            GrabContext.getInstance().getHasUpdatedEvalResultFile().add(xlsPath);
        }
    }

    private void removeTaskMap(Map<String, SingleDevTask> map, String key) {
        if (null != map && !map.isEmpty()) {
            map.remove(key);
        }
    }

    private void updateHostHBAInfo(List<File> xlsFiles) throws IOException {
        if (xlsFiles.isEmpty()) {
            LOGGER.error("there is no xls file, stop update host hab info.");
            return;
        }
        File file = xlsFiles.get(0);
        File taskFile = file.getParentFile().getParentFile();
        ArrayList<File> switchXls = new ArrayList<File>();
        ArrayList<File> hostXls = new ArrayList<File>();
        this.searchAllXls(taskFile, switchXls, hostXls);
        if (switchXls.isEmpty() || hostXls.isEmpty()) {
            LOGGER.error("do no have enough file to update .");
            return;
        }
        HashMap<String, List<String>> wwpnInfo = new HashMap<String, List<String>>();
        this.parseSwithXls(switchXls, wwpnInfo);
        this.update2HostFile(hostXls, wwpnInfo);
    }

    private void update2HostFile(List<File> hostXls, Map<String, List<String>> wwpnInfo) {
        if (wwpnInfo.isEmpty()) {
            LOGGER.error("has not read any wwpn info from switch .");
            return;
        }
        Collection<List<String>> pathValues = GrabContext.getInstance().getCollectedResult().values();
        ArrayList<String> newPathList = new ArrayList<String>();
        for (List<String> path : pathValues) {
            newPathList.add(path.get(0));
        }
        for (File hostFile : hostXls) {
            try {
                List<String> header = XlsReader.getInstance().getXlsRow(hostFile.getCanonicalPath(), 0);
                List<String> data = XlsReader.getInstance().getXlsRow(hostFile.getCanonicalPath(), 1);
                int wwpnIndex = header.indexOf(this.wwpnTitle);
                if (-1 == wwpnIndex) {
                    LOGGER.error("do not find the wwpn column .");
                    GrabContext.getInstance().getHasUpdatedHostFile().put(hostFile.getCanonicalPath(), true);
                    continue;
                }
                StringBuffer hbaModel = new StringBuffer();
                StringBuffer hbaDriver = new StringBuffer();
                StringBuffer hbaFW = new StringBuffer();
                String wwpnInHost = data.get(wwpnIndex);
                if (StringUtils.isNULLStr((String)wwpnInHost)) {
                    LOGGER.error("there is no wwpn info in the host file .");
                    GrabContext.getInstance().getHasUpdatedHostFile().put(hostFile.getCanonicalPath(), true);
                    continue;
                }
                StringBuilder notUpdatedWwpn = new StringBuilder();
                int count = 0;
                String[] singleWwpns = wwpnInHost.split(";");
                count = this.getCount(wwpnInfo, hbaModel, hbaDriver, hbaFW, notUpdatedWwpn, count, singleWwpns);
                this.updateData(newPathList, hostFile, header, hbaModel, hbaDriver, hbaFW, notUpdatedWwpn, count, singleWwpns);
            }
            catch (com.huawei.ism.tool.framework.platform.exception.ToolException e) {
                LOGGER.error("there is one host file read failed .");
            }
            catch (IOException e) {
                LOGGER.info("Update file failed..", (Throwable)e);
            }
        }
    }

    private int getCount(Map<String, List<String>> wwpnInfo, StringBuffer hbaModel, StringBuffer hbaDriver, StringBuffer hbaFW, StringBuilder notUpdatedWwpn, int count, String[] singleWwpns) {
        for (String singleWwpn : singleWwpns) {
            if ("NA".equalsIgnoreCase(singleWwpn)) continue;
            List<String> hbaInfo = wwpnInfo.get(singleWwpn);
            if (null == hbaInfo) {
                LOGGER.error("there is no hba info in switch of wwpn: " + singleWwpn);
                notUpdatedWwpn.append(singleWwpn).append(';');
                continue;
            }
            hbaModel.append(hbaInfo.get(1)).append(';');
            hbaDriver.append(hbaInfo.get(2)).append(';');
            hbaFW.append(hbaInfo.get(3)).append(';');
            ++count;
        }
        return count;
    }

    private void updateData(ArrayList<String> newPathList, File hostFile, List<String> header, StringBuffer hbaModel, StringBuffer hbaDriver, StringBuffer hbaFW, StringBuilder notUpdatedWwpn, int count, String[] singleWwpns) throws IOException {
        if (0 != count) {
            boolean updateFC = XLSService.getInstance().updateOneCellValue(hostFile, header.indexOf(this.isFCTitle), "is fc network");
            boolean updateHbaModel = XLSService.getInstance().updateOneCellValue(hostFile, header.indexOf(this.hbaModelTitle), hbaModel.toString());
            boolean updateHbaDrive = XLSService.getInstance().updateOneCellValue(hostFile, header.indexOf(this.hbaDriverTitle), hbaDriver.toString());
            boolean updateHbaFW = XLSService.getInstance().updateOneCellValue(hostFile, header.indexOf(this.hbaFWTitle), hbaFW.toString());
            HashMap<String, String> updatas = new HashMap<String, String>();
            updatas.put("isFc", "is fc network");
            updatas.put("hbaModel", hbaModel.toString());
            updatas.put("hbaDriver", hbaDriver.toString());
            updatas.put("hbaFW", hbaFW.toString());
            updatas.put("notUpdatedWwpn", notUpdatedWwpn.toString());
            this.updateContextXlsData(hostFile.getCanonicalPath(), updatas);
            if (count == singleWwpns.length) {
                GrabContext.getInstance().getHasUpdatedHostFile().put(hostFile.getCanonicalPath(), updateFC && updateHbaDrive && updateHbaFW && updateHbaModel);
            }
        } else {
            LOGGER.info("there is no hba info in switch of wwpn .");
        }
        if (!newPathList.contains(hostFile.getCanonicalPath())) {
            return;
        }
        if (!StringUtils.isNULLStr((String)notUpdatedWwpn.toString())) {
            XLSService.getInstance().updateOneCellValue(hostFile, header.indexOf(this.notUpdateWwpnTitle), notUpdatedWwpn.toString());
        }
    }

    private void updateContextXlsData(String fileName, Map<String, String> updateDatas) {
        Map<String, LinkedList<String>> hostData = GrabContext.getInstance().getHostData();
        LinkedList<String> titles = hostData.get("title");
        LinkedList<String> datas = hostData.get(fileName);
        int isFcIdx = titles.indexOf(this.isFCTitle);
        int hbaModelIdx = titles.indexOf(this.hbaModelTitle);
        int hbaDriverIdx = titles.indexOf(this.hbaDriverTitle);
        int hbaFWIdx = titles.indexOf(this.hbaFWTitle);
        int notUpdateWwpnIdx = titles.indexOf(this.notUpdateWwpnTitle);
        datas.set(isFcIdx, updateDatas.get("isFc"));
        datas.set(hbaModelIdx, updateDatas.get("hbaModel"));
        datas.set(hbaDriverIdx, updateDatas.get("hbaDriver"));
        datas.set(hbaFWIdx, updateDatas.get("hbaFW"));
        datas.set(notUpdateWwpnIdx, updateDatas.get("notUpdatedWwpn"));
    }

    private void parseSwithXls(List<File> switchXls, Map<String, List<String>> wwpnInfo) {
        for (File file : switchXls) {
            List<List<String>> allXlsRow = XlsReader.getInstance().getAllXlsRow(file, "SwitchHBA", 1);
            for (List<String> xlsRow : allXlsRow) {
                String key = xlsRow.get(0);
                if (wwpnInfo.containsKey(key)) continue;
                wwpnInfo.put(key, xlsRow);
            }
        }
    }

    private void searchAllXls(File taskFile, List<File> switchXls, List<File> hostXls) throws IOException {
        File[] files = taskFile.listFiles();
        if (null == files) {
            LOGGER.info("the file [{}] has no child file.", (Object)taskFile);
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.searchAllXls(file, switchXls, hostXls);
                continue;
            }
            if (!file.getName().endsWith(".xls") || !this.isValidFile(file)) continue;
            if (ExportFileUtil.isHost(file)) {
                String filePath = file.getCanonicalPath();
                Boolean hasUpdated = (Boolean)GrabContext.getInstance().getHasUpdatedHostFile().get(filePath);
                if (null != hasUpdated && hasUpdated.booleanValue()) continue;
                hostXls.add(file);
                continue;
            }
            if (!ExportFileUtil.isSwitch(file)) continue;
            switchXls.add(file);
        }
    }

    private boolean isValidFile(File file) {
        for (GrabDevNode2 dNode : this.allTaskNodes) {
            String fileName;
            if (dNode.getDevTypeLevel2() == null || !(fileName = file.getName().toLowerCase(Locale.ENGLISH)).contains(dNode.getDevTypeLevel2().toString().toLowerCase(Locale.ENGLISH)) || !fileName.contains(dNode.getIp())) continue;
            return true;
        }
        return false;
    }

    private void exportSelectReportAtom(List<File> xlsFiles) {
        if (xlsFiles.isEmpty()) {
            LOGGER.error("there is no xls file, stop export report.");
            return;
        }
        HashMap<String, List<LinkedList<String>>> reportDatas = new HashMap<String, List<LinkedList<String>>>();
        StringBuilder targetPath = new StringBuilder();
        RealTimeTask collectTask = (RealTimeTask)GrabContext.getInstance().getTaskMap().get((Object)this.devNode);
        targetPath.append(this.defaultRepath).append(File.separator).append(collectTask.getTaskDirName());
        File targetFile = new File(GrabFileFactory.getInstance().getTaskBasePath(collectTask) + File.separator + this.getSaveDataFile());
        this.mkdirIfNotExists(targetFile);
        List<GrabDevNode2> allDevices = this.allTaskNodes;
        ArrayList<LinkedList<String>> hostList = new ArrayList<LinkedList<String>>();
        ArrayList<LinkedList<String>> dbList = new ArrayList<LinkedList<String>>();
        ArrayList<LinkedList<String>> switchList = new ArrayList<LinkedList<String>>();
        ArrayList<LinkedList<String>> longList = new ArrayList<LinkedList<String>>();
        this.prepareGrabData(allDevices, hostList, dbList, switchList, longList);
        try {
            if (!hostList.isEmpty()) {
                reportDatas.put("HostReport", hostList);
            }
            if (!dbList.isEmpty()) {
                reportDatas.put("DatabaseReport", dbList);
            }
            if (!switchList.isEmpty()) {
                reportDatas.put("SwitchReport", switchList);
            }
            if (!longList.isEmpty()) {
                reportDatas.put("overlengthInfo", longList);
            }
            XlsWriter.getInstance().saveXlsReport(targetFile, reportDatas);
            this.totalResultPath = ExportFileUtil.getInstance().saveShaCode(targetFile, collectTask, xlsFiles);
            LOGGER.info("generate zip file:{}", (Object)StringUtils.getCleanMessage((String)this.totalResultPath));
        }
        catch (Exception e) {
            LOGGER.info("Save export report failed..", (Throwable)e);
            DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)ResourceUtil.getString((String)"infograb.auto.export.report.failed"));
        }
    }

    public void prepareGrabData(List<GrabDevNode2> allDevices, List<LinkedList<String>> hostList, List<LinkedList<String>> dbList, List<LinkedList<String>> switchList, List<LinkedList<String>> longList) {
        for (GrabDevNode2 dev : allDevices) {
            String sn = dev.getDeviceSerialNumber();
            String xlsName = dev.getXlsFileName();
            Map<String, LinkedList<String>> hostMap = GrabContext.getInstance().getHostData();
            Map<String, LinkedList<String>> dbMap = GrabContext.getInstance().getDbData();
            Map<String, LinkedList<String>> switchMap = GrabContext.getInstance().getSwitchData();
            Map<String, ArrayList<LinkedList<String>>> longMap = GrabContext.getInstance().getOverlengthData();
            if (!hostMap.isEmpty() && hostMap.containsKey(xlsName)) {
                if (hostList.isEmpty()) {
                    hostList.add(hostMap.get("title"));
                }
                hostList.add(this.updateDatafileList(hostMap, sn, xlsName));
            }
            if (!dbMap.isEmpty() && dbMap.containsKey(xlsName)) {
                if (dbList.isEmpty()) {
                    dbList.add(dbMap.get("title"));
                }
                dbList.add(this.updateDatafileList(dbMap, sn, xlsName));
            }
            if (!switchMap.isEmpty() && switchMap.containsKey(xlsName)) {
                if (switchList.isEmpty()) {
                    switchList.add(switchMap.get("title"));
                }
                switchList.add(this.updateDatafileList(switchMap, sn, xlsName));
            }
            if (longMap.isEmpty() || !longMap.containsKey(xlsName)) continue;
            longList.addAll((Collection<LinkedList<String>>)longMap.get(sn));
        }
    }

    public void mkdirIfNotExists(File targetFile) {
        if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
            LOGGER.info("create folder failed..");
        }
    }

    private LinkedList<String> updateDatafileList(Map<String, LinkedList<String>> hostMap, String sn, String xlsFileName) {
        LinkedList<String> list = hostMap.get(xlsFileName);
        if (list.contains("datafile")) {
            String file = GrabContext.getInstance().getCollectedResult().get(sn).get(0);
            String evalFileName = file.substring(file.lastIndexOf(File.separator)).replace(".xls", "_foreEval.txt");
            String dataFile = "EvalMetaData" + evalFileName;
            list.set(list.indexOf("datafile"), dataFile);
        }
        return list;
    }

    private String getSaveDataFile() {
        String dateEnd = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String fileName = "DeviceReport" + dateEnd + ".xls";
        return fileName;
    }

    private String createThreadName() {
        StringBuilder threadHead = new StringBuilder(this.threadPool);
        threadHead.append(this.devNode.getIp());
        threadHead.append(".");
        threadHead.append(this.devNode.getDeviceName());
        return threadHead.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCollectFlow() {
        boolean isWindowsOnline = false;
        long startDevTime = System.currentTimeMillis();
        try {
            WmicConnection connect;
            ExecuteResult execuResult = null;
            if (this.needPrepareCheck()) {
                execuResult = this.createCheckingPrepareLine();
                this.grabService.fillOneResultByNode(this.devNode, execuResult);
                this.uiListener.collectCallback(this.devNode);
                ConnUtils.sleep(100);
            }
            this.prepareCollect(execuResult);
            this.refreshOuterPreg(7);
            boolean isSimulatorFlag = ApplicationContext.getInstance().isSimulatorFlag();
            if ("windows".equalsIgnoreCase(this.devNode.getDevTypeLevel2().toString()) && !isSimulatorFlag && NodeAddEnum.ONLINE.equals((Object)this.devNode.getNodeAddType()) && !(connect = (WmicConnection)WmicConnectionManager.getWmicConnection(this.devNode)).getIsLocalHost().booleanValue()) {
                isWindowsOnline = true;
                this.windowsOnlineCollect();
            }
            if (this.isCollectStop) {
                return;
            }
            List<Item> currItemList = GrabItemUtils.getGrabItemList(this.grabFlowAdapter, this.devNode);
            this.checkDevNodeProcess(currItemList);
        }
        catch (ToolException e) {
            this.checkGraParamEntity(e);
        }
        catch (Exception e) {
            this.buildErrorMsgAndStop(e);
        }
        finally {
            this.modifyModeState(isWindowsOnline, startDevTime);
        }
    }

    private void buildErrorMsgAndStop(Exception e) {
        LOGGER.error("This Node: " + this.devNode.getIp() + "has some error in excute item", (Throwable)e);
        String msg = e.getMessage();
        if (StringUtils.isNULLStr((String)msg)) {
            msg = "unknown";
        }
        String msgTip = msg.split(System.lineSeparator())[0];
        this.grabService.fillFailedReasonByNode(this.devNode, msgTip);
        this.handleItemStatus(this.grabService.createFailedResult(this.devNode));
        GrabResultEntity entity = new GrabResultEntity();
        entity.setErrorMessageKey("eval.retain.devinfo.error");
        entity.setEvalNode(this.devNode);
        entity.setGrabStop(this.isCollectStop);
        entity.setGrabFailed(true);
        this.grabParamEntity.getUiListener().notifyDevGrabEnd(entity);
        for (IGrabRefreshUI observer : this.otherTaskObservers) {
            observer.notifyDevGrabEnd(entity);
        }
    }

    private void modifyModeState(boolean isWindowsOnline, long startDevTime) {
        this.isGrabIng = false;
        if (!this.isCollectStop) {
            this.grabService.setNodesStopped(this.devNode);
        } else {
            this.notifyTaskStopped(null, false);
        }
        if (null != this.devCon) {
            this.devCon.close();
        }
        if (isWindowsOnline && !StringUtils.isNULLStr((String)this.dataFilePath) && new File(this.dataFilePath).exists()) {
            com.huawei.ism.tool.obase.utils.FileUtils.deleteFile(new File(this.dataFilePath));
        }
        this.saveUserOpDataDev(startDevTime);
        this.clearAllProcStatus(this.devNode);
        LOGGER.info(" device {} grab end ", (Object)this.devNode.getIp());
    }

    private void checkGraParamEntity(ToolException e) {
        LOGGER.error("This Node: " + this.devNode.getIp() + "has some error in excute item", (Throwable)e);
        this.grabService.fillFailedReasonByNode(this.devNode, ResourceUtil.getStringWithParams((String)e.getErrorLocaleDescription(), (Object[])new Object[]{this.devNode.getIp()}));
        this.handleItemStatus(this.grabService.createFailedResult(this.devNode));
        GrabResultEntity entity = new GrabResultEntity(ResourceUtil.getStringWithParams((String)e.getErrorLocaleDescription(), (Object[])new Object[]{this.devNode.getIp()}));
        entity.setEvalNode(this.devNode);
        entity.setGrabStop(this.isCollectStop);
        entity.setGrabFailed(true);
        entity.setErrorMessageKey(e.getErrorId());
        this.grabParamEntity.getUiListener().notifyDevGrabEnd(entity);
        for (IGrabRefreshUI observer : this.otherTaskObservers) {
            observer.notifyDevGrabEnd(entity);
        }
    }

    private void checkDevNodeProcess(List<Item> currItemList) throws ToolException, IOException {
        this.checkListItemsNull(currItemList);
        if (ItDeviceType.Storage.equals((Object)this.devNode.getItDeviceType()) && "EMC".equalsIgnoreCase(this.devNode.getDevTypeLevel2().toString()) && "VMAX".equalsIgnoreCase(this.devNode.getDeviceModel())) {
            GrabUtil.insertSmartIdcCollectItem(currItemList);
        }
        this.finalItem = GrabUtil.findLastEnableItem(currItemList);
        if (null != currItemList) {
            if (currItemList.isEmpty()) {
                DialogUtils.showInfoDialog((Frame)GrabContext.getInstance().getCurrInfoGrabFrame(), (String)(this.devNode.getIp() + " " + ResourceUtil.getString((String)"infograb.task.collect.num.jugde")));
                throw new ToolException("infograb.cell.render.emptyitems");
            }
            GrabUtil.reCalcProcess(currItemList);
            if ("DB2".equals(this.devNode.getDeviceName())) {
                this.executeDBItem(this.devNode, currItemList);
            } else {
                this.executeAllItem(this.devNode, currItemList);
            }
        }
    }

    public void windowsOnlineCollect() throws ToolException {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        ExecuteResult execuResult = this.createPretreatment();
        execuResult.setShowProgress(true);
        this.grabService.fillOneResultByNode(this.devNode, execuResult);
        this.uiListener.collectCallback(this.devNode);
        this.dataFilePath = this.windowsDocumentMount(execuResult);
        if (StringUtils.isNULLStr((String)this.dataFilePath)) {
            LOGGER.error("Windows collect info has smae error.");
            String errMsgValue = ResourceUtil.getString((String)"infograb.detail.getinfodatafile") + TAB + ResourceUtil.getString((String)"infograb.python.errmsg.failed") + TAB + ResourceUtil.getString((String)"infograb.use.offline.script.grab");
            retMap.put("err_msg", errMsgValue);
            execuResult.setResultMap(retMap);
            this.setResultStatus(execuResult, ItemResultEnum.FAILD);
            this.isRuningProgress = false;
            throw new ToolException("infograb.use.offline.script.grab");
        }
        this.devNode.setDevInfoPkgPath(this.dataFilePath);
        this.devCon = new FileConnection(this.devNode);
        retMap.put("err_msg", ResourceUtil.getString((String)"infograb.detail.getinfodatafile"));
        execuResult.setResultMap(retMap);
        execuResult.setCurItemProgress(100);
        this.setResultStatus(execuResult, ItemResultEnum.SUCCESS);
        execuResult.setCureItemCollecting(false);
        execuResult.setShowProgress(false);
    }

    public String windowsDocumentMount(final ExecuteResult execuResult) throws ToolException {
        new Thread(new Runnable(){
            int cmdprogress = 5;
            boolean isRunning = true;

            @Override
            public void run() {
                while (this.isRunning && GrabThread.this.isRuningProgress.booleanValue()) {
                    execuResult.setCurItemProgress(this.cmdprogress);
                    if (this.cmdprogress == 95) {
                        this.isRunning = false;
                    }
                    this.cmdprogress += 5;
                    ConnUtils.sleep(5000);
                }
            }
        }).start();
        try {
            String toRemotefile;
            WmicConnection con = (WmicConnection)WmicConnectionManager.getWmicConnection(this.devNode);
            if (!con.getIsCanRemoteExecCmd().booleanValue()) {
                LOGGER.error("The wmic connection is can not remote execcmd.");
                return "";
            }
            String remotePath = con.getPaexecConnection().getRemoteCmdResultPath();
            if (StringUtils.isNULLStr((String)remotePath)) {
                LOGGER.error("The wmic connection has not remote patch.");
                return "";
            }
            String copyDir = ApplicationContext.getInstance().getScriptPath();
            String tempDir = ApplicationContext.getInstance().getTmpPath();
            File targetFile = new File(copyDir + File.separator + "WindowsOnline" + File.separator + CMDFILENAME);
            File copyFile = FilesUtil.copyFile(targetFile, toRemotefile = remotePath + File.separator + REMOTEDIR);
            if (!copyFile.exists()) {
                LOGGER.error("The copy Cmdfile is not exists, the path is :" + copyFile.getCanonicalPath());
                return "";
            }
            com.huawei.ism.tool.obase.utils.FileUtils.replaceContentInLine(copyFile, IPPLACE, toRemotefile, System.lineSeparator());
            String dataFilePathInLocal = this.getExecDataPath(copyFile, con);
            File dataFile = FilesUtil.copyFile(new File(dataFilePathInLocal.trim()), tempDir);
            if (VerifyUtil.isEmpty((Object)dataFile) || !dataFile.exists()) {
                LOGGER.error("The dataFile is not exists, the path is :" + dataFile.getCanonicalPath());
                return "";
            }
            com.huawei.ism.tool.obase.utils.FileUtils.deleteFile(new File(toRemotefile));
            return dataFile.getCanonicalPath();
        }
        catch (Exception e) {
            LOGGER.error("Windows Online Collection Error.", (Throwable)e);
            return "";
        }
    }

    public String getExecDataPath(File copyFile, WmicConnection con) throws IOException, ToolException {
        String result = "";
        String dataFilePathInData = "";
        String execFileCmd = copyFile.getCanonicalPath();
        result = con.execCmdRemoteTimout(execFileCmd, 1200);
        if (StringUtils.isNULLStr((String)result) || !result.toLowerCase(Locale.ENGLISH).contains(FULLPRO)) {
            throw new ToolException("Failed to execute remote script.");
        }
        dataFilePathInData = result.substring(result.lastIndexOf("LOG Path:") + "LOG Path:".length(), result.lastIndexOf(".data") + ".data".length());
        if (!new File(dataFilePathInData.trim()).exists()) {
            throw new ToolException("Data acquisition file not generated.");
        }
        return dataFilePathInData;
    }

    public void notifyTaskStopped(String errorMsg, boolean isGrabFailed) {
        GrabResultEntity entity = new GrabResultEntity();
        entity.setGrabFailed(isGrabFailed);
        entity.setErrorMessage(errorMsg);
        entity.setEvalNode(this.devNode);
        entity.setGrabStop(this.isCollectStop);
        this.grabParamEntity.getUiListener().notifyDevGrabEnd(entity);
        for (IGrabRefreshUI observer : this.otherTaskObservers) {
            observer.notifyDevGrabEnd(entity);
        }
        this.devNode.setCollectStop(true);
    }

    public void prepareCollect(ExecuteResult execuResult) throws ToolException, IOException {
        try {
            this.uiListener.changeSelectNodeStatus(this.devNode);
            this.uiListener.initDevThread(this.devNode);
            this.grabService.startGifLoading();
            if (this.devCon == null) {
                this.createProperCon();
            }
            if (!ToolUtils.isPaconnected(this.devNode) && GrabContext.getInstance().getCurrInfoGrabFrame() == null) {
                WmicConnectionManager.releaseConn(this.devNode);
                throw new ToolException("eval.host.windows.collect.fail.tip");
            }
            this.refreshOuterPreg(5);
            this.prepareCheck(execuResult);
            this.refreshOuterPreg(7);
        }
        catch (IOException e) {
            ItemResultEnum resultEnum;
            String message = e.getMessage();
            ItemResultEnum itemResultEnum = resultEnum = this.isCollectStop ? ItemResultEnum.CHECK_ENDED : ItemResultEnum.FAILD;
            if (message.split(System.lineSeparator()).length == 3) {
                resultEnum = ItemResultEnum.NOCHECK;
            }
            this.setResultStatus(execuResult, resultEnum);
            throw e;
        }
        catch (Exception e) {
            this.setResultStatus(execuResult, this.isCollectStop ? ItemResultEnum.CHECK_ENDED : ItemResultEnum.FAILD);
            throw e;
        }
        finally {
            if (this.isCollectStop) {
                this.setResultStatus(execuResult, ItemResultEnum.CHECK_ENDED);
            }
        }
    }

    private void saveUserOpData2Context(List<String> curCategory) {
        if (null == curCategory) {
            LOGGER.error("curCategory is null.");
            return;
        }
        InfoGrabUserOpData userOpData = new InfoGrabUserOpData();
        GrabContext grabInstance = GrabContext.getInstance();
        List<GrabDevNode2> devNodesList = this.singleTask.getDevNodesList();
        if (devNodesList != null) {
            for (GrabDevNode2 grabDevNode2 : devNodesList) {
                UserOpDeviceDetail userOpDeviceDetail = grabInstance.getUserOpDetails().get(grabDevNode2.getDeviceSerialNumber());
                if (null == userOpDeviceDetail) continue;
                userOpData.getDeviceDetailList().add(userOpDeviceDetail);
            }
            userOpData.setDeviceNums(devNodesList.size());
        } else {
            userOpData.setDeviceNums(0);
        }
        userOpData.setDeviceList2String();
        userOpData.setDeviceSn("");
        userOpData.setDeviceType("");
        userOpData.setDeviceVersion("");
        userOpData.setAuthWay("");
        userOpData.setProxyWay("");
        userOpData.setIpv("");
        userOpData.setTaskResult(UserOpTaskResult.SUCCESS);
        userOpData.setTaskStartTime(START_TASK_DATE);
        Date endDate = new Date();
        userOpData.setTaskEndTime(endDate);
        userOpData.setTotalTaskTime((endDate.getTime() - START_TASK_DATE.getTime()) / 1000L);
        userOpData.setApplicationScenario(new JSONArray(curCategory));
        userOpData.setTaskType("RealTimeTask");
        GrabContext.getInstance().getInfoGrabUserOpDatas().add(userOpData);
    }

    private void saveUserOpDataDev(long startTime) {
        try {
            UserOpDeviceDetail userOpDeviceDetail = new UserOpDeviceDetail(this.devNode);
            Long deviceTimeConsuming = (System.currentTimeMillis() - startTime) / 1000L;
            userOpDeviceDetail.setDeviceTimeConsuming(deviceTimeConsuming);
            GrabContext grabInstance = GrabContext.getInstance();
            List<ExecuteResult> executeResults = grabInstance.getExecuteResultMap().get((Object)this.devNode);
            String deviceSerialNumber = this.devNode.getDeviceSerialNumber();
            List<String> failCommand = grabInstance.getFailCommand().get(deviceSerialNumber);
            if (null != failCommand) {
                userOpDeviceDetail.setFailCommand(failCommand);
            }
            this.fillItemResult2UserOpData(executeResults, userOpDeviceDetail);
            grabInstance.getUserOpDetails().put(deviceSerialNumber, userOpDeviceDetail);
        }
        catch (RuntimeException e) {
            LOGGER.error("there is something wrong while save the user operation data.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("there is something wrong while save the user operation data.", (Throwable)e);
        }
    }

    private void fillItemResult2UserOpData(List<ExecuteResult> executeResults, UserOpDeviceDetail userOpDevice) {
        for (ExecuteResult executeResult : executeResults) {
            Item item = executeResult.getItem();
            if (null == item) {
                LOGGER.info("the item of:{} is null", (Object)executeResult.getDescription());
                continue;
            }
            String itemName = ResourceUtil.getString((String)item.getTitle());
            HashMap<String, Object> singleItemResult = new HashMap<String, Object>();
            singleItemResult.put("itemName", itemName);
            singleItemResult.put("itemCollectResult", executeResult.getItemResultEnum().getResultDesc());
            singleItemResult.put("itemCollectTime", executeResult.getExecuteEndTime().getTime() - executeResult.getExecuteStartTime().getTime());
            userOpDevice.getCollectionItem().add(singleItemResult);
            CollectStatusEnum nowStatus = executeResult.getNowStatus();
            if (null == nowStatus) continue;
            userOpDevice.setDeviceResult(nowStatus);
        }
    }

    private void checkListItemsNull(List<Item> currItemList) throws ToolException {
        if (currItemList == null) {
            throw new ToolException("This curr item list is null", false);
        }
    }

    private void createProperCon() throws ToolException {
        if (this.devNode.isFileNode()) {
            this.devCon = new FileConnectionGrab(this.devNode);
            return;
        }
        GrabDevNode1 oldDevNode = ToolUtils.grabNode2ToNode1(this.devNode);
        if ("EMC".equalsIgnoreCase(this.devNode.getDevTypeLevel2().toString()) && "VMAX".equalsIgnoreCase(this.devNode.getDeviceModel())) {
            return;
        }
        if (ItDeviceType.Host.equals((Object)this.devNode.getItDeviceType()) || ItDeviceType.Switch.equals((Object)this.devNode.getItDeviceType())) {
            if ("windows".equalsIgnoreCase(this.devNode.getDevTypeLevel2().toString())) {
                this.devCon = WmicConnectionManager.getWmicConnection(oldDevNode);
                return;
            }
            this.devCon = SshConnectionHelper.getSshConnection(oldDevNode);
            com.huawei.ism.tool.framework.pubservice.entity.User rootUser = GrabContext.getInstance().getAdminNameAndPassMap().get(this.devNode.getIp());
            if (null != rootUser) {
                this.devNode.setRootUser(rootUser);
                if (this.devCon instanceof IGrabCliConnection) {
                    DevNode oldDev = EntityUtils.toOldDev(this.devNode);
                    oldDev.setRootUser(new User(rootUser.getUserName(), rootUser.getPassword()));
                    SshConnection.switchToRootIfNeeded(oldDev, this.devCon);
                }
            }
            return;
        }
        if (ItDeviceType.Database.equals((Object)this.devNode.getItDeviceType())) {
            this.devCon = DbConnectionManager.getDbConnection(oldDevNode);
            return;
        }
        this.buildStorageConnection(oldDevNode);
    }

    private void buildStorageConnection(GrabDevNode1 oldDevNode) throws ToolException {
        if (!ItDeviceType.Storage.equals((Object)this.devNode.getItDeviceType())) {
            return;
        }
        this.devCon = "VNX_SAN".equalsIgnoreCase(this.devNode.getDeviceModel()) ? StorageConnectionManager.getStorageConnection(oldDevNode) : (DeviceModelChecker.isGrabByRest(this.devNode.getDeviceModel()) ? StorageConnectionManager.getStorageRestConnection(oldDevNode) : SshConnectionHelper.getSshConnection(oldDevNode));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAllItem(GrabDevNode2 deviceNode, List<Item> currItemList) throws IOException, ToolException {
        LinkedList<ExecuteResult> currResultList = new LinkedList<ExecuteResult>();
        ExecuteResult currExecuteResult = new ExecuteResult();
        for (Item item : currItemList) {
            try {
                boolean isFinalItem = false;
                if (null != this.finalItem) {
                    isFinalItem = this.finalItem.equals(item);
                }
                if (this.devCon instanceof SshConnection) {
                    DevNode oldDev = EntityUtils.toOldDev(deviceNode);
                    SshConnection.switchToRootIfNeeded(oldDev, this.devCon);
                    SshConnectionHelper.checkClientUserAndStartIfNeed(this.devCon, oldDev, true);
                }
                currExecuteResult = GrabCommonUtils.createExcuteResult(deviceNode, item, null);
                this.notifyObserverStart(currExecuteResult);
                if (!this.executeAndDealResult(isFinalItem, deviceNode, item, currExecuteResult, currResultList)) continue;
                break;
            }
            finally {
                currExecuteResult.setCureItemCollecting(false);
                currExecuteResult.setCurItemProgress(100);
                currExecuteResult.setShowProgress(false);
                this.uiListener.updateItemProgress(deviceNode);
            }
        }
    }

    private boolean executeAndDealResult(boolean isFinalItem, GrabDevNode2 deviceNode, Item item, ExecuteResult currExecuteResult, List<ExecuteResult> currResultList) throws IOException, ToolException {
        this.prepareExcuteOneItem(deviceNode, item, currExecuteResult);
        Map<String, Object> result = this.getExcuteResult(item, currExecuteResult);
        if (this.isCollectStop) {
            currExecuteResult.setItemResultEnum(ItemResultEnum.STOPED);
            return true;
        }
        this.dealResult(currExecuteResult, currResultList, item, deviceNode, result);
        this.checkFinalItem(isFinalItem, deviceNode, currExecuteResult, currResultList);
        if (this.isCollectStop) {
            currExecuteResult.setItemResultEnum(ItemResultEnum.STOPED);
            return true;
        }
        this.grabService.fillOneResultByNode(deviceNode, currExecuteResult);
        this.handleItemStatus(currExecuteResult);
        return false;
    }

    private void checkFinalItem(boolean isFinalItem, GrabDevNode2 deviceNode, ExecuteResult currExecuteResult, List<ExecuteResult> currResultList) throws ToolException {
        if (null != this.finalItem && isFinalItem) {
            this.isGrabIng = false;
            CollectStatusEnum status = currExecuteResult.getNowStatus();
            if (!MigrationUtils.onlyMigrationScene(deviceNode)) {
                this.addEvalData(currExecuteResult);
            }
            this.createGrabReport(currResultList, deviceNode, status == null ? "" : status.toString());
            currExecuteResult.setExecuteEndTime();
        }
        this.notifyObserver(currExecuteResult, isFinalItem);
    }

    private void dealResult(ExecuteResult currExecuteResult, List<ExecuteResult> currResultList, Item item, GrabDevNode2 deviceNode, Map<String, Object> result) throws IOException {
        this.handleExceptionStatus(deviceNode, currExecuteResult, result);
        currExecuteResult.setExecuteEndTime();
        currExecuteResult.setResultMap(result);
        ToolUtils.dealwithItemResult(currExecuteResult);
        currResultList.add(currExecuteResult);
        this.handleSingleDevExeResult(currExecuteResult, currResultList, item);
    }

    private Map<String, Object> getExcuteResult(Item item, ExecuteResult currExecuteResult) {
        return "SmartIDC".equals(item.getId()) ? this.executeSmartIdcItem(currExecuteResult) : this.executeOneItem(item, currExecuteResult);
    }

    private void prepareExcuteOneItem(GrabDevNode2 deviceNode, Item item, ExecuteResult currExecuteResult) {
        currExecuteResult.setShowProgress(item.isShowProgress());
        int curProgress = item.isShowProgress() ? 1 : -1;
        currExecuteResult.setCurItemProgress(curProgress);
        currExecuteResult.setCureItemCollecting(true);
        this.grabService.fillOneResultByNode(deviceNode, currExecuteResult);
        this.uiListener.updateItemProgress(deviceNode);
    }

    private Map<String, Object> executeSmartIdcItem(ExecuteResult currentExecResult) {
        boolean complete = this.smartIdcCollectDevice(currentExecResult, false);
        FilterDataLinkedHashMap<String, Object> resultMap = new FilterDataLinkedHashMap<String, Object>();
        if (this.isCollectStop) {
            currentExecResult.setItemResultEnum(ItemResultEnum.STOPED);
            resultMap.put("err_msg", ResourceUtil.getString((String)"infograb.grabThread.collectstop"));
        } else if (complete) {
            currentExecResult.setItemResultEnum(ItemResultEnum.SUCCESS);
            currentExecResult.setProgress(currentExecResult.getItem().getUpdateProcNumber());
            resultMap.put("err_msg", ResourceUtil.getString((String)"infograb.grabThread.collectsuccess2"));
        } else {
            currentExecResult.setItemResultEnum(ItemResultEnum.FAILD);
        }
        return resultMap;
    }

    public void addEvalData(ExecuteResult currExecuteResult) {
        this.addDataForEval("deviceSerialNumber", currExecuteResult, this.devNode.getDeviceSerialNumber());
        this.addDataForEval("deviceName", currExecuteResult, this.devNode.getDeviceName());
        this.addDataForEval("deviceNameAlias", currExecuteResult, this.devNode.getDeviceNameAlias());
    }

    public void addDataForEval(String key, ExecuteResult currExecuteResult, String value) {
        Map<String, Object> resultMap = currExecuteResult.getResultMap();
        resultMap.put("_needEvalCmdRtn:" + key, value);
    }

    private void notifyObserverStart(ExecuteResult currExecuteResult) {
        IGrabRefreshUI observer = this.grabParamEntity.getUiListener();
        if (observer != null) {
            GrabResultEntity entity = new GrabResultEntity();
            entity.setCurProgress(currExecuteResult.getProgress());
            entity.setCurrExecuteResult(currExecuteResult);
            entity.setEvalNode(this.devNode);
            entity.setRefreshing(true);
            observer.refreshPregress(entity);
            for (IGrabRefreshUI obs : this.otherTaskObservers) {
                obs.refreshPregress(entity);
            }
        }
    }

    public void notifyObserver(ExecuteResult currExecuteResult, boolean isFinalItem) {
        block4: {
            IGrabRefreshUI observer = this.grabParamEntity.getUiListener();
            if (observer == null) break block4;
            GrabResultEntity entity = new GrabResultEntity();
            entity.setIshostgrabEnd(isFinalItem);
            entity.setCurProgress(currExecuteResult.getProgress());
            entity.setCurrExecuteResult(currExecuteResult);
            entity.setEvalNode(this.devNode);
            entity.setRefreshing(false);
            if (isFinalItem && !MigrationUtils.onlyMigrationScene(this.devNode)) {
                List<String> xlsPaths = GrabContext.getInstance().getCollectedResult().get(currExecuteResult.getDevNode().getDeviceSerialNumber());
                String xlsPath = xlsPaths == null || xlsPaths.isEmpty() ? "" : xlsPaths.get(0);
                String evalTxtFile = xlsPath.replace(".xls", "_foreEval.txt");
                entity.setGrabResultExcelPath(xlsPath);
                entity.setGrabResult4EvalPath(evalTxtFile);
                entity.setIshostgrabEnd(isFinalItem);
                String evalFileName = new File(evalTxtFile).getName();
                XLSService.getInstance().updateOneCellValue(xlsPath, XLSService.META_DATE_KEY_EN, XLSService.META_DATE_KEY_CN, "EvalMetaData" + File.separator + evalFileName);
                observer.notifyDevGrabEnd(entity);
                for (IGrabRefreshUI obs : this.otherTaskObservers) {
                    obs.notifyDevGrabEnd(entity);
                }
            } else {
                entity.setGrabStop(this.isCollectStop);
                observer.refreshPregress(entity);
                for (IGrabRefreshUI obs : this.otherTaskObservers) {
                    obs.refreshPregress(entity);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDBItem(GrabDevNode2 deviceNode, List<Item> currItemList) throws IOException, ToolException {
        LinkedList<ExecuteResult> currResultList = new LinkedList<ExecuteResult>();
        LinkedList<DbGrabData> currDbResultList = new LinkedList<DbGrabData>();
        for (Item item : currItemList) {
            ExecuteResult currExecuteResult = null;
            try {
                currExecuteResult = GrabCommonUtils.createExcuteResult(deviceNode, item, null);
                this.notifyObserverStart(currExecuteResult);
                currExecuteResult.setShowProgress(item.isShowProgress());
                int curProgress = item.isShowProgress() ? 1 : -1;
                currExecuteResult.setCurItemProgress(curProgress);
                currExecuteResult.setCureItemCollecting(true);
                this.grabService.fillOneResultByNode(deviceNode, currExecuteResult);
                this.uiListener.updateItemProgress(deviceNode);
                Map<String, Object> result = this.executeOneItem(item, currExecuteResult);
                if (this.isCollectStop) break;
                if (deviceNode.getDeviceName().equalsIgnoreCase("Db2")) {
                    this.transferDb2Data(currDbResultList, item, currExecuteResult, result);
                }
                this.handleExceptionStatus(deviceNode, currExecuteResult, result);
                currExecuteResult.setExecuteEndTime();
                currExecuteResult.setResultMap(result);
                ToolUtils.dealwithItemResult(currExecuteResult);
                currResultList.add(currExecuteResult);
                this.handleSingleDevExeResult(currExecuteResult, currResultList, item);
                if (null != this.finalItem && this.finalItem.equals(item)) {
                    this.createDB2Report(currResultList, currDbResultList, deviceNode, currExecuteResult.getNowStatus().toString());
                }
                this.notifyObserver(currExecuteResult, this.finalItem == null ? false : this.finalItem.equals(item));
                if (this.isCollectStop) break;
                this.grabService.fillOneResultByNode(deviceNode, currExecuteResult);
                this.handleItemStatus(currExecuteResult);
            }
            finally {
                if (currExecuteResult == null) continue;
                currExecuteResult.setCureItemCollecting(false);
                currExecuteResult.setCurItemProgress(100);
                currExecuteResult.setShowProgress(false);
                this.uiListener.updateItemProgress(deviceNode);
            }
        }
    }

    public void handleSingleDevExeResult(ExecuteResult currResult, List<ExecuteResult> currResultList, Item item) {
        boolean isGrabFinished = null != this.finalItem && this.finalItem.equals(item);
        int itemResultSucc = 0;
        if (isGrabFinished) {
            for (ExecuteResult executeResult : currResultList) {
                if (!ItemResultEnum.SUCCESS.equals((Object)executeResult.getItemResultEnum())) continue;
                ++itemResultSucc;
            }
            if (itemResultSucc == currResultList.size()) {
                currResult.setNowStatus(CollectStatusEnum.COLLECT_SUCC);
                currResult.setProcessing(false);
                currResult.setCheckResult(ResourceUtil.getString((String)"infograb.complete"));
            } else {
                currResult.setNowStatus(CollectStatusEnum.COLLECT_FINISHED_NOTALL);
                currResult.setProcessing(false);
                currResult.setCheckResult(ResourceUtil.getString((String)"infograb.complete"));
            }
        } else {
            currResult.setNowStatus(CollectStatusEnum.COLLECTING);
            currResult.setProcessing(true);
            currResult.setCheckResult(ResourceUtil.getString((String)"infograb.processing"));
        }
    }

    private void transferDb2Data(List<DbGrabData> currDbResultList, Item dbItem, ExecuteResult currExecuteResult, Map<String, Object> result) {
        if (null != result) {
            Set<String> keys = result.keySet();
            boolean isExtendedCommands = false;
            int extendedCommandIndex = 1;
            DbGrabData extendedDataObj = new DbGrabData();
            if (isExtendedCommands = this.isExtendedCommands(currDbResultList, dbItem, currExecuteResult, result, keys, isExtendedCommands, extendedCommandIndex, extendedDataObj)) {
                currDbResultList.add(extendedDataObj);
            }
        }
    }

    private boolean isExtendedCommands(List<DbGrabData> currDbResultList, Item dbItem, ExecuteResult currExecuteResult, Map<String, Object> result, Set<String> keys, boolean isExtendedCommands, int extendedCommandIndex, DbGrabData extendedDataObj) {
        for (String key : keys) {
            String htmlString;
            SQLExecInfo sqlExecInfo;
            String sqlDesc;
            String htmlSqlName;
            String sqlName;
            String txtString;
            DbGrabData dataObj;
            ResultSet resultSet;
            DBCmdResultSet dbresultSet;
            if (key.contains("sql_display")) {
                dbresultSet = (DBCmdResultSet)result.get(key);
                resultSet = (ResultSet)dbresultSet.getSqlResult();
                dataObj = GrabUtil.getResultObj(resultSet);
                dataObj.setItem(dbItem);
                txtString = GrabUtil.parseResultsetToStr(resultSet, dataObj);
                sqlName = dbresultSet.getSqlName();
                sqlName = key + System.getProperty("line.separator") + sqlName;
                htmlSqlName = key + "<br>" + dbresultSet.getSqlName();
                sqlDesc = currExecuteResult.getDescription();
                sqlExecInfo = new SQLExecInfo(sqlName);
                htmlString = GrabUtil.parseResultsetToTableStr(htmlSqlName, resultSet, dataObj);
                dataObj.getTxtResultMap().put((Object)sqlExecInfo, (Object)txtString);
                dataObj.getHtmlResultMap().put((Object)sqlExecInfo, (Object)htmlString);
                dataObj.getSqlDesc().put((Object)sqlExecInfo, (Object)sqlDesc);
                currDbResultList.add(dataObj);
                continue;
            }
            if (!key.contains("cmd_display")) continue;
            isExtendedCommands = true;
            dbresultSet = (DBCmdResultSet)result.get(key);
            resultSet = (ResultSet)dbresultSet.getSqlResult();
            dataObj = GrabUtil.getResultObj(resultSet);
            dataObj.setItem(dbItem);
            txtString = GrabUtil.parseResultsetToStr(resultSet, dataObj);
            sqlName = dbresultSet.getSqlName();
            sqlName = key + System.getProperty("line.separator") + sqlName;
            htmlSqlName = key + "<br>" + dbresultSet.getSqlName();
            sqlDesc = currExecuteResult.getDescription();
            sqlExecInfo = new SQLExecInfo(sqlName);
            htmlString = GrabUtil.parseResultsetToTableStr(htmlSqlName, resultSet, dataObj);
            extendedDataObj.setItem(dbItem);
            extendedDataObj.getSqlDesc().put((Object)sqlExecInfo, (Object)(sqlDesc + extendedCommandIndex++));
            extendedDataObj.getTxtResultMap().put((Object)sqlExecInfo, (Object)txtString);
            extendedDataObj.getHtmlResultMap().put((Object)sqlExecInfo, (Object)htmlString);
        }
        return isExtendedCommands;
    }

    private void createDB2Report(List<ExecuteResult> currResultList, List<DbGrabData> currDbResultList, GrabDevNode2 dev, String status) throws ToolException {
        if (this.grabService.checkDiskCapactity(0x500000L)) {
            if (this.devNode.getDeviceName().equalsIgnoreCase("Db2")) {
                if (!Db2GrabFileFactory.getInstance().createGrabFile(currResultList, currDbResultList)) {
                    this.addResult(currResultList, "Failure");
                    throw new ToolException("infograb.remind.reportecreatefail");
                }
            } else if (!GrabFileFactory.getInstance().createGrabFile(currResultList)) {
                if (SceneEnvironmentImpl.getInstance().isScene()) {
                    this.addResult(currResultList, "Failure");
                }
                throw new ToolException("infograb.remind.reportecreatefail");
            }
            LOGGER.info("begin to create xls report.");
            if (!this.handleXlsReport(currResultList, dev)) {
                this.addResult(currResultList, "Failure");
                throw new ToolException("infograb.remind.reportecreatefail");
            }
        } else {
            throw new ToolException("infograb.remind.diskcapactityfail");
        }
        LOGGER.info("build scene result.");
        this.addResult(currResultList, status);
    }

    private void createGrabReport(List<ExecuteResult> currComResultList, GrabDevNode2 dev, String status) throws ToolException {
        if (this.grabService.checkDiskCapactity(0x500000L)) {
            if (!GrabFileFactory.getInstance().createGrabFile(currComResultList)) {
                this.addResult(currComResultList, "Failure");
                throw new ToolException("infograb.remind.reportecreatefail");
            }
            this.createGeneralGrabReport(currComResultList, dev);
            if (OfflineImportUtils.needCreateHostXml(dev)) {
                LOGGER.info("begin to create Migration host xml report.");
                if (!this.handleHostXmlReport(currComResultList, dev)) {
                    LOGGER.error("create Migration host xml report fail");
                    this.addResult(currComResultList, "Failure");
                    throw new ToolException("infograb.remind.reportecreatefail");
                }
            }
        } else {
            throw new ToolException("infograb.remind.diskcapactityfail");
        }
        LOGGER.info("all of excel file are:{}", (Object)StringUtils.getCleanMessage((String)this.singleTask.getAllDevsFiles().toString()));
        this.addResult(currComResultList, status);
    }

    private void createGeneralGrabReport(List<ExecuteResult> currComResultList, GrabDevNode2 dev) throws ToolException {
        boolean storageCounts = currComResultList.get(0).getDevNode().getItDeviceType().getName().equalsIgnoreCase("storage");
        if (storageCounts) {
            this.createMigrationStorageXls(currComResultList, dev);
        }
        if (!(storageCounts || OfflineImportUtils.isOfflineHost(this.devNode) || MigrationUtils.onlyMigrationScene(this.devNode))) {
            LOGGER.info("begin to create xls report.");
            if (!this.handleXlsReport(currComResultList, dev)) {
                this.addResult(currComResultList, "Failure");
                throw new ToolException("infograb.remind.reportecreatefail");
            }
        }
    }

    private void createMigrationStorageXls(List<ExecuteResult> currComResultList, GrabDevNode2 dev) {
        LOGGER.info("Begin to create storage xls report.");
        try {
            if (this.canGenerateNasExcelReport(currComResultList)) {
                return;
            }
            if (this.handleStorageXlsReport(currComResultList, dev)) {
                return;
            }
            LOGGER.error("Create migration storage xls report fail.");
        }
        catch (Exception exception) {
            LOGGER.error("Create migration storage xls report fail", (Throwable)exception);
        }
    }

    private boolean canGenerateNasExcelReport(List<ExecuteResult> currComResultList) {
        if (MigrationType.NAS.getName().equals(this.devNode.getMigrType())) {
            new NasParseService(this.devNode, this.grabService, this.uiListener).doDataParse(currComResultList);
            return true;
        }
        return false;
    }

    private boolean handleHostXmlReport(List<ExecuteResult> currResultList, GrabDevNode2 dev) {
        try {
            List<CollectItem> hostCollection = MigrationParse.getHostCollections(this.devNode.getDeviceName());
            File txtFile = GrabFileFactory.getInstance().getTxtFile(currResultList);
            File scriptParentFile = OfflineImportUtils.getParseScriptParent(this.devNode, currResultList);
            if (!txtFile.exists() || !scriptParentFile.exists()) {
                LOGGER.error("txtFile is not exists.");
                return false;
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            for (CollectItem collectItem : hostCollection) {
                String script = collectItem.getScriptName();
                File collectionScript = new File(scriptParentFile, script);
                Map<String, Object> data = GrabCommonUtils.callMigScriptData(collectionScript, txtFile, dev);
                if (data == null) {
                    return false;
                }
                LOGGER.info("script host file {} exec success.", (Object)script);
                resultMap.put(collectItem.getItemName(), data.get("data"));
            }
            return HostDataHandleService.host2XML(currResultList, dev, resultMap, null);
        }
        catch (Exception e) {
            LOGGER.error("Failed to generate the host XML data.", (Throwable)e);
            return false;
        }
    }

    private void addResult(List<ExecuteResult> currResultList, String status) {
        if (SceneEnvironmentImpl.getInstance().isScene()) {
            ExecuteResult currExecutreRes = currResultList.get(0);
            GrabDevNode2 currNode = currExecutreRes.getDevNode();
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("toolId", "InfoGrab");
            resultMap.put("IP", currNode.getIp());
            resultMap.put("SN", currNode.getItDeviceType().getName());
            if (status.equalsIgnoreCase(ResourceUtil.getString((String)"infograb.dev.status.succ.noall"))) {
                resultMap.put("status", "PartSuccess");
            } else {
                resultMap.put("status", "Success");
            }
            resultMap.put("fileName", "scenedata.xml");
            resultMap.put("endTime", currExecutreRes.getExecuteStartTimeString());
            GrabContext.getInstance().getResultList().add(resultMap);
            LOGGER.info("Save data success.");
        }
    }

    private static boolean checkHostType(String hostType) {
        ArrayList<String> hostList = new ArrayList<String>();
        hostList.add("aix");
        hostList.add("hp-ux");
        hostList.add("solaris");
        hostList.add("linux");
        for (String hostStr : hostList) {
            if (!hostStr.equals(hostType)) continue;
            return true;
        }
        return false;
    }

    private boolean handleXlsReport(List<ExecuteResult> currResultList, GrabDevNode2 dev) {
        StringBuilder xlsItemKey = new StringBuilder();
        xlsItemKey.append(this.devNode.getItDeviceType().getName()).append('_').append(this.devNode.getDeviceName());
        List<XlsItem> xlsItemList = XLSService.getInstance().getXlsItems(xlsItemKey.toString());
        if (null == xlsItemList || xlsItemList.isEmpty()) {
            return false;
        }
        File txtFile = GrabFileFactory.getInstance().getTxtFile(currResultList);
        if (!txtFile.exists()) {
            return false;
        }
        File scriptParentFile = new File(new File(GrabUtil.fixPath(currResultList.get(0).getItem().getScriptPath())).getParentFile(), "xls");
        if (!(scriptParentFile = this.checkCanonical(dev, scriptParentFile)).exists()) {
            return scriptParentFile.getAbsolutePath().contains("multipathBuglist") || scriptParentFile.getAbsolutePath().contains("script\\advanced");
        }
        HashMap<String, String> xlsReportData = new HashMap<String, String>();
        try {
            LOGGER.info("begin to exec extracting script.");
            this.fillCellValue2XlsDataMap(xlsItemList, txtFile, scriptParentFile, xlsReportData);
            LOGGER.info("begin to save data to excel file.");
            File xlsFile = GrabFileFactory.getInstance().getXlsFile(currResultList);
            dev.setXlsFileName(xlsFile.getName());
            XLSService.getInstance().saveXlsReport(xlsFile, xlsReportData, xlsItemList, dev);
            LOGGER.info("excel file is exist:{} file path:{}", (Object)xlsFile.exists(), (Object)xlsFile.getCanonicalPath());
            this.singleTask.getAllDevsFiles().add(xlsFile);
            this.add2CollectedResult(xlsFile);
            this.dealwithSwitchHBAInfo(xlsFile, scriptParentFile, txtFile);
        }
        catch (com.huawei.ism.tool.framework.platform.exception.ToolException e) {
            LOGGER.error("save xls File error", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("create excel file failed!", (Throwable)e);
            return false;
        }
        return true;
    }

    private File checkCanonical(GrabDevNode2 dev, File scriptParentFile) {
        try {
            String hostType;
            String canonicalPath = scriptParentFile.getCanonicalPath();
            if (canonicalPath.contains("hosts\\common") && GrabThread.checkHostType(hostType = dev.getDeviceName().toLowerCase(Locale.ENGLISH))) {
                switch (hostType) {
                    case "aix": {
                        hostType = "AIX";
                        break;
                    }
                    case "hp-ux": {
                        hostType = "HPUX";
                        break;
                    }
                }
                scriptParentFile = new File("script" + File.separator + "hosts" + File.separator + hostType + File.separator + "xls");
            }
        }
        catch (IOException e1) {
            LOGGER.error("get getCanonicalPath error", (Throwable)e1);
        }
        return scriptParentFile;
    }

    private void fillCellValue2XlsDataMap(List<XlsItem> xlsItemList, File txtFile, File scriptParentFile, Map<String, String> xlsReportData) {
        for (XlsItem item : xlsItemList) {
            if (item.getKey().equalsIgnoreCase("host_catgeroy")) {
                List<String> selectedCategory = GrabFlowAdapter.getInstance().getNodeSelectedCategoryMap().get((Object)this.devNode);
                xlsReportData.put(item.getKey(), String.join((CharSequence)";", selectedCategory));
                continue;
            }
            if (item.getKey().equalsIgnoreCase("InfoGrabVersion")) {
                xlsReportData.put(item.getKey(), this.getInfograbVersion());
                continue;
            }
            if (item.getKey().equals("host_user_is_admin")) {
                xlsReportData.put(item.getKey(), this.getDeviceUserIsAdminFlag());
                continue;
            }
            File scriptFile = new File(scriptParentFile, item.getKey() + ".py");
            if (!scriptFile.exists()) {
                LOGGER.error("script file {}.py does not exist.", (Object)item.getKey());
                continue;
            }
            xlsReportData.put(item.getKey(), this.callScriptData(item.getStartLabel(), txtFile, scriptFile));
            this.devNode.setHbaInfo(this.hbaObj);
            LOGGER.info("script file {}.py exec success.", (Object)item.getKey());
        }
    }

    private String getDeviceUserIsAdminFlag() {
        String deviceUserIsAdminFlag = "YES";
        if (ItDeviceType.Host.equals((Object)this.devNode.getItDeviceType())) {
            String deviceType = this.devNode.getDevTypeLevel2().toString();
            String userName = this.devNode.getLoginUser().getUserName();
            if ("Windows".equals(deviceType)) {
                deviceUserIsAdminFlag = "NA";
            } else if (this.devNode.getRootUser() == null && this.devNode.getAdminUser() == null && !"root".equals(userName)) {
                deviceUserIsAdminFlag = "NO";
            }
        }
        return deviceUserIsAdminFlag;
    }

    private String getInfograbVersion() {
        String infoGrabVersion = GrabUtil.getVersionShow().trim();
        if (infoGrabVersion.equalsIgnoreCase("--")) {
            infoGrabVersion = "NA";
        }
        return infoGrabVersion;
    }

    private void add2CollectedResult(File xlsFile) {
        List<String> paths = GrabContext.getInstance().getCollectedResult().get(this.devNode.getDeviceSerialNumber());
        if (null == paths) {
            paths = new ArrayList<String>();
            GrabContext.getInstance().getCollectedResult().put(this.devNode.getDeviceSerialNumber(), paths);
        }
        paths.add(0, ToolUtils.getCanonicalFilePath(xlsFile));
    }

    private void dealwithSwitchHBAInfo(File xlsFile, File scriptParentFile, File txtFile) throws com.huawei.ism.tool.framework.platform.exception.ToolException {
        if (ItDeviceType.Switch.equals((Object)this.devNode.getItDeviceType())) {
            File scriptFile = new File(scriptParentFile, "sw_hba.py");
            if (!scriptFile.exists()) {
                LOGGER.error("script file sw_hba.py does not exist.");
                return;
            }
            String wwpnInfoResult = this.callScriptData("NA", txtFile, scriptFile);
            LOGGER.info("script file sw_hba.py exec success.");
            ArrayList<LinkedList<String>> allDatas = new ArrayList<LinkedList<String>>();
            if (null == wwpnInfoResult) {
                LOGGER.error("do not get wwpn info in txt .");
                return;
            }
            String[] wwpnInfos = wwpnInfoResult.split(";");
            this.addAllDatas(allDatas, wwpnInfos);
            if (!allDatas.isEmpty()) {
                HSSFWorkbook writeWorkBook = null;
                FileInputStream fis = null;
                FileOutputStream fos = null;
                try {
                    ArrayList<LinkedList<String>> oldDatas = new ArrayList<LinkedList<String>>();
                    oldDatas.add((LinkedList)XlsReader.getInstance().getXlsRow(xlsFile.getCanonicalPath(), 0));
                    oldDatas.add((LinkedList)XlsReader.getInstance().getXlsRow(xlsFile.getCanonicalPath(), 1));
                    fis = new FileInputStream(xlsFile);
                    writeWorkBook = new HSSFWorkbook((InputStream)fis);
                    HSSFSheet sheet = writeWorkBook.getSheet("data");
                    if (null == sheet) {
                        sheet = writeWorkBook.createSheet("data");
                    }
                    HSSFSheet sheet2 = writeWorkBook.createSheet("SwitchHBA");
                    XlsWriter.getInstance().saveColItem2Sheet(writeWorkBook, (Sheet)sheet, oldDatas, false);
                    XlsWriter.getInstance().saveColItem2Sheet(writeWorkBook, (Sheet)sheet2, allDatas, false);
                    fos = new FileOutputStream(FilePathUtils.checkFile((File)xlsFile));
                    writeWorkBook.write((OutputStream)fos);
                }
                catch (IOException e) {
                    try {
                        LOGGER.error("create or write excel error.");
                        throw new com.huawei.ism.tool.framework.platform.exception.ToolException("create or write excel error.", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        StreamUtils.closeResource(null, writeWorkBook);
                        StreamUtils.closeStream(fos, fis);
                        throw throwable;
                    }
                }
                StreamUtils.closeResource(null, (Closeable)writeWorkBook);
                StreamUtils.closeStream((OutputStream)fos, (InputStream)fis);
            }
        }
    }

    private void addAllDatas(List<LinkedList<String>> allDatas, String[] wwpnInfos) {
        if (4 == wwpnInfos.length) {
            LinkedList<String> headerDatas = new LinkedList<String>();
            headerDatas.add("wwpn");
            headerDatas.add("model");
            headerDatas.add("version");
            headerDatas.add("firware");
            allDatas.add(headerDatas);
            String[] items = wwpnInfos[0].split(",");
            int itemsIndex = 0;
            for (String item : items) {
                LinkedList<String> oneRowDatas = new LinkedList<String>();
                try {
                    oneRowDatas.add(item.replaceAll(":", "").trim());
                    oneRowDatas.add(wwpnInfos[1].split(",")[itemsIndex].trim());
                    oneRowDatas.add(wwpnInfos[2].split(",")[itemsIndex].trim());
                    oneRowDatas.add(wwpnInfos[3].split(",")[itemsIndex++].trim());
                }
                catch (IndexOutOfBoundsException e) {
                    LOGGER.error("the wwpn info may not correct.");
                    continue;
                }
                allDatas.add(oneRowDatas);
            }
        }
    }

    private boolean handleStorageXlsReport(List<ExecuteResult> currResultList, GrabDevNode2 dev) throws ToolException {
        List<XlsClusterItem> xlsStorageItemList = GrabCommonUtils.getXlsStorageItemList(this.devNode);
        if (null == xlsStorageItemList || xlsStorageItemList.isEmpty()) {
            return false;
        }
        File storageTxtFile = GrabFileFactory.getInstance().getTxtFile(currResultList);
        if (!storageTxtFile.exists()) {
            return false;
        }
        File scriptClusterParentFile = new File(new File(GrabUtil.fixPath(currResultList.get(0).getItem().getScriptPath())).getParentFile(), "xls");
        if (!scriptClusterParentFile.exists()) {
            return false;
        }
        HashMap<String, Map<String, List<String>>> dataMap = new HashMap<String, Map<String, List<String>>>();
        LOGGER.info("begin to exec extracting script.");
        Map<String, List<String>> storageNameMap = GrabCommonUtils.storageFirstCallScript(xlsStorageItemList, storageTxtFile, scriptClusterParentFile, dataMap, this.devNode);
        List<String> storageList = storageNameMap.get("mapping_view_id");
        XlsClusterItem xlsClusterItemHost = null;
        XlsClusterItem xlsClusterItemLun = null;
        if (xlsStorageItemList.size() > 3) {
            xlsClusterItemHost = xlsStorageItemList.get(2);
            xlsClusterItemLun = xlsStorageItemList.get(3);
            xlsStorageItemList.remove(2);
            xlsStorageItemList.remove(2);
            xlsStorageItemList.remove(1);
            List<XlsClusterItem> moreXlsItems = GrabCommonUtils.getMoreXlsItems(xlsClusterItemHost, xlsClusterItemLun, storageList);
            xlsStorageItemList.addAll(moreXlsItems);
            Map<String, Map<String, List<String>>> resultMap = GrabCommonUtils.secondCallScript(xlsStorageItemList, storageTxtFile, scriptClusterParentFile, dataMap, this.devNode);
            dataMap.putAll(resultMap);
        }
        try {
            this.createStorageExcel(currResultList, xlsStorageItemList, dataMap, xlsClusterItemHost, xlsClusterItemLun);
        }
        catch (com.huawei.ism.tool.framework.platform.exception.ToolException e) {
            LOGGER.error("save migrate xls err");
            return false;
        }
        return true;
    }

    private void createStorageExcel(List<ExecuteResult> currResultList, List<XlsClusterItem> xlsStorageItemList, Map<String, Map<String, List<String>>> dataMap, XlsClusterItem xlsClusterItemHost, XlsClusterItem xlsClusterItemLun) throws com.huawei.ism.tool.framework.platform.exception.ToolException {
        if (!"VNX_SAN".equalsIgnoreCase(this.devNode.getDeviceModel())) {
            Map<String, Map<String, List<String>>> dealStorage = HandleStorageXlsData.dealStorageXlsData(dataMap, xlsStorageItemList, xlsClusterItemHost, xlsClusterItemLun);
            LOGGER.info("migrateData has analyzed success,ready write data to xls");
            XLSStorageService.getInstance().saveXlsReport(GrabFileFactory.getInstance().getMigrateXlsFile(currResultList, "Storage"), dealStorage, xlsStorageItemList);
        } else {
            LOGGER.info("migrateData has analyzed success,ready write data to xls");
            XLSStorageService.getInstance().saveXlsReport(GrabFileFactory.getInstance().getMigrateXlsFile(currResultList, "Storage"), dataMap, xlsStorageItemList);
        }
    }

    public static String transferPythonCmd(XlsClusterItem xlsMig) {
        StringBuffer sb = new StringBuffer();
        sb.append("key:" + xlsMig.getMigrateItemKey() + ";");
        for (XlsItem xItem : xlsMig.getSinglePyItems()) {
            sb.append(xItem.getKey() + ":" + xItem.getStartLabel() + ";");
        }
        return sb.toString();
    }

    public static String transferStoragePythonCmd(XlsClusterItem xlsMig) {
        StringBuffer sb = new StringBuffer();
        sb.append("key:" + xlsMig.getMigrateItemKey() + ";");
        for (XlsItem xItem : xlsMig.getSinglePyItems()) {
            if (xItem.getKey().equals("mapping_view_id")) {
                sb.append(xItem.getKey() + ":" + xlsMig.getStorageId() + ";");
                continue;
            }
            sb.append(xItem.getKey() + ":" + xItem.getStartLabel() + ";");
        }
        return sb.toString();
    }

    private String callScriptData(String startLable, File txtFile, File scriptFile) {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("command", startLable);
        context.put("dev_model", this.devNode.getDeviceModel());
        context.put("Logger", (String)LOGGER);
        context.put(LANGUAGE, LanguageManager.getInstance().getCurrentLanguage().toString());
        String scriptFilePath = null;
        try {
            scriptFilePath = txtFile.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("get canonical file path error.", (Throwable)e);
            return null;
        }
        context.put("path", scriptFilePath);
        try {
            JythonExecuter jythonExecuter = this.buildJythonExecutor();
            jythonExecuter.compileScript(scriptFile);
            jythonExecuter.simpleInvokeFunction("execute", context);
        }
        catch (SignException e) {
            LOGGER.error("execute script error signException", (Throwable)e);
            return null;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("execute script error fileNotFound Exception:{}.", (Object)scriptFile.getName());
            return null;
        }
        catch (ToolException e) {
            LOGGER.error("execute script error Tool Exception", e.getCause());
            return null;
        }
        catch (Exception e) {
            LOGGER.error("execute script error Tool Exception", (Throwable)e);
            return null;
        }
        if (this.isHbaModelScript(scriptFile.getName())) {
            this.hbaObj.setHbaModel(String.valueOf(context.get("result")));
        }
        if (this.isHbaModelDrVersion(scriptFile.getName())) {
            this.hbaObj.setHbaDriverVersion(String.valueOf(context.get("result")));
        }
        if (this.isHbaModelFwVersion(scriptFile.getName())) {
            this.hbaObj.setFwVersion(String.valueOf(context.get("result")));
        }
        return String.valueOf(context.get("result"));
    }

    private JythonExecuter buildJythonExecutor() {
        String workPath = ApplicationContext.getInstance().getWorkPath();
        if (workPath.endsWith("upgradeEvaluation") && !ApplicationContext.getInstance().isWindowsOS()) {
            return new JythonExecuter(new File(String.join((CharSequence)File.separator, workPath, "script")));
        }
        return new JythonExecuter();
    }

    private boolean isHbaModelScript(String scriptName) {
        ArrayList<String> hbaModels = new ArrayList<String>();
        hbaModels.add("host_hba_card_type.py");
        hbaModels.add("host_hba_type.py");
        hbaModels.add("host_hba_model.py");
        return hbaModels.contains(scriptName);
    }

    private boolean isHbaModelDrVersion(String scriptName) {
        ArrayList<String> drVersionSripts = new ArrayList<String>();
        drVersionSripts.add("host_hba_card_driver_version.py");
        drVersionSripts.add("host_hbadriver_version.py");
        drVersionSripts.add("host_hba_version.py");
        return drVersionSripts.contains(scriptName);
    }

    private boolean isHbaModelFwVersion(String scriptName) {
        ArrayList<String> drFwSripts = new ArrayList<String>();
        drFwSripts.add("host_hba_card_FW_version.py");
        drFwSripts.add("host_hbafw_version.py");
        drFwSripts.add("host_hba_version.py");
        return drFwSripts.contains(scriptName);
    }

    private void handleExceptionStatus(GrabDevNode2 deviceNode, ExecuteResult currExecuteResult, Map<String, Object> result) throws IOException {
        if (result == null) {
            currExecuteResult.setExecuteEndTime();
            result = new HashMap<String, Object>();
            result.put("err_msg", ResourceUtil.getString((String)"infograb.python.errmsg.exeitemfailed"));
            currExecuteResult.setResultMap(result);
            this.grabService.fillOneResultByNode(deviceNode, currExecuteResult);
            this.handleItemStatus(this.grabService.createFailedResult(this.devNode));
            throw new IOException(ResourceUtil.getString((String)"infograb.failed.reason.executefaild"));
        }
    }

    private void clearAllProcStatus(GrabDevNode2 deviceNode) {
        List<ExecuteResult> exeResultList = GrabContext.getInstance().getExecuteResultMap().get((Object)deviceNode);
        if (null != exeResultList) {
            for (ExecuteResult eResult : exeResultList) {
                Map<String, Object> resultMap = eResult.getResultMap();
                if (resultMap == null) continue;
                Object errMsg = resultMap.get("err_msg");
                resultMap.clear();
                resultMap.put("err_msg", errMsg);
                eResult.setProcessing(false);
            }
        }
    }

    private void handleItemStatus(ExecuteResult currExecuteResult) {
        ArrayList<ExecuteResult> currExecuteResultList = new ArrayList<ExecuteResult>();
        currExecuteResultList.add(currExecuteResult);
        if (!this.isCollectStop) {
            this.uiListener.refreshPregress(currExecuteResultList);
        }
        this.uiListener.collectCallback(currExecuteResult.getDevNode());
        try {
            TimeUnit.MILLISECONDS.sleep(30L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Handle Item Status thread sleep Exception");
        }
    }

    private Map<String, Object> executeOneItem(Item currItem, ExecuteResult currExecuteResult) {
        String scriptPath = currItem.getScriptPath();
        String oldSuccess = "execute success";
        String newSuccess = "Execution succeeded";
        String oldFailed = "execute failed";
        String newFailed = "Execution failed";
        if (null == scriptPath) {
            return null;
        }
        try {
            JythonExecuter jythonExecuter = new JythonExecuter(new File(InfograbConstants.SCRIPT_ROOT_PATH));
            File currPyFile = new File(GrabUtil.fixPath(scriptPath));
            LOGGER.info("current script file: {}", (Object)currPyFile.getName());
            jythonExecuter.compileScript(currPyFile);
            Map<String, Object> context = this.prepareParameters();
            context.put("isSimulator", ApplicationContext.getInstance().isSimulatorFlag());
            FilterDataLinkedHashMap retMap = (FilterDataLinkedHashMap)context.get(RET_MAP);
            context.put("deviceTypeLevel2", this.devNode.getDevTypeLevel2().toString());
            if ("extended_command_info".equals(currItem.getId())) {
                context.put(EXTENDED_COMMANDS, currItem.getExtendedCommands());
            }
            jythonExecuter.simpleInvokeFunction("execute", context);
            String errMsg = GrabCommonUtils.getErrMsg(oldSuccess, newSuccess, oldFailed, newFailed, retMap);
            retMap.put("err_msg", GrabCommonUtils.dealErrorMessageWithEcho(errMsg));
            return retMap;
        }
        catch (SignException e) {
            currExecuteResult.setItemResultEnum(ItemResultEnum.FAILD);
            LOGGER.error("Current DevNode: " + this.devNode.getIp() + "Get " + currItem + " failed. SignException details is: ", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            currExecuteResult.setItemResultEnum(ItemResultEnum.FAILD);
            LOGGER.error("Current DevNode: " + this.devNode.getIp() + "Get " + currItem + " failed.");
        }
        catch (ToolException e) {
            currExecuteResult.setItemResultEnum(ItemResultEnum.FAILD);
            LOGGER.error("Current DevNode: " + this.devNode.getIp() + " Get " + currItem + " failed. ToolException detail is", (Throwable)e);
        }
        catch (Exception e) {
            currExecuteResult.setItemResultEnum(ItemResultEnum.FAILD);
            LOGGER.error("Current DevNode: " + this.devNode.getIp() + " Get " + currItem + " failed. Error details is: ", (Throwable)e);
        }
        return null;
    }

    private Map<String, Object> prepareParameters() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        String conName = this.createConName(this.devNode.getItDeviceType());
        if (!StringUtils.isNULLStr((String)this.devNode.getDevInfoPkgPath())) {
            context.put("reportPath", this.devNode.getDevInfoPkgPath());
        }
        context.put(conName, this.devCon);
        context.put(DEV_TYPE, this.devNode.getDeviceType().toString());
        context.put("dev_model", this.devNode.getDeviceModel());
        context.put("version", this.devNode.getProductVersion());
        context.put("deviceName", this.devNode.getDeviceName());
        context.put("LoginUsername", this.devNode.getLoginUser().getUserName());
        context.put(LANGUAGE, LanguageManager.getInstance().getCurrentLanguage().toString());
        context.put(RET_MAP, new FilterDataLinkedHashMap());
        context.put("PY_LOGGER", ToolLoggerFactory.getLoggerInStandAlone((String)"PY_LOGGER"));
        context.put("Logger", LOGGER);
        context.put("SUDO", this.devNode.isSudoGrab() ? InfograbConstants.SUDO : "");
        context.put("SUDO_MIDDLE", this.devNode.isSudoGrab() ? InfograbConstants.SUDO_MIDDLE : "");
        context.put("isUseJdbc", this.devNode.isUseJdbc());
        context.put("DEV_IP", this.devNode.getIp());
        context.put("uiObsver", this.uiListener);
        context.put("mappedStorage", this.grabParamEntity.getMappedStorage());
        context.put("launcher", GrabContext.getInstance().getLauncherMap().get(this.devNode.getDevKey()));
        RealTimeTask collectTask = (RealTimeTask)GrabContext.getInstance().getTaskMap().get((Object)this.devNode);
        if (collectTask.isContainsDataTurboSence()) {
            this.setDataTurboCollectParam(context);
        }
        return context;
    }

    private void setDataTurboCollectParam(Map<String, Object> context) {
        SftpConnector sftp = new SftpConnector(this.devNode.getIp(), this.devNode.getPort(), this.devNode.getLoginUser().getUserName(), this.devNode.getLoginUser().getPassword());
        context.put("sftp", sftp);
        RealTimeTask collectTask = (RealTimeTask)GrabContext.getInstance().getTaskMap().get((Object)this.devNode);
        context.put("collect_model", collectTask.getDataTurboCollectStrategy().getModel());
        context.put("start_time", collectTask.getDataTurboCollectStrategy().getStartTime());
        context.put("end_time", collectTask.getDataTurboCollectStrategy().getEndTime());
        context.put("split_volume_size", collectTask.getDataTurboCollectStrategy().getSplitVolumeSize());
        String taskBasePath = GrabFileFactory.getInstance().getTaskBasePath(collectTask).toString();
        context.put("task_dir_path", taskBasePath);
    }

    private String createConName(ItDeviceType type) {
        return type.equals((Object)ItDeviceType.Database) ? DBCON : SSH;
    }

    private void prepareCheck(ExecuteResult execuResult) throws ToolException, IOException {
        if (null != this.devCon) {
            this.vmstatResultMapList = new ArrayList<Map<String, String>>();
            if ("windows".equalsIgnoreCase(this.devNode.getDevTypeLevel2().toString())) {
                return;
            }
            LOGGER.info("Begin to execute vmstat and iostat.");
            this.hostPrepareCheckDealData();
            LOGGER.info("Begin to Check cpu and io.");
            this.prepareCheckCPUAndIO();
        }
    }

    public void setResultStatus(ExecuteResult execuResult, ItemResultEnum resultEnum) {
        if (execuResult != null) {
            execuResult.setCureItemCollecting(false);
            execuResult.setItemResultEnum(resultEnum);
        }
    }

    private void prepareCheckCPUAndIO() throws IOException {
        if (this.devNode.getItDeviceType().equals((Object)ItDeviceType.Host)) {
            int checkCpuRet = -1;
            int checkIoRet = -1;
            if (!this.devNode.getDevTypeLevel2().toString().equalsIgnoreCase("vmware")) {
                Map<String, String> checkItemValueMap = this.getCheckItemValue();
                checkCpuRet = this.checkCpu(checkItemValueMap);
                checkIoRet = this.checkIo(checkItemValueMap);
                if (this.isCollectStop) {
                    return;
                }
                this.refreshPrepareCheckLine(checkCpuRet, checkIoRet);
                if (checkCpuRet != -1 || checkIoRet != -1) {
                    String tip = ResourceUtil.getString((String)"infograb.failed.reason.preparecheckfaild");
                    throw new IOException(tip + System.lineSeparator() + checkCpuRet + System.lineSeparator() + checkIoRet);
                }
            }
        }
    }

    private void hostPrepareCheckDealData() throws ToolException {
        String executeResult;
        if (ItDeviceType.Host.equals((Object)this.devNode.getItDeviceType()) && !"vmware".equalsIgnoreCase(this.devNode.getDevTypeLevel2().toString()) && !StringUtils.isNULLStr((String)(executeResult = this.devCon.execCmdWithTimout(CHECK_CMD_VMSTAT, 60)))) {
            String[] vmStringArr = executeResult.split(ENTER);
            this.createVmstatResultMap(vmStringArr, this.vmstatResultMapList);
        }
    }

    private boolean needPrepareCheck() {
        return !InfoGrabDeviceTypeUtil.isWindows(this.devNode) && InfoGrabDeviceTypeUtil.isGrabHost(this.devNode) && !InfoGrabDeviceTypeUtil.isVmware(this.devNode) && !OfflineImportUtils.isOfflineHost(this.devNode);
    }

    private void createVmstatResultMap(String[] vmStringArr, List<Map<String, String>> vmstatRetMapList) {
        int i;
        String[] key = null;
        String[] value = null;
        if (vmStringArr.length <= 3) {
            return;
        }
        for (i = 0; i < vmStringArr.length; ++i) {
            if (!vmStringArr[i].contains("sy") || !vmStringArr[i].contains("id")) continue;
            key = vmStringArr[i].trim().split("\\s+");
        }
        for (i = 0; i < 3; ++i) {
            value = vmStringArr[vmStringArr.length - i - 1].trim().split("\\s+");
            vmstatRetMapList.add(this.transArrayToMap(key, value));
        }
    }

    private Map<String, String> transArrayToMap(String[] key, String[] value) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        if (null == key) {
            return retMap;
        }
        for (int i = 0; i < key.length; ++i) {
            try {
                retMap.put(key[i].trim(), value[i].trim());
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.error("wrong cmd result , pleanse check through cli client.");
            }
        }
        return retMap;
    }

    private boolean valueIsNumber(String string) {
        try {
            if (StringUtils.isDigit((String)string)) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.info("The value is not a number, it is: {}", (Object)string);
        }
        return false;
    }

    private int checkCpu(Map<String, String> checkItemMap) {
        try {
            int cpuIdleNum = 0;
            if (this.vmstatResultMapList.isEmpty()) {
                LOGGER.warn("params is not valid.");
                return -1;
            }
            for (Map<String, String> vmstatRetMap : this.vmstatResultMapList) {
                cpuIdleNum += Integer.parseInt(vmstatRetMap.get("id"));
            }
            boolean isValid = (cpuIdleNum /= 3) >= (checkItemMap.isEmpty() || !this.valueIsNumber(checkItemMap.get(IDLE_CPU)) ? 20 : Integer.parseInt(checkItemMap.get(IDLE_CPU)));
            return isValid ? -1 : 100 - cpuIdleNum;
        }
        catch (NumberFormatException e) {
            LOGGER.info("Cpu prepare check command execute failed, skip check!");
            return -1;
        }
    }

    public Map<String, String> getCheckItemValue() {
        HashMap<String, String> checkItemValueMap = new HashMap<String, String>();
        try {
            SystemProperties appConfigs = new SystemProperties(System.getProperty(ROOT_DIR));
            checkItemValueMap.put(IDLE_CPU, appConfigs.getValue(IDLE_CPU));
            checkItemValueMap.put(IO_WAIT, appConfigs.getValue(IO_WAIT));
        }
        catch (MissingResourceException e) {
            LOGGER.error("Can not find the key from system.properties, ErrorType: MissingResourceException");
        }
        catch (Exception e) {
            LOGGER.error("Find other exception:", (Throwable)e);
        }
        LOGGER.info(((Object)checkItemValueMap).toString());
        return checkItemValueMap;
    }

    private int checkIo(Map<String, String> checkItemMap) {
        try {
            int ioNum = 0;
            if (this.devNode.getDevTypeLevel2().toString().equalsIgnoreCase("linux") || this.devNode.getDevTypeLevel2().toString().equalsIgnoreCase("aix")) {
                if (this.vmstatResultMapList.isEmpty()) {
                    return -1;
                }
                ioNum = this.ioNumCheck(ioNum, "wa");
            } else if (ToolUtils.isUnixSystem(this.devNode)) {
                return -1;
            }
            boolean isValid = (ioNum /= 3) <= (checkItemMap.isEmpty() || !this.valueIsNumber(checkItemMap.get(IO_WAIT)) ? 20 : Integer.parseInt(checkItemMap.get(IO_WAIT)));
            return isValid ? -1 : ioNum;
        }
        catch (NumberFormatException e) {
            LOGGER.error("Io prepare check command execute failed, skip check!");
            return -1;
        }
    }

    private int ioNumCheck(int ioNum, String str) {
        for (Map<String, String> vmstatRetMap : this.vmstatResultMapList) {
            ioNum += Integer.parseInt(vmstatRetMap.get(str));
        }
        return ioNum;
    }

    private void refreshPrepareCheckLine(int checkCpuRet, int checkIoRet) {
        boolean checkCpuRetValid = checkCpuRet == -1;
        boolean checkIoRetValid = checkIoRet == -1;
        ExecuteResult initResult = this.createPrepareLine();
        initResult.setExecuteEndTime();
        initResult.getResultMap().put("err_msg", this.createPrepareCheckErrorMsg(checkCpuRet, checkIoRet));
        if (checkCpuRetValid && checkIoRetValid) {
            initResult.setItemResultEnum(ItemResultEnum.CHECK);
        } else {
            String failedMsg;
            String cpuTip = ResourceUtil.getStringWithParams((String)"eval.preparecheck.errmsg.cpu.failed.tip", (Object[])new Object[]{checkCpuRet});
            String ioTip = ResourceUtil.getStringWithParams((String)"eval.preparecheck.errmsg.io.failed.tip", (Object[])new Object[]{checkIoRet});
            initResult.setItemResultEnum(ItemResultEnum.NOCHECK);
            String string = failedMsg = checkCpuRetValid ? "" : cpuTip;
            if (!checkCpuRetValid) {
                failedMsg = failedMsg + System.lineSeparator();
            }
            failedMsg = failedMsg + (checkIoRetValid ? "" : ioTip);
            GrabResultEntity entity = new GrabResultEntity();
            entity.setErrorMessage(failedMsg);
            entity.setEvalNode(this.devNode);
            entity.setGrabFailed(true);
            this.grabParamEntity.getUiListener().notifyDevGrabEnd(entity);
        }
        this.grabService.fillOneResultByNode(this.devNode, initResult);
        this.uiListener.collectCallback(this.devNode);
        ConnUtils.sleep(100);
    }

    private String createPrepareCheckErrorMsg(int checkCpuRet, int checkIoRet) {
        boolean checkCpuRetValid = checkCpuRet == -1;
        boolean checkIoRetValid = checkIoRet == -1;
        StringBuilder msgBuilder = new StringBuilder();
        msgBuilder.append(checkCpuRetValid ? ResourceUtil.getString((String)"infograb.preparecheck.errmsg.cpu.success") + ResourceUtil.getString((String)"infograb.cpu.or.io.check.result.success") : ResourceUtil.getString((String)"infograb.preparecheck.errmsg.cpu.failed") + ResourceUtil.getString((String)"infograb.cpu.or.io.check.result.failed")).append(TAB + (checkCpuRetValid ? " " : ResourceUtil.getStringWithParams((String)"infograb.preparecheck.errmsg.cpu.failed.tip", (Object[])new Object[]{checkCpuRet})));
        msgBuilder.append(ENTER);
        if (ToolUtils.isUnixSystem(this.devNode)) {
            return msgBuilder.toString();
        }
        msgBuilder.append(checkIoRetValid ? ResourceUtil.getString((String)"infograb.preparecheck.errmsg.io.success") + ResourceUtil.getString((String)"infograb.cpu.or.io.check.result.success") : ResourceUtil.getString((String)"infograb.preparecheck.errmsg.io.failed") + ResourceUtil.getString((String)"infograb.cpu.or.io.check.result.failed")).append(TAB + (checkIoRetValid ? " " : ResourceUtil.getStringWithParams((String)"infograb.preparecheck.errmsg.io.failed.tip", (Object[])new Object[]{checkIoRet})));
        return msgBuilder.toString();
    }

    private ExecuteResult createCheckingPrepareLine() {
        ExecuteResult result = new ExecuteResult();
        result.setDevNode(this.devNode);
        result.setDescription("infograb.detail.preparecheck");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        result.setResultMap(resultMap);
        result.setProcessing(false);
        result.setPrepareItem(true);
        result.setCureItemCollecting(true);
        return result;
    }

    private ExecuteResult createPretreatment() {
        ExecuteResult result = new ExecuteResult();
        result.setDevNode(this.devNode);
        result.setDescription("infograb.detail.pretreatment");
        result.setProcessing(false);
        result.setProcessItem(true);
        result.setShowProgress(true);
        result.setCureItemCollecting(true);
        return result;
    }

    private ExecuteResult createPrepareLine() {
        ExecuteResult result;
        List<ExecuteResult> executeResults = GrabContext.getInstance().getExecuteResultMap().get((Object)this.devNode);
        if (!executeResults.isEmpty() && "infograb.detail.preparecheck".equals((result = executeResults.get(executeResults.size() - 1)).getDescription())) {
            result.setDescription("infograb.detail.preparecheck");
            result.setCureItemCollecting(false);
            return result;
        }
        result = new ExecuteResult();
        result.setDevNode(this.devNode);
        result.setDescription("infograb.detail.preparecheck");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        result.setResultMap(resultMap);
        result.setProcessing(false);
        return result;
    }

    public void setStop(boolean isStopBool) {
        this.isCollectStop = isStopBool;
    }

    private boolean smartIdcCollectDevice(ExecuteResult currExecuteResult, boolean isNetAppCollect) {
        try {
            LOGGER.info("start collect!");
            if (!SmartIdcUtil.INSTANCE.getServerStatus()) {
                LOGGER.error("SmartIDC is not running");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("err_msg", ResourceUtil.getString((String)"infograb.grabThread.startcollectfailed"));
                currExecuteResult.setResultMap(map);
                return false;
            }
            Map<String, Object> jsonParams = this.getJsonParams();
            JSONObject startResult = SmartIdcUtil.INSTANCE.postStartCollect(jsonParams);
            if (!JsonUtil.safeGetBoolean((JSONObject)startResult, (String)"success")) {
                LOGGER.error("fail to send collect post ");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("err_msg", ResourceUtil.getString((String)"infograb.grabThread.startcollectfailed"));
                currExecuteResult.setResultMap(map);
                return false;
            }
            LOGGER.info("start to collect successfully");
            ConnUtils.sleep(30000);
            boolean complete = this.checkIdcCollectProgress(JsonUtil.safeGetString((JSONObject)startResult, (String)"task_id"), currExecuteResult, isNetAppCollect);
            if (complete) {
                this.devNode.setDevInfoPkgPath(this.getDevInfoPkgPath(jsonParams.get("log_dir").toString(), JsonUtil.safeGetString((JSONObject)startResult, (String)"task_id")));
            }
            return complete;
        }
        catch (Exception e) {
            LOGGER.error("fail to collect.", (Throwable)e);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("err_msg", ResourceUtil.getString((String)"infograb.grabThread.collectstop"));
            currExecuteResult.setResultMap(map);
            return false;
        }
    }

    boolean checkIdcCollectProgress(String taskId, ExecuteResult currExecuteResult, boolean isNetAppCollect) {
        int statusTimes = 0;
        while (true) {
            JSONObject taskInfo = this.getIdcTaskInfo(taskId);
            String status = JsonUtil.safeGetString((JSONObject)taskInfo, (String)"status");
            int progress = Math.max(JsonUtil.safeGetInt((JSONObject)taskInfo, (String)"progress", (int)1), 1);
            this.refreshProgress(progress, currExecuteResult, isNetAppCollect);
            if (Objects.equals("Success", status)) {
                return true;
            }
            if (Objects.equals("In Progress", status)) {
                statusTimes = 0;
            } else {
                if (Objects.equals("Failed", status)) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("err_msg", ResourceUtil.getString((String)"infograb.grabThread.startcollectfailed"));
                    currExecuteResult.setResultMap(map);
                    return false;
                }
                ++statusTimes;
            }
            if (this.isCollectStop) {
                return false;
            }
            if (statusTimes >= 3) {
                LOGGER.error("failed to collect information");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("err_msg", ResourceUtil.getString((String)"infograb.grabThread.collectingfailed"));
                currExecuteResult.setResultMap(map);
                return false;
            }
            ConnUtils.sleep(60000);
        }
    }

    JSONObject getIdcTaskInfo(String taskId) {
        return SmartIdcUtil.INSTANCE.postGetTaskProcess(Collections.singletonMap("task_id", taskId));
    }

    private String getDevInfoPkgPath(String logDir, String taskId) throws ToolException {
        try {
            File file = FileUtils.getFile((String[])new String[]{logDir, taskId});
            if (file.exists() && file.isDirectory()) {
                return file.getCanonicalPath();
            }
            throw new ToolException("get smart idc grab report path error.");
        }
        catch (IOException e) {
            throw new ToolException("get smart idc grab report path error.", e);
        }
    }

    private void refreshProgress(int progress, ExecuteResult currExecuteResult, boolean isNetAppCollect) {
        int upgradeProgress = isNetAppCollect ? 90 : currExecuteResult.getItem().getUpdateProcNumber();
        int currentProgress = progress >= 100 ? 99 : progress;
        currExecuteResult.setCurItemProgress(currentProgress);
        currentProgress = currentProgress * upgradeProgress / 100;
        currExecuteResult.setProgress(currentProgress);
        this.uiListener.updateItemProgress(this.devNode);
        JComponent component = GrabContext.getInstance().getCurrentTask().getTaskDetailContainer();
        if (component instanceof RealTimeTaskDetailContainer) {
            InfoGrabIsmTable table = ((RealTimeTaskDetailContainer)component).getDevTable();
            List rows = table.getAllRows();
            TableRow useRow = null;
            for (TableRow row : rows) {
                if (!((String)row.getIdentifier()).equals(this.devNode.getDeviceSerialNumber())) continue;
                useRow = row;
                break;
            }
            if (useRow != null) {
                useRow.setValueAt(6, (Object)new IsmTableCell.ProgressCell(currentProgress));
            }
        }
    }

    private Map<String, Object> getJsonParams() {
        HashMap<String, Object> jsonParams = new HashMap<String, Object>();
        jsonParams.put("log_dir", SmartIdcUtil.INSTANCE.getLogDir(this.devNode.getMigrType(), this.devNode.getDeviceName(), this.devNode.getDeviceModel(), this.devNode.getIp()));
        HashMap<String, Object> devicesMap = new HashMap<String, Object>();
        devicesMap.put("uid", this.devNode.getUuid());
        devicesMap.put("type", "Storage");
        devicesMap.put("vendor", this.devNode.getDeviceName());
        devicesMap.put("model", this.devNode.getDeviceModel());
        devicesMap.put("username", this.devNode.getLoginUser().getUserName());
        devicesMap.put("password", "xxxx");
        devicesMap.put("collect_type", "Configuration");
        devicesMap.put("duration", MigrationUtils.getSmartIdcGrabDuration(this.devNode));
        devicesMap.put("durationText", "Current");
        devicesMap.put("port", this.devNode.getPort() + "");
        devicesMap.put("service_name", "Migration");
        if (InfoGrabDeviceTypeUtil.isEmcVmaxDevice(this.devNode.getDeviceName(), this.devNode.getDeviceModel())) {
            devicesMap.put("symmetrixId", this.devNode.getDeviceSerialNumber());
        }
        devicesMap.put("data_center", "Migration");
        devicesMap.put("ips", Collections.singletonList(this.devNode.getIp()));
        jsonParams.put("devices", Collections.singletonList(devicesMap));
        return jsonParams;
    }

    private void nasCollectPre(ExecuteResult currExecuteResult) {
        this.uiListener.changeSelectNodeStatus(this.devNode);
        this.uiListener.initDevThread(this.devNode);
        this.grabService.startGifLoading();
        currExecuteResult.setDevNode(this.devNode);
        currExecuteResult.setDescription("smartIDC_configuration_sysinfo");
        currExecuteResult.setCureItemCollecting(true);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("err_msg", ResourceUtil.getString((String)"infograb.grabThread.collecting"));
        currExecuteResult.setResultMap(map);
        GrabContext.getInstance().getNodeStatusMap().put(this.devNode, true);
        this.grabService.fillOneResultByNode(this.devNode, currExecuteResult);
        this.uiListener.updateItemProgress(this.devNode);
    }

    private void getInfoBySmartIdc() {
        ExecuteResult currExecuteResult = new ExecuteResult();
        this.nasCollectPre(currExecuteResult);
        boolean complete = this.smartIdcCollectDevice(currExecuteResult, true);
        if (this.isCollectStop) {
            currExecuteResult.setItemResultEnum(ItemResultEnum.STOPED);
            currExecuteResult.setCureItemCollecting(false);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("err_msg", ResourceUtil.getString((String)"infograb.grabThread.collectstop"));
            currExecuteResult.setResultMap(map);
            this.devNode.setCollectDone(false);
            this.grabService.refreshStopStatus(this.devNode);
        } else if (complete) {
            currExecuteResult.setProgress(90);
            currExecuteResult.setCureItemCollecting(false);
            currExecuteResult.setItemResultEnum(ItemResultEnum.SUCCESS);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("err_msg", ResourceUtil.getString((String)"infograb.grabThread.collectsuccess"));
            currExecuteResult.setResultMap(resultMap);
            currExecuteResult.setCurItemProgress(100);
            currExecuteResult.setShowProgress(false);
            currExecuteResult.setExecuteEndTime();
            currExecuteResult.setNowStatus(CollectStatusEnum.COLLECT_SUCC);
            currExecuteResult.setCheckResult(ResourceUtil.getString((String)"infograb.complete"));
            new NasParseService(this.devNode, this.grabService, this.uiListener).doDataParse(Collections.singletonList(currExecuteResult));
        } else {
            currExecuteResult.setCureItemCollecting(false);
            currExecuteResult.setItemResultEnum(ItemResultEnum.FAILD);
            currExecuteResult.setExecuteEndTime();
            currExecuteResult.setNowStatus(CollectStatusEnum.COLLECT_FAILED);
            currExecuteResult.setCheckResult(ResourceUtil.getString((String)"infograb.failed"));
            this.devNode.setCollectDone(false);
            this.grabService.fillOneResultByNode(this.devNode, currExecuteResult);
            this.uiListener.updateItemProgress(this.devNode);
            this.handleItemStatus(currExecuteResult);
        }
        GrabContext.getInstance().getNodeStatusMap().put(this.devNode, false);
        this.devNode.setCollectStop(true);
        this.isGrabIng = false;
        this.clearAllProcStatus(this.devNode);
        LOGGER.info(" device {} grab end ", (Object)this.devNode.getIp());
    }

    private void getInfoRun() {
        this.isGrabIng = true;
        JLabel bottomPanel = new JLabel();
        if (!GrabContext.getInstance().isUpgradeEval()) {
            bottomPanel = GrabContext.getInstance().getCurrInfoGrabFrame().getBottomPanel();
        }
        bottomPanel.setText("");
        this.refreshOuterPreg(4);
        this.initCollectFlow();
        if (null == this.singleTask) {
            if (GrabContext.getInstance().isUpgradeEval()) {
                GrabContext.countDownLatch.countDown();
            }
            LOGGER.info("null == singleTask is null");
            return;
        }
        if (this.singleTask.getDevNum() == 1) {
            List<String> curCategory = GrabFlowAdapter.getInstance().getNodeSelectedCategoryMap().get((Object)this.devNode);
            if (null != curCategory && curCategory.contains(this.dataMigration)) {
                try {
                    List<GrabDevNode2> summaryNodes = this.getSummaryNodes();
                    if (summaryNodes.size() > 0) {
                        String excelPath = this.getSaveDataXls(this.devNode);
                        HostDataHandleService.summary2Xls(excelPath, summaryNodes);
                        AnonymizeUtils.anonymizeData(summaryNodes, excelPath);
                        LOGGER.info("creat migration Summary report successful");
                    }
                }
                catch (Exception e) {
                    LOGGER.error("creat migration Summary report fail. {}", (Throwable)e);
                }
            }
            this.saveUserData(bottomPanel, curCategory);
        } else {
            if (GrabContext.getInstance().isUpgradeEval()) {
                GrabContext.countDownLatch.countDown();
            }
            this.singleTask.setDevNum(this.singleTask.getDevNum() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveUserData(JLabel bottomPanel, List<String> curCategory) {
        if (null != curCategory && (curCategory.contains(this.preUpgrade) || curCategory.contains(this.networkDiscovery))) {
            try {
                GrabContext.isGrabzip = false;
                bottomPanel.setText(ResourceUtil.getStringWithParams((String)"infograb.end.report.start", (Object[])new Object[]{10}));
                this.saveUserOpData2Context(curCategory);
                bottomPanel.setText(ResourceUtil.getStringWithParams((String)"infograb.end.report.start", (Object[])new Object[]{30}));
                List<GrabDevNode2> currSelectedDevs = this.singleTask.getDevNodesList();
                if (!InfoGrabService.getInstance().isSelectedNodesStopped(currSelectedDevs)) return;
                List<File> xlsFiles = this.fillLatestFile2List();
                bottomPanel.setText(ResourceUtil.getStringWithParams((String)"infograb.end.report.start", (Object[])new Object[]{40}));
                LOGGER.info("all of excel file are:{}", xlsFiles);
                this.updateHostHBAInfo(xlsFiles);
                bottomPanel.setText(ResourceUtil.getStringWithParams((String)"infograb.end.report.start", (Object[])new Object[]{50}));
                this.updateDeviceMetaDateKey(xlsFiles);
                bottomPanel.setText(ResourceUtil.getStringWithParams((String)"infograb.end.report.start", (Object[])new Object[]{80}));
                long t1 = System.currentTimeMillis();
                this.exportSelectReportAtom(xlsFiles);
                long t2 = System.currentTimeMillis();
                bottomPanel.setText(ResourceUtil.getStringWithParams((String)"infograb.end.report.start", (Object[])new Object[]{95}));
                LOGGER.info("Export reports costs {}ms...", (Object)((int)(t2 - t1)));
                bottomPanel.setText(ResourceUtil.getString((String)"infograb.end.report.end"));
                return;
            }
            catch (RuntimeException e) {
                LOGGER.error("cancel collect..something is wrong. {}", (Throwable)e);
                bottomPanel.setText("");
                return;
            }
            catch (Exception e) {
                LOGGER.error("cancel collect.. {}", (Throwable)e);
                bottomPanel.setText("");
                return;
            }
            finally {
                GrabContext.isGrabzip = true;
                if (GrabContext.getInstance().isUpgradeEval()) {
                    GrabContext.countDownLatch.countDown();
                }
                this.removeTaskMap(GrabContext.getInstance().getSingleDevTask(), this.taskKey);
                LOGGER.info("alreadly remove + {}", (Object)GrabContext.getInstance().getSingleDevTask().size());
            }
        } else {
            this.saveUserOpData2Context(curCategory);
        }
    }

    public boolean isStop() {
        return this.isCollectStop;
    }

    public InfoGrabService getGrabService() {
        return this.grabService;
    }

    private List<GrabDevNode2> getSummaryNodes() {
        List<String> supportHostTypes = OfflineImportUtils.getSupportOfflineHostTypes();
        ArrayList<GrabDevNode2> summaryNodes = new ArrayList<GrabDevNode2>();
        String taskName = "";
        Map<GrabDevNode2, BaseTask> node2TaskMap = GrabContext.getInstance().getTaskMap();
        List<GrabDevNode2> singleTaskNodes = this.singleTask.getDevNodesList();
        String singleTaskName = node2TaskMap.get((Object)singleTaskNodes.get(0)).getTaskName();
        LOGGER.info("Checking singleTask {} for done node.", (Object)singleTaskName);
        if (this.checkSummaryStatu(supportHostTypes)) {
            List<BaseTaskPanel> allTasks = GrabContext.getInstance().getCollectTasks();
            for (BaseTaskPanel oneTask : allTasks) {
                List<GrabDevNode2> oneTaskNodes = ((RealTimeTaskDetailContainer)oneTask.getTaskDetailContainer()).getAllDevNode();
                if (oneTaskNodes.size() > 0 && !singleTaskName.equals(taskName = node2TaskMap.get((Object)oneTaskNodes.get(0)).getTaskName())) continue;
                for (GrabDevNode2 oneNode : oneTaskNodes) {
                    if (supportHostTypes.contains(oneNode.getDeviceName()) && InfoGrabService.getInstance().findNodeStatus(oneNode).booleanValue()) {
                        LOGGER.info("This task has not only one singleTask,some supportting nodes are collectting.");
                        return new ArrayList<GrabDevNode2>();
                    }
                    if (!supportHostTypes.contains(oneNode.getDeviceName()) || InfoGrabService.getInstance().findNodeStatus(oneNode).booleanValue()) continue;
                    LOGGER.info("{} task has right node:{}", (Object)taskName, (Object)oneNode.getIp());
                    summaryNodes.add(oneNode);
                }
                if (summaryNodes.size() <= 0) continue;
                break;
            }
        }
        return summaryNodes;
    }

    private boolean checkSummaryStatu(List<String> supportHostTypes) {
        List<GrabDevNode2> singleTaskNodes = this.singleTask.getDevNodesList();
        for (GrabDevNode2 node : singleTaskNodes) {
            if (!node.isCollectDone() || !supportHostTypes.contains(node.getDeviceName())) continue;
            LOGGER.info("this singleTask has supportting colloectdone nodes.");
            return true;
        }
        LOGGER.warn("this singleTask has no supportting colloectdone node.");
        return false;
    }

    private String getSaveDataXls(GrabDevNode2 node) {
        RealTimeTask collectTask = (RealTimeTask)GrabContext.getInstance().getTaskMap().get((Object)node);
        String taskDirName = GrabFileFactory.getInstance().getTaskBasePath(collectTask).toString();
        String timeStamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        StringBuilder dirStringBuilder = new StringBuilder();
        dirStringBuilder.append(taskDirName).append(File.separator).append("Summary_").append(timeStamp).append(".xls");
        return dirStringBuilder.toString();
    }
}

