/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.grab;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.DeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.enums.NodeAddEnum;
import com.huawei.ism.tool.infograb.entity.CollectItem;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.Item;
import com.huawei.ism.tool.infograb.exception.ExcutePyException;
import com.huawei.ism.tool.infograb.grab.FilterDataLinkedHashMap;
import com.huawei.ism.tool.infograb.grab.GrabFlowAdapter;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabFileFactory;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabUtil;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.infograb.parser.MigrationParse;
import com.huawei.ism.tool.infograb.service.HandleStorageXlsData;
import com.huawei.ism.tool.infograb.service.HostDataHandleService;
import com.huawei.ism.tool.infograb.service.XLSStorageService;
import com.huawei.ism.tool.infograb.service.XlsClusterItem;
import com.huawei.ism.tool.infograb.service.migration.NasParseService;
import com.huawei.ism.tool.infograb.utils.DeviceModelChecker;
import com.huawei.ism.tool.infograb.utils.GrabCommonUtils;
import com.huawei.ism.tool.infograb.utils.InfograbConstants;
import com.huawei.ism.tool.infograb.utils.OfflineImportUtils;
import com.huawei.ism.tool.infograb.utils.migration.MigrationUtils;
import com.huawei.ism.tool.obase.utils.CommonEncodeDetectUtils;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.python.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfflineGrabService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfflineGrabService.class);
    private static final String DKC_INFO_CSV = "DkcInfo.csv";
    private static final String MICRO_VERSION_CSV = "MicroVersion.csv";
    private static final String WWN_INFO_CSV = "WwnInfo.csv";
    private static final String LUN_INFO_CSV = "LunInfo.csv";
    private static final String LDEV_INFO_CSV = "LdevInfo.csv";
    private static final String STORAGE_SYSTEM_TYPE = "Storage System Type";
    private static final String SERIAL_NUMBER = "Serial Number#";
    private static final String IP_ADDRESS = "IP Address";
    private static final String DKCMAIN = "DKCMAIN";
    private static final String DIR_CSV = "CSV";
    private static final String REGEX = ",";
    private static final String RET_MAP = "ret_map";
    private static final String LANGUAGE = "lang";
    private String taskName;
    private boolean failGrab = false;
    private GrabDevNode2 devNode;

    public OfflineGrabService(GrabDevNode2 devNode, String taskName) {
        this.devNode = devNode;
        this.taskName = taskName;
    }

    public OfflineGrabService(GrabDevNode2 devNode) {
        this.devNode = devNode;
    }

    public boolean parseBasicInfo() {
        if (StringUtils.isNULLStr((String)this.devNode.getDevInfoPkgPath())) {
            this.devNode.setErrorDecs(ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.invalidOfflineFilePath"));
            return false;
        }
        if (this.devNode.getDevInfoPkgPath().endsWith("data")) {
            return this.parseHostBasicInfo();
        }
        if (this.devNode.getDevInfoPkgPath().toUpperCase(Locale.ENGLISH).endsWith(".TGZ") && this.unTgzHdsReportFile()) {
            return this.parseStorageBasicInfo();
        }
        if (this.devNode.getDevInfoPkgPath().toUpperCase(Locale.ENGLISH).endsWith(".TAR.GZ") && this.unzipNetAppReportFile()) {
            return this.parseStorageBasicInfo();
        }
        return false;
    }

    private boolean parseStorageBasicInfo() {
        try {
            if ("HDS".equals(this.devNode.getDeviceName())) {
                this.parseHdsBasicInfo();
            } else {
                this.parseNetAppInfo();
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("parse storage device basic info error.", (Throwable)e);
            this.devNode.setErrorDecs(ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.unknownError"));
            return false;
        }
    }

    private void parseNetAppInfo() throws Exception {
        Path logFile = MigrationUtils.getNetAppLogFilePath(this.devNode, this.taskName);
        try (Stream<String> lineStream = Files.lines(logFile, Charset.forName(CommonEncodeDetectUtils.endcodeDetect(logFile.toFile())));){
            Optional<String> rightLine = lineStream.filter(line -> line.contains("collection is successful") && line.contains(this.devNode.getDeviceName())).findFirst();
            if (!rightLine.isPresent()) {
                this.devNode.setErrorDecs(ResourceUtil.getStringWithParams((String)"infograb.morefunction.offline.notsupport", (Object[])new Object[0]));
                return;
            }
            this.setIpModel(rightLine.get());
        }
    }

    private void setIpModel(String tempLine) {
        Matcher ipMatcher = MigrationUtils.IP_PATTERN.matcher(tempLine);
        if (ipMatcher.find()) {
            this.devNode.setIp(ipMatcher.group(ipMatcher.groupCount()));
        }
        this.devNode.setDeviceModel(this.getNetAppDeviceModel(tempLine));
    }

    private String getNetAppDeviceModel(String tempLine) {
        if (tempLine.contains("C-MODE")) {
            return "C-MODE";
        }
        if (tempLine.contains("7-MODE")) {
            return "7-MODE";
        }
        return "";
    }

    private void parseHdsBasicInfo() throws com.huawei.ism.tool.obase.exception.ToolException {
        List<List<String>> dkcInfos = this.readHdsCsvFile(DKC_INFO_CSV);
        List<String> headers = dkcInfos.get(0);
        List<String> datas = dkcInfos.get(1);
        for (int index = 0; index < headers.size(); ++index) {
            String header = headers.get(index);
            if (STORAGE_SYSTEM_TYPE.equalsIgnoreCase(header)) {
                this.devNode.setDeviceModel(datas.get(index));
                this.devNode.setDeviceType(DeviceType.valueOf((String)datas.get(index)));
                continue;
            }
            if (SERIAL_NUMBER.equalsIgnoreCase(header)) {
                this.devNode.setDeviceSerialNumber(datas.get(index));
                continue;
            }
            if (!IP_ADDRESS.equalsIgnoreCase(header)) continue;
            this.devNode.setIp(datas.get(index));
        }
        List<List<String>> versionInfos = this.readHdsCsvFile(MICRO_VERSION_CSV);
        headers = versionInfos.get(0);
        datas = versionInfos.get(1);
        for (int index = 0; index < headers.size(); ++index) {
            if (!DKCMAIN.equalsIgnoreCase(headers.get(index))) continue;
            this.devNode.setProductVersion(datas.get(index));
            break;
        }
    }

    private List<List<String>> readHdsCsvFile(String fileName) throws com.huawei.ism.tool.obase.exception.ToolException {
        String csvFilePath = this.devNode.getDevInfoPkgPath() + fileName;
        ArrayList<List<String>> dataList = new ArrayList<List<String>>();
        FileReader fileReader = null;
        BufferedReader reader = null;
        try {
            String line;
            fileReader = new FileReader(csvFilePath);
            reader = new BufferedReader(fileReader);
            int lineIndex = 0;
            while ((line = reader.readLine()) != null) {
                if (++lineIndex == 1) continue;
                dataList.add(this.splitToListByTrim(REGEX, line));
            }
            if (dataList.size() < 2) {
                throw new com.huawei.ism.tool.obase.exception.ToolException("invalidHdsCsvData");
            }
        }
        catch (IOException e) {
            try {
                LOGGER.error("read HDS csv file {} io error.", (Object)fileName);
                throw new com.huawei.ism.tool.obase.exception.ToolException("readHdsCsvError", e);
            }
            catch (Throwable throwable) {
                FileUtils.close(reader, fileReader);
                throw throwable;
            }
        }
        FileUtils.close(reader, fileReader);
        return dataList;
    }

    private boolean unzipNetAppReportFile() {
        String filePath = this.devNode.getDevInfoPkgPath();
        String toPath = InfoGrabDirPropertiesUtil.getProperty() + File.separator + this.taskName;
        try {
            ZipUtils.decompressTarGzFile((File)new File(filePath), (String)toPath);
        }
        catch (Exception e) {
            LOGGER.error("un tgz device report file error.", (Throwable)e);
            this.devNode.setErrorDecs(ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.unTgzFail"));
            return false;
        }
        return true;
    }

    private boolean unTgzHdsReportFile() {
        String filePath = this.devNode.getDevInfoPkgPath();
        String toPath = filePath.substring(0, filePath.length() - 4);
        try {
            ZipUtils.decompressTarGzFile((File)new File(filePath), (String)toPath);
            filePath = toPath + File.separator + DIR_CSV + File.separator;
            if (!this.checkTgzHdsReportObjs(filePath)) {
                LOGGER.error("check hds report file fail.");
                this.devNode.setErrorDecs(ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.invalidHdsCsvData"));
                return false;
            }
            this.devNode.setDevInfoPkgPath(filePath);
        }
        catch (IOException e) {
            LOGGER.error("un tgz HDS device report file error.", (Throwable)e);
            this.devNode.setErrorDecs(ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.unTgzFail"));
            return false;
        }
        return true;
    }

    private boolean checkTgzHdsReportObjs(String filePath) {
        List<String> fileNames = Arrays.asList(DKC_INFO_CSV, MICRO_VERSION_CSV, WWN_INFO_CSV, LDEV_INFO_CSV, LUN_INFO_CSV);
        File csvDir = new File(filePath);
        if (!csvDir.exists() || !csvDir.isDirectory()) {
            return false;
        }
        File[] files = csvDir.listFiles();
        int count = 0;
        if (null != files) {
            for (File file : files) {
                if (!fileNames.contains(file.getName())) continue;
                ++count;
            }
        }
        return count == fileNames.size();
    }

    private List<String> splitToListByTrim(String regex, String infoStr) {
        String[] infos = infoStr.split(regex);
        ArrayList<String> infoList = new ArrayList<String>(infos.length);
        for (String info : infos) {
            infoList.add(info.trim());
        }
        return infoList;
    }

    private String getHostScriptFile(GrabDevNode2 devNode) {
        return ApplicationContext.getInstance().getWorkPath() + InfograbConstants.OFFLINE_HOST_DISCOVERY + devNode.getDeviceName().toLowerCase(Locale.ENGLISH) + ".py";
    }

    private boolean parseHostBasicInfo() {
        try {
            return this.parseHostInfo(this.devNode, this.parseHostInfo(this.devNode));
        }
        catch (Exception e) {
            this.handleParseHostBasicInfoException(this.devNode, e);
            return false;
        }
    }

    private void handleParseHostBasicInfoException(GrabDevNode2 devNode, Exception exception) {
        if (exception instanceof SignException || exception instanceof com.huawei.ism.tool.obase.exception.ToolException) {
            LOGGER.error("py file execute filed!", (Throwable)exception);
            devNode.setErrorDecs(ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.verifyfail"));
        } else if (exception instanceof FileNotFoundException) {
            LOGGER.error("py file not found!");
            devNode.setErrorDecs(ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.scriptlost"));
        } else {
            LOGGER.error("py file execute filed!", (Throwable)exception);
            devNode.setErrorDecs(ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.verifyfail"));
        }
    }

    private HostInfo parseHostInfo(GrabDevNode2 devNode) throws FileNotFoundException, com.huawei.ism.tool.obase.exception.ToolException {
        Map<String, String> hostInfoMap = this.queryHost(devNode);
        HostInfo hostInfo = new HostInfo();
        hostInfo.setName(hostInfoMap.get("name"));
        hostInfo.setType(hostInfoMap.get("type"));
        hostInfo.setSn(hostInfoMap.get("sn").toUpperCase(Locale.ENGLISH));
        hostInfo.setVersion(hostInfoMap.get("version"));
        hostInfo.setIp(hostInfoMap.get("ip"));
        return hostInfo;
    }

    private Map<String, String> queryHost(GrabDevNode2 devNode) throws FileNotFoundException, com.huawei.ism.tool.obase.exception.ToolException {
        File hostScriptFile = new File(this.getHostScriptFile(devNode));
        if (!hostScriptFile.exists()) {
            throw new FileNotFoundException(hostScriptFile.getName() + " is not exist.");
        }
        LOGGER.info("excute script file {} to parse device basic info", (Object)hostScriptFile.getName());
        JythonExecuter executer = new JythonExecuter();
        executer.compileScript(hostScriptFile);
        Map<String, Object> context = this.prepareContext();
        return (Map)executer.simpleInvokeFunction("execute", context);
    }

    private Map<String, Object> prepareContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("datafile", this.devNode.getDevInfoPkgPath());
        context.put("Logger", LOGGER);
        return context;
    }

    private boolean parseHostInfo(GrabDevNode2 devNode, HostInfo hostInfo) {
        if (!this.hostInfoValid(devNode, hostInfo)) {
            LOGGER.error("The script result is Invalid!");
            devNode.setErrorDecs(ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.verifyfail"));
            return false;
        }
        devNode.setDeviceSerialNumber(hostInfo.getSn());
        DeviceType devType = DeviceType.valueOf((String)hostInfo.getType());
        devNode.setDeviceType(devType);
        devNode.setProductVersion(hostInfo.getVersion());
        devNode.setIp(hostInfo.getIp());
        return true;
    }

    private boolean hostInfoValid(GrabDevNode2 devNode, HostInfo hostInfo) {
        LOGGER.info("Parse offline host, IP:{}, DeviceName:{}, Type:{}, SN:{}, Version:{}", new Object[]{hostInfo.getIp(), hostInfo.getName(), hostInfo.getType(), hostInfo.getSn(), hostInfo.getVersion()});
        if (!hostInfo.getName().equals(devNode.getDeviceName())) {
            devNode.setErrorDecs(ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.errortype"));
            return false;
        }
        if (Strings.isNullOrEmpty((String)hostInfo.getIp()) || Strings.isNullOrEmpty((String)hostInfo.type)) {
            devNode.setErrorDecs(ResourceUtil.getString((String)"devicemanager.layout.device.offlineImport.verifyfail"));
            return false;
        }
        return true;
    }

    public boolean offlineGrab() {
        if (DeviceModelChecker.isNetAppDevice(this.devNode.getDeviceModel())) {
            if (NodeAddEnum.OFFLINE_IMPORT.equals((Object)this.devNode.getNodeAddType())) {
                MigrationUtils.setNetAppReportPath(this.devNode, this.taskName);
            }
            new NasParseService(this.devNode).generateReport();
            this.devNode.setCollectDone(true);
            return true;
        }
        List<Item> grabItems = this.getGrabItems();
        if (VerifyUtil.isEmpty(grabItems)) {
            LOGGER.error("fail to get grab items.");
            this.devNode.setErrorDecs(ResourceUtil.getString((String)"infograb.morefunction.offline.grabFail"));
            return false;
        }
        try {
            List<ExecuteResult> executeResults = this.executeAllItem(grabItems);
            boolean createReport = this.createReport(executeResults);
            this.devNode.setCollectDone(true);
            return createReport;
        }
        catch (Exception e) {
            LOGGER.error("fail to grab items.", (Throwable)e);
            this.devNode.setErrorDecs(ResourceUtil.getString((String)"infograb.morefunction.offline.grabFail"));
            return false;
        }
    }

    private List<Item> getGrabItems() {
        if (ItDeviceType.Storage.equals((Object)this.devNode.getItDeviceType())) {
            return GrabFlowAdapter.getInstance().findProperFlow(this.devNode);
        }
        return this.getHostGrabItems();
    }

    private List<Item> getHostGrabItems() {
        Optional<List<Item>> hostGrabFlow = OfflineImportUtils.getHostGrabFlow(this.devNode.getDeviceName());
        if (!hostGrabFlow.isPresent()) {
            return new ArrayList<Item>();
        }
        return hostGrabFlow.get();
    }

    private List<ExecuteResult> executeAllItem(List<Item> grabItems) {
        return grabItems.stream().map(item -> this.excuteOneItem((Item)item)).collect(Collectors.toList());
    }

    private ExecuteResult excuteOneItem(Item item) {
        try {
            return this.getOneItemResult(item);
        }
        catch (Exception e) {
            LOGGER.error("Current DevNode: {} Get {} failed. Error details is: ", new Object[]{this.devNode.getIp(), item, e});
            throw new ExcutePyException("fail to grab items.");
        }
    }

    private boolean createReport(List<ExecuteResult> currResultList) throws IOException {
        return this.createGeneralReport(currResultList) && this.createStorageXls(currResultList) && this.createHostXml(currResultList, this.taskName);
    }

    private boolean createHostXml(List<ExecuteResult> currResultList, String taskName) {
        boolean createHostXml = true;
        if (ItDeviceType.Host.equals((Object)this.devNode.getItDeviceType())) {
            createHostXml = this.handleHostXmlReport(currResultList, taskName);
        }
        return createHostXml;
    }

    private boolean createStorageXls(List<ExecuteResult> currResultList) {
        boolean createStorageXls = true;
        if (ItDeviceType.Storage.equals((Object)this.devNode.getItDeviceType())) {
            createStorageXls = this.handleStorageXlsReport(currResultList);
        }
        return createStorageXls;
    }

    private ExecuteResult getOneItemResult(Item item) throws com.huawei.ism.tool.obase.exception.ToolException, FileNotFoundException {
        ExecuteResult executeResult = GrabCommonUtils.createExcuteResult(this.devNode, item, null);
        Map<String, Object> itemResult = this.getExecuteOneItem(item);
        executeResult.setExecuteEndTime();
        executeResult.setResultMap(itemResult);
        return executeResult;
    }

    private Map<String, Object> getExecuteOneItem(Item item) throws com.huawei.ism.tool.obase.exception.ToolException, FileNotFoundException {
        Map<String, Object> retMap = this.executeOneItem(item);
        return this.dealRetMap(retMap);
    }

    private Map<String, Object> dealRetMap(Map<String, Object> retMap) {
        String errMsg = GrabCommonUtils.getErrMsg("execute success", "Execution succeeded", "execute failed", "Execution failed", retMap);
        retMap.put("err_msg", GrabCommonUtils.dealErrorMessageWithEcho(errMsg));
        return retMap;
    }

    private Map<String, Object> executeOneItem(Item currItem) throws com.huawei.ism.tool.obase.exception.ToolException, FileNotFoundException {
        String scriptPath = currItem.getScriptPath();
        JythonExecuter jythonExecuter = new JythonExecuter(new File(InfograbConstants.SCRIPT_ROOT_PATH));
        File currPyFile = new File(GrabUtil.fixPath(scriptPath));
        LOGGER.info("current script file: {}", (Object)currPyFile.getName());
        jythonExecuter.compileScript(currPyFile);
        FilterDataLinkedHashMap<String, Object> retMap = new FilterDataLinkedHashMap<String, Object>();
        jythonExecuter.simpleInvokeFunction("execute", this.prepareParameters(retMap));
        return retMap;
    }

    private Map<String, Object> prepareParameters(Map<String, Object> retMap) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("reportPath", this.devNode.getDevInfoPkgPath());
        context.put(RET_MAP, retMap);
        context.put("Logger", LOGGER);
        context.put(LANGUAGE, LanguageManager.getInstance().getCurrentLanguage().toString());
        return context;
    }

    private boolean handleStorageXlsReport(List<ExecuteResult> currResultList) {
        try {
            List<XlsClusterItem> xlsItems = GrabCommonUtils.getXlsStorageItemList(this.devNode);
            File storageTxtFile = new File(GrabFileFactory.getInstance().getOfflineTxtPath(currResultList, this.taskName));
            File scriptParent = new File(this.getDeviceDir(currResultList), "xls");
            LOGGER.info("begin to exec extracting script.");
            HashMap<String, Map<String, List<String>>> dataMap = new HashMap<String, Map<String, List<String>>>();
            Map<String, List<String>> storageNameMap = GrabCommonUtils.storageFirstCallScript(xlsItems, storageTxtFile, scriptParent, dataMap, this.devNode);
            XlsClusterItem itemHost = xlsItems.get(2);
            XlsClusterItem itemLun = xlsItems.get(3);
            this.removeHostLunItem(xlsItems);
            List<String> storageList = storageNameMap.get("mapping_view_id");
            List<XlsClusterItem> moreXlsItems = GrabCommonUtils.getMoreXlsItems(itemHost, itemLun, storageList);
            xlsItems.addAll(moreXlsItems);
            Map<String, Map<String, List<String>>> resultMap = GrabCommonUtils.secondCallScript(xlsItems, storageTxtFile, scriptParent, dataMap, this.devNode);
            dataMap.putAll(resultMap);
            this.createStorageExcel(currResultList, xlsItems, dataMap, itemHost, itemLun);
        }
        catch (ToolException | com.huawei.ism.tool.obase.exception.ToolException e) {
            LOGGER.error("create storage xls error.", e);
            return false;
        }
        return true;
    }

    private void removeHostLunItem(List<XlsClusterItem> xlsItems) {
        XlsClusterItem item0 = xlsItems.get(0);
        xlsItems.clear();
        xlsItems.add(item0);
    }

    private File getDeviceDir(List<ExecuteResult> currResultList) {
        return new File(GrabUtil.fixPath(currResultList.get(0).getItem().getScriptPath())).getParentFile();
    }

    private void createStorageExcel(List<ExecuteResult> currResultList, List<XlsClusterItem> xlsItems, Map<String, Map<String, List<String>>> dataMap, XlsClusterItem itemHost, XlsClusterItem itemLun) throws ToolException {
        Map<String, Map<String, List<String>>> dealStorage = HandleStorageXlsData.dealStorageXlsData(dataMap, xlsItems, itemHost, itemLun);
        LOGGER.info("migrateData has analyzed success,ready write data to xls");
        XLSStorageService.getInstance().saveXlsReport(GrabFileFactory.getInstance().getOfflineMigrateXlsFile(currResultList, this.taskName), dealStorage, xlsItems);
    }

    private boolean createGeneralReport(List<ExecuteResult> currComResultList) throws IOException {
        return GrabFileFactory.getInstance().createOfflineGrabFile(currComResultList, this.taskName);
    }

    private boolean handleHostXmlReport(List<ExecuteResult> currResultList, String taskName) {
        List<CollectItem> hostCollection = MigrationParse.getHostCollections(this.devNode.getDeviceName());
        File txtFile = new File(GrabFileFactory.getInstance().getOfflineTxtPath(currResultList, taskName));
        File scriptParentFile = OfflineImportUtils.getOfflineParseScriptParent(currResultList);
        if (!txtFile.exists() || !scriptParentFile.exists()) {
            LOGGER.error("txtFile is not exists.");
            return false;
        }
        Map<String, Object> resultMap = hostCollection.stream().collect(Collectors.toMap(CollectItem::getItemName, collectItem -> this.getDta((CollectItem)collectItem, txtFile, scriptParentFile), (oldData, newData) -> newData));
        return HostDataHandleService.host2XML(currResultList, this.devNode, resultMap, taskName);
    }

    private Object getDta(CollectItem collectItem, File txtFile, File scriptParentFile) {
        String script = collectItem.getScriptName();
        File collectionScript = new File(scriptParentFile, script);
        Map<String, Object> data = GrabCommonUtils.callMigScriptData(collectionScript, txtFile, this.devNode);
        if (null == data) {
            throw new ExcutePyException("excute py error.");
        }
        LOGGER.info("script host file {} exec success.", (Object)script);
        return data.get("data");
    }

    private class HostInfo {
        private String name;
        private String type;
        private String sn;
        private String version;
        private String ip;

        private HostInfo() {
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getSn() {
            return this.sn;
        }

        public String getVersion() {
            return this.version;
        }

        public String getIp() {
            return this.ip;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setSn(String sn) {
            this.sn = sn;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }
    }
}

