/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.intf.worktaker.impl;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabFileFactory;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import org.slf4j.Logger;

public class CopyDirectory {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(GrabFileFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File targetFile) throws IOException {
        FileInputStream input = null;
        BufferedInputStream inBuff = null;
        FileOutputStream output = null;
        BufferedOutputStream outBuff = null;
        try {
            int len;
            input = new FileInputStream(FilePathUtils.checkFile((File)sourceFile));
            inBuff = new BufferedInputStream(input);
            output = new FileOutputStream(FilePathUtils.checkFile((File)targetFile));
            outBuff = new BufferedOutputStream(output);
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                outBuff.write(b, 0, len);
            }
            outBuff.flush();
        }
        catch (IOException e) {
            block5: {
                try {
                    if (!LOGGER.isErrorEnabled()) break block5;
                    LOGGER.error("Error in copy file");
                }
                catch (Throwable throwable) {
                    StreamUtils.closeResource(outBuff, output);
                    StreamUtils.closeResource(null, inBuff);
                    StreamUtils.closeResource(null, (Closeable)input);
                    throw throwable;
                }
            }
            StreamUtils.closeResource(outBuff, output);
            StreamUtils.closeResource(null, (Closeable)inBuff);
            StreamUtils.closeResource(null, (Closeable)input);
            return;
        }
        StreamUtils.closeResource((Flushable)outBuff, (Closeable)output);
        StreamUtils.closeResource(null, (Closeable)inBuff);
        StreamUtils.closeResource(null, (Closeable)input);
    }

    public static void copyDirectiory(String sourceDir, String targetDir) throws IOException {
        File sourceDirFile;
        Object[] file;
        File tatgetFile = ToolUtils.getCanonicalFile(targetDir);
        if (null == tatgetFile) {
            LOGGER.error("get target canonical file error.!!!");
            return;
        }
        if (!tatgetFile.mkdirs()) {
            LOGGER.error("Can not creat the targetDir!!!");
        }
        if (VerifyUtil.isEmpty((Object[])(file = (sourceDirFile = ToolUtils.getCanonicalFile(sourceDir)).listFiles()))) {
            return;
        }
        for (int i = 0; i < file.length; ++i) {
            if (((File)file[i]).isFile()) {
                Object sourceFile = file[i];
                String filePath = null;
                try {
                    filePath = new File(targetDir).getCanonicalPath();
                }
                catch (IOException e) {
                    LOGGER.error("get canonical file path error.");
                    continue;
                }
                File targetFile = new File(filePath + File.separator + ((File)file[i]).getName());
                CopyDirectory.copyFile((File)sourceFile, targetFile);
            }
            if (!((File)file[i]).isDirectory()) continue;
            String dir1 = sourceDir + File.separator + ((File)file[i]).getName();
            String dir2 = targetDir + File.separator + ((File)file[i]).getName();
            CopyDirectory.copyDirectiory(dir1, dir2);
        }
    }
}

