/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.intf.worktaker.impl;

import com.huawei.ism.tool.base.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.DB2DevReportData;
import com.huawei.ism.tool.infograb.entity.DbGrabData;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.entity.SQLExecInfo;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.CopyDirectory;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabFileFactory;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.infograb.report.TemplateFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public final class Db2GrabFileFactory {
    public static final String ENTER = System.getProperty("line.separator");
    public static final String SPACE = " ";
    public static final String TAB = "\t";
    public static final String UNDERLINE = "_";
    private static final Db2GrabFileFactory INSTANCE = new Db2GrabFileFactory();
    private static final String DASHSPERATOR = "--------------------------------------------------\r\n";
    private static final String TXTFILETYPE = ".txt";
    private static final String XLSFILETYPE = ".xls";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(GrabFileFactory.class);
    private static final String DATATYPE = "yyyyMMddHHmmss";
    private static final String STARSPERATOR = "*********^^^^^^^^^^************^^^^^^^^^^*********\r\n";
    private static final String GRABTYPE = "GrabType";
    private static final String HTMLFILETYPE = ".html";
    private static final String GRABNAME = "GrabName";
    private static final String TESTFILENAME = "infograbXXXtempfile";
    private static final String GRABDATE = "GrabDate";
    private static final String REPORT_FILE_DIR = "\\data\\reportcss\\";
    private static final String GRABIP = "GrabIp";
    private List<String> fileHeaderDb = new LinkedList<String>();

    private Db2GrabFileFactory() {
        this.hostHeaderFormat();
    }

    private void hostHeaderFormat() {
        this.fileHeaderDb.add(STARSPERATOR);
        this.fileHeaderDb.add(this.polishString(ResourceUtil.getString((String)"infograb.result.txt.infograb"), 15, false));
        this.fileHeaderDb.add(System.lineSeparator());
        this.fileHeaderDb.add(this.polishString(ResourceUtil.getString((String)"infograb.result.txt.devtype"), 15, false) + ":\t\tGrabType");
        this.fileHeaderDb.add(System.lineSeparator());
        this.fileHeaderDb.add(this.polishString(ResourceUtil.getString((String)"infograb.result.txt.ostype"), 15, false) + ":\t\tGrabName");
        this.fileHeaderDb.add(System.lineSeparator());
        this.fileHeaderDb.add(this.polishString(ResourceUtil.getString((String)"infograb.result.txt.ip"), 17, false) + ":\t\tGrabIp");
        this.fileHeaderDb.add(System.lineSeparator());
        this.fileHeaderDb.add(this.polishString(ResourceUtil.getString((String)"infograb.result.txt.date"), 17, false) + ":\t\tGrabDate");
        this.fileHeaderDb.add(System.lineSeparator());
        this.fileHeaderDb.add(STARSPERATOR);
        this.fileHeaderDb.add(DASHSPERATOR);
        this.fileHeaderDb.add(DASHSPERATOR);
    }

    public String polishString(String val, int num, boolean location) {
        StringBuilder str = new StringBuilder(val);
        while (str.length() < num) {
            int locat = location ? 0 : str.length();
            str.insert(locat, SPACE);
        }
        return str.toString();
    }

    public static Db2GrabFileFactory getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCheckResultFolder() {
        String tempPath = InfoGrabDirPropertiesUtil.getProperty();
        File resultFolderFile = new File(tempPath + File.separator + TESTFILENAME);
        try {
            if (!resultFolderFile.createNewFile()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Can not have the W/R rights in result folder");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (!resultFolderFile.delete() && LOGGER.isErrorEnabled()) {
                LOGGER.error("Can not have the W/R rights in result folder");
            }
        }
    }

    public boolean checkDiskCapactity(long collectionInfoapacty) {
        String tempDbPath = InfoGrabDirPropertiesUtil.getProperty();
        String[] diskPathArray = tempDbPath.split(":");
        String diskPath = diskPathArray[0];
        File diskFile = new File(diskPath + ":" + File.separator);
        long freeCapacty = diskFile.getFreeSpace();
        return freeCapacty > collectionInfoapacty;
    }

    public boolean createGrabFile(List<ExecuteResult> currResultList, List<DbGrabData> currDbResultList) {
        boolean ret = true;
        if (!this.createTxtFile(currResultList, currDbResultList)) {
            LOGGER.error("Create TXT file failed!");
            ret = false;
        }
        if (!this.createReportFile(currResultList, currDbResultList)) {
            LOGGER.error("Create report file failed!");
            ret = false;
        }
        return ret;
    }

    public boolean createReportFile(List<ExecuteResult> currResultList, List<DbGrabData> currDbResultList) {
        if (currResultList == null) {
            return false;
        }
        ExecuteResult currExecutreRes = currResultList.get(0);
        GrabDevNode2 currNode = currExecutreRes.getDevNode();
        RealTimeTask collectTask = (RealTimeTask)GrabContext.getInstance().getTaskMap().get((Object)currNode);
        String dateEnd = new SimpleDateFormat(DATATYPE).format(currExecutreRes.getExecuteEndTime());
        DB2DevReportData devReportData = new DB2DevReportData(currResultList, currDbResultList);
        String taskDirName = collectTask.getTaskDirName();
        String devDirName = this.createFileName(currNode, dateEnd, "");
        String fileName = this.createFileName(currNode, dateEnd, HTMLFILETYPE);
        StringBuilder fileStrBuilder = new StringBuilder();
        fileStrBuilder.append(InfoGrabDirPropertiesUtil.getProperty()).append(File.separator).append(taskDirName).append(File.separator).append(devDirName);
        if (!this.createDir(new File(fileStrBuilder.toString()))) {
            return false;
        }
        if (!this.copyCss(System.getProperty("user.dir") + REPORT_FILE_DIR, fileStrBuilder.toString())) {
            return false;
        }
        StringBuilder pro = new StringBuilder();
        pro.append(fileStrBuilder.toString()).append(File.separator).append("html");
        boolean fatherDbHtml = TemplateFactory.processorFtl("father.html", devReportData.getReportMap(), fileStrBuilder.toString() + File.separator + fileName);
        boolean leftDbHtml = TemplateFactory.processorFtl("left.html", devReportData.getReportMap(), pro.toString() + File.separator + "left.html");
        boolean rightDbHtml = TemplateFactory.processorFtl("right.html", devReportData.getReportMap(), pro.toString() + File.separator + "right.html");
        boolean topDbHtml = TemplateFactory.processorFtl("top.html", devReportData.getReportMap(), pro.toString() + File.separator + "top.html");
        return fatherDbHtml && leftDbHtml && rightDbHtml && topDbHtml;
    }

    public File getTxtFile(List<ExecuteResult> currResultList) {
        return this.getFile(currResultList, TXTFILETYPE);
    }

    private File getFile(List<ExecuteResult> currResultList, String fileType) {
        ExecuteResult currExecutreResList = currResultList.get(0);
        GrabDevNode2 currNode = currExecutreResList.getDevNode();
        RealTimeTask collectTask = (RealTimeTask)GrabContext.getInstance().getTaskMap().get((Object)currNode);
        String dateEnd = new SimpleDateFormat(DATATYPE).format(currExecutreResList.getExecuteEndTime());
        String taskDirDbName = collectTask.getTaskDirName();
        String devDirDbName = this.createFileName(currNode, dateEnd, "");
        String fileDbName = this.createFileName(currNode, dateEnd, fileType);
        StringBuilder fileStringBuilder = new StringBuilder();
        fileStringBuilder.append(InfoGrabDirPropertiesUtil.getProperty()).append(File.separator).append(taskDirDbName).append(File.separator).append(devDirDbName);
        fileStringBuilder.append(File.separator).append(fileDbName);
        return new File(fileStringBuilder.toString());
    }

    public File getXlsFile(List<ExecuteResult> currResultList) {
        return this.getFile(currResultList, XLSFILETYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createTxtFile(List<ExecuteResult> currResultList, List<DbGrabData> currDbResultList) {
        FileOutputStream outStream = null;
        BufferedOutputStream buff = null;
        if (currResultList == null) {
            return false;
        }
        ExecuteResult currExecutreResList = currResultList.get(0);
        GrabDevNode2 currNode = currExecutreResList.getDevNode();
        RealTimeTask collectTask = (RealTimeTask)GrabContext.getInstance().getTaskMap().get((Object)currNode);
        String dateEnd = new SimpleDateFormat(DATATYPE).format(currExecutreResList.getExecuteEndTime());
        String pyExeStartTime = currExecutreResList.getExecuteStartTimeString();
        try {
            String taskDirDbName = collectTask.getTaskDirName();
            String devDirDbName = this.createFileName(currNode, dateEnd, "");
            String fileDbName = this.createFileName(currNode, dateEnd, TXTFILETYPE);
            StringBuilder fileStrBuilder = new StringBuilder();
            fileStrBuilder.append(InfoGrabDirPropertiesUtil.getProperty()).append(File.separator).append(taskDirDbName).append(File.separator).append(devDirDbName);
            if (!this.createDir(new File(fileStrBuilder.toString()))) {
                boolean bl = false;
                return bl;
            }
            fileStrBuilder.append(File.separator).append(fileDbName);
            File resultFile = new File(fileStrBuilder.toString());
            if (!resultFile.createNewFile()) {
                boolean bl = false;
                return bl;
            }
            outStream = new FileOutputStream(resultFile);
            buff = new BufferedOutputStream(outStream);
            this.writeFileHeader(buff, currNode, pyExeStartTime);
            this.writeFileDetails(buff, currDbResultList);
            boolean bl = true;
            this.checkIoException(outStream, buff);
            return bl;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("File Not found.");
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("create Grab details file error");
            boolean bl = false;
            return bl;
        }
        finally {
            this.checkIoException(outStream, buff);
        }
    }

    void checkIoException(FileOutputStream outStream, BufferedOutputStream buff) {
        block4: {
            try {
                if (buff != null) {
                    buff.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                if (!LOGGER.isErrorEnabled()) break block4;
                LOGGER.error("close Grab details file error", (Throwable)e);
            }
        }
    }

    private boolean createDir(File fileDir) {
        return fileDir.exists() || fileDir.mkdirs();
    }

    private boolean copyCss(String sourceDirStr, String targetDir) {
        try {
            CopyDirectory.copyDirectiory(sourceDirStr, targetDir);
        }
        catch (IOException e) {
            LOGGER.error("copy css files failed.");
            return false;
        }
        return true;
    }

    private void writeFileDetails(BufferedOutputStream buff, List<DbGrabData> currDbResultList) throws IOException {
        for (DbGrabData dataDbObj : currDbResultList) {
            buff.write((dataDbObj.getSqlDesc() + ENTER).getBytes("UTF-8"));
            buff.write(DASHSPERATOR.getBytes("UTF-8"));
            this.writeSinglePyDetails(buff, dataDbObj);
        }
    }

    private void writeSinglePyDetails(BufferedOutputStream buff, DbGrabData dataObj) throws IOException {
        KeyOrderedHashMap<SQLExecInfo, String> map = dataObj.getTxtResultMap();
        for (Map.Entry<SQLExecInfo, String> entry : map.entrySet()) {
            this.writeEntryToFile(buff, entry);
            buff.write(STARSPERATOR.getBytes("UTF-8"));
        }
    }

    private void writeEntryToFile(BufferedOutputStream buff, Map.Entry<SQLExecInfo, String> entry) throws IOException {
        buff.write(entry.getKey().getSqlName().getBytes("UTF-8"));
        buff.write(ENTER.getBytes("UTF-8"));
        buff.write(entry.getValue().getBytes("UTF-8"));
    }

    private void writeFileHeader(BufferedOutputStream buff, GrabDevNode2 devNode, String startDate) throws IOException {
        for (String string : this.fileHeaderDb) {
            buff.write(this.fixHeaderPara(string, devNode, startDate).getBytes("UTF-8"));
        }
    }

    private String fixHeaderPara(String currHeaderStr, GrabDevNode2 devNode, String date) {
        if (currHeaderStr.contains(GRABTYPE)) {
            return StringUtils.replace((String)currHeaderStr, (String)GRABTYPE, (String)devNode.getItDeviceType().toString());
        }
        if (currHeaderStr.contains(GRABNAME)) {
            return StringUtils.replace((String)currHeaderStr, (String)GRABNAME, (String)devNode.getDeviceName());
        }
        if (currHeaderStr.contains(GRABIP)) {
            return StringUtils.replace((String)currHeaderStr, (String)GRABIP, (String)devNode.getIp());
        }
        if (currHeaderStr.contains(GRABDATE)) {
            return StringUtils.replace((String)currHeaderStr, (String)GRABDATE, (String)date);
        }
        return currHeaderStr;
    }

    private String createFileName(GrabDevNode2 currNode, String dateEnd, String fileType) {
        StringBuilder strBuil = new StringBuilder(currNode.getDeviceName());
        strBuil.append(UNDERLINE);
        strBuil.append(currNode.getIp());
        strBuil.append(UNDERLINE);
        strBuil.append(dateEnd);
        strBuil.append(fileType);
        return strBuil.toString();
    }
}

