/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.intf.worktaker.impl;

import com.google.common.base.Strings;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.context.ItemEvalResult;
import com.huawei.ism.tool.infograb.entity.DBCmdResultSet;
import com.huawei.ism.tool.infograb.entity.DevReportData;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.grab.FilterDataLinkedHashMap;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.CopyDirectory;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.infograb.report.TemplateFactory;
import com.huawei.ism.tool.infograb.utils.ExportFileUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrabFileFactory {
    private static final Logger log = LoggerFactory.getLogger(GrabFileFactory.class);
    public static final String EVAL_FILENAME_SUFFIX = "_foreEval.txt";
    public static final String TXTFILETYPE = ".txt";
    public static final String XLSFILETYPE = ".xls";
    public static final String XMLFILETYPE = ".xml";
    public static final String ENTER = System.getProperty("line.separator");
    public static final String UPPER = ">";
    public static final String LOWER = "<";
    public static final String SPACE = " ";
    public static final String UNDERLINE = "_";
    public static final String STARSPERATOR = "*********^^^^^^^^^^************^^^^^^^^^^*********\r\n";
    private static final GrabFileFactory INSTANCE = new GrabFileFactory();
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(GrabFileFactory.class);
    private static final String DATATYPE = "yyyyMMddHHmmss";
    private static final String DASHSPERATOR = "--------------------------------------------------\r\n";
    private static final String HTMLFILETYPE = ".html";
    private static final String GRABTYPE = "GrabType";
    private static final String GRABNAME = "GrabName";
    private static final String GRABIP = "GrabIp";
    private static final String GRABDATE = "GrabDate";
    private static final String TESTFILENAME = "infograbXXXtempfile";
    private static final String SPLITDATALABEL = "|";
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private static final String REPORT_FILE_DIR = "\\data\\reportcss\\";
    private List<String> fileHeader = new LinkedList<String>();

    private GrabFileFactory() {
        this.hostHeaderFormat();
    }

    private void hostHeaderFormat() {
        this.fileHeader.add(STARSPERATOR);
        this.fileHeader.add(this.polishString(ResourceUtil.getString((String)"infograb.result.txt.infograb"), 15, false));
        this.fileHeader.add(System.lineSeparator());
        this.fileHeader.add(this.polishString(ResourceUtil.getString((String)"infograb.result.txt.devtype"), 15, false) + ":\t\tGrabType");
        this.fileHeader.add(System.lineSeparator());
        this.fileHeader.add(this.polishString(ResourceUtil.getString((String)"infograb.result.txt.ostype"), 15, false) + ":\t\tGrabName");
        this.fileHeader.add(System.lineSeparator());
        this.fileHeader.add(this.polishString(ResourceUtil.getString((String)"infograb.result.txt.ip"), 17, false) + ":\t\tGrabIp");
        this.fileHeader.add(System.lineSeparator());
        this.fileHeader.add(this.polishString(ResourceUtil.getString((String)"infograb.result.txt.date"), 17, false) + ":\t\tGrabDate");
        this.fileHeader.add(System.lineSeparator());
        this.fileHeader.add(STARSPERATOR);
        this.fileHeader.add(DASHSPERATOR);
        this.fileHeader.add(DASHSPERATOR);
    }

    public String polishString(String val, int num, boolean location) {
        StringBuilder str = new StringBuilder(val);
        while (str.length() < num) {
            int locat = location ? 0 : str.length();
            str.insert(locat, SPACE);
        }
        return str.toString();
    }

    public static GrabFileFactory getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preCheckResultFolder() {
        String tempPath = InfoGrabDirPropertiesUtil.getProperty();
        File resultFolder = new File(tempPath + File.separator + TESTFILENAME);
        try {
            if (!resultFolder.createNewFile()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Can not have the W/R rights in result folder");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (!resultFolder.delete() && LOGGER.isErrorEnabled()) {
                LOGGER.error("Can not have the W/R rights in result folder");
            }
        }
    }

    public boolean checkDiskCapactity(long collectionInfoapacty) {
        long freeCapacty;
        String tempPath = InfoGrabDirPropertiesUtil.getProperty();
        String[] diskPathArray = tempPath.split(":");
        String diskPath = diskPathArray[0];
        File diskFile = new File(diskPath + ":" + File.separator);
        if (!diskFile.isFile()) {
            try {
                Files.createDirectories(diskFile.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                log.warn("failed creat result dir for :{}", (Object)diskFile.toPath());
            }
        }
        return (freeCapacty = diskFile.getFreeSpace()) > collectionInfoapacty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createGrabFile(List<ExecuteResult> currResultList) {
        boolean ret = true;
        try {
            if (!this.createTxtFile(currResultList)) {
                LOGGER.error("Create TXT file failed!");
                ret = false;
            }
            if (!this.createReportFile(currResultList)) {
                LOGGER.error("Create report file failed!");
                ret = false;
            }
        }
        catch (IOException e) {
            LOGGER.info("Create grab file failed..", (Throwable)e);
        }
        finally {
            this.clearTemptFile(currResultList);
        }
        return ret;
    }

    private void clearTemptFile(List<ExecuteResult> currResultList) {
        LOGGER.info("***[starting execute clearTemptFile]***");
        for (ExecuteResult executeResult : currResultList) {
            ((FilterDataLinkedHashMap)executeResult.getResultMap()).delteteFile();
        }
    }

    public boolean createReportFile(List<ExecuteResult> currResultList) throws IOException {
        if (currResultList == null) {
            return false;
        }
        ExecuteResult currExecutreRes = currResultList.get(0);
        GrabDevNode2 currNode = currExecutreRes.getDevNode();
        RealTimeTask collectTask = (RealTimeTask)GrabContext.getInstance().getTaskMap().get((Object)currNode);
        String dateEnd = new SimpleDateFormat(DATATYPE).format(currExecutreRes.getExecuteEndTime());
        DevReportData devReportData = new DevReportData(currResultList);
        String taskDirName = collectTask.getTaskDirName();
        String devDirName = this.createFileName(currNode, dateEnd, "");
        String fileName = this.createFileName(currNode, dateEnd, HTMLFILETYPE);
        StringBuilder fileStringBuilder = new StringBuilder();
        fileStringBuilder.append(InfoGrabDirPropertiesUtil.getProperty()).append(File.separator).append(taskDirName).append(File.separator).append(devDirName);
        if (!this.createDir(new File(fileStringBuilder.toString()))) {
            return false;
        }
        if (!this.copyCss(System.getProperty("user.dir") + REPORT_FILE_DIR, fileStringBuilder.toString())) {
            return false;
        }
        StringBuilder pro = new StringBuilder();
        pro.append(fileStringBuilder.toString()).append(File.separator).append("html");
        boolean fatherHtml = TemplateFactory.processorFtl("father.html", devReportData.getReportMap(), fileStringBuilder.toString() + File.separator + fileName);
        boolean leftHtml = TemplateFactory.processorFtl("left.html", devReportData.getReportMap(), pro.toString() + File.separator + "left.html");
        boolean reightHtml = TemplateFactory.processorFtl("right.html", devReportData.getReportMap(), pro.toString() + File.separator + "right.html");
        boolean topHtml = TemplateFactory.processorFtl("top.html", devReportData.getReportMap(), pro.toString() + File.separator + "top.html");
        return fatherHtml && leftHtml && reightHtml && topHtml;
    }

    public File getTxtFile(List<ExecuteResult> currResultList) {
        return this.getFile(currResultList, TXTFILETYPE);
    }

    public File getXmlFile(List<ExecuteResult> currResultList) {
        return this.getFile(currResultList, XMLFILETYPE);
    }

    private File getFile(List<ExecuteResult> currResultList, String fileType) {
        ExecuteResult currExecutreRes = currResultList.get(0);
        GrabDevNode2 currNode = currExecutreRes.getDevNode();
        RealTimeTask collectTask = (RealTimeTask)GrabContext.getInstance().getTaskMap().get((Object)currNode);
        String dateEnd = new SimpleDateFormat(DATATYPE).format((Date)ObjectUtils.defaultIfNull((Object)currExecutreRes.getExecuteEndTime(), (Object)currExecutreRes.getExecuteStartTime()));
        String devDirName = this.createFileName(currNode, dateEnd, "");
        String fileName = this.createFileName(currNode, dateEnd, fileType);
        StringBuilder fileStringBuilder = this.getTaskBasePath(collectTask);
        fileStringBuilder.append(devDirName);
        fileStringBuilder.append(File.separator).append(fileName);
        return new File(fileStringBuilder.toString());
    }

    public StringBuilder getTaskBasePath(RealTimeTask collectTask) {
        StringBuilder fileStringBuilder = new StringBuilder();
        fileStringBuilder.append(InfoGrabDirPropertiesUtil.getProperty()).append(File.separator).append(collectTask.getTaskDirName()).append(File.separator);
        return fileStringBuilder;
    }

    public File getXlsFile(List<ExecuteResult> currResultList) {
        return this.getFile(currResultList, XLSFILETYPE);
    }

    public File getMigrateXlsFile(List<ExecuteResult> currResultList, String typeName) {
        return this.getMigrateFile(currResultList, XLSFILETYPE, typeName);
    }

    private File getMigrateFile(List<ExecuteResult> currResultList, String fileType, String typeName) {
        ExecuteResult currExecutreRes = currResultList.get(0);
        GrabDevNode2 currNode = currExecutreRes.getDevNode();
        RealTimeTask collectTask = (RealTimeTask)GrabContext.getInstance().getTaskMap().get((Object)currNode);
        String dateEnd = new SimpleDateFormat(DATATYPE).format(currExecutreRes.getExecuteEndTime());
        String taskDirName = collectTask.getTaskDirName();
        String devDirName = this.createFileName(currNode, dateEnd, "");
        String fileName = this.createFileName(currNode, dateEnd, fileType);
        fileName = fileName.replaceAll(currNode.getDeviceName(), typeName + UNDERLINE + currNode.getDeviceName());
        StringBuilder fileStringBuilder = new StringBuilder();
        fileStringBuilder.append(InfoGrabDirPropertiesUtil.getProperty()).append(File.separator).append(taskDirName).append(File.separator).append(devDirName);
        fileStringBuilder.append(File.separator).append(fileName);
        LOGGER.info("getMigrateFile Err");
        return new File(fileStringBuilder.toString());
    }

    public boolean createTxtFile(List<ExecuteResult> currResultList) throws IOException {
        if (currResultList == null) {
            return false;
        }
        ExecuteResult currExecutreRes = currResultList.get(0);
        GrabDevNode2 currNode = currExecutreRes.getDevNode();
        RealTimeTask collectTask = (RealTimeTask)GrabContext.getInstance().getTaskMap().get((Object)currNode);
        String dateEnd = new SimpleDateFormat(DATATYPE).format(currExecutreRes.getExecuteEndTime());
        String pyExeStartTime = currExecutreRes.getExecuteStartTimeString();
        return this.checkCollectTask(currResultList, currNode, collectTask, dateEnd, pyExeStartTime);
    }

    boolean checkCollectTask(List<ExecuteResult> currResultList, GrabDevNode2 currNode, RealTimeTask collectTask, String dateEnd, String pyExeStartTime) throws IOException {
        String taskDirName = collectTask.getTaskDirName();
        String devDirName = this.createFileName(currNode, dateEnd, "");
        String fileName = this.createFileName(currNode, dateEnd, TXTFILETYPE);
        StringBuilder fileStringBuilder = new StringBuilder();
        fileStringBuilder.append(InfoGrabDirPropertiesUtil.getProperty()).append(File.separator).append(taskDirName).append(File.separator).append(devDirName);
        if (!this.createDir(new File(fileStringBuilder.toString()))) {
            return false;
        }
        fileStringBuilder.append(File.separator).append(fileName);
        String evalName = fileStringBuilder.toString().replace(TXTFILETYPE, EVAL_FILENAME_SUFFIX);
        File generalTxtFile = FileUtils.getFile((String[])new String[]{fileStringBuilder.toString()});
        File evalTxtFile = FileUtils.getFile((String[])new String[]{evalName});
        return this.createGeneralTxt(generalTxtFile, currNode, currResultList, pyExeStartTime) && this.createEvalTxt(evalTxtFile, currNode, currResultList);
    }

    /*
     * Exception decompiling
     */
    private boolean createEvalTxt(File evalTxtFile, GrabDevNode2 currNode, List<ExecuteResult> currResultList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private boolean createGeneralTxt(File generalTxtFile, GrabDevNode2 currNode, List<ExecuteResult> currResultList, String pyExeStartTime) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean createDir(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            return false;
        }
        LOGGER.info("create the dir success, the path of dir is:{}", (Object)StringUtils.getCleanMessage((String)dir.getCanonicalPath()));
        return true;
    }

    private boolean copyCss(String sourceDir, String targetDir) {
        try {
            CopyDirectory.copyDirectiory(sourceDir, targetDir);
        }
        catch (IOException e) {
            LOGGER.error("copyCss error!");
            return false;
        }
        return true;
    }

    private void writeFileDetails(BufferedOutputStream buff, List<ExecuteResult> currResultList) throws IOException {
        this.writeFileDetails(buff, currResultList, false);
    }

    private void writeFileDetails(BufferedOutputStream buff, List<ExecuteResult> currResultList, boolean writeForEval) throws IOException {
        for (ExecuteResult exeResult : currResultList) {
            buff.write((exeResult.getDescription() + ENTER).getBytes("UTF-8"));
            buff.write(DASHSPERATOR.getBytes("UTF-8"));
            if (writeForEval) {
                this.writeSinglePyDetailsForEval(buff, exeResult);
                continue;
            }
            this.writeSinglePyDetails(buff, exeResult);
        }
        buff.flush();
    }

    private void writeSinglePyDetails(BufferedOutputStream buff, ExecuteResult exeResult) throws IOException {
        Map<String, Object> pyDetailMap = exeResult.getResultMap();
        Object errMsgObj = pyDetailMap.get("err_msg");
        String errMsg = "";
        if (null != errMsgObj) {
            errMsg = errMsgObj.toString();
        }
        for (Map.Entry<String, Object> entry : pyDetailMap.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase("err_msg")) {
                this.writeEntryToFile(buff, entry, errMsg, pyDetailMap);
                buff.write(STARSPERATOR.getBytes("UTF-8"));
            }
            buff.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSinglePyDetailsForEval(BufferedOutputStream buff, ExecuteResult exeResult) throws IOException {
        Map<String, Object> pyDetailMap = exeResult.getResultMap();
        for (Map.Entry<String, Object> entry : pyDetailMap.entrySet()) {
            String key = entry.getKey();
            if ("evalResult".equals(entry.getKey()) && null != entry.getValue()) {
                ItemEvalResult ier = (ItemEvalResult)entry.getValue();
                buff.write(ier.getEvalResultJsonString().getBytes("UTF-8"));
            }
            if (!ExportFileUtil.isCliKeyToBeEval(key)) continue;
            Object formerVal = entry.getValue();
            Object reportKeyVal = pyDetailMap.get(key);
            Object realVal = pyDetailMap.get(reportKeyVal);
            entry.setValue(realVal != null ? realVal : formerVal);
            try {
                this.writeEntryToFile(buff, entry, "", pyDetailMap);
            }
            finally {
                entry.setValue(formerVal);
            }
            buff.write(STARSPERATOR.getBytes("UTF-8"));
        }
        buff.flush();
    }

    private void writeEntryToFile(BufferedOutputStream buff, Map.Entry<String, Object> entry, String errMsg, Map<String, Object> pyDetailMap) throws IOException {
        buff.write((entry.getKey() + ENTER).getBytes("UTF-8"));
        if (entry.getValue() instanceof String) {
            if (entry.getValue().equals(FilterDataLinkedHashMap.getReadFromTemp())) {
                String data = (String)((FilterDataLinkedHashMap)pyDetailMap).get(entry.getKey());
                buff.write((data + ENTER).getBytes("UTF-8"));
            } else {
                buff.write((entry.getValue() + ENTER).getBytes("UTF-8"));
            }
        } else if (entry.getValue() instanceof DBCmdResultSet) {
            DBCmdResultSet tableResult = (DBCmdResultSet)entry.getValue();
            if (tableResult.getSqlResult() == null || tableResult.getSqlResult() instanceof ResultSet) {
                buff.write(tableResult.getSqlName().getBytes("UTF-8"));
                buff.write(ENTER.getBytes("UTF-8"));
                buff.write(this.parseResultsetToStr(tableResult, errMsg).getBytes("UTF-8"));
            } else if (tableResult.getSqlResult() instanceof String) {
                buff.write(((String)tableResult.getSqlResult()).getBytes("UTF-8"));
            }
        }
    }

    private String parseResultsetToStr(DBCmdResultSet dbCmdResultSet, String errMsg) {
        ResultSet resultSet = (ResultSet)dbCmdResultSet.getSqlResult();
        if (resultSet == null) {
            String[] errMsgs;
            String sqlName = dbCmdResultSet.getSqlName();
            for (String msg : errMsgs = errMsg.split("\r\n")) {
                if (!msg.contains(sqlName) || !msg.contains(ResourceUtil.getString((String)"infograb.dev.status.noecollect"))) continue;
                return ResourceUtil.getString((String)"infograb.execute.cmd.error127&128&others") + ENTER;
            }
            return ResourceUtil.getString((String)"infograb.execute.cmd.failed.timeout") + ENTER;
        }
        StringBuilder sbStr = new StringBuilder();
        try {
            resultSet.beforeFirst();
            LinkedList<String> columeName = new LinkedList<String>();
            ResultSetMetaData rsmd = resultSet.getMetaData();
            int count = rsmd.getColumnCount();
            sbStr.append("DataBase Column Name : ");
            for (int i = 1; i <= count; ++i) {
                String columnStr = rsmd.getColumnLabel(i);
                columeName.add(columnStr);
                sbStr.append(LEFT_BRACKET);
                sbStr.append(columnStr);
                sbStr.append(RIGHT_BRACKET);
            }
            sbStr.append(ENTER);
            while (resultSet.next()) {
                for (String name : columeName) {
                    sbStr.append(resultSet.getString(name)).append(SPLITDATALABEL);
                }
                sbStr.append(ENTER);
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error happened in parseResultsetToStr");
        }
        return sbStr.toString();
    }

    private void writeFileHeader(BufferedOutputStream buff, GrabDevNode2 devNode, String startDate) throws IOException {
        for (String str : this.fileHeader) {
            buff.write(this.fixHeaderPara(str, devNode, startDate).getBytes("UTF-8"));
        }
        buff.flush();
    }

    private String fixHeaderPara(String currHeader, GrabDevNode2 devNode, String date) {
        if (currHeader.contains(GRABTYPE)) {
            return org.apache.commons.lang3.StringUtils.replace((String)currHeader, (String)GRABTYPE, (String)devNode.getItDeviceType().toString());
        }
        if (currHeader.contains(GRABNAME)) {
            return org.apache.commons.lang3.StringUtils.replace((String)currHeader, (String)GRABNAME, (String)devNode.getDeviceName());
        }
        if (currHeader.contains(GRABIP)) {
            return org.apache.commons.lang3.StringUtils.replace((String)currHeader, (String)GRABIP, (String)devNode.getIp());
        }
        if (currHeader.contains(GRABDATE)) {
            return org.apache.commons.lang3.StringUtils.replace((String)currHeader, (String)GRABDATE, (String)date);
        }
        return currHeader;
    }

    private String createFileName(GrabDevNode2 currNode, String dateEnd, String fileType) {
        String deviceName = currNode.getDeviceName();
        StringBuilder sb = new StringBuilder(deviceName == null ? "" : deviceName);
        sb.append(UNDERLINE);
        sb.append(currNode.getIp().replaceAll(":", UNDERLINE));
        sb.append(UNDERLINE);
        sb.append(dateEnd);
        sb.append(fileType);
        return sb.toString();
    }

    public boolean createOfflineGrabFile(List<ExecuteResult> currResultList, String taskName) throws IOException {
        boolean ret = true;
        if (!this.createOfflineTxtFile(currResultList, taskName)) {
            LOGGER.error("TaskName {}, create TXT file failed!", (Object)taskName);
            ret = false;
        }
        if (!this.createOfflineReportFile(currResultList, taskName)) {
            LOGGER.error("TaskName {}, create report file failed!", (Object)taskName);
            ret = false;
        }
        this.clearTemptFile(currResultList);
        return ret;
    }

    public boolean createOfflineReportFile(List<ExecuteResult> currResultList, String taskName) throws IOException {
        if (currResultList == null) {
            return false;
        }
        String offlineDevPath = this.getOfflineDevPath(currResultList, taskName).toString();
        if (!this.copyFiles(offlineDevPath)) {
            return false;
        }
        return this.createHtmls(currResultList, offlineDevPath);
    }

    private boolean createHtmls(List<ExecuteResult> currResultList, String offlineDevPath) {
        DevReportData devReportData = new DevReportData(currResultList);
        String pro = offlineDevPath + File.separator + "html";
        String fileName = this.getOfflineFlieName(currResultList, HTMLFILETYPE);
        return this.createFatherHtml(devReportData, offlineDevPath, fileName) && this.createLeftHtml(devReportData, pro) && this.createRightHtml(devReportData, pro) && this.createTopHtml(devReportData, pro);
    }

    private boolean createTopHtml(DevReportData devReportData, String pro) {
        return TemplateFactory.processorFtl("top.html", devReportData.getReportMap(), pro + File.separator + "top.html");
    }

    private boolean createRightHtml(DevReportData devReportData, String pro) {
        return TemplateFactory.processorFtl("right.html", devReportData.getReportMap(), pro + File.separator + "right.html");
    }

    private boolean createLeftHtml(DevReportData devReportData, String pro) {
        return TemplateFactory.processorFtl("left.html", devReportData.getReportMap(), pro + File.separator + "left.html");
    }

    private boolean createFatherHtml(DevReportData devReportData, String offlineDevPath, String fileName) {
        return TemplateFactory.processorFtl("father.html", devReportData.getReportMap(), offlineDevPath + File.separator + fileName);
    }

    private boolean copyFiles(String offlineDevPath) throws IOException {
        if (!this.createDir(new File(offlineDevPath))) {
            return false;
        }
        return this.copyCss(System.getProperty("user.dir") + REPORT_FILE_DIR, offlineDevPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createOfflineTxtFile(List<ExecuteResult> currResultList, String taskName) {
        boolean bl;
        FileOutputStream outStream = null;
        BufferedOutputStream buff = null;
        try {
            String offlineDevPath = this.getOfflineDevPath(currResultList, taskName);
            if (!this.createDir(new File(offlineDevPath))) {
                boolean bl2 = false;
                return bl2;
            }
            File resultFile = new File(this.getOfflineTxtPath(currResultList, taskName));
            if (!resultFile.createNewFile()) {
                boolean bl3 = false;
                return bl3;
            }
            outStream = new FileOutputStream(resultFile, true);
            buff = new BufferedOutputStream(outStream);
            this.writeFileHeader(buff, currResultList.get(0).getDevNode(), currResultList.get(0).getExecuteStartTimeString());
            this.writeFileDetails(buff, currResultList);
            bl = true;
            StreamUtils.closeResource(null, (Closeable)outStream);
        }
        catch (IOException e) {
            LOGGER.error("Error in create Grab details file", (Throwable)e);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            StreamUtils.closeResource(null, outStream);
            StreamUtils.closeResource(null, buff);
        }
        StreamUtils.closeResource(null, (Closeable)buff);
        return bl;
    }

    public String getOfflineTaskPath(String taskName) {
        return InfoGrabDirPropertiesUtil.getProperty() + File.separator + taskName;
    }

    public String getOfflineDevPath(List<ExecuteResult> currResultList, String taskName) {
        return this.getOfflineTaskPath(taskName) + File.separator + this.getOfflineFlieName(currResultList, "");
    }

    public String getOfflineFlieName(List<ExecuteResult> currResultList, String fileType) {
        ExecuteResult currExecutreRes = currResultList.get(0);
        GrabDevNode2 currNode = currExecutreRes.getDevNode();
        String dateEnd = new SimpleDateFormat(DATATYPE).format(currExecutreRes.getExecuteEndTime());
        String fileName = this.createFileName(currNode, dateEnd, fileType);
        if (!Strings.isNullOrEmpty((String)fileType) && ItDeviceType.Storage.equals((Object)currNode.getItDeviceType())) {
            return ItDeviceType.Storage.getName() + UNDERLINE + fileName;
        }
        return fileName;
    }

    public String getOfflineTxtPath(List<ExecuteResult> currResultList, String taskName) {
        return this.getOfflineDevPath(currResultList, taskName) + File.separator + this.getOfflineFlieName(currResultList, TXTFILETYPE);
    }

    public String getOfflineXlsPath(String taskName) {
        String timeStamp = new SimpleDateFormat(DATATYPE).format(new Date());
        return this.getOfflineTaskPath(taskName) + File.separator + "Summary_" + timeStamp + XLSFILETYPE;
    }

    public String getOfflineXmlPath(List<ExecuteResult> currResultList, String taskName) {
        return this.getOfflineDevPath(currResultList, taskName) + File.separator + this.getOfflineFlieName(currResultList, XMLFILETYPE);
    }

    public File getOfflineMigrateXlsFile(List<ExecuteResult> currResultList, String taskName) {
        return new File(this.getOfflineDevPath(currResultList, taskName) + File.separator + this.getOfflineFlieName(currResultList, XLSFILETYPE));
    }
}

