/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.intf.worktaker.impl;

import com.huawei.ism.tool.base.utils.PatchUtil;
import com.huawei.ism.tool.base.utils.RSAUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SHA256Check;
import com.huawei.ism.tool.base.utils.SHAAndRSAVerifyUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.TooliniParser;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.DbGrabData;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.Item;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.infograb.ui.InfoGrabMainFrame;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PublicKey;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

public abstract class GrabUtil {
    public static final String ENTER = System.getProperty("line.separator");
    public static final String HTML_SPACE = "&nbsp;";
    public static final String HTML_ENTER = "<br>";
    public static final String HTML_STRING_FORMAT_START_2 = "<p class=\"fonts\" style=\"padding-left:5px;white-space:nowrap;\">";
    public static final String HTML_STRING_FORMAT_START_1 = "<div class=\"padds\"><div class=\"tables\" style=\"border:1px solid black;\">";
    public static final String HTML_TABLE_ALIGN_START = "<div class=\"padds\">";
    public static final String HTML_STRING_FORMAT_END = "</p></div></div>";
    public static final String HTML_TABLE_SCROLL_START = "<div class=\"tables\">";
    public static final String HTML_TABLE_ALIGN_END = "</div>";
    public static final String HTML_TABLE_SIZE_START = "<table align=left width=100% class='hovertable'>";
    public static final String HTML_TABLE_SCROLL_END = "</div>";
    public static final String HTML_TABLE_ROW_START_1 = "<tr>";
    public static final String HTML_TABLE_SIZE_END = "</table>";
    public static final String HTML_TABLE_ROW_START_2 = "<tr onmouseover=\"this.style.backgroundColor='#ffff66';\" ";
    public static final String HTML_TABLE_ROW_START_3 = "onmouseout=\"this.style.backgroundColor='#d4e3e5';\">";
    public static final String HTML_TABLE_ROW_END = "</tr>";
    public static final String HTML_TABLE_HEAD_START = "<th>";
    public static final String HTML_TABLE_HEAD_END = "</th>";
    public static final String HTML_TABLE_DATA_START = "<td>";
    public static final String HTML_TABLE_DATA_END = "</td>";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(GrabUtil.class);
    private static final int REPORT_FILE_MAX_CAPACITY = 200;
    private static final int ONE_MB = 0x100000;
    private static final int NUMBER_100 = 100;
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private static final String SPLITDATALABEL = "|";
    private static double fileSize = 0.0;
    private static final String SHA_VERIFYFILE_EXTENDNAME = ".sign";

    public static boolean isHostDevice(GrabDevNode2 devNode) {
        return devNode.getItDeviceType().equals((Object)ItDeviceType.Host);
    }

    public static String fixPath(String xPath) {
        return xPath.replace("/", File.separator);
    }

    public static Item findLastEnableItem(List<Item> items) {
        if (items == null) {
            return null;
        }
        Item lastEnableItem = null;
        for (Item item : items) {
            if (!item.isDefaultChoose()) continue;
            lastEnableItem = item;
        }
        return lastEnableItem;
    }

    public static void reCalcProcess(List<Item> currListItems) {
        Integer totalNumber = GrabUtil.calcTotalProcessNumber(currListItems);
        Item finalItem = GrabUtil.findLastEnableItem(currListItems);
        Integer processNumber = 0;
        for (Item item : currListItems) {
            if (!item.equals(finalItem) && item.isDefaultChoose()) {
                processNumber = processNumber + item.getProcessBar() * 100;
                item.setUpdateProcNumber(processNumber / totalNumber);
                continue;
            }
            item.setUpdateProcNumber(100);
        }
    }

    private static Integer calcTotalProcessNumber(List<Item> currListItems) {
        Integer startNumber = 0;
        for (Item item : currListItems) {
            if (!item.isDefaultChoose()) continue;
            startNumber = startNumber + item.getProcessBar();
        }
        return startNumber == 0 ? 100 : startNumber;
    }

    public static void insertSmartIdcCollectItem(List<Item> itemList) {
        Item firstItem = itemList.get(0);
        if ("SmartIDC".equals(firstItem.getId())) {
            return;
        }
        Item item = new Item();
        item.copyeItem(firstItem);
        item.setShowProgress(true);
        item.setProcessBar(firstItem.getProcessBar() * 3);
        item.setTitle("smartIDC_configuration_sysinfo");
        item.setId("SmartIDC");
        itemList.add(0, item);
    }

    public static boolean checkAtLeastOneNode(List<GrabDevNode2> currSelectedNodes) {
        InfoGrabMainFrame currInfoGrabDialog = GrabContext.getInstance().getCurrInfoGrabFrame();
        if ((currSelectedNodes == null || currSelectedNodes.isEmpty()) && null != currInfoGrabDialog) {
            DialogUtils.showInfoDialog((Frame)currInfoGrabDialog, (String)ResourceUtil.getString((String)"infograb.remind.onecollectIntegrateNodeleast"));
            return false;
        }
        return true;
    }

    public static void deleteFiles(File file) {
        List<File> deletefiles = GrabUtil.getDeleteFiles(file, fileSize - 200.0);
        for (File tempfile : deletefiles) {
            GrabUtil.deleteDirectory(tempfile);
        }
    }

    private static void deleteFile(File file) {
        if (!file.delete() && LOGGER.isErrorEnabled()) {
            LOGGER.error("Can not have the W/R rights in result folder");
        }
    }

    private static void deleteDirectory(File path) {
        if (path != null && path.exists() && path.isDirectory()) {
            File[] deletefiles = path.listFiles();
            if (deletefiles == null) {
                return;
            }
            for (File tempFile : deletefiles) {
                if (tempFile.isDirectory()) {
                    GrabUtil.deleteDirectory(tempFile);
                    continue;
                }
                GrabUtil.deleteFile(tempFile);
            }
            GrabUtil.deleteFile(path);
        }
    }

    public static boolean checkFileCapacity(File file) {
        fileSize = GrabUtil.getFileSize(file) / 1048576.0;
        return fileSize >= 200.0;
    }

    public static List<File> getDeleteFiles(File file, double extrafilesize) {
        LinkedList<File> deleteFiles = new LinkedList<File>();
        List<File> files = GrabUtil.sortFileFromlastModified(file);
        double tempsize = 0.0;
        if (null != files) {
            for (File tempfile : files) {
                tempsize += GrabUtil.getFileSize(tempfile) / 1048576.0;
                deleteFiles.add(tempfile);
                if (!(tempsize >= 20.0 + extrafilesize)) continue;
                break;
            }
        } else {
            LOGGER.error("File sorting failed,failed is null");
        }
        return deleteFiles;
    }

    private static List<File> sortFileFromlastModified(File file) {
        File[] files = file.listFiles();
        if (files == null) {
            return null;
        }
        List<File> fileList = Arrays.asList(files);
        Collections.sort(fileList, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return (int)(f1.lastModified() - f2.lastModified());
            }
        });
        return fileList;
    }

    public static double getFileSize(File file) {
        double filesize = 0.0;
        if (file != null && file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File tempfile : files) {
                    filesize += GrabUtil.getFileSize(tempfile);
                }
            }
        } else if (file != null && file.exists()) {
            filesize += (double)file.length();
        }
        return filesize;
    }

    public static void doDeleteFiles() {
        String logPath = InfoGrabDirPropertiesUtil.getProperty();
        File file = new File(logPath);
        if (GrabUtil.checkFileCapacity(file)) {
            GrabUtil.deleteFiles(file);
        }
    }

    public static String parseResultsetToStr(ResultSet resultSet, DbGrabData dataObj) {
        if (resultSet == null) {
            return ResourceUtil.getString((String)"infoGrab.execute.sql.failed") + ENTER;
        }
        StringBuilder sbStr = new StringBuilder();
        sbStr.append("DataBase Column Name : ");
        String[] headers = dataObj.getColumeNames();
        for (int i = 0; i < headers.length; ++i) {
            sbStr.append(LEFT_BRACKET);
            sbStr.append(headers[i]);
            sbStr.append(RIGHT_BRACKET);
        }
        sbStr.append(ENTER);
        List<String[]> resultStrList = dataObj.getContents();
        String[][] resultArray = GrabUtil.parsetList2Array(resultStrList);
        for (int i = 0; i < resultArray.length; ++i) {
            for (int j = 0; j < resultArray[i].length; ++j) {
                sbStr.append(resultArray[i][j]).append(SPLITDATALABEL);
            }
            sbStr.append(ENTER);
        }
        return sbStr.toString();
    }

    public static String parseResultsetToTableStr(String sqlName, ResultSet resultSet, DbGrabData dataObj) {
        if (resultSet == null) {
            String cmdDisplay = sqlName + HTML_ENTER + ResourceUtil.getString((String)"infoGrab.execute.sql.failed") + HTML_ENTER;
            cmdDisplay = "<div class=\"padds\"><div class=\"tables\" style=\"border:1px solid black;\"><p class=\"fonts\" style=\"padding-left:5px;white-space:nowrap;\">" + cmdDisplay + HTML_STRING_FORMAT_END;
            return cmdDisplay;
        }
        StringBuilder tableStr = new StringBuilder();
        tableStr.append(sqlName).append(HTML_ENTER);
        tableStr.append(HTML_TABLE_ALIGN_START);
        tableStr.append(HTML_TABLE_SCROLL_START);
        tableStr.append(HTML_TABLE_SIZE_START);
        tableStr.append(HTML_TABLE_ROW_START_1);
        String[] headers = dataObj.getColumeNames();
        for (int i = 0; i < headers.length; ++i) {
            tableStr.append(HTML_TABLE_HEAD_START).append(headers[i]).append(HTML_TABLE_HEAD_END);
        }
        tableStr.append(HTML_TABLE_ROW_END);
        List<String[]> resultStringList = dataObj.getContents();
        String[][] resultArray = GrabUtil.parsetList2Array(resultStringList);
        for (int i = 0; i < resultArray.length; ++i) {
            tableStr.append("<tr onmouseover=\"this.style.backgroundColor='#ffff66';\" onmouseout=\"this.style.backgroundColor='#d4e3e5';\">");
            for (int j = 0; j < resultArray[i].length; ++j) {
                tableStr.append(HTML_TABLE_DATA_START).append(resultArray[i][j]).append(HTML_TABLE_DATA_END);
            }
            tableStr.append(HTML_TABLE_ROW_END);
        }
        tableStr.append(HTML_TABLE_SIZE_END);
        tableStr.append("</div>");
        tableStr.append("</div>");
        return tableStr.toString();
    }

    public static DbGrabData getResultObj(ResultSet resultSet) {
        DbGrabData dataObj = new DbGrabData();
        if (null != resultSet) {
            ArrayList<String[]> resultStringList = new ArrayList<String[]>();
            String[] headers = null;
            try {
                ResultSetMetaData rsmd = resultSet.getMetaData();
                int count = rsmd.getColumnCount();
                headers = new String[count];
                for (int i = 0; i < count; ++i) {
                    headers[i] = rsmd.getColumnLabel(i + 1);
                }
                while (resultSet.next()) {
                    String[] tempString = new String[count];
                    for (int j = 0; j < count; ++j) {
                        tempString[j] = resultSet.getString(rsmd.getColumnLabel(j + 1));
                    }
                    resultStringList.add(tempString);
                }
                dataObj.setContents(resultStringList);
                dataObj.setColumeNames(headers);
            }
            catch (SQLException e) {
                LOGGER.error("resultSet get data failed");
            }
        } else {
            LOGGER.info("the ResultSet is null");
        }
        return dataObj;
    }

    private static String[][] parsetList2Array(List<String[]> list) {
        int row = list.size();
        if (list.isEmpty()) {
            return new String[0][0];
        }
        int colume = list.get(0).length;
        String[][] resultStringArray = new String[row][colume];
        int index = 0;
        for (String[] arr : list) {
            resultStringArray[index++] = arr;
        }
        return resultStringArray;
    }

    public static String getVersionShow() {
        File toolInitFile = new File(ApplicationContext.getInstance().getWorkPath(), "tool.ini");
        try {
            if (toolInitFile.exists() && SHAAndRSAVerifyUtils.getInstance().excuteVerify(toolInitFile)) {
                return TooliniParser.getToolIniProp((String)"tool.version.show");
            }
        }
        catch (Exception e) {
            LOGGER.error("valid file error", (Throwable)e);
        }
        return "--";
    }

    public static String getToolVersion() {
        File toolInitFile = new File(ApplicationContext.getInstance().getWorkPath(), "tool.ini");
        try {
            if (toolInitFile.exists() && SHAAndRSAVerifyUtils.getInstance().excuteVerify(toolInitFile)) {
                return TooliniParser.getToolIniProp((String)"tool.version");
            }
        }
        catch (Exception e) {
            LOGGER.error("valid file error", (Throwable)e);
        }
        return "--";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCompatibilityWebsite() {
        iniFile = ToolUtils.getCanonicalFile(ApplicationContext.getInstance().getWorkPath() + File.separator + "tool.ini");
        if (null == iniFile) {
            GrabUtil.LOGGER.error("Can not creat the targetDir!!!");
            return "--";
        }
        if (iniFile.exists() == false) return "--";
        if (GrabUtil.excuteVerify(iniFile) == false) return "--";
        inputStream = null;
        inputStreamReader = null;
        bufferedReader = null;
        try {
            inputStream = new FileInputStream(iniFile);
            inputStreamReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            bufferedReader = new BufferedReader(inputStreamReader);
            lineText = null;
            while ((lineText = bufferedReader.readLine()) != null) {
                if (StringUtils.isNULLStr((String)lineText) || !lineText.startsWith("tool.compatibilitywebsite.show")) continue;
                lineTextArray = lineText.split("=");
                var6_7 = lineTextArray.length == 2 ? lineTextArray[1] : "--";
                ** GOTO lbl30
            }
            ** GOTO lbl34
        }
        catch (IOException e) {
            try {
                GrabUtil.LOGGER.error("Get the infograb version failed");
            }
            catch (Throwable var7_8) {
                StreamUtils.closeResource(null, bufferedReader);
                StreamUtils.closeResource(null, inputStreamReader);
                StreamUtils.closeResource(null, (Closeable)inputStream);
                throw var7_8;
            }
lbl30:
            // 1 sources

            StreamUtils.closeResource(null, (Closeable)bufferedReader);
            StreamUtils.closeResource(null, (Closeable)inputStreamReader);
            StreamUtils.closeResource(null, (Closeable)inputStream);
            return var6_7;
lbl34:
            // 1 sources

            StreamUtils.closeResource(null, (Closeable)bufferedReader);
            StreamUtils.closeResource(null, (Closeable)inputStreamReader);
            StreamUtils.closeResource(null, (Closeable)inputStream);
            return "--";
            StreamUtils.closeResource(null, bufferedReader);
            StreamUtils.closeResource(null, (Closeable)inputStreamReader);
            StreamUtils.closeResource(null, (Closeable)inputStream);
            return "--";
        }
    }

    private static boolean excuteVerify(File verifySrcFile) {
        File shaFile = new File(verifySrcFile.getParentFile(), verifySrcFile.getName() + SHA_VERIFYFILE_EXTENDNAME);
        if (!shaFile.exists()) {
            return false;
        }
        PublicKey publicKey = RSAUtils.getPublicKey((String)PatchUtil.importRSAKey());
        String shaVerifyCode = StreamUtils.readStringFormFile((File)shaFile);
        if (null == publicKey || StringUtils.isNULLStr((String)shaVerifyCode)) {
            return false;
        }
        String decryptedHash = RSAUtils.decrypt((PublicKey)publicKey, (String)shaVerifyCode);
        String filePath = null;
        try {
            filePath = verifySrcFile.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("get canonical file path error.");
            return false;
        }
        String fileHash = SHA256Check.getInstance().getHash(filePath);
        return fileHash.equals(decryptedHash);
    }

    public static Date cloneDate(Date oldDate) {
        if (null == oldDate) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(oldDate);
        return cal.getTime();
    }
}

