/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.intf.worktaker.impl;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.infograb.base.BaseTask;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.context.ItemResultEnum;
import com.huawei.ism.tool.infograb.context.SingleDevTask;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.GrabParamEntity;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.grab.GrabEngine;
import com.huawei.ism.tool.infograb.grab.GrabFlowAdapter;
import com.huawei.ism.tool.infograb.intf.worktaker.IGrabRefreshUI;
import com.huawei.ism.tool.infograb.intf.worktaker.IGrabWorktaker;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.GrabFileFactory;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;

public class GrabWorktaker
implements IGrabWorktaker {
    private AtomicInteger taskNumber = new AtomicInteger(1);
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(GrabWorktaker.class);

    public static IGrabWorktaker getInstance() {
        return Holder.INSTACNE;
    }

    @Override
    public void collect(List<GrabDevNode2> nodeList, IGrabRefreshUI uiListener) {
        throw new NotImplementedException("method not implemented.");
    }

    @Override
    public synchronized void collectDevsInfos(GrabParamEntity grabParamEntity, BaseTask task) {
        if (grabParamEntity == null) {
            LOGGER.warn("grabParamEntity is null.");
            return;
        }
        grabParamEntity.setTaskDirPath(this.initTask(grabParamEntity, task));
        List<GrabDevNode2> currSelectedNodes = grabParamEntity.getGrabDevNodeList();
        this.clearOldData(currSelectedNodes);
        this.setChoosenNodeRunning(currSelectedNodes);
        StringBuilder devsKey = new StringBuilder();
        for (GrabDevNode2 dev : currSelectedNodes) {
            devsKey.append(dev.getIp());
        }
        SingleDevTask singleDevTask = new SingleDevTask();
        singleDevTask.setDevNodesList(currSelectedNodes);
        singleDevTask.setDevNum(currSelectedNodes.size());
        singleDevTask.setTaskNum(grabParamEntity.getTaskNum());
        GrabContext.getInstance().getSingleDevTask().put(devsKey.toString(), singleDevTask);
        this.initGrabFlowThreads(currSelectedNodes, grabParamEntity);
    }

    public String initTask(GrabParamEntity grabParamEntity, BaseTask task) {
        if (task == null) {
            RealTimeTask taskNew = new RealTimeTask();
            taskNew.setId(System.currentTimeMillis() + "");
            taskNew.setTaskDirName("Task_" + this.taskNumber.getAndIncrement());
            taskNew.setTaskType(ResourceUtil.getString((String)"infograb.task.realtime"));
            ArrayList<String> taskCategorys = new ArrayList<String>();
            taskCategorys.add(ResourceUtil.getString((String)"infograb.item.category.pre_update_exploration"));
            taskNew.setTaskCategory(taskCategorys);
            taskNew.setTaskName("EvalTask_" + this.taskNumber.getAndIncrement());
            for (GrabDevNode2 devNode : grabParamEntity.getGrabDevNodeList()) {
                if (GrabContext.getInstance().getTaskMap().containsKey((Object)devNode)) continue;
                GrabContext.getInstance().getTaskMap().put(devNode, taskNew);
                GrabFlowAdapter.getInstance().cacheItemsOfNodeForUpgrade(devNode);
            }
            return GrabFileFactory.getInstance().getTaskBasePath(taskNew).toString();
        }
        if (task instanceof RealTimeTask) {
            return GrabFileFactory.getInstance().getTaskBasePath((RealTimeTask)task).toString();
        }
        return null;
    }

    private void initGrabFlowThreads(List<GrabDevNode2> currSelectedNodes, GrabParamEntity grabParamEntity) {
        this.refreshAllNodePregress(currSelectedNodes, grabParamEntity);
        this.refreshFistLines(currSelectedNodes, grabParamEntity);
        Date collectTime = new Date();
        for (GrabDevNode2 currNode : currSelectedNodes) {
            GrabParamEntity entity = new GrabParamEntity(currSelectedNodes, grabParamEntity.getUiListener(), grabParamEntity.getTaskNum(), null);
            GrabContext.getInstance().getTaskStartTime().put(currNode.getDeviceSerialNumber(), collectTime.getTime());
            entity.setCurGrabDev(currNode);
            GrabEngine.getInstance().addOneGrabThread(entity);
        }
    }

    private void refreshAllNodePregress(List<GrabDevNode2> currNodes, GrabParamEntity grabParamEntity) {
        ArrayList<ExecuteResult> currExecuteResultList = new ArrayList<ExecuteResult>();
        for (GrabDevNode2 node : currNodes) {
            currExecuteResultList.add(InfoGrabService.getInstance().createStartingResult(node));
        }
        IGrabRefreshUI listner = grabParamEntity.getUiListener();
        if (listner != null) {
            listner.refreshPregress(currExecuteResultList);
        }
    }

    private void refreshFistLines(List<GrabDevNode2> currNodes, GrabParamEntity grabParamEntity) {
        GrabDevNode2 devNode;
        for (GrabDevNode2 node : currNodes) {
            ExecuteResult initResult = this.createFirstLine(node);
            initResult.setExecuteEndTime();
            InfoGrabService.getInstance().fillOneResultByNode(node, initResult);
        }
        IGrabRefreshUI listner = grabParamEntity.getUiListener();
        if (listner != null && null != (devNode = grabParamEntity.getCurGrabDev())) {
            listner.collectCallback(devNode);
        }
    }

    private ExecuteResult createFirstLine(GrabDevNode2 devNode) {
        ExecuteResult result = new ExecuteResult();
        result.setDevNode(devNode);
        result.setDescription("infograb.detail.perparecollect");
        result.setItemResultEnum(ItemResultEnum.SUCCESS);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("err_msg", ResourceUtil.getString((String)"infograb.detail.perparecollect"));
        result.setResultMap(resultMap);
        result.setProcessing(false);
        return result;
    }

    private void setChoosenNodeRunning(List<GrabDevNode2> currSelectedNodes) {
        InfoGrabService.getInstance().setNodesRunning(currSelectedNodes);
    }

    private void clearOldData(List<GrabDevNode2> currSelectedNodes) {
        ConcurrentHashMap<GrabDevNode2, List<ExecuteResult>> currResultMap = GrabContext.getInstance().getExecuteResultMap();
        for (GrabDevNode2 node : currSelectedNodes) {
            currResultMap.remove((Object)node);
        }
    }

    private static final class Holder {
        private static final IGrabWorktaker INSTACNE = new GrabWorktaker();

        private Holder() {
        }
    }
}

