/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.intf.worktaker.impl;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.infograb.entity.RealTimeTask;
import com.huawei.ism.tool.infograb.utils.SceneEnvironmentImpl;
import com.huawei.ism.tool.obase.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InfoGrabDirPropertiesUtil {
    private static final String HOST_INFO_DIR = "hostInfo";
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoGrabDirPropertiesUtil.class);
    private static final String FILEPATH = ApplicationContext.getInstance().getTmpPath() + File.separator;
    private static final String FILENAME = "infoGrabDir.properties";
    private static final String INFOGRABKEY = "info.grab.directory";
    public static final String INFOGRABPATHKEY = "info.grab.directory.suffix";
    private static final String INFOGRABCOMMENT = "Info grab directory";
    private static final Map<String, String> GRAB_PATH_PARAM = new HashMap<String, String>();

    private InfoGrabDirPropertiesUtil() {
    }

    public static synchronized void setPathParam(String key, String value) {
        GRAB_PATH_PARAM.put(key, value);
    }

    public static synchronized String getProperty() {
        File file;
        Properties properties = InfoGrabDirPropertiesUtil.getDirProperties();
        String path = "";
        if (SceneEnvironmentImpl.getInstance().isScene() && !System.getenv("jsonScene").contains("\"mainScene\":\"Troubleshooting\"")) {
            String scenInfo = System.getenv("jsonScene");
            String string = scenInfo = scenInfo == null ? "" : scenInfo;
            if (!scenInfo.contains("\"mainScene\":\"Migration\"")) {
                File evalPath;
                path = SceneEnvironmentImpl.getInstance().getEnvirValueByKey("jsonSceneResultPath");
                LOGGER.info("scene path : {}", (Object)StringUtils.getCleanMessage((String)path));
                if (GRAB_PATH_PARAM.containsKey(INFOGRABPATHKEY) && null != path && !(evalPath = new File(path = path + File.separator + GRAB_PATH_PARAM.get(INFOGRABPATHKEY) + File.separator + HOST_INFO_DIR)).exists()) {
                    LOGGER.info("mkdir result : {}", (Object)evalPath.mkdir());
                }
                return path;
            }
        }
        if (properties.containsKey(INFOGRABKEY)) {
            path = properties.getProperty(INFOGRABKEY);
            if (StringUtils.isNULLStr((String)path)) {
                path = FileUtils.getDefaultDirectory().getAbsolutePath() + File.separator + "data" + File.separator + "infograb";
            }
        } else {
            path = FileUtils.getDefaultDirectory().getAbsolutePath() + File.separator + "data" + File.separator + "infograb";
        }
        if (!(file = new File(path)).exists() && !file.mkdirs()) {
            return ApplicationContext.getInstance().getWorkPath();
        }
        return path;
    }

    public static synchronized String getTaskPath(RealTimeTask collectTask) {
        return InfoGrabDirPropertiesUtil.getProperty() + File.separator + collectTask.getTaskDirName();
    }

    private static Properties getDirProperties() {
        Properties properties = new Properties();
        FileInputStream fileReader = null;
        try {
            File file = new File(FILEPATH + FILENAME);
            if (file.exists()) {
                fileReader = new FileInputStream(file);
                properties.load(fileReader);
            }
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("getProperty error");
            }
        }
        finally {
            block15: {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException e) {
                        if (!LOGGER.isErrorEnabled()) break block15;
                        LOGGER.error("Infograb filereader IO Exception error");
                    }
                }
            }
        }
        return properties;
    }

    public static synchronized void setProperty(String value) throws ToolException {
        Properties properties = new Properties();
        FileOutputStream fileWrite = null;
        try {
            File fileDir = new File(FILEPATH);
            File file = new File(FILEPATH + FILENAME);
            if (!fileDir.exists()) {
                boolean result;
                boolean bl = result = fileDir.mkdirs() && file.createNewFile();
                if (!result && LOGGER.isErrorEnabled()) {
                    LOGGER.error("createNewFile error.");
                }
            } else {
                file = new File(FILEPATH + FILENAME);
            }
            fileWrite = new FileOutputStream(file);
            properties.setProperty(INFOGRABKEY, value);
            properties.store(fileWrite, INFOGRABCOMMENT);
        }
        catch (IOException e) {
            throw new ToolException("", (Throwable)e);
        }
        finally {
            block14: {
                if (fileWrite != null) {
                    try {
                        fileWrite.close();
                    }
                    catch (IOException e) {
                        if (!LOGGER.isErrorEnabled()) break block14;
                        LOGGER.error("InfograbDir file write IO close exception");
                    }
                }
            }
        }
    }
}

