/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.intf.worktaker.impl;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InfoGrabTaskNumProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoGrabTaskNumProperties.class);
    private static final String TEMPPATH = ApplicationContext.getInstance().getTmpPath() + File.separator;
    private static final String FILENAMEPRO = "infoGrabTaskNum.properties";
    private static final String INFOGRABTASKKEY = "info.grab.taskNameNumber";
    private static final String INFOGRABCOMMENT = "Info grab taskNameNumber";

    private InfoGrabTaskNumProperties() {
    }

    public static synchronized Integer getProperty() {
        Properties properties = InfoGrabTaskNumProperties.getNumberProperties();
        String taskNum = properties.getProperty(INFOGRABTASKKEY);
        if (StringUtils.isNULLStr((String)taskNum)) {
            taskNum = "0";
        }
        return Integer.parseInt(taskNum);
    }

    private static Properties getNumberProperties() {
        Properties proper = new Properties();
        FileInputStream fileInput = null;
        try {
            File file = new File(TEMPPATH + FILENAMEPRO);
            if (file.exists()) {
                fileInput = new FileInputStream(file);
                proper.load(fileInput);
            }
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("get taskNumber is error");
            }
        }
        finally {
            StreamUtils.closeStream(null, fileInput);
        }
        return proper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setProperty(String value) {
        Properties properties = new Properties();
        FileOutputStream fileOut = null;
        try {
            File fileDir = new File(TEMPPATH);
            File file = new File(TEMPPATH + FILENAMEPRO);
            if (!fileDir.exists()) {
                boolean result;
                boolean bl = result = fileDir.mkdirs() && file.createNewFile();
                if (!result && LOGGER.isErrorEnabled()) {
                    LOGGER.error("createNewFile error.");
                }
            } else {
                file = new File(TEMPPATH + FILENAMEPRO);
            }
            fileOut = new FileOutputStream(file);
            properties.setProperty(INFOGRABTASKKEY, value);
            properties.store(fileOut, INFOGRABCOMMENT);
            StreamUtils.closeStream((OutputStream)fileOut, null);
        }
        catch (IOException e) {
            LOGGER.error("set taskNumber is error!");
        }
        finally {
            StreamUtils.closeStream(fileOut, null);
        }
    }
}

