/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.parser;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.GrabFlow;
import com.huawei.ism.tool.infograb.entity.Item;
import com.huawei.ism.tool.infograb.entity.Module;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class InfoGrabItemPaser {
    private static final String TRUE = "true";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(InfoGrabItemPaser.class);
    private static final InfoGrabItemPaser INSTANCE = new InfoGrabItemPaser();
    private static final String FLOW_GUIDE_PATH = "config/wizard/InfoGrabFlowGuide.xml";
    private static final String XML_MODULE = "module";
    private static final String XML_NAMEKEY = "namekey";
    private static final String SHOW_PROG = "showProgress";
    private static final String XML_LOCATION = "location";
    private static final String XML_ITEM = "item";
    private static final String XML_SCRIPT = "script";
    private static final String XML_DEFAULT = "default";
    private static final String XML_PROCESSBAR = "processbar";
    private static final String XML_HOST = "host";
    private static final String XML_STORAGE = "storage";
    private static final String XML_SWITCH = "switch";
    private static final String XML_DATABASE = "database";

    private InfoGrabItemPaser() {
    }

    public static InfoGrabItemPaser getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDoc(String resource) {
        ClassLoader classLoader = InfoGrabItemPaser.class.getClassLoader();
        InputStream stream = null;
        if (null != classLoader) {
            stream = classLoader.getResourceAsStream(resource);
        }
        if (null == stream) {
            return null;
        }
        Document doc = null;
        try {
            doc = XmlUtils.parseDocument((InputStream)stream);
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)stream);
        }
        return doc;
    }

    public void createGrabFlowByXML() {
        Document doc = this.getDoc(FLOW_GUIDE_PATH);
        if (null == doc) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Could not found the info grab flow guide.");
            }
            return;
        }
        Element root = doc.getDocumentElement();
        HashMap<ItDeviceType, GrabFlow> currUniqueFlowMap = new HashMap<ItDeviceType, GrabFlow>();
        for (Element moduleElem : XmlUtils.getChildren((Element)root, (String)XML_MODULE)) {
            String moduleNameKey = XmlUtils.getAttribute((Element)moduleElem, (String)XML_NAMEKEY);
            String location = XmlUtils.getAttribute((Element)moduleElem, (String)XML_LOCATION);
            currUniqueFlowMap.put(this.str2ItDeviceType(moduleNameKey), this.hanldeGrabFlow(location));
        }
        GrabContext.getInstance().setSysType2FlowMap(currUniqueFlowMap);
    }

    private ItDeviceType str2ItDeviceType(String itDeviceType) {
        if (itDeviceType.equalsIgnoreCase(XML_HOST)) {
            return ItDeviceType.Host;
        }
        if (itDeviceType.equalsIgnoreCase(XML_SWITCH)) {
            return ItDeviceType.Switch;
        }
        if (itDeviceType.equalsIgnoreCase(XML_STORAGE)) {
            return ItDeviceType.Storage;
        }
        if (itDeviceType.equalsIgnoreCase(XML_DATABASE)) {
            return ItDeviceType.Database;
        }
        return null;
    }

    public GrabFlow hanldeGrabFlow(String location) {
        Document doc = this.getDoc(location);
        if (null == doc) {
            return null;
        }
        Element root = doc.getDocumentElement();
        GrabFlow currGrabFlow = new GrabFlow();
        for (Element moduleElem : XmlUtils.getChildren((Element)root, (String)XML_MODULE)) {
            String moduleNameKey = XmlUtils.getAttribute((Element)moduleElem, (String)XML_NAMEKEY);
            Module currModule = new Module(moduleNameKey);
            currModule.setItemList(this.getItemsByElem(moduleElem));
            currModule.setTitle(moduleNameKey);
            currGrabFlow.setSingleModuleList(currModule);
        }
        return currGrabFlow;
    }

    private List<Item> getItemsByElem(Element moduleElem) {
        if (moduleElem == null) {
            return null;
        }
        LinkedList<Item> currProcessList = new LinkedList<Item>();
        for (Element item : XmlUtils.getChildren((Element)moduleElem, (String)XML_ITEM)) {
            Boolean enabled = Boolean.valueOf(XmlUtils.getAttribute((Element)item, (String)XML_DEFAULT));
            String scriptURL = XmlUtils.getAttribute((Element)item, (String)XML_SCRIPT);
            String nameKey = XmlUtils.getAttribute((Element)item, (String)XML_NAMEKEY);
            String processBar = XmlUtils.getAttribute((Element)item, (String)XML_PROCESSBAR);
            String showProgress = XmlUtils.getAttribute((Element)item, (String)SHOW_PROG);
            ArrayList<String> cagegoryList = new ArrayList<String>();
            for (Element category : XmlUtils.getChildren((Element)item)) {
                cagegoryList.add(ResourceUtil.getString((String)category.getAttribute("value")));
            }
            Item currItem = new Item(nameKey, nameKey, scriptURL);
            currItem.setShowProgress(TRUE.equals(showProgress));
            currItem.setCategory(cagegoryList);
            currItem.setDefaultChoose(enabled);
            currItem.setProcessBar(Integer.parseInt(processBar));
            currProcessList.add(currItem);
        }
        return currProcessList;
    }
}

