/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.parser;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.infograb.entity.CollectItem;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MigrationParse {
    private static final Logger log = LoggerFactory.getLogger(MigrationParse.class);
    private static final String HOST_XML_PATH = "config/wizard/migrationHost.xml";
    private static final String STORAGE_XML_PATH = "config/wizard/migrationStorage.xml";
    private static final String XML_HOST = "host";
    private static final String XML_STORAGE = "storage";
    private static final String XML_TYPE = "type";
    private static final String XML_COLLECTION = "collection";
    private static final String XML_NAME = "name";
    private static final String XML_SCRIPT = "script";

    private static Map<String, List<CollectItem>> createParseMaps(String xmlPath, String parseType) {
        return XmlUtils.getChildren((Element)MigrationParse.getDoc(xmlPath).getDocumentElement(), (String)parseType).stream().collect(Collectors.toMap(element -> XmlUtils.getAttribute((Element)element, (String)XML_TYPE), MigrationParse::getElementCollection, (oldData, newData) -> newData));
    }

    private static Document getDoc(String resource) {
        ClassLoader classLoader = MigrationParse.class.getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(resource);
        Document doc = XmlUtils.parseDocument((InputStream)stream);
        StreamUtils.closeStream(null, (InputStream)stream);
        return doc;
    }

    private static List<CollectItem> getElementCollection(Element element) {
        return XmlUtils.getChildren((Element)element, (String)XML_COLLECTION).stream().map(MigrationParse::getCollection).collect(Collectors.toList());
    }

    private static CollectItem getCollection(Element element) {
        CollectItem collectItem = new CollectItem();
        collectItem.setItemName(XmlUtils.getAttribute((Element)element, (String)XML_NAME));
        collectItem.setScriptName(XmlUtils.getAttribute((Element)element, (String)XML_SCRIPT));
        return collectItem;
    }

    public static List<CollectItem> getHostCollections(String hostType) {
        return MigrationParse.createParseMaps(HOST_XML_PATH, XML_HOST).get(hostType);
    }

    public static List<CollectItem> getStorageCollections(String storageType) {
        return MigrationParse.createParseMaps(STORAGE_XML_PATH, XML_STORAGE).get(storageType);
    }
}

