/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.parser.host;

import com.google.common.base.Strings;
import com.huawei.ism.tool.infograb.entity.HostInfo;
import com.huawei.ism.tool.infograb.entity.HostOs;
import com.huawei.ism.tool.infograb.entity.MultiDisk;
import com.huawei.ism.tool.infograb.entity.Multipath;
import com.huawei.ism.tool.infograb.entity.OverView;
import com.huawei.ism.tool.infograb.utils.migration.SummaryConstants;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import com.huawei.migration.common.util.json.JsonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;

public class HostCommonParser {
    public static List<List<String>> getOverviewData(List<HostInfo> hosts) {
        ArrayList<List<String>> overviewData = new ArrayList<List<String>>();
        overviewData.add(HostCommonParser.getOverViewHeader());
        Map<String, String> ip2GroupName = HostCommonParser.getIp2GroupName(hosts);
        hosts.stream().map(hostInfo -> HostCommonParser.getOneHostOverviewData(hostInfo, ip2GroupName)).forEach(overviewData::add);
        return overviewData;
    }

    private static List<String> getOneHostOverviewData(HostInfo hostInfo, Map<String, String> ip2GroupName) {
        OverView overView = hostInfo.getOverView();
        return Arrays.asList(overView.getIp(), overView.getHostName(), overView.getOsVersion(), overView.getHbaType(), overView.getHbaWwn(), overView.getMultiType(), overView.getMultiVersion(), overView.getClusterName(), overView.getClusterVersion(), ip2GroupName.getOrDefault(overView.getRealIp(), ""), overView.getLvmType(), overView.getDbName(), overView.getDbVersion(), overView.getDiskUse(), overView.getInfoGrabVersion(), overView.getMultiPathStatus(), overView.getHbaDetail());
    }

    private static Map<String, String> getIp2GroupName(List<HostInfo> hosts) {
        HashMap<String, String> ip2GroupName = new HashMap<String, String>();
        AtomicInteger groupNum = new AtomicInteger(1);
        ArrayList allHostClusterIps = new ArrayList();
        hosts.stream().filter(hostInfo -> !HostCommonParser.notClusterIp(hostInfo)).map(HostInfo::getOverView).map(OverView::getClusterIps).forEach(clusterIp -> HostCommonParser.generateClusterName(clusterIp, allHostClusterIps, groupNum, ip2GroupName));
        return ip2GroupName;
    }

    private static boolean notClusterIp(HostInfo hostInfo) {
        List<String> currentHostClusterIps = hostInfo.getOverView().getClusterIps();
        return currentHostClusterIps.isEmpty() || Strings.isNullOrEmpty((String)currentHostClusterIps.get(0));
    }

    private static List<String> getOverViewHeader() {
        return Arrays.asList("IP/ID", "Host Name", "Os Info", "HBA Type", "HBA WWN", "Multipath Type", "Multipath Version", "Cluster Name", "Cluster Version", "Cluster Group", "LVM Type", "DB Name", "DB Version", "Disk Use", "InfoGrab Version", "Multipath Status", "HBA Detail");
    }

    private static void generateClusterName(List<String> currentHostClusterIps, List<List<String>> allHostClusterIps, AtomicInteger groupNum, Map<String, String> ip2GroupName) {
        if (HostCommonParser.isInCluster(currentHostClusterIps, allHostClusterIps) && HostCommonParser.clusterHasNotParsed(ip2GroupName, currentHostClusterIps)) {
            HostCommonParser.addClusterGroupName(ip2GroupName, currentHostClusterIps, groupNum.getAndIncrement());
        } else {
            allHostClusterIps.add(currentHostClusterIps);
        }
    }

    private static void addClusterGroupName(Map<String, String> ip2GroupName, List<String> currentHostClusterIps, int groupNum) {
        currentHostClusterIps.forEach(clusterIp -> ip2GroupName.put((String)clusterIp, "Group" + String.format(Locale.ENGLISH, "%03d", groupNum)));
    }

    private static boolean clusterHasNotParsed(Map<String, String> ip2GroupName, List<String> currentHostClusterIps) {
        return currentHostClusterIps.stream().noneMatch(ip2GroupName::containsKey);
    }

    private static boolean isInCluster(List<String> currentHostClusterIps, List<List<String>> allHostClusterIps) {
        return allHostClusterIps.stream().anyMatch(clusterIps -> HostCommonParser.isSameClusterIps(currentHostClusterIps, clusterIps));
    }

    private static boolean isSameClusterIps(List<String> currentHostClusterIps, List<String> clusterIps) {
        return CollectionUtils.isEqualCollection(currentHostClusterIps, clusterIps);
    }

    public static List<List<String>> getMultiData(List<HostInfo> hosts, String hostType) {
        ArrayList<List<String>> multiData = new ArrayList<List<String>>();
        multiData.add(HostCommonParser.getMultiPathHeader(hostType));
        List allHostMultiPathData = hosts.stream().map(hostInfo -> HostCommonParser.getOneHostMultiPathData(hostInfo, hostType)).flatMap(Collection::stream).collect(Collectors.toList());
        multiData.addAll(allHostMultiPathData);
        return multiData;
    }

    private static List<List<String>> getOneHostMultiPathData(HostInfo host, String hostType) {
        return host.getMultipaths().stream().map(multipath -> HostCommonParser.getOneTypeMultiPathData(hostType, multipath)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<List<String>> getOneTypeMultiPathData(String hostType, Multipath multipath) {
        return multipath.getMultiDisks().stream().map(multiDisk -> HostCommonParser.getOneMultiDiskContent(hostType, multiDisk, multipath)).collect(Collectors.toList());
    }

    private static List<String> getMultiPathHeader(String hostType) {
        switch (hostType) {
            case "Linux": {
                return SummaryConstants.getMultipathHeaderForLinux();
            }
            case "AIX": {
                return SummaryConstants.getMultipathHeaderForAix();
            }
            case "Windows": {
                return SummaryConstants.getMultipathHeaderForWindows();
            }
            case "Solaris": {
                return SummaryConstants.getMultipathHeaderForSolaris();
            }
        }
        return SummaryConstants.getMultipathHeaderDefault();
    }

    private static List<String> getOneMultiDiskContent(String hostType, MultiDisk multiDisk, Multipath multipath) {
        ArrayList<String> content = new ArrayList<String>();
        content.add(multipath.getIp());
        content.add(multipath.getType());
        content.add(multipath.getVersion());
        content.add(multiDisk.getDiskName());
        content.add(multiDisk.getLunSize());
        content.add(multiDisk.getLunWwn());
        if ("AIX".equals(hostType)) {
            content.add(multiDisk.getReservePolicy());
        }
        content.add(multiDisk.getVendor());
        content.add(multiDisk.getProduct());
        if ("Windows".equals(hostType)) {
            content.add(multiDisk.getWindowsAlua());
            content.add(multiDisk.getWindowsDriveLetter());
        }
        if ("Linux".equals(hostType)) {
            content.add(multiDisk.getDmMaxSectors());
        }
        if ("Solaris".equals(hostType)) {
            content.add(multiDisk.getIsAlua());
        }
        return content;
    }

    public static List<List<String>> getOsData(List<HostInfo> hosts) {
        ArrayList<List<String>> osDatas = new ArrayList<List<String>>(Collections.singletonList(Arrays.asList("IP/ID", "Os Type", "Os Version")));
        hosts.forEach(hostInfo -> osDatas.add(HostCommonParser.getOneHostOsData(hostInfo.getHostOs())));
        return osDatas;
    }

    private static List<String> getOneHostOsData(HostOs hostOs) {
        return Arrays.asList(hostOs.getIp(), hostOs.getType(), hostOs.getVersion());
    }

    public static List<List<String>> getSolarisOsData(List<HostInfo> hosts) {
        ArrayList<List<String>> osDatas = new ArrayList<List<String>>(Collections.singletonList(Arrays.asList("IP/ID", "Os Type", "Os Version", "Is San Boot")));
        hosts.stream().map(HostInfo::getHostOs).forEach(host -> osDatas.add(Arrays.asList(host.getIp(), host.getType(), host.getVersion(), host.getIsSanBoot())));
        return osDatas;
    }

    public static void buildMultipath(HostInfo hostInfo, Map<String, Object> resultMap, String hostType) {
        JSONObject multiMap = new JSONObject(resultMap.get("multipath_info").toString());
        hostInfo.setMultipaths(HostCommonParser.getMultipath(multiMap, hostType));
    }

    private static List<Multipath> getMultipath(JSONObject multiMap, String hostType) {
        JSONArray multiPathArr = JsonUtil.safeGetJsonArray((JSONObject)multiMap, (String)"multipaths");
        String ip = JsonUtil.safeGetString((JSONObject)multiMap, (String)"host_ip");
        return IntStream.range(0, multiPathArr.length()).mapToObj(index -> HostCommonParser.getOneMultiPath(multiPathArr.getJSONObject(index), hostType, ip)).collect(Collectors.toList());
    }

    private static Multipath getOneMultiPath(JSONObject jsonObject, String hostType, String ip) {
        Multipath multipath = new Multipath();
        multipath.setIp(ip);
        multipath.setType(JsonUtil.safeGetString((JSONObject)jsonObject, (String)"multipath_type"));
        multipath.setVersion(JsonUtil.safeGetString((JSONObject)jsonObject, (String)"version"));
        JSONArray diskArr = JsonUtil.safeGetJsonArray((JSONObject)jsonObject, (String)"disk_list");
        multipath.setMultiDisks(HostCommonParser.getMultiDisks(diskArr, hostType));
        return multipath;
    }

    private static List<MultiDisk> getMultiDisks(JSONArray diskArr, String hostType) {
        return IntStream.range(0, diskArr.length()).mapToObj(index -> HostCommonParser.getOneMultiDisk(diskArr.getJSONObject(index), hostType)).collect(Collectors.toList());
    }

    private static MultiDisk getOneMultiDisk(JSONObject oneDisk, String hostType) {
        MultiDisk multiDisk = new MultiDisk();
        if ("Windows".equals(hostType)) {
            multiDisk.setDiskName(JsonUtil.safeGetString((JSONObject)oneDisk, (String)"system_disk"));
            multiDisk.setWindowsDriveLetter(JsonUtil.safeGetString((JSONObject)oneDisk, (String)"drive_letter"));
            multiDisk.setWindowsAlua(JsonUtil.safeGetString((JSONObject)oneDisk, (String)"alua"));
        } else {
            multiDisk.setDiskName(JsonUtil.safeGetString((JSONObject)oneDisk, (String)"disk_name"));
        }
        multiDisk.setLunSize(JsonUtil.safeGetString((JSONObject)oneDisk, (String)"lun_size"));
        multiDisk.setLunWwn(JsonUtil.safeGetString((JSONObject)oneDisk, (String)"lun_wwn"));
        multiDisk.setVendor(JsonUtil.safeGetString((JSONObject)oneDisk, (String)"vendor"));
        multiDisk.setProduct(JsonUtil.safeGetString((JSONObject)oneDisk, (String)"product"));
        if ("AIX".equals(hostType)) {
            multiDisk.setReservePolicy(JsonUtil.safeGetString((JSONObject)oneDisk, (String)"reserve_policy"));
        }
        if ("Linux".equals(hostType)) {
            multiDisk.setDmMaxSectors(JsonUtil.safeGetString((JSONObject)oneDisk, (String)"max_sectors_kb"));
        }
        if ("Solaris".equals(hostType)) {
            multiDisk.setIsAlua(JsonUtil.safeGetString((JSONObject)oneDisk, (String)"is_alua"));
        }
        return multiDisk;
    }

    private HostCommonParser() {
    }
}

