/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.parser.host;

import com.huawei.ism.tool.infograb.entity.HostInfo;
import com.huawei.ism.tool.infograb.entity.offline.HyperV;
import com.huawei.ism.tool.infograb.entity.offline.HyperVDisk;
import com.huawei.ism.tool.infograb.entity.offline.WfscCluster;
import com.huawei.ism.tool.infograb.entity.offline.WfscClusterDisk;
import com.huawei.ism.tool.infograb.entity.offline.WindowsHost;
import com.huawei.ism.tool.infograb.parser.host.HostCommonParser;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import com.huawei.migration.common.util.json.JsonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsParser {
    private static final Logger log = LoggerFactory.getLogger(WindowsParser.class);

    public static void buildWindowsHostInfo(WindowsHost hostInfo, Map<String, Object> resultMap, String nameKey) {
        if ("windows_cluster_info".equals(nameKey)) {
            WindowsParser.setWindowsClusterInfo(hostInfo, resultMap);
        } else if ("windows_hyper_v_info".equals(nameKey)) {
            WindowsParser.setHyperVInfo(hostInfo, resultMap);
        }
    }

    private static void setWindowsClusterInfo(WindowsHost hostInfo, Map<String, Object> resultMap) {
        WfscCluster windowsCluster = new WfscCluster();
        JSONObject clusterMap = new JSONObject(resultMap.get("windows_cluster_info").toString());
        windowsCluster.setIp(JsonUtil.safeGetString((JSONObject)clusterMap, (String)"host_ip"));
        windowsCluster.setClusterName(JsonUtil.safeGetString((JSONObject)clusterMap, (String)"cluster_name"));
        windowsCluster.setWfscClusterDisks(WindowsParser.getWfscDisks(JsonUtil.safeGetJsonArray((JSONObject)clusterMap, (String)"disks")));
        hostInfo.setWfscCluster(windowsCluster);
    }

    private static List<WfscClusterDisk> getWfscDisks(JSONArray diskArr) {
        return IntStream.range(0, diskArr.length()).mapToObj(index -> WindowsParser.getOneWfscDisk(diskArr.getJSONObject(index))).collect(Collectors.toList());
    }

    private static WfscClusterDisk getOneWfscDisk(JSONObject diskMap) {
        return new WfscClusterDisk(JsonUtil.safeGetString((JSONObject)diskMap, (String)"cluster_disk"), JsonUtil.safeGetString((JSONObject)diskMap, (String)"cluster_disk_type"), JsonUtil.safeGetString((JSONObject)diskMap, (String)"system_disk_name"), JsonUtil.safeGetString((JSONObject)diskMap, (String)"disk_state"), JsonUtil.safeGetString((JSONObject)diskMap, (String)"disk_info"));
    }

    private static void setHyperVInfo(WindowsHost hostInfo, Map<String, Object> resultMap) {
        HyperV hyperV = new HyperV();
        JSONObject clusterMap = new JSONObject(resultMap.get("windows_hyper_v_info").toString());
        hyperV.setIp(JsonUtil.safeGetString((JSONObject)clusterMap, (String)"host_ip"));
        hyperV.setHyperVDisks(WindowsParser.getHyperVDisks(JsonUtil.safeGetJsonArray((JSONObject)clusterMap, (String)"vms")));
        hostInfo.setHyperV(hyperV);
    }

    private static List<HyperVDisk> getHyperVDisks(JSONArray vms) {
        return IntStream.range(0, vms.length()).mapToObj(index -> WindowsParser.getOneHyperVDisk(vms.getJSONObject(index))).collect(Collectors.toList());
    }

    private static HyperVDisk getOneHyperVDisk(JSONObject diskMap) {
        return new HyperVDisk(JsonUtil.safeGetString((JSONObject)diskMap, (String)"virtual_machines"), JsonUtil.safeGetString((JSONObject)diskMap, (String)"state"), JsonUtil.safeGetString((JSONObject)diskMap, (String)"is_vm_in_cluster"), JsonUtil.safeGetString((JSONObject)diskMap, (String)"vm_disk_path"), JsonUtil.safeGetString((JSONObject)diskMap, (String)"virtual_hba"));
    }

    public static void buildWindowsStructureDatas(List<HostInfo> hosts, Map<String, List<List<String>>> reportData) {
        if (hosts.size() > 0) {
            reportData.put("Windows_OS", HostCommonParser.getOsData(hosts));
            reportData.put("Windows_Multipath", HostCommonParser.getMultiData(hosts, "Windows"));
            List<WindowsHost> windowsHosts = WindowsParser.change2WindowsHost(hosts);
            reportData.put("Windows_Cluster", WindowsParser.getWindowsClusterData(windowsHosts));
            reportData.put("Windows_Hyper-V", WindowsParser.getWindowsHyperVData(windowsHosts));
        }
    }

    private static List<WindowsHost> change2WindowsHost(List<HostInfo> windowsHosts) {
        return windowsHosts.stream().filter(WindowsHost.class::isInstance).map(hostInfo -> (WindowsHost)hostInfo).collect(Collectors.toList());
    }

    private static List<List<String>> getWindowsClusterData(List<WindowsHost> windowsHosts) {
        ArrayList<List<String>> windowsClusterData = new ArrayList<List<String>>();
        windowsClusterData.add(Arrays.asList("IP/ID", "Cluster Name", "Cluster Disk", "Cluster Disk Type", "System Disk Name", "Disk State", "DiskInfo"));
        windowsHosts.forEach(windowsHost -> windowsClusterData.addAll(WindowsParser.getOneWindowsHostClusterData(windowsHost)));
        return windowsClusterData;
    }

    private static List<List<String>> getOneWindowsHostClusterData(WindowsHost windowsHost) {
        WfscCluster wfscCluster = windowsHost.getWfscCluster();
        return wfscCluster.getWfscClusterDisks().stream().map(disk -> WindowsParser.getOneDiskContent(disk, wfscCluster.getIp(), wfscCluster.getClusterName())).collect(Collectors.toList());
    }

    private static List<String> getOneDiskContent(WfscClusterDisk disk, String ip, String clusterName) {
        return Arrays.asList(ip, clusterName, disk.getDiskName(), disk.getDiskType(), disk.getSystemDiskName(), disk.getDiskState(), disk.getDiskInfo());
    }

    private static List<List<String>> getWindowsHyperVData(List<WindowsHost> windowsHosts) {
        ArrayList<List<String>> hyperVData = new ArrayList<List<String>>();
        hyperVData.add(Arrays.asList("IP/ID", "Virtual Machines", "State", "Is In Cluster", "VM Disk Path", "Virtual HBA"));
        windowsHosts.forEach(windowsHost -> hyperVData.addAll(WindowsParser.getOneWindowsHostHyperVData(windowsHost)));
        return hyperVData;
    }

    private static List<List<String>> getOneWindowsHostHyperVData(WindowsHost windowsHost) {
        HyperV hyperV = windowsHost.getHyperV();
        return hyperV.getHyperVDisks().stream().map(disk -> WindowsParser.getOneHyperVDiskContent(disk, hyperV.getIp())).collect(Collectors.toList());
    }

    private static List<String> getOneHyperVDiskContent(HyperVDisk disk, String ip) {
        return Arrays.asList(ip, disk.getVirtualMachines(), disk.getState(), disk.getInCluster(), disk.getVmDiskPath(), disk.getVirtualHba());
    }

    private WindowsParser() {
    }
}

