/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.periodgrab;

import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.periodgrab.context.CloudEvaReportContext;
import com.huawei.ism.tool.infograb.periodgrab.context.PeriodGrabContext;
import com.huawei.ism.tool.infograb.periodgrab.entity.PeriodGrabReportItem;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.math.BigDecimal;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PeriodGrabMethod {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodGrabMethod.class);
    private static final String SRCIPT_PARENT_PATH_SCRIPT = "script";
    private static final String SRCIPT_PARENT_PATH_CLOUDEVA = "CloudEva";
    private static final String SSH = "SSH";
    private static final String DBCON = "DBConn";
    private static final String DEV_TYPE = "dev_type";
    private static final String DEV_IP = "dev_ip";
    private static final String LANGUAGE = "lang";
    private static final String RET_MAP = "ret_map";
    private static final String BANDWIDTH_RX = "cat /sys/class/net/eth*/statistics/rx_bytes";
    private static final String BANDWIDTH_TX = "cat /sys/class/net/eth*/statistics/tx_bytes";
    private static JythonExecuter jythonExecuter = new JythonExecuter();

    public static double[] monitorCPU(ICliConnection connection, GrabDevNode2 devNode, double[] cpuInfo, long execTimes, double d) {
        if (!"Windows".equalsIgnoreCase(devNode.getDevTypeLevel2().toString())) {
            try {
                String result = connection.execCmd("vmstat 1 1");
                if (result != null) {
                    String cpuIdTemp = result.split("\n")[3].trim().split("\\s+")[14];
                    int cpuId = 0;
                    if (PeriodGrabMethod.isNumeric(cpuIdTemp)) {
                        cpuId = Integer.valueOf(result.split("\n")[3].trim().split("\\s+")[14]);
                    }
                    if (cpuInfo[2] < (double)(100 - cpuId)) {
                        cpuInfo[2] = 100 - cpuId;
                    }
                    cpuInfo[3] = 100 - cpuId;
                    if ((double)(100 - cpuId) > d) {
                        cpuInfo[1] = cpuInfo[1] + 1.0;
                    }
                    cpuInfo[0] = (cpuInfo[0] * (double)(execTimes - 1L) + (double)(100 - cpuId)) / (double)execTimes;
                    return cpuInfo;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.error("not format result.");
            }
            catch (NumberFormatException e) {
                LOGGER.error("period grab method exec cmd error,because of number format.");
            }
            catch (ToolException e) {
                LOGGER.error("period grab method exec cmd error.");
            }
        }
        return cpuInfo;
    }

    public static double[] monitorMemory(ICliConnection connection, GrabDevNode2 devNode, double[] memInfo, long execTimes, double thMem) {
        if (!"Windows".equalsIgnoreCase(devNode.getDevTypeLevel2().toString())) {
            try {
                String result = connection.execCmd("vmstat 1 1");
                if (result != null) {
                    long swpd = 0L;
                    long free = 0L;
                    long buff = 0L;
                    long cache = 0L;
                    if (PeriodGrabMethod.isNumeric(result.split("\n")[3].trim().split("\\s+")[2])) {
                        swpd = Long.valueOf(result.split("\n")[3].trim().split("\\s+")[2]);
                    }
                    if (PeriodGrabMethod.isNumeric(result.split("\n")[3].trim().split("\\s+")[3])) {
                        free = Long.valueOf(result.split("\n")[3].trim().split("\\s+")[3]);
                    }
                    if (PeriodGrabMethod.isNumeric(result.split("\n")[3].trim().split("\\s+")[4])) {
                        buff = Long.valueOf(result.split("\n")[3].trim().split("\\s+")[4]);
                    }
                    if (PeriodGrabMethod.isNumeric(result.split("\n")[3].trim().split("\\s+")[5])) {
                        cache = Long.valueOf(result.split("\n")[3].trim().split("\\s+")[5]);
                    }
                    long sum = swpd + free + buff + cache;
                    BigDecimal bd1 = new BigDecimal("1.0");
                    BigDecimal bd2 = new BigDecimal(free);
                    BigDecimal bd4 = new BigDecimal(sum);
                    double calc = bd1.subtract(bd2.multiply(bd1).divide(bd4)).doubleValue();
                    if (memInfo[2] < calc) {
                        memInfo[2] = calc;
                    }
                    memInfo[3] = calc;
                    if (calc > thMem / 100.0) {
                        memInfo[1] = memInfo[1] + 1.0;
                    }
                    memInfo[0] = (memInfo[0] * (double)(execTimes - 1L) + calc) / (double)execTimes;
                    return memInfo;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.error("not format result.");
            }
            catch (NumberFormatException e) {
                LOGGER.error("period grab method exec cmd error,because of number format.");
            }
            catch (ToolException e) {
                LOGGER.error("period grab method exec cmd error.");
            }
        }
        return memInfo;
    }

    public static void grabRealTimeInfo(ICliConnection connection, GrabDevNode2 devNode, ExecuteResult execResult) {
        Map<Integer, PeriodGrabReportItem> itemMap = CloudEvaReportContext.getInstance().getItemMap();
        for (int col : itemMap.keySet()) {
            String result;
            PeriodGrabReportItem item = itemMap.get(col);
            if (0 == item.getType()) {
                result = PeriodGrabMethod.execGrabItem(connection, devNode, item);
                PeriodGrabContext.getInstance().getResultMap().put(col, result);
                continue;
            }
            result = execResult.getMonitorResult().getResultByName(item.getScriptPath());
            PeriodGrabContext.getInstance().getResultMap().put(col, result);
        }
    }

    public static double[] grabIopsInfo(ICliConnection connection, GrabDevNode2 devNode, double[] iopsInfo, long execTimes, double thIops) {
        if (!devNode.getDevTypeLevel2().toString().equalsIgnoreCase("Windows")) {
            try {
                String result = connection.execCmd("iostat -d | tail -n +4 | head -n -1 | awk '{s+=$2} END {print s}'");
                if (result != null) {
                    double iops = 0.0;
                    String iopsStr = result.split("\n")[1].trim();
                    if (PeriodGrabMethod.isNumeric(iopsStr)) {
                        iops = Double.valueOf(iopsStr);
                    }
                    if (iopsInfo[2] < iops) {
                        iopsInfo[2] = iops;
                    }
                    iopsInfo[3] = iops;
                    if (iops > thIops) {
                        iopsInfo[1] = iopsInfo[1] + 1.0;
                    }
                    iopsInfo[0] = (iopsInfo[0] * (double)(execTimes - 1L) + iops) / (double)execTimes;
                    return iopsInfo;
                }
            }
            catch (ToolException e) {
                LOGGER.info("period grab method exec cmd exec cmd error.");
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.error("get iops error.");
            }
        }
        return iopsInfo;
    }

    public static double[] grabBandWidthInfo(ICliConnection connection, GrabDevNode2 devNode, double[] bwInfo, long execTimes, double thBw) {
        if (!devNode.getDevTypeLevel2().toString().equalsIgnoreCase("Windows")) {
            try {
                String rxStr0 = connection.execCmd(BANDWIDTH_RX).split("\n")[1].trim();
                String txStr0 = connection.execCmd(BANDWIDTH_TX).split("\n")[1].trim();
                TimeUnit.MILLISECONDS.sleep(1000L);
                String rxStr1 = connection.execCmd(BANDWIDTH_RX).split("\n")[1].trim();
                String txStr1 = connection.execCmd(BANDWIDTH_TX).split("\n")[1].trim();
                if (PeriodGrabMethod.isNumeric(rxStr0) && PeriodGrabMethod.isNumeric(txStr0) && PeriodGrabMethod.isNumeric(rxStr1) && PeriodGrabMethod.isNumeric(txStr1)) {
                    double txBw;
                    double rxBw = Double.valueOf(rxStr1) - Double.valueOf(rxStr0);
                    double totalBw = rxBw + (txBw = Double.valueOf(txStr1) - Double.valueOf(txStr0));
                    if (bwInfo[2] < totalBw) {
                        bwInfo[2] = totalBw;
                    }
                    bwInfo[3] = totalBw;
                    if (totalBw > thBw * 1024.0) {
                        bwInfo[1] = bwInfo[1] + 1.0;
                    }
                    bwInfo[0] = (bwInfo[0] * (double)(execTimes - 1L) + totalBw) / (double)execTimes;
                    return bwInfo;
                }
            }
            catch (ToolException e) {
                LOGGER.error("period grab method exec cmd error.");
            }
            catch (InterruptedException e) {
                LOGGER.error("thread interrupted error.");
            }
        }
        return bwInfo;
    }

    private static boolean isNumeric(String str) {
        str = Normalizer.normalize(str, Normalizer.Form.NFKC);
        Pattern pattern = Pattern.compile("-?[0-9]+.*[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    private static String execGrabItem(ICliConnection connection, GrabDevNode2 devNode, PeriodGrabReportItem periodItem) {
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(SRCIPT_PARENT_PATH_SCRIPT).append(File.separator).append(SRCIPT_PARENT_PATH_CLOUDEVA).append(File.separator).append(devNode.getDevTypeLevel2()).append(File.separator).append(periodItem.getScriptPath()).append(".py");
        File scriptFile = new File(pathBuilder.toString());
        if (!scriptFile.exists()) {
            LOGGER.info("script file does not exist.");
            return "";
        }
        return PeriodGrabMethod.execScript(devNode, connection, scriptFile);
    }

    private static String execScript(GrabDevNode2 devNode, ICliConnection connection, File scriptFile) {
        Map<String, Object> context = PeriodGrabMethod.prepareParameters(devNode, connection);
        try {
            jythonExecuter.compileScript(scriptFile);
            jythonExecuter.simpleInvokeFunction("execute", context);
        }
        catch (SignException e) {
            LOGGER.error(scriptFile.getName() + " not sign.");
            return null;
        }
        catch (FileNotFoundException e) {
            LOGGER.error(scriptFile.getName() + " not found.");
            return null;
        }
        catch (ToolException e) {
            LOGGER.error("execute script error");
            return null;
        }
        return (String)((Map)context.get(RET_MAP)).get("result");
    }

    private static Map<String, Object> prepareParameters(GrabDevNode2 devNode, ICliConnection connection) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        String conName = PeriodGrabMethod.createConName(devNode.getItDeviceType());
        context.put(conName, connection);
        context.put(DEV_IP, devNode.getIp());
        context.put(DEV_TYPE, devNode.getDeviceType().toString());
        context.put(LANGUAGE, LanguageManager.getInstance().getCurrentLanguage().toString());
        context.put(RET_MAP, new LinkedHashMap());
        context.put("isUseJdbc", devNode.isUseJdbc());
        context.put("Logger", LOGGER);
        return context;
    }

    private static String createConName(ItDeviceType type) {
        return ItDeviceType.Database.equals((Object)type) ? DBCON : SSH;
    }
}

