/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.periodgrab;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.periodgrab.context.CloudEvaReportContext;
import com.huawei.ism.tool.infograb.periodgrab.context.PeriodGrabContext;
import com.huawei.ism.tool.infograb.periodgrab.entity.PeriodGrabReportItem;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;

public class PeriodGrabReportBuilder {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PeriodGrabReportBuilder.class);
    private static final String CLOUD_MODEL_PATH_ZH = "/config/templatefile/cloud_model_zh.xls";
    private static final String CLOUD_MODEL_PATH_EN = "/config/templatefile/cloud_model_en.xls";
    private static PeriodGrabReportBuilder instance = new PeriodGrabReportBuilder();
    private static Map<Integer, String> resultMap = PeriodGrabContext.getInstance().getResultMap();
    private Map<Integer, PeriodGrabReportItem> grabItemMap = CloudEvaReportContext.getInstance().getItemMap();

    private PeriodGrabReportBuilder() {
    }

    public static PeriodGrabReportBuilder getInstance() {
        return instance;
    }

    public void produceExcelReport(File saveFile) throws IOException, ToolException {
        this.copyFile(saveFile);
        this.buildReport(saveFile);
    }

    public void produceTxtReport(File txtFile, String txtData) throws IOException {
        this.buildTxtReport(txtFile, txtData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildTxtReport(File txtFile, String txtData) {
        BufferedWriter bw = null;
        OutputStreamWriter osw = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(txtFile, true);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            bw = new BufferedWriter(osw);
            bw.write(txtData + System.lineSeparator());
        }
        catch (IOException e) {
            try {
                LOGGER.error("build txt report err");
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(bw, bw);
                StreamUtils.closeResource(null, osw);
                StreamUtils.closeResource((Flushable)fos, (Closeable)fos);
                throw throwable;
            }
            StreamUtils.closeResource(bw, bw);
            StreamUtils.closeResource(null, (Closeable)osw);
            StreamUtils.closeResource((Flushable)fos, (Closeable)fos);
        }
        StreamUtils.closeResource((Flushable)bw, (Closeable)bw);
        StreamUtils.closeResource(null, (Closeable)osw);
        StreamUtils.closeResource((Flushable)fos, (Closeable)fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File saveFile) throws IOException, ToolException {
        block11: {
            InputStream fis;
            InputStream inputStream = fis = Locale.ENGLISH.equals(GrabContext.getInstance().getLocale()) ? PeriodGrabReportBuilder.class.getResourceAsStream(CLOUD_MODEL_PATH_EN) : PeriodGrabReportBuilder.class.getResourceAsStream(CLOUD_MODEL_PATH_ZH);
            if (null == fis) {
                LOGGER.info("can't find the model excel file.");
            }
            OutputStream fos = null;
            try {
                if (null != saveFile && null != fis) {
                    if (saveFile.isDirectory()) {
                        StreamUtils.closeResource(null, (Closeable)fis);
                        throw new ToolException("The savefile is a directory, not file.");
                    }
                    if (!saveFile.getParentFile().exists() && saveFile.getParentFile().mkdirs()) {
                        StreamUtils.closeResource(null, (Closeable)fis);
                        throw new ToolException("create directory failed.");
                    }
                    fos = this.getExcelFileOS(saveFile);
                    int len = 0;
                    byte[] buf = new byte[1024];
                    while ((len = fis.read(buf)) != -1) {
                        fos.write(buf, 0, len);
                        fos.flush();
                    }
                } else {
                    StreamUtils.closeResource(null, (Closeable)fis);
                    throw new ToolException("Copy file failed");
                }
                StreamUtils.closeResource(null, (Closeable)fis);
            }
            catch (ToolException e) {
                LOGGER.error("get Excel File OutputStream failed.");
                break block11;
            }
            finally {
                StreamUtils.closeResource(null, (Closeable)fis);
                StreamUtils.closeResource(fos, fos);
            }
            StreamUtils.closeResource((Flushable)fos, (Closeable)fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void buildReport(File saveFile) throws ToolException {
        block14: {
            POIFSFileSystem fs;
            FileOutputStream out1;
            FileOutputStream out;
            HSSFWorkbook xlsTempWorkbook;
            FileInputStream in;
            block12: {
                if (null == saveFile) {
                    LOGGER.error("the file to save is null.");
                    return;
                }
                in = null;
                xlsTempWorkbook = null;
                out = null;
                out1 = null;
                fs = null;
                in = new FileInputStream(saveFile);
                fs = new POIFSFileSystem((InputStream)in);
                xlsTempWorkbook = new HSSFWorkbook(fs);
                HSSFSheet sheet = xlsTempWorkbook.getSheetAt(0);
                out = new FileOutputStream(saveFile);
                this.clearConfigRow(sheet);
                xlsTempWorkbook.write((OutputStream)out);
                out1 = new FileOutputStream(saveFile);
                this.updateResult(sheet);
                xlsTempWorkbook.write((OutputStream)out1);
                if (null == xlsTempWorkbook) break block12;
                try {
                    xlsTempWorkbook.close();
                }
                catch (IOException e) {
                    LOGGER.error("close xlsTempWorkbook failed");
                }
            }
            StreamUtils.closeResource(null, (Closeable)fs);
            StreamUtils.closeStream((OutputStream)out, (InputStream)in);
            StreamUtils.closeStream((OutputStream)out1, null);
            break block14;
            catch (IOException e) {
                block13: {
                    try {
                        LOGGER.error("period grab report read model file error");
                        if (null == xlsTempWorkbook) break block13;
                    }
                    catch (Throwable throwable) {
                        if (null != xlsTempWorkbook) {
                            try {
                                xlsTempWorkbook.close();
                            }
                            catch (IOException e2) {
                                LOGGER.error("close xlsTempWorkbook failed");
                            }
                        }
                        StreamUtils.closeResource(null, fs);
                        StreamUtils.closeStream(out, (InputStream)in);
                        StreamUtils.closeStream(out1, null);
                        throw throwable;
                    }
                    try {
                        xlsTempWorkbook.close();
                    }
                    catch (IOException e3) {
                        LOGGER.error("close xlsTempWorkbook failed");
                    }
                }
                StreamUtils.closeResource(null, (Closeable)fs);
                StreamUtils.closeStream(out, (InputStream)in);
                StreamUtils.closeStream(out1, null);
            }
        }
    }

    private void clearConfigRow(HSSFSheet sheet) {
        HSSFRow temp = sheet.getRow(3);
        HSSFRow temp1 = sheet.getRow(4);
        for (int col : this.grabItemMap.keySet()) {
            temp.getCell(col).setCellValue("");
            temp1.getCell(col).setCellValue("");
        }
    }

    private void updateResult(HSSFSheet sheet) {
        HSSFRow row = sheet.getRow(3);
        for (Map.Entry<Integer, PeriodGrabReportItem> entry : this.grabItemMap.entrySet()) {
            String result = resultMap.get(entry.getKey());
            HSSFCell cell = row.getCell(entry.getKey().intValue());
            cell.setCellValue(result);
        }
    }

    private OutputStream getExcelFileOS(File savePath) throws ToolException {
        FileOutputStream periodOutputStream = null;
        try {
            File parentFilePath = savePath.getParentFile();
            if (!parentFilePath.exists() && !parentFilePath.mkdirs()) {
                throw new ToolException("create parrent directory failed.");
            }
            if (savePath.exists() && !savePath.delete()) {
                throw new ToolException("the file already exists!");
            }
            if (!savePath.createNewFile()) {
                throw new ToolException("can not create new file.");
            }
            periodOutputStream = new FileOutputStream(savePath);
        }
        catch (IOException e) {
            throw new ToolException("create output stream failed.", (Throwable)e);
        }
        return periodOutputStream;
    }
}

