/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.periodgrab;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.infograb.connection.SshConnectionHelper;
import com.huawei.ism.tool.infograb.context.CollectStatusEnum;
import com.huawei.ism.tool.infograb.context.GrabContext;
import com.huawei.ism.tool.infograb.entity.ExecuteResult;
import com.huawei.ism.tool.infograb.entity.GrabDevNode2;
import com.huawei.ism.tool.infograb.entity.UserOpDeviceDetail;
import com.huawei.ism.tool.infograb.grab.GrabEngine;
import com.huawei.ism.tool.infograb.intf.worktaker.IGrabRefreshUI;
import com.huawei.ism.tool.infograb.intf.worktaker.impl.InfoGrabDirPropertiesUtil;
import com.huawei.ism.tool.infograb.periodgrab.PeriodGrabMethod;
import com.huawei.ism.tool.infograb.periodgrab.PeriodGrabReportBuilder;
import com.huawei.ism.tool.infograb.periodgrab.context.PeriodGrabConfig;
import com.huawei.ism.tool.infograb.periodgrab.entity.PeriodGrabResult;
import com.huawei.ism.tool.infograb.periodgrab.entity.PeriodGrabTask;
import com.huawei.ism.tool.infograb.service.InfoGrabService;
import com.huawei.ism.tool.infograb.utils.ToolUtils;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class PeriodGrabThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(PeriodGrabThread.class);
    private static final String DATATYPE = "yyyyMMddHHmmss";
    private static final String XLSFILETYPE = ".xls";
    private static final String TXTFILETYPE = ".txt";
    private static final String UNDERLINE = "_";
    private long execTimes = 0L;
    private double[] cpuInfo = new double[]{0.0, 0.0, 0.0, 0.0};
    private double[] memInfo = new double[]{0.0, 0.0, 0.0, 0.0};
    private double[] iopsInfo = new double[]{0.0, 0.0, 0.0, 0.0};
    private double[] bwInfo = new double[]{0.0, 0.0, 0.0, 0.0};
    private volatile boolean isStop = false;
    private long monitorFreq;
    private long monitorTime;
    private InfoGrabService grabService;
    private GrabDevNode2 devNode;
    private ICliConnection devCon;
    private PeriodGrabConfig monitorConfig;
    private IGrabRefreshUI uiListener;
    private String threadPool = "MonitorInfo ThreadPool-";
    private String taskDirFileName = "";
    private String createDateEnd = "";
    private int txtNum = 1;
    private UserOpDeviceDetail userOpDeviceDetail;

    public PeriodGrabThread(GrabDevNode2 devNode, IGrabRefreshUI uiListener) {
        this.userOpDeviceDetail = new UserOpDeviceDetail(devNode);
        this.uiListener = uiListener;
        this.devNode = devNode;
        this.grabService = InfoGrabService.getInstance();
        this.monitorConfig = GrabContext.getInstance().getMonitorConfigMap().get((Object)devNode);
        if (null != this.monitorConfig) {
            this.monitorFreq = this.monitorConfig.getMonitorFreq();
            this.monitorTime = this.monitorConfig.getMonitorTime();
        }
        this.setName(this.createThreadName());
    }

    public UserOpDeviceDetail getUserOpDeviceDetail() {
        return this.userOpDeviceDetail;
    }

    private String createThreadName() {
        StringBuilder threadHead = new StringBuilder(this.threadPool);
        threadHead.append(this.devNode.getIp());
        threadHead.append(".");
        threadHead.append(this.devNode.getDeviceName());
        return threadHead.toString();
    }

    @Override
    public void run() {
        GrabEngine.getInstance().getCurrMonitorThreadMap().put(this.devNode, this);
        this.monitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitor() {
        this.uiListener.changeSelectNodeStatus(this.devNode);
        this.grabService.startGifLoading();
        try {
            if (this.devCon == null) {
                this.createProperCon();
            }
            long count = this.monitorFreq;
            LinkedList<ExecuteResult> currResultList = new LinkedList<ExecuteResult>();
            this.taskDirFileName = this.getFileName();
            this.createDateEnd = new SimpleDateFormat(DATATYPE).format(new Date());
            while (!this.isStop) {
                count = this.setGrabService(count, currResultList);
                if (!this.isStop) {
                    this.uiListener.refreshPregress(currResultList);
                }
                ++count;
                --this.monitorTime;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)"PeriodGrab sleep exception.");
                }
            }
        }
        catch (com.huawei.ism.tool.obase.exception.ToolException e) {
            LOGGER.error((Object)"PeriodGrabThread run error.");
        }
        finally {
            if (this.isStop) {
                this.devNode.setCollectStop(true);
            }
            if (this.devCon != null) {
                this.devCon.close();
            }
        }
    }

    private long setGrabService(long count, List<ExecuteResult> currResultList) {
        if (count == this.monitorFreq) {
            if (0L == this.execTimes) {
                String txtTitle = ResourceUtil.getString((String)"infograb.item.monitor.txttitle");
                this.buildTxtReport(txtTitle);
            }
            ++this.execTimes;
            ExecuteResult executeResult = this.exeMonitor(this.devNode);
            String singleRowData = this.formateTxtData(executeResult, this.execTimes);
            this.buildTxtReport(singleRowData);
            if (this.monitorTime <= 0L) {
                this.saveResult(executeResult);
                this.isStop = true;
                this.grabService.setNodesStopped(this.devNode);
                executeResult.setCheckResult(ResourceUtil.getString((String)"infograb.complete"));
                executeResult.setNowStatus(CollectStatusEnum.COLLECT_SUCC);
                this.uiListener.refreshPregress(currResultList);
            }
            currResultList.clear();
            currResultList.add(executeResult);
            count = 0L;
        } else {
            ExecuteResult executeResult = currResultList.get(0);
            if (this.monitorTime <= 0L) {
                this.saveResult(executeResult);
                this.isStop = true;
                this.grabService.setNodesStopped(this.devNode);
                executeResult.setCheckResult(ResourceUtil.getString((String)"infograb.complete"));
                executeResult.setNowStatus(CollectStatusEnum.COLLECT_SUCC);
                this.uiListener.refreshPregress(currResultList);
            }
            PeriodGrabResult monitorResult = executeResult.getMonitorResult();
            monitorResult.setMonitorTimes(this.execTimes);
            monitorResult.setLeftTime(this.monitorTime);
            executeResult.setMonitorResult(monitorResult);
            currResultList.set(0, executeResult);
        }
        return count;
    }

    private void saveResult(ExecuteResult executeResult) {
        PeriodGrabMethod.grabRealTimeInfo(this.devCon, this.devNode, executeResult);
        this.buildExcelReport();
    }

    private void buildExcelReport() {
        try {
            PeriodGrabReportBuilder.getInstance().produceExcelReport(this.getReportFileName(this.taskDirFileName));
        }
        catch (IOException e) {
            LOGGER.error((Object)"save excel report file IOException error");
        }
        catch (ToolException e) {
            LOGGER.error((Object)"save excel report ToolException error");
        }
    }

    private void buildTxtReport(String singleRowData) {
        try {
            PeriodGrabReportBuilder.getInstance().produceTxtReport(this.getTxtReportFileName(this.taskDirFileName), singleRowData);
        }
        catch (IOException e) {
            LOGGER.error((Object)"save txt report error");
        }
    }

    private File getReportFileName(String fileDirName) {
        String xlsReportFileName = fileDirName;
        StringBuffer fileStringBuilder = new StringBuffer();
        fileStringBuilder.append(xlsReportFileName);
        String dateEnd = new SimpleDateFormat(DATATYPE).format(new Date());
        String fileName = this.createFileName(this.devNode, dateEnd, XLSFILETYPE);
        if (!this.createDir(new File(fileStringBuilder.toString()))) {
            return null;
        }
        fileStringBuilder.append(File.separator).append(fileName);
        File resultFile = new File(fileStringBuilder.toString());
        try {
            if (!resultFile.createNewFile()) {
                return null;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"PeriodGrabThread createNewFile err");
        }
        return resultFile;
    }

    private String getFileName() {
        PeriodGrabTask collectTask = (PeriodGrabTask)GrabContext.getInstance().getTaskMap().get((Object)this.devNode);
        String dateEnd = new SimpleDateFormat(DATATYPE).format(new Date());
        String taskDirName = collectTask.getTaskDirName();
        String devDirName = this.createFileName(this.devNode, dateEnd, "");
        StringBuilder fileStringBuilder = new StringBuilder();
        fileStringBuilder.append(InfoGrabDirPropertiesUtil.getProperty()).append(File.separator).append(taskDirName).append(File.separator).append(devDirName);
        return fileStringBuilder.toString();
    }

    private File getTxtReportFileName(String fileDirName) {
        StringBuffer fileStringBuilder = new StringBuffer();
        fileStringBuilder.append(fileDirName);
        String fileName = this.createFileName(this.devNode, this.createDateEnd, TXTFILETYPE, this.txtNum);
        if (!this.createDir(new File(fileStringBuilder.toString()))) {
            return null;
        }
        fileStringBuilder.append(File.separator).append(fileName);
        File resultFile = new File(fileStringBuilder.toString());
        if (0x500000L < resultFile.length()) {
            fileStringBuilder = new StringBuffer();
            fileStringBuilder.append(fileDirName);
            ++this.txtNum;
            fileName = this.createFileName(this.devNode, this.createDateEnd, TXTFILETYPE, this.txtNum);
            fileStringBuilder.append(File.separator).append(fileName);
            File newFile = new File(fileStringBuilder.toString());
            String txtTitle = ResourceUtil.getString((String)"infograb.item.monitor.txttitle");
            try {
                PeriodGrabReportBuilder.getInstance().produceTxtReport(newFile, txtTitle);
            }
            catch (IOException e) {
                LOGGER.error((Object)"save txt report error");
            }
            return newFile;
        }
        return resultFile;
    }

    private boolean createDir(File dir) {
        return dir.exists() || dir.mkdirs();
    }

    private String createFileName(GrabDevNode2 currNode, String dateEnd, String fileType, int txtDataNum) {
        StringBuilder sb = new StringBuilder(currNode.getDeviceName());
        sb.append(UNDERLINE);
        sb.append(currNode.getIp());
        sb.append(UNDERLINE);
        sb.append(dateEnd);
        sb.append('_');
        sb.append(txtDataNum);
        sb.append(fileType);
        return sb.toString();
    }

    private String createFileName(GrabDevNode2 currNode, String dateEnd, String fileType) {
        StringBuilder sb = new StringBuilder(currNode.getDeviceName());
        sb.append(UNDERLINE);
        sb.append(currNode.getIp());
        sb.append(UNDERLINE);
        sb.append(dateEnd);
        sb.append(fileType);
        return sb.toString();
    }

    private void createProperCon() throws com.huawei.ism.tool.obase.exception.ToolException {
        this.devCon = SshConnectionHelper.getSshConnection(ToolUtils.grabNode2ToNode1(this.devNode));
    }

    public void setStop(boolean isStopBool) {
        this.isStop = isStopBool;
    }

    private ExecuteResult exeMonitor(GrabDevNode2 currentDevNode) {
        PeriodGrabResult monitorResult = new PeriodGrabResult();
        monitorResult.setMonitorTimes(this.execTimes);
        this.cpuInfo = PeriodGrabMethod.monitorCPU(this.devCon, currentDevNode, this.cpuInfo, this.execTimes, this.monitorConfig.getCpuThreshold());
        monitorResult.setCpuUse(this.cpuInfo[2] + "%/(" + (int)this.cpuInfo[1] + "/" + this.execTimes + ")/" + this.cpuInfo[0] + "%");
        monitorResult.setCpuCurrentData(this.cpuInfo[3] + "%");
        this.memInfo = PeriodGrabMethod.monitorMemory(this.devCon, currentDevNode, this.memInfo, this.execTimes, this.monitorConfig.getMemThreshold());
        monitorResult.setMemoryUse(String.format(Locale.ENGLISH, "%.2f", this.memInfo[2] * 100.0) + "%/(" + (int)this.memInfo[1] + "/" + this.execTimes + ")/" + String.format(Locale.ENGLISH, "%.2f", this.memInfo[0] * 100.0) + "%");
        monitorResult.setMemoryCurrentData(String.format(Locale.ENGLISH, "%.2f", this.memInfo[3] * 100.0) + "%");
        this.iopsInfo = PeriodGrabMethod.grabIopsInfo(this.devCon, currentDevNode, this.iopsInfo, this.execTimes, this.monitorConfig.getIopsThreshold());
        monitorResult.setIopsUse(String.format(Locale.ENGLISH, "%.2f", this.iopsInfo[2]) + "/(" + (int)this.iopsInfo[1] + "/" + this.execTimes + ")/" + String.format(Locale.ENGLISH, "%.2f", this.iopsInfo[0]));
        monitorResult.setIopCurrentData(String.format(Locale.ENGLISH, "%.2f", this.iopsInfo[3]));
        this.bwInfo = PeriodGrabMethod.grabBandWidthInfo(this.devCon, currentDevNode, this.bwInfo, this.execTimes, this.monitorConfig.getBandwidthThreshold());
        this.setBwUsage(this.bwInfo, monitorResult);
        monitorResult.setLeftTime(this.monitorTime);
        monitorResult.setDescription("");
        return this.createExcuteResult(currentDevNode, monitorResult);
    }

    private void setBwUsage(double[] avgbw, PeriodGrabResult monitorResult) {
        if (avgbw[0] < 1024.0) {
            monitorResult.setBandWidthUse(String.format(Locale.ENGLISH, "%.2f", avgbw[2]) + "bps/(" + (int)avgbw[1] + "/" + this.execTimes + ")/" + String.format(Locale.ENGLISH, "%.2f", avgbw[0]) + "bps");
            monitorResult.setBandWidthCurrentData(String.format(Locale.ENGLISH, "%.2f", avgbw[3]) + "bps");
        } else if (avgbw[0] >= 1024.0 && avgbw[0] < 1048576.0) {
            monitorResult.setBandWidthUse(String.format(Locale.ENGLISH, "%.2f", avgbw[2] / 1024.0) + "Kbps/(" + (int)avgbw[1] + "/" + this.execTimes + ")/" + String.format(Locale.ENGLISH, "%.2f", avgbw[0] / 1024.0) + "Kbps");
            monitorResult.setBandWidthCurrentData(String.format(Locale.ENGLISH, "%.2f", avgbw[3] / 1024.0) + "Kbps");
        } else if (avgbw[0] >= 1048576.0 && avgbw[0] < 1.073741824E9) {
            monitorResult.setBandWidthUse(String.format(Locale.ENGLISH, "%.2f", avgbw[0] / 1024.0 / 1024.0) + "Mbps/(" + (int)avgbw[1] + "/" + this.execTimes + ")/" + String.format(Locale.ENGLISH, "%.2f", avgbw[0] / 1024.0 / 1024.0) + "Mbps");
            monitorResult.setBandWidthCurrentData(String.format(Locale.ENGLISH, "%.2f", avgbw[3] / 1024.0 / 1024.0) + "Mbps");
        } else {
            monitorResult.setBandWidthUse(String.format(Locale.ENGLISH, "%.2f", avgbw[0] / 1024.0 / 1024.0 / 1024.0) + "Gbps/(" + (int)avgbw[1] + "/" + this.execTimes + ")/" + String.format(Locale.ENGLISH, "%.2f", avgbw[0] / 1024.0 / 1024.0 / 1024.0) + "Gbps");
            monitorResult.setBandWidthCurrentData(String.format(Locale.ENGLISH, "%.2f", avgbw[3] / 1024.0 / 1024.0 / 1024.0) + "Gbps");
        }
    }

    private ExecuteResult createExcuteResult(GrabDevNode2 deviceNode, PeriodGrabResult result) {
        ExecuteResult currResult = new ExecuteResult();
        currResult.setDevNode(deviceNode);
        currResult.setDescription(result.getDescription());
        currResult.setNowStatus(CollectStatusEnum.COLLECTING);
        currResult.setMonitorResult(result);
        return currResult;
    }

    private String formateTxtData(ExecuteResult executeResult, long execCurrentTimes) {
        String cpuCurrData = executeResult.getMonitorResult().getCpuCurrentData();
        String memCurrData = executeResult.getMonitorResult().getMemoryCurrentData();
        String iopsCurrData = executeResult.getMonitorResult().getIopCurrentData();
        String bwCurrData = executeResult.getMonitorResult().getBandWidthCurrentData();
        String dateEnd = new SimpleDateFormat(DATATYPE).format(new Date());
        StringBuffer sb = new StringBuffer();
        sb.append(' ');
        sb.append(execCurrentTimes);
        sb.append("            ");
        sb.append(cpuCurrData);
        sb.append("         ");
        sb.append(memCurrData);
        sb.append("         ");
        sb.append(iopsCurrData);
        sb.append("      ");
        sb.append(bwCurrData);
        sb.append("      ");
        sb.append(dateEnd);
        return sb.toString();
    }
}

