/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.periodgrab.context;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.infograb.periodgrab.PeriodGrabReportBuilder;
import com.huawei.ism.tool.infograb.periodgrab.entity.PeriodGrabReportItem;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;

public class CloudEvaReportContext {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CloudEvaReportContext.class);
    private static final String CLOUD_MODEL_PATH = "/config/templatefile/cloud_model_zh.xls";
    private static CloudEvaReportContext instance = new CloudEvaReportContext();
    private List<PeriodGrabReportItem> grabItemArr = new ArrayList<PeriodGrabReportItem>();
    private Map<Integer, PeriodGrabReportItem> itemMap = new HashMap<Integer, PeriodGrabReportItem>();

    private CloudEvaReportContext() {
        this.loadExcelTemplate();
    }

    public static CloudEvaReportContext getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExcelTemplate() {
        InputStream fis = PeriodGrabReportBuilder.class.getResourceAsStream(CLOUD_MODEL_PATH);
        if (null == fis) {
            LOGGER.info("can't find the model excel file.");
        }
        try {
            POIFSFileSystem fs = new POIFSFileSystem(fis);
            HSSFWorkbook xlsTempWorkbook = new HSSFWorkbook(fs);
            HSSFSheet sheet = xlsTempWorkbook.getSheetAt(0);
            this.getGrabItem(sheet);
        }
        catch (IOException e) {
            LOGGER.info("read excel template error.");
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)fis);
        }
    }

    private void getGrabItem(HSSFSheet sheet) {
        int i;
        HSSFRow typeRow = sheet.getRow(3);
        HSSFRow pyRow = sheet.getRow(4);
        int start = pyRow.getFirstCellNum();
        short end = pyRow.getLastCellNum();
        for (i = start; i <= end && i < Integer.MAX_VALUE; ++i) {
            HSSFCell pycell = pyRow.getCell(i);
            if (null == pycell || StringUtils.isNULLStr((String)pycell.getStringCellValue())) continue;
            HSSFCell typecell = typeRow.getCell(i);
            PeriodGrabReportItem item = new PeriodGrabReportItem(i, (int)typecell.getNumericCellValue(), pycell.getStringCellValue());
            this.grabItemArr.add(item);
        }
        for (i = 0; i < this.grabItemArr.size(); ++i) {
            this.itemMap.put(this.grabItemArr.get(i).getColIndex(), this.grabItemArr.get(i));
        }
    }

    public Map<Integer, PeriodGrabReportItem> getItemMap() {
        return this.itemMap;
    }

    public void setItemMap(Map<Integer, PeriodGrabReportItem> itemMap) {
        this.itemMap = itemMap;
    }
}

