/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.infograb.periodgrab.context;

import java.text.Normalizer;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PeriodGrabConfig {
    private static final double TH_CPU = 50.0;
    private static final double TH_MEM = 0.5;
    private static final double TH_IOPS = 5.0;
    private static final double TH_BW = 5.0;
    private long monitorTime;
    private long monitorFreq;
    private String monitorTimeAndUnit;
    private String monitorFreqAndUnit;
    private List<String> monitorItems;
    private String cpuThreshold;
    private String memThreshold;
    private String iopsThreshold;
    private String bandwidthThreshold = "null";

    public long getMonitorTime() {
        return this.monitorTime;
    }

    public void setMonitorTime(long monitorTime) {
        this.monitorTime = monitorTime;
    }

    public long getMonitorFreq() {
        return this.monitorFreq;
    }

    public void setMonitorFreq(long monitorFreq) {
        this.monitorFreq = monitorFreq;
    }

    public String getMonitorTimeAndUnit() {
        return this.monitorTimeAndUnit;
    }

    public void setMonitorTimeAndUnit(String monitorTimeAndUnit) {
        this.monitorTimeAndUnit = monitorTimeAndUnit;
    }

    public String getMonitorFreqAndUnit() {
        return this.monitorFreqAndUnit;
    }

    public void setMonitorFreqAndUnit(String monitorFreqAndUnit) {
        this.monitorFreqAndUnit = monitorFreqAndUnit;
    }

    public List<String> getMonitorItems() {
        return this.monitorItems;
    }

    public void setMonitorItems(List<String> monitorItems) {
        this.monitorItems = monitorItems;
    }

    public void setCpuThreshold(String cpuThreshold) {
        this.cpuThreshold = cpuThreshold;
    }

    public void setMemThreshold(String memThreshold) {
        this.memThreshold = memThreshold;
    }

    public void setIopsThreshold(String iopsThreshold) {
        this.iopsThreshold = iopsThreshold;
    }

    public void setBandwidthThreshold(String bandwidthThreshold) {
        this.bandwidthThreshold = bandwidthThreshold;
    }

    public double getCpuThreshold() {
        if (this.isNumeric(this.cpuThreshold)) {
            return Integer.valueOf(this.cpuThreshold).intValue();
        }
        return 50.0;
    }

    public double getMemThreshold() {
        if (this.isNumeric(this.memThreshold)) {
            return Integer.valueOf(this.memThreshold).intValue();
        }
        return 0.5;
    }

    public double getIopsThreshold() {
        if (this.isNumeric(this.iopsThreshold)) {
            return Integer.valueOf(this.iopsThreshold).intValue();
        }
        return 5.0;
    }

    public double getBandwidthThreshold() {
        String[] bw = this.bandwidthThreshold.split(":");
        if (!this.isNumeric(bw[0])) {
            return 5.0;
        }
        double bwTh = Integer.valueOf(bw[0]).intValue();
        if ("Mbps".equalsIgnoreCase(bw[1])) {
            return bwTh * 1024.0;
        }
        return bwTh;
    }

    private boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("-?[0-9]+.*[0-9]*");
        Matcher isNum = pattern.matcher(str = Normalizer.normalize(str, Normalizer.Form.NFKC));
        return isNum.matches();
    }
}

